/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;

public final class FileUtil {
    private static final int BUFFER_SIZE = 1024;

    private FileUtil() {
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getContent(FileObject fileObject) throws IOException {
        FileContent fileContent = fileObject.getContent();
        int n = (int)fileContent.getSize();
        byte[] byArray = new byte[n];
        try (InputStream inputStream = fileContent.getInputStream();){
            block6: {
                int n2;
                int n3;
                block5: {
                    n3 = 0;
                    n2 = 0;
                    if (!true) break block5;
                    if (n2 >= n) return byArray;
                    if (n3 < 0) break block6;
                }
                do {
                    n3 = inputStream.read(byArray, n2, n - n2);
                    n2 += n3;
                    if (n2 >= n) return byArray;
                } while (n3 >= 0);
            }
            return byArray;
        }
    }

    public static void writeContent(FileObject fileObject, OutputStream outputStream) throws IOException {
        try (InputStream inputStream = fileObject.getContent().getInputStream();){
            int n;
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }
    }

    public static void copyContent(FileObject fileObject, FileObject fileObject2) throws IOException {
        try (OutputStream outputStream = fileObject2.getContent().getOutputStream();){
            FileUtil.writeContent(fileObject, outputStream);
        }
    }
}

