/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs2.FileSystem;

public final class FileSystemOptions
implements Cloneable {
    private Map<FileSystemOptionKey, Object> options = new TreeMap<FileSystemOptionKey, Object>();

    void setOption(Class<? extends FileSystem> clazz, String string, Object object) {
        this.options.put(new FileSystemOptionKey(clazz, string), object);
    }

    Object getOption(Class<? extends FileSystem> clazz, String string) {
        FileSystemOptionKey fileSystemOptionKey = new FileSystemOptionKey(clazz, string);
        return this.options.get(fileSystemOptionKey);
    }

    boolean hasOption(Class<? extends FileSystem> clazz, String string) {
        FileSystemOptionKey fileSystemOptionKey = new FileSystemOptionKey(clazz, string);
        return this.options.containsKey(fileSystemOptionKey);
    }

    public int compareTo(FileSystemOptions fileSystemOptions) {
        int n;
        int n2;
        if (this == fileSystemOptions) {
            return 0;
        }
        int n3 = this.options == null ? 0 : this.options.size();
        int n4 = n2 = fileSystemOptions.options == null ? 0 : fileSystemOptions.options.size();
        if (n3 < n2) {
            return -1;
        }
        if (n3 > n2) {
            return 1;
        }
        if (n3 == 0) {
            return 0;
        }
        int n5 = this.options.hashCode();
        if (n5 < (n = fileSystemOptions.options.hashCode())) {
            return -1;
        }
        if (n5 > n) {
            return 1;
        }
        return 0;
    }

    public Object clone() {
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        fileSystemOptions.options = new TreeMap<FileSystemOptionKey, Object>(this.options);
        return fileSystemOptions;
    }

    private static final class FileSystemOptionKey
    implements Comparable<FileSystemOptionKey> {
        private static final int HASH = 29;
        private final Class<? extends FileSystem> fileSystemClass;
        private final String name;

        private FileSystemOptionKey(Class<? extends FileSystem> clazz, String string) {
            this.fileSystemClass = clazz;
            this.name = string;
        }

        @Override
        public int compareTo(FileSystemOptionKey fileSystemOptionKey) {
            int n = this.fileSystemClass.getName().compareTo(fileSystemOptionKey.fileSystemClass.getName());
            if (n != 0) {
                return n;
            }
            return this.name.compareTo(fileSystemOptionKey.name);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FileSystemOptionKey fileSystemOptionKey = (FileSystemOptionKey)object;
            if (!this.fileSystemClass.equals(fileSystemOptionKey.fileSystemClass)) {
                return false;
            }
            return this.name.equals(fileSystemOptionKey.name);
        }

        public int hashCode() {
            int n = this.fileSystemClass.hashCode();
            n = 29 * n + this.name.hashCode();
            return n;
        }
    }
}

