/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.util.Messages;

public class FileSystemException
extends IOException {
    private static final long serialVersionUID = 20101208L;
    private static final Pattern URL_PATTERN = Pattern.compile("[a-z]+://.*");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(":(?:[^/]+)@");
    private final Throwable throwable;
    private final String code;
    private final String[] info;

    public FileSystemException(String string) {
        this(string, null, null);
    }

    public FileSystemException(String string, Object object) {
        this(string, new Object[]{object}, (Throwable)null);
    }

    public FileSystemException(String string, Object object, Throwable throwable) {
        this(string, new Object[]{object}, throwable);
    }

    public FileSystemException(String string, Object[] objectArray) {
        this(string, objectArray, (Throwable)null);
    }

    public FileSystemException(String string, Throwable throwable) {
        this(string, null, throwable);
    }

    public FileSystemException(String string, Object[] objectArray, Throwable throwable) {
        super(string);
        if (objectArray == null) {
            this.info = new String[0];
        } else {
            this.info = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                String string2 = String.valueOf(objectArray[n]);
                Matcher matcher = URL_PATTERN.matcher(string2);
                if (matcher.find()) {
                    Matcher matcher2 = PASSWORD_PATTERN.matcher(string2);
                    string2 = matcher2.replaceFirst(":***@");
                }
                this.info[n] = string2;
                ++n;
            }
        }
        this.code = string;
        this.throwable = throwable;
    }

    public FileSystemException(Throwable throwable) {
        this(throwable.getMessage(), null, throwable);
    }

    @Override
    public String getMessage() {
        return Messages.getString(super.getMessage(), this.getInfo());
    }

    @Override
    public final Throwable getCause() {
        return this.throwable;
    }

    public String getCode() {
        return this.code;
    }

    public String[] getInfo() {
        return this.info;
    }
}

