/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;

public class FileDepthSelector
implements FileSelector {
    private final int minDepth;
    private final int maxDepth;

    public FileDepthSelector(int n, int n2) {
        this.minDepth = n;
        this.maxDepth = n2;
    }

    @Override
    public boolean includeFile(FileSelectInfo fileSelectInfo) {
        int n = fileSelectInfo.getDepth();
        return this.minDepth <= n && n <= this.maxDepth;
    }

    @Override
    public boolean traverseDescendents(FileSelectInfo fileSelectInfo) {
        return fileSelectInfo.getDepth() < this.maxDepth;
    }
}

