/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.net.io.Util;

public final class KeyManagerUtils {
    private static final String DEFAULT_STORE_TYPE = KeyStore.getDefaultType();

    private KeyManagerUtils() {
    }

    public static KeyManager createClientKeyManager(KeyStore keyStore, String string, String string2) throws GeneralSecurityException {
        ClientKeyStore clientKeyStore = new ClientKeyStore(keyStore, string != null ? string : KeyManagerUtils.findAlias(keyStore), string2);
        return new X509KeyManager(clientKeyStore);
    }

    public static KeyManager createClientKeyManager(String string, File file, String string2, String string3, String string4) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyManagerUtils.loadStore(string, file, string2);
        return KeyManagerUtils.createClientKeyManager(keyStore, string3, string4);
    }

    public static KeyManager createClientKeyManager(File file, String string, String string2) throws IOException, GeneralSecurityException {
        return KeyManagerUtils.createClientKeyManager(DEFAULT_STORE_TYPE, file, string, string2, string);
    }

    public static KeyManager createClientKeyManager(File file, String string) throws IOException, GeneralSecurityException {
        return KeyManagerUtils.createClientKeyManager(DEFAULT_STORE_TYPE, file, string, null, string);
    }

    private static KeyStore loadStore(String string, File file, String string2) throws KeyStoreException, IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(string);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            keyStore.load(fileInputStream, string2.toCharArray());
        }
        catch (Throwable throwable) {
            Util.closeQuietly(fileInputStream);
            throw throwable;
        }
        Util.closeQuietly(fileInputStream);
        return keyStore;
    }

    private static String findAlias(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            return string;
        }
        throw new KeyStoreException("Cannot find a private key entry");
    }

    private static class ClientKeyStore {
        private final X509Certificate[] certChain;
        private final PrivateKey key;
        private final String keyAlias;

        ClientKeyStore(KeyStore keyStore, String string, String string2) throws GeneralSecurityException {
            this.keyAlias = string;
            this.key = (PrivateKey)keyStore.getKey(this.keyAlias, string2.toCharArray());
            Certificate[] certificateArray = keyStore.getCertificateChain(this.keyAlias);
            X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
            int n = 0;
            while (n < certificateArray.length) {
                x509CertificateArray[n] = (X509Certificate)certificateArray[n];
                ++n;
            }
            this.certChain = x509CertificateArray;
        }

        final X509Certificate[] getCertificateChain() {
            return this.certChain;
        }

        final PrivateKey getPrivateKey() {
            return this.key;
        }

        final String getAlias() {
            return this.keyAlias;
        }
    }

    private static class X509KeyManager
    extends X509ExtendedKeyManager {
        private final ClientKeyStore keyStore;

        X509KeyManager(ClientKeyStore clientKeyStore) {
            this.keyStore = clientKeyStore;
        }

        @Override
        public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
            return this.keyStore.getAlias();
        }

        @Override
        public X509Certificate[] getCertificateChain(String string) {
            return this.keyStore.getCertificateChain();
        }

        @Override
        public String[] getClientAliases(String string, Principal[] principalArray) {
            return new String[]{this.keyStore.getAlias()};
        }

        @Override
        public PrivateKey getPrivateKey(String string) {
            return this.keyStore.getPrivateKey();
        }

        @Override
        public String[] getServerAliases(String string, Principal[] principalArray) {
            return null;
        }

        @Override
        public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
            return null;
        }
    }
}

