/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class Base64 {
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    static final int CHUNK_SIZE = 76;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte PAD = 61;
    private static final byte[] DECODE_TABLE;
    private static final int MASK_6BITS = 63;
    private static final int MASK_8BITS = 255;
    private final byte[] encodeTable;
    private final int lineLength;
    private final byte[] lineSeparator;
    private final int decodeSize;
    private final int encodeSize;
    private byte[] buffer;
    private int pos;
    private int readPos;
    private int currentLinePos;
    private int modulus;
    private boolean eof;
    private int x;

    static {
        byte[] byArray = new byte[123];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = 62;
        byArray[44] = -1;
        byArray[45] = 62;
        byArray[46] = -1;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = 63;
        byArray[96] = -1;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        DECODE_TABLE = byArray;
    }

    public Base64() {
        this(false);
    }

    public Base64(boolean bl) {
        this(76, CHUNK_SEPARATOR, bl);
    }

    public Base64(int n) {
        this(n, CHUNK_SEPARATOR);
    }

    public Base64(int n, byte[] byArray) {
        this(n, byArray, false);
    }

    public Base64(int n, byte[] byArray, boolean bl) {
        if (byArray == null) {
            n = 0;
            byArray = CHUNK_SEPARATOR;
        }
        this.lineLength = n > 0 ? n / 4 * 4 : 0;
        this.lineSeparator = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.lineSeparator, 0, byArray.length);
        this.encodeSize = n > 0 ? 4 + byArray.length : 4;
        this.decodeSize = this.encodeSize - 1;
        if (Base64.containsBase64Byte(byArray)) {
            String string = Base64.newStringUtf8(byArray);
            throw new IllegalArgumentException("lineSeperator must not contain base64 characters: [" + string + "]");
        }
        this.encodeTable = bl ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
    }

    public boolean isUrlSafe() {
        return this.encodeTable == URL_SAFE_ENCODE_TABLE;
    }

    boolean hasData() {
        return this.buffer != null;
    }

    int avail() {
        return this.buffer != null ? this.pos - this.readPos : 0;
    }

    private void resizeBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[8192];
            this.pos = 0;
            this.readPos = 0;
        } else {
            byte[] byArray = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }
    }

    int readResults(byte[] byArray, int n, int n2) {
        if (this.buffer != null) {
            int n3 = Math.min(this.avail(), n2);
            if (this.buffer != byArray) {
                System.arraycopy(this.buffer, this.readPos, byArray, n, n3);
                this.readPos += n3;
                if (this.readPos >= this.pos) {
                    this.buffer = null;
                }
            } else {
                this.buffer = null;
            }
            return n3;
        }
        return this.eof ? -1 : 0;
    }

    void setInitialBuffer(byte[] byArray, int n, int n2) {
        if (byArray != null && byArray.length == n2) {
            this.buffer = byArray;
            this.pos = n;
            this.readPos = n;
        }
    }

    void encode(byte[] byArray, int n, int n2) {
        if (this.eof) {
            return;
        }
        if (n2 < 0) {
            this.eof = true;
            if (this.buffer == null || this.buffer.length - this.pos < this.encodeSize) {
                this.resizeBuffer();
            }
            switch (this.modulus) {
                case 1: {
                    this.buffer[this.pos++] = this.encodeTable[this.x >> 2 & 0x3F];
                    this.buffer[this.pos++] = this.encodeTable[this.x << 4 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    break;
                }
                case 2: {
                    this.buffer[this.pos++] = this.encodeTable[this.x >> 10 & 0x3F];
                    this.buffer[this.pos++] = this.encodeTable[this.x >> 4 & 0x3F];
                    this.buffer[this.pos++] = this.encodeTable[this.x << 2 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    this.buffer[this.pos++] = 61;
                }
            }
            if (this.lineLength > 0 && this.pos > 0) {
                System.arraycopy(this.lineSeparator, 0, this.buffer, this.pos, this.lineSeparator.length);
                this.pos += this.lineSeparator.length;
            }
        } else {
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                if (this.buffer == null || this.buffer.length - this.pos < this.encodeSize) {
                    this.resizeBuffer();
                }
                ++this.modulus;
                this.modulus %= 3;
                if ((n4 = byArray[n++]) < 0) {
                    n4 += 256;
                }
                this.x = (this.x << 8) + n4;
                if (this.modulus == 0) {
                    this.buffer[this.pos++] = this.encodeTable[this.x >> 18 & 0x3F];
                    this.buffer[this.pos++] = this.encodeTable[this.x >> 12 & 0x3F];
                    this.buffer[this.pos++] = this.encodeTable[this.x >> 6 & 0x3F];
                    this.buffer[this.pos++] = this.encodeTable[this.x & 0x3F];
                    this.currentLinePos += 4;
                    if (this.lineLength > 0 && this.lineLength <= this.currentLinePos) {
                        System.arraycopy(this.lineSeparator, 0, this.buffer, this.pos, this.lineSeparator.length);
                        this.pos += this.lineSeparator.length;
                        this.currentLinePos = 0;
                    }
                }
                ++n3;
            }
        }
    }

    void decode(byte[] byArray, int n, int n2) {
        if (this.eof) {
            return;
        }
        if (n2 < 0) {
            this.eof = true;
        }
        int n3 = 0;
        while (n3 < n2) {
            byte by;
            byte by2;
            if (this.buffer == null || this.buffer.length - this.pos < this.decodeSize) {
                this.resizeBuffer();
            }
            if ((by2 = byArray[n++]) == 61) {
                this.eof = true;
                break;
            }
            if (by2 >= 0 && by2 < DECODE_TABLE.length && (by = DECODE_TABLE[by2]) >= 0) {
                ++this.modulus;
                this.modulus %= 4;
                this.x = (this.x << 6) + by;
                if (this.modulus == 0) {
                    this.buffer[this.pos++] = (byte)(this.x >> 16 & 0xFF);
                    this.buffer[this.pos++] = (byte)(this.x >> 8 & 0xFF);
                    this.buffer[this.pos++] = (byte)(this.x & 0xFF);
                }
            }
            ++n3;
        }
        if (this.eof && this.modulus != 0) {
            this.x <<= 6;
            switch (this.modulus) {
                case 2: {
                    this.x <<= 6;
                    this.buffer[this.pos++] = (byte)(this.x >> 16 & 0xFF);
                    break;
                }
                case 3: {
                    this.buffer[this.pos++] = (byte)(this.x >> 16 & 0xFF);
                    this.buffer[this.pos++] = (byte)(this.x >> 8 & 0xFF);
                }
            }
        }
    }

    public static boolean isBase64(byte by) {
        return by == 61 || by >= 0 && by < DECODE_TABLE.length && DECODE_TABLE[by] != -1;
    }

    public static boolean isArrayByteBase64(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            if (!Base64.isBase64(byArray[n]) && !Base64.isWhiteSpace(byArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean containsBase64Byte(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            if (Base64.isBase64(byArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static byte[] encodeBase64(byte[] byArray) {
        return Base64.encodeBase64(byArray, false);
    }

    public static String encodeBase64String(byte[] byArray) {
        return Base64.newStringUtf8(Base64.encodeBase64(byArray, true));
    }

    public static byte[] encodeBase64URLSafe(byte[] byArray) {
        return Base64.encodeBase64(byArray, false, true);
    }

    public static String encodeBase64URLSafeString(byte[] byArray) {
        return Base64.newStringUtf8(Base64.encodeBase64(byArray, false, true));
    }

    public static byte[] encodeBase64Chunked(byte[] byArray) {
        return Base64.encodeBase64(byArray, true);
    }

    public Object decode(Object object) {
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new RuntimeException("Parameter supplied to Base64 decode is not a byte[] or a String");
    }

    public byte[] decode(String string) {
        return this.decode(this.getBytesUtf8(string));
    }

    private byte[] getBytesUtf8(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public byte[] decode(byte[] byArray) {
        this.reset();
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        long l = byArray.length * 3 / 4;
        byte[] byArray2 = new byte[(int)l];
        this.setInitialBuffer(byArray2, 0, byArray2.length);
        this.decode(byArray, 0, byArray.length);
        this.decode(byArray, 0, -1);
        byte[] byArray3 = new byte[this.pos];
        this.readResults(byArray3, 0, byArray3.length);
        return byArray3;
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl) {
        return Base64.encodeBase64(byArray, bl, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl, boolean bl2) {
        return Base64.encodeBase64(byArray, bl, bl2, Integer.MAX_VALUE);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl, boolean bl2, int n) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        long l = Base64.getEncodeLength(byArray, 76, CHUNK_SEPARATOR);
        if (l > (long)n) {
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + l + ") than the specified maxium size of " + n);
        }
        Base64 base64 = bl ? new Base64(bl2) : new Base64(0, CHUNK_SEPARATOR, bl2);
        return base64.encode(byArray);
    }

    public static byte[] decodeBase64(String string) {
        return new Base64().decode(string);
    }

    public static byte[] decodeBase64(byte[] byArray) {
        return new Base64().decode(byArray);
    }

    private static boolean isWhiteSpace(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public Object encode(Object object) {
        if (!(object instanceof byte[])) {
            throw new RuntimeException("Parameter supplied to Base64 encode is not a byte[]");
        }
        return this.encode((byte[])object);
    }

    public String encodeToString(byte[] byArray) {
        return Base64.newStringUtf8(this.encode(byArray));
    }

    private static String newStringUtf8(byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return string;
    }

    public byte[] encode(byte[] byArray) {
        this.reset();
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        long l = Base64.getEncodeLength(byArray, this.lineLength, this.lineSeparator);
        byte[] byArray2 = new byte[(int)l];
        this.setInitialBuffer(byArray2, 0, byArray2.length);
        this.encode(byArray, 0, byArray.length);
        this.encode(byArray, 0, -1);
        if (this.buffer != byArray2) {
            this.readResults(byArray2, 0, byArray2.length);
        }
        if (this.isUrlSafe() && this.pos < byArray2.length) {
            byte[] byArray3 = new byte[this.pos];
            System.arraycopy(byArray2, 0, byArray3, 0, this.pos);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    private static long getEncodeLength(byte[] byArray, int n, byte[] byArray2) {
        n = n / 4 * 4;
        long l = byArray.length * 4 / 3;
        long l2 = l % 4L;
        if (l2 != 0L) {
            l += 4L - l2;
        }
        if (n > 0) {
            boolean bl = l % (long)n == 0L;
            l += l / (long)n * (long)byArray2.length;
            if (!bl) {
                l += (long)byArray2.length;
            }
        }
        return l;
    }

    public static BigInteger decodeInteger(byte[] byArray) {
        return new BigInteger(1, Base64.decodeBase64(byArray));
    }

    public static byte[] encodeInteger(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new NullPointerException("encodeInteger called with null parameter");
        }
        return Base64.encodeBase64(Base64.toIntegerBytes(bigInteger), false);
    }

    static byte[] toIntegerBytes(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        n = n + 7 >> 3 << 3;
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            return byArray;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n2 = 1;
            --n3;
        }
        int n4 = n / 8 - n3;
        byte[] byArray2 = new byte[n / 8];
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return byArray2;
    }

    private void reset() {
        this.buffer = null;
        this.pos = 0;
        this.readPos = 0;
        this.currentLinePos = 0;
        this.modulus = 0;
        this.eof = false;
    }
}

