/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.pop3;

import java.io.IOException;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.commons.net.io.DotTerminatedMessageReader;
import org.apache.commons.net.pop3.POP3;
import org.apache.commons.net.pop3.POP3MessageInfo;

public class POP3Client
extends POP3 {
    private static POP3MessageInfo __parseStatus(String string) {
        int n;
        int n2;
        StringTokenizer stringTokenizer;
        block4: {
            stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreElements()) {
                return null;
            }
            n2 = 0;
            n = 0;
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreElements()) break block4;
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        n2 = Integer.parseInt(stringTokenizer.nextToken());
        return new POP3MessageInfo(n, n2);
    }

    private static POP3MessageInfo __parseUID(String string) {
        int n;
        StringTokenizer stringTokenizer;
        block4: {
            stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreElements()) {
                return null;
            }
            n = 0;
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreElements()) break block4;
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        string = stringTokenizer.nextToken();
        return new POP3MessageInfo(n, string);
    }

    public boolean login(String string, String string2) throws IOException {
        if (this.getState() != 0) {
            return false;
        }
        if (this.sendCommand(0, string) != 0) {
            return false;
        }
        if (this.sendCommand(1, string2) != 0) {
            return false;
        }
        this.setState(1);
        return true;
    }

    public boolean login(String string, String string2, String string3) throws IOException, NoSuchAlgorithmException {
        if (this.getState() != 0) {
            return false;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        string2 = String.valueOf(string2) + string3;
        byte[] byArray = messageDigest.digest(string2.getBytes());
        StringBuilder stringBuilder = new StringBuilder(128);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            if (n2 <= 15) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toHexString(n2));
            ++n;
        }
        StringBuilder stringBuilder2 = new StringBuilder(256);
        stringBuilder2.append(string);
        stringBuilder2.append(' ');
        stringBuilder2.append(stringBuilder.toString());
        if (this.sendCommand(9, stringBuilder2.toString()) != 0) {
            return false;
        }
        this.setState(1);
        return true;
    }

    public boolean logout() throws IOException {
        if (this.getState() == 1) {
            this.setState(2);
        }
        this.sendCommand(2);
        return this._replyCode == 0;
    }

    public boolean noop() throws IOException {
        if (this.getState() == 1) {
            return this.sendCommand(7) == 0;
        }
        return false;
    }

    public boolean deleteMessage(int n) throws IOException {
        if (this.getState() == 1) {
            return this.sendCommand(6, Integer.toString(n)) == 0;
        }
        return false;
    }

    public boolean reset() throws IOException {
        if (this.getState() == 1) {
            return this.sendCommand(8) == 0;
        }
        return false;
    }

    public POP3MessageInfo status() throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(3) != 0) {
            return null;
        }
        return POP3Client.__parseStatus(this._lastReplyLine.substring(3));
    }

    public POP3MessageInfo listMessage(int n) throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(4, Integer.toString(n)) != 0) {
            return null;
        }
        return POP3Client.__parseStatus(this._lastReplyLine.substring(3));
    }

    public POP3MessageInfo[] listMessages() throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(4) != 0) {
            return null;
        }
        this.getAdditionalReply();
        POP3MessageInfo[] pOP3MessageInfoArray = new POP3MessageInfo[this._replyLines.size() - 2];
        ListIterator listIterator = this._replyLines.listIterator(1);
        int n = 0;
        while (n < pOP3MessageInfoArray.length) {
            pOP3MessageInfoArray[n] = POP3Client.__parseStatus((String)listIterator.next());
            ++n;
        }
        return pOP3MessageInfoArray;
    }

    public POP3MessageInfo listUniqueIdentifier(int n) throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(11, Integer.toString(n)) != 0) {
            return null;
        }
        return POP3Client.__parseUID(this._lastReplyLine.substring(3));
    }

    public POP3MessageInfo[] listUniqueIdentifiers() throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(11) != 0) {
            return null;
        }
        this.getAdditionalReply();
        POP3MessageInfo[] pOP3MessageInfoArray = new POP3MessageInfo[this._replyLines.size() - 2];
        ListIterator listIterator = this._replyLines.listIterator(1);
        int n = 0;
        while (n < pOP3MessageInfoArray.length) {
            pOP3MessageInfoArray[n] = POP3Client.__parseUID((String)listIterator.next());
            ++n;
        }
        return pOP3MessageInfoArray;
    }

    public Reader retrieveMessage(int n) throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(5, Integer.toString(n)) != 0) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader);
    }

    public Reader retrieveMessageTop(int n, int n2) throws IOException {
        if (n2 < 0 || this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(10, String.valueOf(Integer.toString(n)) + " " + Integer.toString(n2)) != 0) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader);
    }
}

