/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ntp;

import java.net.DatagramPacket;
import org.apache.commons.net.ntp.NtpUtils;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeStamp;

public class NtpV3Impl
implements NtpV3Packet {
    private static final int MODE_INDEX = 0;
    private static final int MODE_SHIFT = 0;
    private static final int VERSION_INDEX = 0;
    private static final int VERSION_SHIFT = 3;
    private static final int LI_INDEX = 0;
    private static final int LI_SHIFT = 6;
    private static final int STRATUM_INDEX = 1;
    private static final int POLL_INDEX = 2;
    private static final int PRECISION_INDEX = 3;
    private static final int ROOT_DELAY_INDEX = 4;
    private static final int ROOT_DISPERSION_INDEX = 8;
    private static final int REFERENCE_ID_INDEX = 12;
    private static final int REFERENCE_TIMESTAMP_INDEX = 16;
    private static final int ORIGINATE_TIMESTAMP_INDEX = 24;
    private static final int RECEIVE_TIMESTAMP_INDEX = 32;
    private static final int TRANSMIT_TIMESTAMP_INDEX = 40;
    private final byte[] buf = new byte[48];
    private volatile DatagramPacket dp;

    @Override
    public int getMode() {
        return NtpV3Impl.ui(this.buf[0]) >> 0 & 7;
    }

    @Override
    public String getModeName() {
        return NtpUtils.getModeName(this.getMode());
    }

    @Override
    public void setMode(int n) {
        this.buf[0] = (byte)(this.buf[0] & 0xF8 | n & 7);
    }

    @Override
    public int getLeapIndicator() {
        return NtpV3Impl.ui(this.buf[0]) >> 6 & 3;
    }

    @Override
    public void setLeapIndicator(int n) {
        this.buf[0] = (byte)(this.buf[0] & 0x3F | (n & 3) << 6);
    }

    @Override
    public int getPoll() {
        return this.buf[2];
    }

    @Override
    public void setPoll(int n) {
        this.buf[2] = (byte)(n & 0xFF);
    }

    @Override
    public int getPrecision() {
        return this.buf[3];
    }

    public void setPrecision(int n) {
        this.buf[3] = (byte)(n & 0xFF);
    }

    @Override
    public int getVersion() {
        return NtpV3Impl.ui(this.buf[0]) >> 3 & 7;
    }

    @Override
    public void setVersion(int n) {
        this.buf[0] = (byte)(this.buf[0] & 0xC7 | (n & 7) << 3);
    }

    @Override
    public int getStratum() {
        return NtpV3Impl.ui(this.buf[1]);
    }

    @Override
    public void setStratum(int n) {
        this.buf[1] = (byte)(n & 0xFF);
    }

    @Override
    public int getRootDelay() {
        return this.getInt(4);
    }

    @Override
    public double getRootDelayInMillisDouble() {
        double d = this.getRootDelay();
        return d / 65.536;
    }

    @Override
    public int getRootDispersion() {
        return this.getInt(8);
    }

    @Override
    public long getRootDispersionInMillis() {
        long l = this.getRootDispersion();
        return l * 1000L / 65536L;
    }

    @Override
    public double getRootDispersionInMillisDouble() {
        double d = this.getRootDispersion();
        return d / 65.536;
    }

    @Override
    public void setReferenceId(int n) {
        int n2 = 3;
        while (n2 >= 0) {
            this.buf[12 + n2] = (byte)(n & 0xFF);
            n >>>= 8;
            --n2;
        }
    }

    @Override
    public int getReferenceId() {
        return this.getInt(12);
    }

    @Override
    public String getReferenceIdString() {
        int n = this.getVersion();
        int n2 = this.getStratum();
        if (n == 3 || n == 4) {
            if (n2 == 0 || n2 == 1) {
                return this.idAsString();
            }
            if (n == 4) {
                return this.idAsHex();
            }
        }
        if (n2 >= 2) {
            return this.idAsIPAddress();
        }
        return this.idAsHex();
    }

    private String idAsIPAddress() {
        return String.valueOf(NtpV3Impl.ui(this.buf[12])) + "." + NtpV3Impl.ui(this.buf[13]) + "." + NtpV3Impl.ui(this.buf[14]) + "." + NtpV3Impl.ui(this.buf[15]);
    }

    private String idAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n <= 3) {
            char c = (char)this.buf[12 + n];
            if (c == '\u0000') break;
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    private String idAsHex() {
        return Integer.toHexString(this.getReferenceId());
    }

    @Override
    public TimeStamp getTransmitTimeStamp() {
        return this.getTimestamp(40);
    }

    @Override
    public void setTransmitTime(TimeStamp timeStamp) {
        this.setTimestamp(40, timeStamp);
    }

    @Override
    public void setOriginateTimeStamp(TimeStamp timeStamp) {
        this.setTimestamp(24, timeStamp);
    }

    @Override
    public TimeStamp getOriginateTimeStamp() {
        return this.getTimestamp(24);
    }

    @Override
    public TimeStamp getReferenceTimeStamp() {
        return this.getTimestamp(16);
    }

    @Override
    public void setReferenceTime(TimeStamp timeStamp) {
        this.setTimestamp(16, timeStamp);
    }

    @Override
    public TimeStamp getReceiveTimeStamp() {
        return this.getTimestamp(32);
    }

    @Override
    public void setReceiveTimeStamp(TimeStamp timeStamp) {
        this.setTimestamp(32, timeStamp);
    }

    @Override
    public String getType() {
        return "NTP";
    }

    private int getInt(int n) {
        int n2 = NtpV3Impl.ui(this.buf[n]) << 24 | NtpV3Impl.ui(this.buf[n + 1]) << 16 | NtpV3Impl.ui(this.buf[n + 2]) << 8 | NtpV3Impl.ui(this.buf[n + 3]);
        return n2;
    }

    private TimeStamp getTimestamp(int n) {
        return new TimeStamp(this.getLong(n));
    }

    private long getLong(int n) {
        long l = NtpV3Impl.ul(this.buf[n]) << 56 | NtpV3Impl.ul(this.buf[n + 1]) << 48 | NtpV3Impl.ul(this.buf[n + 2]) << 40 | NtpV3Impl.ul(this.buf[n + 3]) << 32 | NtpV3Impl.ul(this.buf[n + 4]) << 24 | NtpV3Impl.ul(this.buf[n + 5]) << 16 | NtpV3Impl.ul(this.buf[n + 6]) << 8 | NtpV3Impl.ul(this.buf[n + 7]);
        return l;
    }

    private void setTimestamp(int n, TimeStamp timeStamp) {
        long l = timeStamp == null ? 0L : timeStamp.ntpValue();
        int n2 = 7;
        while (n2 >= 0) {
            this.buf[n + n2] = (byte)(l & 0xFFL);
            l >>>= 8;
            --n2;
        }
    }

    @Override
    public synchronized DatagramPacket getDatagramPacket() {
        if (this.dp == null) {
            this.dp = new DatagramPacket(this.buf, this.buf.length);
            this.dp.setPort(123);
        }
        return this.dp;
    }

    @Override
    public void setDatagramPacket(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        int n = datagramPacket.getLength();
        if (n > this.buf.length) {
            n = this.buf.length;
        }
        System.arraycopy(byArray, 0, this.buf, 0, n);
    }

    protected static final int ui(byte by) {
        int n = by & 0xFF;
        return n;
    }

    protected static final long ul(byte by) {
        long l = by & 0xFF;
        return l;
    }

    public String toString() {
        return "[version:" + this.getVersion() + ", mode:" + this.getMode() + ", poll:" + this.getPoll() + ", precision:" + this.getPrecision() + ", delay:" + this.getRootDelay() + ", dispersion(ms):" + this.getRootDispersionInMillisDouble() + ", id:" + this.getReferenceIdString() + ", xmitTime:" + this.getTransmitTimeStamp().toDateString() + " ]";
    }
}

