/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ntp;

import org.apache.commons.net.ntp.NtpV3Packet;

public final class NtpUtils {
    public static String getHostAddress(int n) {
        return String.valueOf(n >>> 24 & 0xFF) + "." + (n >>> 16 & 0xFF) + "." + (n >>> 8 & 0xFF) + "." + (n >>> 0 & 0xFF);
    }

    public static String getRefAddress(NtpV3Packet ntpV3Packet) {
        int n = ntpV3Packet == null ? 0 : ntpV3Packet.getReferenceId();
        return NtpUtils.getHostAddress(n);
    }

    public static String getReferenceClock(NtpV3Packet ntpV3Packet) {
        if (ntpV3Packet == null) {
            return "";
        }
        int n = ntpV3Packet.getReferenceId();
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(4);
        int n2 = 24;
        while (n2 >= 0) {
            char c = (char)(n >>> n2 & 0xFF);
            if (c == '\u0000') break;
            if (!Character.isLetterOrDigit(c)) {
                return "";
            }
            stringBuilder.append(c);
            n2 -= 8;
        }
        return stringBuilder.toString();
    }

    public static String getModeName(int n) {
        switch (n) {
            case 0: {
                return "Reserved";
            }
            case 1: {
                return "Symmetric Active";
            }
            case 2: {
                return "Symmetric Passive";
            }
            case 3: {
                return "Client";
            }
            case 4: {
                return "Server";
            }
            case 5: {
                return "Broadcast";
            }
            case 6: {
                return "Control";
            }
            case 7: {
                return "Private";
            }
        }
        return "Unknown";
    }
}

