/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.imap;

import java.io.IOException;
import org.apache.commons.net.imap.IMAP;
import org.apache.commons.net.imap.IMAPCommand;

public class IMAPClient
extends IMAP {
    public boolean capability() throws IOException {
        return this.doCommand(IMAPCommand.CAPABILITY);
    }

    public boolean noop() throws IOException {
        return this.doCommand(IMAPCommand.NOOP);
    }

    public boolean logout() throws IOException {
        return this.doCommand(IMAPCommand.LOGOUT);
    }

    public boolean login(String string, String string2) throws IOException {
        if (this.getState() != IMAP.IMAPState.NOT_AUTH_STATE) {
            return false;
        }
        if (!this.doCommand(IMAPCommand.LOGIN, String.valueOf(string) + " " + string2)) {
            return false;
        }
        this.setState(IMAP.IMAPState.AUTH_STATE);
        return true;
    }

    public boolean select(String string) throws IOException {
        return this.doCommand(IMAPCommand.SELECT, string);
    }

    public boolean examine(String string) throws IOException {
        return this.doCommand(IMAPCommand.EXAMINE, string);
    }

    public boolean create(String string) throws IOException {
        return this.doCommand(IMAPCommand.CREATE, string);
    }

    public boolean delete(String string) throws IOException {
        return this.doCommand(IMAPCommand.DELETE, string);
    }

    public boolean rename(String string, String string2) throws IOException {
        return this.doCommand(IMAPCommand.RENAME, String.valueOf(string) + " " + string2);
    }

    public boolean subscribe(String string) throws IOException {
        return this.doCommand(IMAPCommand.SUBSCRIBE, string);
    }

    public boolean unsubscribe(String string) throws IOException {
        return this.doCommand(IMAPCommand.UNSUBSCRIBE, string);
    }

    public boolean list(String string, String string2) throws IOException {
        return this.doCommand(IMAPCommand.LIST, String.valueOf(string) + " " + string2);
    }

    public boolean lsub(String string, String string2) throws IOException {
        return this.doCommand(IMAPCommand.LSUB, String.valueOf(string) + " " + string2);
    }

    public boolean status(String string, String[] stringArray) throws IOException {
        if (stringArray == null || stringArray.length < 1) {
            throw new IllegalArgumentException("STATUS command requires at least one data item name");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(" (");
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(stringArray[n]);
            ++n;
        }
        stringBuilder.append(")");
        return this.doCommand(IMAPCommand.STATUS, stringBuilder.toString());
    }

    public boolean append(String string, String string2, String string3) throws IOException {
        String string4 = string;
        if (string2 != null) {
            string4 = String.valueOf(string4) + " " + string2;
        }
        if (string3 != null) {
            string4 = string3.charAt(0) == '{' ? String.valueOf(string4) + " " + string3 : String.valueOf(string4) + " {" + string3 + "}";
        }
        return this.doCommand(IMAPCommand.APPEND, string4);
    }

    public boolean append(String string) throws IOException {
        return this.append(string, null, null);
    }

    public boolean check() throws IOException {
        return this.doCommand(IMAPCommand.CHECK);
    }

    public boolean close() throws IOException {
        return this.doCommand(IMAPCommand.CLOSE);
    }

    public boolean expunge() throws IOException {
        return this.doCommand(IMAPCommand.EXPUNGE);
    }

    public boolean search(String string, String string2) throws IOException {
        String string3 = "";
        if (string != null) {
            string3 = String.valueOf(string3) + "CHARSET " + string;
        }
        string3 = String.valueOf(string3) + string2;
        return this.doCommand(IMAPCommand.SEARCH, string3);
    }

    public boolean search(String string) throws IOException {
        return this.search(null, string);
    }

    public boolean fetch(String string, String string2) throws IOException {
        return this.doCommand(IMAPCommand.FETCH, String.valueOf(string) + " " + string2);
    }

    public boolean store(String string, String string2, String string3) throws IOException {
        return this.doCommand(IMAPCommand.STORE, String.valueOf(string) + " " + string2 + " " + string3);
    }

    public boolean copy(String string, String string2) throws IOException {
        return this.doCommand(IMAPCommand.COPY, String.valueOf(string) + " " + string2);
    }

    public boolean uid(String string, String string2) throws IOException {
        return this.doCommand(IMAPCommand.UID, String.valueOf(string) + " " + string2);
    }

    public static enum FETCH_ITEM_NAMES {
        ALL,
        FAST,
        FULL,
        BODY,
        BODYSTRUCTURE,
        ENVELOPE,
        FLAGS,
        INTERNALDATE,
        RFC822,
        UID;

    }

    public static enum SEARCH_CRITERIA {
        ALL,
        ANSWERED,
        BCC,
        BEFORE,
        BODY,
        CC,
        DELETED,
        DRAFT,
        FLAGGED,
        FROM,
        HEADER,
        KEYWORD,
        LARGER,
        NEW,
        NOT,
        OLD,
        ON,
        OR,
        RECENT,
        SEEN,
        SENTBEFORE,
        SENTON,
        SENTSINCE,
        SINCE,
        SMALLER,
        SUBJECT,
        TEXT,
        TO,
        UID,
        UNANSWERED,
        UNDELETED,
        UNDRAFT,
        UNFLAGGED,
        UNKEYWORD,
        UNSEEN;

    }

    public static enum STATUS_DATA_ITEMS {
        MESSAGES,
        RECENT,
        UIDNEXT,
        UIDVALIDITY,
        UNSEEN;

    }
}

