/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.imap;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import org.apache.commons.net.imap.IMAP;
import org.apache.commons.net.imap.IMAPCommand;
import org.apache.commons.net.imap.IMAPReply;
import org.apache.commons.net.imap.IMAPSClient;
import org.apache.commons.net.util.Base64;

public class AuthenticatingIMAPClient
extends IMAPSClient {
    public AuthenticatingIMAPClient() {
        this("TLS", false);
    }

    public AuthenticatingIMAPClient(boolean bl) {
        this("TLS", bl);
    }

    public AuthenticatingIMAPClient(String string) {
        this(string, false);
    }

    public AuthenticatingIMAPClient(String string, boolean bl) {
        this(string, bl, null);
    }

    public AuthenticatingIMAPClient(String string, boolean bl, SSLContext sSLContext) {
        super(string, bl, sSLContext);
    }

    public AuthenticatingIMAPClient(boolean bl, SSLContext sSLContext) {
        this("TLS", bl, sSLContext);
    }

    public AuthenticatingIMAPClient(SSLContext sSLContext) {
        this(false, sSLContext);
    }

    public boolean authenticate(AUTH_METHOD aUTH_METHOD, String string, String string2) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        return this.auth(aUTH_METHOD, string, string2);
    }

    public boolean auth(AUTH_METHOD aUTH_METHOD, String string, String string2) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        if (!IMAPReply.isContinuation(this.sendCommand(IMAPCommand.AUTHENTICATE, aUTH_METHOD.getAuthName()))) {
            return false;
        }
        switch (aUTH_METHOD) {
            case PLAIN: {
                int n = this.sendData(new String(Base64.encodeBase64(("\u0000" + string + "\u0000" + string2).getBytes())));
                if (n == 0) {
                    this.setState(IMAP.IMAPState.AUTH_STATE);
                }
                return n == 0;
            }
            case CRAM_MD5: {
                byte[] byArray = Base64.decodeBase64(this.getReplyString().substring(2).trim());
                Mac mac = Mac.getInstance("HmacMD5");
                mac.init(new SecretKeySpec(string2.getBytes(), "HmacMD5"));
                byte[] byArray2 = this._convertToHexString(mac.doFinal(byArray)).getBytes();
                byte[] byArray3 = string.getBytes();
                byte[] byArray4 = new byte[byArray3.length + 1 + byArray2.length];
                System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
                byArray4[byArray3.length] = 32;
                System.arraycopy(byArray2, 0, byArray4, byArray3.length + 1, byArray2.length);
                int n = this.sendData(new String(Base64.encodeBase64(byArray4)));
                if (n == 0) {
                    this.setState(IMAP.IMAPState.AUTH_STATE);
                }
                return n == 0;
            }
            case LOGIN: {
                if (this.sendData(new String(Base64.encodeBase64(string.getBytes()))) != 3) {
                    return false;
                }
                int n = this.sendData(new String(Base64.encodeBase64(string2.getBytes())));
                if (n == 0) {
                    this.setState(IMAP.IMAPState.AUTH_STATE);
                }
                return n == 0;
            }
        }
        return false;
    }

    private String _convertToHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & 0xFF) <= 15) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toHexString(byArray[n] & 0xFF));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static enum AUTH_METHOD {
        PLAIN("PLAIN"),
        CRAM_MD5("CRAM-MD5"),
        LOGIN("LOGIN");

        private final String authName;

        private AUTH_METHOD(String string2) {
            this.authName = string2;
        }

        public final String getAuthName() {
            return this.authName;
        }
    }
}

