/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.parser.VMSFTPEntryParser;

public class VMSVersioningFTPEntryParser
extends VMSFTPEntryParser {
    private final Pattern _preparse_pattern_;
    private static final String PRE_PARSE_REGEX = "(.*);([0-9]+)\\s*.*";

    public VMSVersioningFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public VMSVersioningFTPEntryParser(FTPClientConfig fTPClientConfig) {
        this.configure(fTPClientConfig);
        try {
            this._preparse_pattern_ = Pattern.compile(PRE_PARSE_REGEX);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Unparseable regex supplied:  (.*);([0-9]+)\\s*.*");
        }
    }

    @Override
    public List<String> preParse(List<String> list) {
        Integer n;
        Integer n2;
        String string;
        String string2;
        Matcher matcher;
        MatchResult matchResult;
        String string3;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            string3 = listIterator.next().trim();
            matchResult = null;
            matcher = this._preparse_pattern_.matcher(string3);
            if (!matcher.matches()) continue;
            matchResult = matcher.toMatchResult();
            string2 = matchResult.group(1);
            string = matchResult.group(2);
            n2 = Integer.valueOf(string);
            n = (Integer)hashMap.get(string2);
            if (n != null && n2 < n) {
                listIterator.remove();
                continue;
            }
            hashMap.put(string2, n2);
        }
        while (listIterator.hasPrevious()) {
            string3 = listIterator.previous().trim();
            matchResult = null;
            matcher = this._preparse_pattern_.matcher(string3);
            if (!matcher.matches()) continue;
            matchResult = matcher.toMatchResult();
            string2 = matchResult.group(1);
            string = matchResult.group(2);
            n2 = Integer.valueOf(string);
            n = (Integer)hashMap.get(string2);
            if (n == null || n2 >= n) continue;
            listIterator.remove();
        }
        return list;
    }

    @Override
    protected boolean isVersioning() {
        return true;
    }
}

