/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.net.ftp.FTPFileEntryParserImpl;

public abstract class RegexFTPFileEntryParserImpl
extends FTPFileEntryParserImpl {
    private Pattern pattern = null;
    private MatchResult result = null;
    protected Matcher _matcher_ = null;

    public RegexFTPFileEntryParserImpl(String string) {
        this.setRegex(string);
    }

    public boolean matches(String string) {
        this.result = null;
        this._matcher_ = this.pattern.matcher(string);
        if (this._matcher_.matches()) {
            this.result = this._matcher_.toMatchResult();
        }
        return this.result != null;
    }

    public int getGroupCnt() {
        if (this.result == null) {
            return 0;
        }
        return this.result.groupCount();
    }

    public String group(int n) {
        if (this.result == null) {
            return null;
        }
        return this.result.group(n);
    }

    public String getGroupsAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        while (n <= this.result.groupCount()) {
            stringBuilder.append(n).append(") ").append(this.result.group(n)).append(System.getProperty("line.separator"));
            ++n;
        }
        return stringBuilder.toString();
    }

    public boolean setRegex(String string) {
        try {
            this.pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Unparseable regex supplied: " + string);
        }
        return this.pattern != null;
    }
}

