/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParserImpl;

public class MLSxEntryParser
extends FTPFileEntryParserImpl {
    private static final MLSxEntryParser PARSER = new MLSxEntryParser();
    private static final HashMap<String, Integer> TYPE_TO_INT = new HashMap();
    private static int[] UNIX_GROUPS;
    private static int[][] UNIX_PERMS;

    static {
        TYPE_TO_INT.put("file", 0);
        TYPE_TO_INT.put("cdir", 1);
        TYPE_TO_INT.put("pdir", 1);
        TYPE_TO_INT.put("dir", 1);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        UNIX_GROUPS = nArray;
        int[][] nArrayArray = new int[8][];
        nArrayArray[0] = new int[0];
        nArrayArray[1] = new int[]{2};
        nArrayArray[2] = new int[]{1};
        nArrayArray[3] = new int[]{2, 1};
        nArrayArray[4] = new int[1];
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        nArrayArray[5] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray[6] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArrayArray[7] = nArray4;
        UNIX_PERMS = nArrayArray;
    }

    @Override
    public FTPFile parseFTPEntry(String string) {
        String[] stringArray = string.split(" ", 2);
        if (stringArray.length != 2) {
            return null;
        }
        FTPFile fTPFile = new FTPFile();
        fTPFile.setRawListing(string);
        fTPFile.setName(stringArray[1]);
        String[] stringArray2 = stringArray[0].split(";");
        boolean bl = stringArray[0].toLowerCase(Locale.ENGLISH).contains("unix.mode=");
        String[] stringArray3 = stringArray2;
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray3[n2];
            String[] stringArray4 = string2.split("=");
            if (stringArray4.length == 2) {
                Object object;
                String string3 = stringArray4[0].toLowerCase(Locale.ENGLISH);
                String string4 = stringArray4[1];
                String string5 = string4.toLowerCase(Locale.ENGLISH);
                if ("size".equals(string3)) {
                    fTPFile.setSize(Long.parseLong(string4));
                } else if ("sizd".equals(string3)) {
                    fTPFile.setSize(Long.parseLong(string4));
                } else if ("modify".equals(string3)) {
                    object = string4.contains(".") ? new SimpleDateFormat("yyyyMMddHHmmss.SSS") : new SimpleDateFormat("yyyyMMddHHmmss");
                    TimeZone timeZone = TimeZone.getTimeZone("GMT");
                    ((DateFormat)object).setTimeZone(timeZone);
                    GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
                    try {
                        gregorianCalendar.setTime(((DateFormat)object).parse(string4));
                    }
                    catch (ParseException parseException) {}
                    fTPFile.setTimestamp(gregorianCalendar);
                } else if ("type".equals(string3)) {
                    object = TYPE_TO_INT.get(string5);
                    if (object == null) {
                        fTPFile.setType(3);
                    } else {
                        fTPFile.setType((Integer)object);
                    }
                } else if (string3.startsWith("unix.")) {
                    object = string3.substring("unix.".length()).toLowerCase(Locale.ENGLISH);
                    if ("group".equals(object)) {
                        fTPFile.setGroup(string4);
                    } else if ("owner".equals(object)) {
                        fTPFile.setUser(string4);
                    } else if ("mode".equals(object)) {
                        int n3 = string4.length() - 3;
                        int n4 = 0;
                        while (n4 < 3) {
                            int n5 = string4.charAt(n3 + n4) - 48;
                            if (n5 >= 0 && n5 <= 7) {
                                int[] nArray = UNIX_PERMS[n5];
                                int n6 = nArray.length;
                                int n7 = 0;
                                while (n7 < n6) {
                                    int n8 = nArray[n7];
                                    fTPFile.setPermission(UNIX_GROUPS[n4], n8, true);
                                    ++n7;
                                }
                            }
                            ++n4;
                        }
                    }
                } else if (!bl && "perm".equals(string3)) {
                    this.doUnixPerms(fTPFile, string5);
                }
            }
            ++n2;
        }
        return fTPFile;
    }

    private void doUnixPerms(FTPFile fTPFile, String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case 'a': {
                    fTPFile.setPermission(0, 1, true);
                    break;
                }
                case 'c': {
                    fTPFile.setPermission(0, 1, true);
                    break;
                }
                case 'd': {
                    fTPFile.setPermission(0, 1, true);
                    break;
                }
                case 'e': {
                    fTPFile.setPermission(0, 0, true);
                    break;
                }
                case 'f': {
                    break;
                }
                case 'l': {
                    fTPFile.setPermission(0, 2, true);
                    break;
                }
                case 'm': {
                    fTPFile.setPermission(0, 1, true);
                    break;
                }
                case 'p': {
                    fTPFile.setPermission(0, 1, true);
                    break;
                }
                case 'r': {
                    fTPFile.setPermission(0, 0, true);
                    break;
                }
                case 'w': {
                    fTPFile.setPermission(0, 1, true);
                }
            }
            ++n2;
        }
    }

    public static FTPFile parseEntry(String string) {
        return PARSER.parseFTPEntry(string);
    }

    public static MLSxEntryParser getInstance() {
        return PARSER;
    }
}

