/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.util.Base64;

public class FTPHTTPClient
extends FTPClient {
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyUsername;
    private final String proxyPassword;
    private String host;
    private int port;
    private final byte[] CRLF;
    private final Base64 base64 = new Base64();

    public FTPHTTPClient(String string, int n, String string2, String string3) {
        this.proxyHost = string;
        this.proxyPort = n;
        this.proxyUsername = string2;
        this.proxyPassword = string3;
        try {
            this.CRLF = "\r\n".getBytes(this.getControlEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public FTPHTTPClient(String string, int n) {
        this(string, n, null, null);
    }

    @Override
    protected Socket _openDataConnection_(int n, String string) throws IOException {
        Socket socket = new Socket(this.host, this.port);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        this.tunnelHandshake(this.host, this.port, inputStream, outputStream);
        return socket;
    }

    @Override
    public void connect(String string, int n) throws SocketException, IOException {
        this.host = string;
        this.port = n;
        this._socket_ = new Socket(this.proxyHost, this.proxyPort);
        this._input_ = this._socket_.getInputStream();
        this._output_ = this._socket_.getOutputStream();
        try {
            this.tunnelHandshake(string, n, this._input_, this._output_);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Could not connect to " + string);
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private void tunnelHandshake(String string, int n, InputStream inputStream, OutputStream outputStream) throws IOException, UnsupportedEncodingException {
        String string2 = "CONNECT " + string + ":" + n + " HTTP/1.1";
        this._output_.write(string2.getBytes(this.getControlEncoding()));
        this._output_.write(this.CRLF);
        if (this.proxyUsername != null && this.proxyPassword != null) {
            String string3 = "Proxy-Authorization: Basic " + this.base64.encode(String.valueOf(this.proxyUsername) + ":" + this.proxyPassword) + "\r\n";
            this._output_.write(string3.getBytes("UTF-8"));
            this._output_.write(this.CRLF);
            ArrayList<String> arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this._input_));
            String string4 = bufferedReader.readLine();
            while (string4 != null && string4.length() > 0) {
                arrayList.add(string4);
                string4 = bufferedReader.readLine();
            }
            int n2 = arrayList.size();
            if (n2 == 0) {
                throw new IOException("No response from proxy");
            }
            String string5 = null;
            String string6 = (String)arrayList.get(0);
            if (!string6.startsWith("HTTP/") || string6.length() < 12) {
                throw new IOException("Invalid response from proxy: " + string6);
            }
            string5 = string6.substring(9, 12);
            if (!"200".equals(string5)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("HTTPTunnelConnector: connection failed\r\n");
                stringBuilder.append("Response received from the proxy:\r\n");
                for (String string7 : arrayList) {
                    stringBuilder.append(string7);
                    stringBuilder.append("\r\n");
                }
                throw new IOException(stringBuilder.toString());
            }
        }
    }
}

