/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Inflater;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InflaterInputStream
extends FilterInputStream {
    protected final Inflater inflater;
    protected byte[] buf;
    private boolean closed = false;
    private boolean eof = false;
    private boolean close_in = true;
    protected static final int DEFAULT_BUFSIZE = 512;
    protected boolean myinflater = false;
    private byte[] byte1 = new byte[1];
    private byte[] b = new byte[512];

    public InflaterInputStream(InputStream inputStream) throws IOException {
        this(inputStream, new Inflater());
        this.myinflater = true;
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) throws IOException {
        this(inputStream, inflater, 512);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) throws IOException {
        this(inputStream, inflater, n, true);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n, boolean bl) throws IOException {
        super(inputStream);
        if (inputStream == null || inflater == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("buffer size must be greater than 0");
        }
        this.inflater = inflater;
        this.buf = new byte[n];
        this.close_in = bl;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        return this.read(this.byte1, 0, 1) == -1 ? -1 : this.byte1[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.eof) {
            return -1;
        }
        int n3 = 0;
        this.inflater.setOutput(byArray, n, n2);
        while (!this.eof) {
            if (this.inflater.avail_in == 0) {
                this.fill();
            }
            int n4 = this.inflater.inflate(0);
            n3 += this.inflater.next_out_index - n;
            n = this.inflater.next_out_index;
            switch (n4) {
                case -3: {
                    throw new IOException(this.inflater.msg);
                }
                case 1: 
                case 2: {
                    this.eof = true;
                    if (n4 != 2) break;
                    return -1;
                }
            }
            if (this.inflater.avail_out == 0) break;
        }
        return n3;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.eof) {
            return 0;
        }
        return 1;
    }

    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        int n = (int)Math.min(l, Integer.MAX_VALUE);
        int n2 = 0;
        while (n2 < n) {
            int n3 = n - n2;
            if (n3 > this.b.length) {
                n3 = this.b.length;
            }
            if ((n3 = this.read(this.b, 0, n3)) == -1) {
                this.eof = true;
                break;
            }
            n2 += n3;
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.myinflater) {
                this.inflater.end();
            }
            if (this.close_in) {
                this.in.close();
            }
            this.closed = true;
        }
    }

    protected void fill() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        int n = this.in.read(this.buf, 0, this.buf.length);
        if (n == -1) {
            if (this.inflater.istate.was != -1L) {
                throw new IOException("footer is not found");
            }
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inflater.setInput(this.buf, 0, n, true);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int n) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public long getTotalIn() {
        return this.inflater.getTotalIn();
    }

    public long getTotalOut() {
        return this.inflater.getTotalOut();
    }

    public byte[] getAvailIn() {
        if (this.inflater.avail_in <= 0) {
            return null;
        }
        byte[] byArray = new byte[this.inflater.avail_in];
        System.arraycopy(this.inflater.next_in, this.inflater.next_in_index, byArray, 0, this.inflater.avail_in);
        return byArray;
    }

    public void readHeader() throws IOException {
        byte[] byArray = "".getBytes();
        this.inflater.setInput(byArray, 0, 0, false);
        this.inflater.setOutput(byArray, 0, 0);
        int n = this.inflater.inflate(0);
        if (!this.inflater.istate.inParsingHeader()) {
            return;
        }
        byte[] byArray2 = new byte[1];
        do {
            int n2;
            if ((n2 = this.in.read(byArray2)) <= 0) {
                throw new IOException("no input");
            }
            this.inflater.setInput(byArray2);
            n = this.inflater.inflate(0);
            if (n == 0) continue;
            throw new IOException(this.inflater.msg);
        } while (this.inflater.istate.inParsingHeader());
    }

    public Inflater getInflater() {
        return this.inflater;
    }
}

