/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Adler32;
import com.jcraft.jzlib.CRC32;
import com.jcraft.jzlib.GZIPHeader;
import com.jcraft.jzlib.InfBlocks;
import com.jcraft.jzlib.ZStream;
import java.io.ByteArrayOutputStream;

final class Inflate {
    private static final int MAX_WBITS = 15;
    private static final int PRESET_DICT = 32;
    static final int Z_NO_FLUSH = 0;
    static final int Z_PARTIAL_FLUSH = 1;
    static final int Z_SYNC_FLUSH = 2;
    static final int Z_FULL_FLUSH = 3;
    static final int Z_FINISH = 4;
    private static final int Z_DEFLATED = 8;
    private static final int Z_OK = 0;
    private static final int Z_STREAM_END = 1;
    private static final int Z_NEED_DICT = 2;
    private static final int Z_ERRNO = -1;
    private static final int Z_STREAM_ERROR = -2;
    private static final int Z_DATA_ERROR = -3;
    private static final int Z_MEM_ERROR = -4;
    private static final int Z_BUF_ERROR = -5;
    private static final int Z_VERSION_ERROR = -6;
    private static final int METHOD = 0;
    private static final int FLAG = 1;
    private static final int DICT4 = 2;
    private static final int DICT3 = 3;
    private static final int DICT2 = 4;
    private static final int DICT1 = 5;
    private static final int DICT0 = 6;
    private static final int BLOCKS = 7;
    private static final int CHECK4 = 8;
    private static final int CHECK3 = 9;
    private static final int CHECK2 = 10;
    private static final int CHECK1 = 11;
    private static final int DONE = 12;
    private static final int BAD = 13;
    private static final int HEAD = 14;
    private static final int LENGTH = 15;
    private static final int TIME = 16;
    private static final int OS = 17;
    private static final int EXLEN = 18;
    private static final int EXTRA = 19;
    private static final int NAME = 20;
    private static final int COMMENT = 21;
    private static final int HCRC = 22;
    private static final int FLAGS = 23;
    int mode;
    int method;
    long was = -1L;
    long need;
    int marker;
    int wrap;
    int wbits;
    InfBlocks blocks;
    final ZStream z;
    private int flags;
    private int need_bytes = -1;
    private byte[] crcbuf = new byte[4];
    GZIPHeader gheader = null;
    private static byte[] mark;
    private ByteArrayOutputStream tmp_string = null;

    static {
        byte[] byArray = new byte[4];
        byArray[2] = -1;
        byArray[3] = -1;
        mark = byArray;
    }

    int inflateReset() {
        if (this.z == null) {
            return -2;
        }
        this.z.total_out = 0L;
        this.z.total_in = 0L;
        this.z.msg = null;
        this.mode = 14;
        this.need_bytes = -1;
        this.blocks.reset(this.z);
        return 0;
    }

    int inflateEnd() {
        if (this.blocks != null) {
            this.blocks.free(this.z);
        }
        return 0;
    }

    Inflate(ZStream zStream) {
        this.z = zStream;
    }

    int inflateInit(int n) {
        this.z.msg = null;
        this.blocks = null;
        this.wrap = 0;
        if (n < 0) {
            n = -n;
        } else {
            this.wrap = (n >> 4) + 1;
            if (n < 48) {
                n &= 0xF;
            }
        }
        if (n < 8 || n > 15) {
            this.inflateEnd();
            return -2;
        }
        if (this.blocks != null && this.wbits != n) {
            this.blocks.free(this.z);
            this.blocks = null;
        }
        this.wbits = n;
        this.blocks = new InfBlocks(this.z, 1 << n);
        this.inflateReset();
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    int inflate(int var1_1) {
        if (this.z == null || this.z.next_in == null) {
            if (var1_1 == 4 && this.mode == 14) {
                return 0;
            }
            return -2;
        }
        var1_1 = var1_1 == 4 ? -5 : 0;
        var2_2 = -5;
        block44: while (true) {
            switch (this.mode) {
                case 14: {
                    if (this.wrap == 0) {
                        this.mode = 7;
                        continue block44;
                    }
                    try {
                        var2_2 = this.readBytes(this.z, 2, var2_2, var1_1);
                    }
                    catch (Return var4_5) {
                        return var4_5.r;
                    }
                    if ((this.wrap & 2) != 0 && this.need == 35615L) {
                        this.z.adler = new CRC32();
                        this.checksum(2, this.need);
                        if (this.gheader == null) {
                            this.gheader = new GZIPHeader();
                        }
                        this.mode = 23;
                        continue block44;
                    }
                    this.flags = 0;
                    this.method = (int)this.need & 255;
                    var3_3 = (int)(this.need >> 8) & 255;
                    if ((this.wrap & 1) == 0 || ((this.method << 8) + var3_3) % 31 != 0) {
                        this.mode = 13;
                        this.z.msg = "incorrect header check";
                        continue block44;
                    }
                    if ((this.method & 15) != 8) {
                        this.mode = 13;
                        this.z.msg = "unknown compression method";
                        continue block44;
                    }
                    if ((this.method >> 4) + 8 > this.wbits) {
                        this.mode = 13;
                        this.z.msg = "invalid window size";
                        continue block44;
                    }
                    this.z.adler = new Adler32();
                    if ((var3_3 & 32) == 0) {
                        this.mode = 7;
                        continue block44;
                    }
                    this.mode = 2;
                }
                case 2: {
                    if (this.z.avail_in == 0) {
                        return var2_2;
                    }
                    var2_2 = var1_1;
                    --this.z.avail_in;
                    ++this.z.total_in;
                    this.need = (long)((this.z.next_in[this.z.next_in_index++] & 255) << 24) & 0xFF000000L;
                    this.mode = 3;
                }
                case 3: {
                    if (this.z.avail_in == 0) {
                        return var2_2;
                    }
                    var2_2 = var1_1;
                    --this.z.avail_in;
                    ++this.z.total_in;
                    this.need += (long)((this.z.next_in[this.z.next_in_index++] & 255) << 16) & 0xFF0000L;
                    this.mode = 4;
                }
                case 4: {
                    if (this.z.avail_in == 0) {
                        return var2_2;
                    }
                    var2_2 = var1_1;
                    --this.z.avail_in;
                    ++this.z.total_in;
                    this.need += (long)((this.z.next_in[this.z.next_in_index++] & 255) << 8) & 65280L;
                    this.mode = 5;
                }
                case 5: {
                    if (this.z.avail_in == 0) {
                        return var2_2;
                    }
                    var2_2 = var1_1;
                    --this.z.avail_in;
                    ++this.z.total_in;
                    this.need += (long)this.z.next_in[this.z.next_in_index++] & 255L;
                    this.z.adler.reset(this.need);
                    this.mode = 6;
                    return 2;
                }
                case 6: {
                    this.mode = 13;
                    this.z.msg = "need dictionary";
                    this.marker = 0;
                    return -2;
                }
                case 7: {
                    var2_2 = this.blocks.proc(this.z, var2_2);
                    if (var2_2 == -3) {
                        this.mode = 13;
                        this.marker = 0;
                        continue block44;
                    }
                    if (var2_2 == 0) {
                        var2_2 = var1_1;
                    }
                    if (var2_2 != 1) {
                        return var2_2;
                    }
                    var2_2 = var1_1;
                    this.was = this.z.adler.getValue();
                    this.blocks.reset(this.z);
                    if (this.wrap == 0) {
                        this.mode = 12;
                        continue block44;
                    }
                    this.mode = 8;
                }
                case 8: {
                    if (this.z.avail_in == 0) {
                        return var2_2;
                    }
                    var2_2 = var1_1;
                    --this.z.avail_in;
                    ++this.z.total_in;
                    this.need = (long)((this.z.next_in[this.z.next_in_index++] & 255) << 24) & 0xFF000000L;
                    this.mode = 9;
                }
                case 9: {
                    if (this.z.avail_in == 0) {
                        return var2_2;
                    }
                    var2_2 = var1_1;
                    --this.z.avail_in;
                    ++this.z.total_in;
                    this.need += (long)((this.z.next_in[this.z.next_in_index++] & 255) << 16) & 0xFF0000L;
                    this.mode = 10;
                }
                case 10: {
                    if (this.z.avail_in == 0) {
                        return var2_2;
                    }
                    var2_2 = var1_1;
                    --this.z.avail_in;
                    ++this.z.total_in;
                    this.need += (long)((this.z.next_in[this.z.next_in_index++] & 255) << 8) & 65280L;
                    this.mode = 11;
                }
                case 11: {
                    if (this.z.avail_in == 0) {
                        return var2_2;
                    }
                    var2_2 = var1_1;
                    --this.z.avail_in;
                    ++this.z.total_in;
                    this.need += (long)this.z.next_in[this.z.next_in_index++] & 255L;
                    if (this.flags != 0) {
                        this.need = ((this.need & -16777216L) >> 24 | (this.need & 0xFF0000L) >> 8 | (this.need & 65280L) << 8 | (this.need & 65535L) << 24) & 0xFFFFFFFFL;
                    }
                    if ((int)this.was != (int)this.need) {
                        this.z.msg = "incorrect data check";
                    } else if (this.flags != 0 && this.gheader != null) {
                        this.gheader.crc = this.need;
                    }
                    this.mode = 15;
                }
                case 15: {
                    if (this.wrap != 0 && this.flags != 0) {
                        try {
                            var2_2 = this.readBytes(this.z, 4, var2_2, var1_1);
                        }
                        catch (Return var4_6) {
                            return var4_6.r;
                        }
                        if (this.z.msg != null && this.z.msg.equals("incorrect data check")) {
                            this.mode = 13;
                            this.marker = 5;
                            continue block44;
                        }
                        if (this.need != (this.z.total_out & 0xFFFFFFFFL)) {
                            this.z.msg = "incorrect length check";
                            this.mode = 13;
                            continue block44;
                        }
                        this.z.msg = null;
                    } else if (this.z.msg != null && this.z.msg.equals("incorrect data check")) {
                        this.mode = 13;
                        this.marker = 5;
                        continue block44;
                    }
                    this.mode = 12;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return -3;
                }
                case 23: {
                    try {
                        var2_2 = this.readBytes(this.z, 2, var2_2, var1_1);
                    }
                    catch (Return var4_7) {
                        return var4_7.r;
                    }
                    this.flags = (int)this.need & 65535;
                    if ((this.flags & 255) != 8) {
                        this.z.msg = "unknown compression method";
                        this.mode = 13;
                        continue block44;
                    }
                    if ((this.flags & 57344) != 0) {
                        this.z.msg = "unknown header flags set";
                        this.mode = 13;
                        continue block44;
                    }
                    if ((this.flags & 512) != 0) {
                        this.checksum(2, this.need);
                    }
                    this.mode = 16;
                }
                case 16: {
                    try {
                        var2_2 = this.readBytes(this.z, 4, var2_2, var1_1);
                    }
                    catch (Return var4_8) {
                        return var4_8.r;
                    }
                    if (this.gheader != null) {
                        this.gheader.time = this.need;
                    }
                    if ((this.flags & 512) != 0) {
                        this.checksum(4, this.need);
                    }
                    this.mode = 17;
                }
                case 17: {
                    try {
                        var2_2 = this.readBytes(this.z, 2, var2_2, var1_1);
                    }
                    catch (Return var4_9) {
                        return var4_9.r;
                    }
                    if (this.gheader != null) {
                        this.gheader.xflags = (int)this.need & 255;
                        this.gheader.os = (int)this.need >> 8 & 255;
                    }
                    if ((this.flags & 512) != 0) {
                        this.checksum(2, this.need);
                    }
                    this.mode = 18;
                }
                case 18: {
                    if ((this.flags & 1024) != 0) {
                        try {
                            var2_2 = this.readBytes(this.z, 2, var2_2, var1_1);
                        }
                        catch (Return var4_10) {
                            return var4_10.r;
                        }
                        if (this.gheader != null) {
                            this.gheader.extra = new byte[(int)this.need & 65535];
                        }
                        if ((this.flags & 512) != 0) {
                            this.checksum(2, this.need);
                        }
                    } else if (this.gheader != null) {
                        this.gheader.extra = null;
                    }
                    this.mode = 19;
                }
                case 19: {
                    if ((this.flags & 1024) == 0) ** GOTO lbl237
                    try {
                        var2_2 = this.readBytes(this.z, var2_2, var1_1);
                        if (this.gheader == null) ** GOTO lbl239
                        var4_4 = this.tmp_string.toByteArray();
                        this.tmp_string = null;
                        if (var4_4.length != this.gheader.extra.length) ** GOTO lbl232
                        System.arraycopy(var4_4, 0, this.gheader.extra, 0, var4_4.length);
                        ** GOTO lbl239
lbl232:
                        // 1 sources

                        this.z.msg = "bad extra field length";
                        this.mode = 13;
                        continue block44;
                    }
                    catch (Return var4_11) {
                        return var4_11.r;
                    }
lbl237:
                    // 1 sources

                    if (this.gheader != null) {
                        this.gheader.extra = null;
                    }
lbl239:
                    // 5 sources

                    this.mode = 20;
                }
                case 20: {
                    if ((this.flags & 2048) != 0) {
                        try {
                            var2_2 = this.readString(this.z, var2_2, var1_1);
                            if (this.gheader != null) {
                                this.gheader.name = this.tmp_string.toByteArray();
                            }
                            this.tmp_string = null;
                        }
                        catch (Return var4_12) {
                            return var4_12.r;
                        }
                    } else if (this.gheader != null) {
                        this.gheader.name = null;
                    }
                    this.mode = 21;
                }
                case 21: {
                    if ((this.flags & 4096) != 0) {
                        try {
                            var2_2 = this.readString(this.z, var2_2, var1_1);
                            if (this.gheader != null) {
                                this.gheader.comment = this.tmp_string.toByteArray();
                            }
                            this.tmp_string = null;
                        }
                        catch (Return var4_13) {
                            return var4_13.r;
                        }
                    } else if (this.gheader != null) {
                        this.gheader.comment = null;
                    }
                    this.mode = 22;
                }
                case 22: {
                    if ((this.flags & 512) != 0) {
                        try {
                            var2_2 = this.readBytes(this.z, 2, var2_2, var1_1);
                        }
                        catch (Return var4_14) {
                            return var4_14.r;
                        }
                        if (this.gheader != null) {
                            this.gheader.hcrc = (int)(this.need & 65535L);
                        }
                        if (this.need != (this.z.adler.getValue() & 65535L)) {
                            this.mode = 13;
                            this.z.msg = "header crc mismatch";
                            this.marker = 5;
                            continue block44;
                        }
                    }
                    this.z.adler = new CRC32();
                    this.mode = 7;
                    continue block44;
                }
            }
            break;
        }
        return -2;
    }

    int inflateSetDictionary(byte[] byArray, int n) {
        if (this.z == null || this.mode != 6 && this.wrap != 0) {
            return -2;
        }
        int n2 = 0;
        int n3 = n;
        if (this.mode == 6) {
            long l = this.z.adler.getValue();
            this.z.adler.reset();
            this.z.adler.update(byArray, 0, n);
            if (this.z.adler.getValue() != l) {
                return -3;
            }
        }
        this.z.adler.reset();
        if (n3 >= 1 << this.wbits) {
            n3 = (1 << this.wbits) - 1;
            n2 = n - n3;
        }
        this.blocks.set_dictionary(byArray, n2, n3);
        this.mode = 7;
        return 0;
    }

    int inflateSync() {
        int n;
        if (this.z == null) {
            return -2;
        }
        if (this.mode != 13) {
            this.mode = 13;
            this.marker = 0;
        }
        if ((n = this.z.avail_in) == 0) {
            return -5;
        }
        int n2 = this.z.next_in_index;
        int n3 = this.marker;
        while (n != 0 && n3 < 4) {
            n3 = this.z.next_in[n2] == mark[n3] ? ++n3 : (this.z.next_in[n2] != 0 ? 0 : 4 - n3);
            ++n2;
            --n;
        }
        this.z.total_in += (long)(n2 - this.z.next_in_index);
        this.z.next_in_index = n2;
        this.z.avail_in = n;
        this.marker = n3;
        if (n3 != 4) {
            return -3;
        }
        long l = this.z.total_in;
        long l2 = this.z.total_out;
        this.inflateReset();
        this.z.total_in = l;
        this.z.total_out = l2;
        this.mode = 7;
        return 0;
    }

    int inflateSyncPoint() {
        if (this.z == null || this.blocks == null) {
            return -2;
        }
        return this.blocks.sync_point();
    }

    private int readBytes(ZStream zStream, int n, int n2, int n3) throws Return {
        if (this.need_bytes == -1) {
            this.need_bytes = n;
            this.need = 0L;
        }
        while (this.need_bytes > 0) {
            if (zStream.avail_in == 0) {
                throw new Return(n2);
            }
            n2 = n3;
            --zStream.avail_in;
            ++zStream.total_in;
            this.need |= (long)((zStream.next_in[zStream.next_in_index++] & 0xFF) << (n - this.need_bytes) * 8);
            --this.need_bytes;
        }
        if (n == 2) {
            this.need &= 0xFFFFL;
        } else if (n == 4) {
            this.need &= 0xFFFFFFFFL;
        }
        this.need_bytes = -1;
        return n2;
    }

    private int readString(ZStream zStream, int n, int n2) throws Return {
        if (this.tmp_string == null) {
            this.tmp_string = new ByteArrayOutputStream();
        }
        byte by = 0;
        do {
            if (zStream.avail_in == 0) {
                throw new Return(n);
            }
            n = n2;
            --zStream.avail_in;
            ++zStream.total_in;
            by = zStream.next_in[zStream.next_in_index];
            if (by != 0) {
                this.tmp_string.write(zStream.next_in, zStream.next_in_index, 1);
            }
            zStream.adler.update(zStream.next_in, zStream.next_in_index, 1);
            ++zStream.next_in_index;
        } while (by != 0);
        return n;
    }

    private int readBytes(ZStream zStream, int n, int n2) throws Return {
        if (this.tmp_string == null) {
            this.tmp_string = new ByteArrayOutputStream();
        }
        while (this.need > 0L) {
            if (zStream.avail_in == 0) {
                throw new Return(n);
            }
            n = n2;
            --zStream.avail_in;
            ++zStream.total_in;
            byte cfr_ignored_0 = zStream.next_in[zStream.next_in_index];
            this.tmp_string.write(zStream.next_in, zStream.next_in_index, 1);
            zStream.adler.update(zStream.next_in, zStream.next_in_index, 1);
            ++zStream.next_in_index;
            --this.need;
        }
        return n;
    }

    private void checksum(int n, long l) {
        int n2 = 0;
        while (n2 < n) {
            this.crcbuf[n2] = (byte)(l & 0xFFL);
            l >>= 8;
            ++n2;
        }
        this.z.adler.update(this.crcbuf, 0, n);
    }

    public GZIPHeader getGZIPHeader() {
        return this.gheader;
    }

    boolean inParsingHeader() {
        switch (this.mode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    class Return
    extends Exception {
        int r;

        Return(int n) {
            this.r = n;
        }
    }
}

