/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Checksum;

final class CRC32
implements Checksum,
Cloneable {
    private int v = 0;
    private static int[] crc_table = null;
    private static final int GF2_DIM = 32;

    static {
        crc_table = new int[256];
        int n = 0;
        while (n < 256) {
            int n2 = n;
            int n3 = 8;
            while (--n3 >= 0) {
                if ((n2 & 1) != 0) {
                    n2 = 0xEDB88320 ^ n2 >>> 1;
                    continue;
                }
                n2 >>>= 1;
            }
            CRC32.crc_table[n] = n2;
            ++n;
        }
    }

    CRC32() {
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3 = ~this.v;
        while (--n2 >= 0) {
            n3 = crc_table[(n3 ^ byArray[n++]) & 0xFF] ^ n3 >>> 8;
        }
        this.v = ~n3;
    }

    @Override
    public void reset() {
        this.v = 0;
    }

    @Override
    public void reset(long l) {
        this.v = (int)(l & 0xFFFFFFFFL);
    }

    @Override
    public long getValue() {
        return (long)this.v & 0xFFFFFFFFL;
    }

    static long combine(long l, long l2, long l3) {
        long[] lArray = new long[32];
        long[] lArray2 = new long[32];
        if (l3 <= 0L) {
            return l;
        }
        lArray2[0] = 3988292384L;
        long l4 = 1L;
        int n = 1;
        while (n < 32) {
            lArray2[n] = l4;
            l4 <<= 1;
            ++n;
        }
        CRC32.gf2_matrix_square(lArray, lArray2);
        CRC32.gf2_matrix_square(lArray2, lArray);
        do {
            CRC32.gf2_matrix_square(lArray, lArray2);
            if ((l3 & 1L) != 0L) {
                l = CRC32.gf2_matrix_times(lArray, l);
            }
            if ((l3 >>= 1) == 0L) break;
            CRC32.gf2_matrix_square(lArray2, lArray);
            if ((l3 & 1L) == 0L) continue;
            l = CRC32.gf2_matrix_times(lArray2, l);
        } while ((l3 >>= 1) != 0L);
        return l ^= l2;
    }

    private static long gf2_matrix_times(long[] lArray, long l) {
        long l2 = 0L;
        int n = 0;
        while (l != 0L) {
            if ((l & 1L) != 0L) {
                l2 ^= lArray[n];
            }
            l >>= 1;
            ++n;
        }
        return l2;
    }

    static final void gf2_matrix_square(long[] lArray, long[] lArray2) {
        int n = 0;
        while (n < 32) {
            lArray[n] = CRC32.gf2_matrix_times(lArray2, lArray2[n]);
            ++n;
        }
    }

    @Override
    public CRC32 copy() {
        CRC32 cRC32 = new CRC32();
        cRC32.v = this.v;
        return cRC32;
    }
}

