/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Checksum;

final class Adler32
implements Checksum {
    private static final int BASE = 65521;
    private static final int NMAX = 5552;
    private long adler = 1L;

    Adler32() {
    }

    @Override
    public void reset(long l) {
        this.adler = l;
    }

    @Override
    public void reset() {
        this.adler = 1L;
    }

    @Override
    public long getValue() {
        return this.adler;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        long l = this.adler & 0xFFFFL;
        long l2 = this.adler >> 16 & 0xFFFFL;
        while (n2 > 0) {
            int n3 = n2 < 5552 ? n2 : 5552;
            n2 -= n3;
            while (n3-- > 0) {
                l2 += (l += (long)(byArray[n++] & 0xFF));
            }
            l %= 65521L;
            l2 %= 65521L;
        }
        this.adler = l2 << 16 | l;
    }

    @Override
    public Adler32 copy() {
        Adler32 adler32 = new Adler32();
        adler32.adler = this.adler;
        return adler32;
    }

    static long combine(long l, long l2, long l3) {
        long l4 = 65521L;
        long l5 = l3 % l4;
        long l6 = l & 0xFFFFL;
        long l7 = l5 * l6;
        l7 %= l4;
        l7 += (l >> 16 & 0xFFFFL) + (l2 >> 16 & 0xFFFFL) + l4 - l5;
        if ((l6 += (l2 & 0xFFFFL) + l4 - 1L) >= l4) {
            l6 -= l4;
        }
        if (l6 >= l4) {
            l6 -= l4;
        }
        if (l7 >= l4 << 1) {
            l7 -= l4 << 1;
        }
        if (l7 >= l4) {
            l7 -= l4;
        }
        return l6 | l7 << 16;
    }
}

