/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.Buffer;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;

public class SignatureECDSA
implements com.jcraft.jsch.SignatureECDSA {
    Signature signature;
    KeyFactory keyFactory;

    @Override
    public void init() throws Exception {
        this.signature = Signature.getInstance("SHA256withECDSA");
        this.keyFactory = KeyFactory.getInstance("EC");
    }

    @Override
    public void setPubKey(byte[] byArray, byte[] byArray2) throws Exception {
        byArray = this.insert0(byArray);
        byArray2 = this.insert0(byArray2);
        String string = "secp256r1";
        if (byArray.length >= 64) {
            string = "secp521r1";
        } else if (byArray.length >= 48) {
            string = "secp384r1";
        }
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
        algorithmParameters.init(new ECGenParameterSpec(string));
        ECParameterSpec eCParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
        ECPoint eCPoint = new ECPoint(new BigInteger(1, byArray), new BigInteger(1, byArray2));
        PublicKey publicKey = this.keyFactory.generatePublic(new ECPublicKeySpec(eCPoint, eCParameterSpec));
        this.signature.initVerify(publicKey);
    }

    @Override
    public void setPrvKey(byte[] byArray) throws Exception {
        byArray = this.insert0(byArray);
        String string = "secp256r1";
        if (byArray.length >= 64) {
            string = "secp521r1";
        } else if (byArray.length >= 48) {
            string = "secp384r1";
        }
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
        algorithmParameters.init(new ECGenParameterSpec(string));
        ECParameterSpec eCParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
        BigInteger bigInteger = new BigInteger(1, byArray);
        PrivateKey privateKey = this.keyFactory.generatePrivate(new ECPrivateKeySpec(bigInteger, eCParameterSpec));
        this.signature.initSign(privateKey);
    }

    @Override
    public byte[] sign() throws Exception {
        byte[] byArray = this.signature.sign();
        if (byArray[0] == 48 && (byArray[1] + 2 == byArray.length || (byArray[1] & 0x80) != 0 && (byArray[2] & 0xFF) + 3 == byArray.length)) {
            int n = 3;
            if ((byArray[1] & 0x80) != 0 && (byArray[2] & 0xFF) + 3 == byArray.length) {
                n = 4;
            }
            byte[] byArray2 = new byte[byArray[n]];
            byte[] byArray3 = new byte[byArray[n + 2 + byArray[n]]];
            System.arraycopy(byArray, n + 1, byArray2, 0, byArray2.length);
            System.arraycopy(byArray, n + 3 + byArray[n], byArray3, 0, byArray3.length);
            byArray2 = this.chop0(byArray2);
            byArray3 = this.chop0(byArray3);
            Buffer buffer = new Buffer();
            buffer.putMPInt(byArray2);
            buffer.putMPInt(byArray3);
            byArray = new byte[buffer.getLength()];
            buffer.setOffSet(0);
            buffer.getByte(byArray);
        }
        return byArray;
    }

    @Override
    public void update(byte[] byArray) throws Exception {
        this.signature.update(byArray);
    }

    @Override
    public boolean verify(byte[] byArray) throws Exception {
        if (byArray[0] != 48 || byArray[1] + 2 != byArray.length && ((byArray[1] & 0x80) == 0 || (byArray[2] & 0xFF) + 3 != byArray.length)) {
            Buffer buffer = new Buffer(byArray);
            buffer.getString();
            buffer.getInt();
            byte[] byArray2 = buffer.getMPInt();
            byte[] byArray3 = buffer.getMPInt();
            byArray2 = this.insert0(byArray2);
            byArray3 = this.insert0(byArray3);
            byte[] byArray4 = null;
            if (byArray2.length < 64) {
                byArray4 = new byte[6 + byArray2.length + byArray3.length];
                byArray4[0] = 48;
                byArray4[1] = (byte)(4 + byArray2.length + byArray3.length);
                byArray4[2] = 2;
                byArray4[3] = (byte)byArray2.length;
                System.arraycopy(byArray2, 0, byArray4, 4, byArray2.length);
                byArray4[byArray2.length + 4] = 2;
                byArray4[byArray2.length + 5] = (byte)byArray3.length;
                System.arraycopy(byArray3, 0, byArray4, 6 + byArray2.length, byArray3.length);
            } else {
                byArray4 = new byte[6 + byArray2.length + byArray3.length + 1];
                byArray4[0] = 48;
                byArray4[1] = -127;
                byArray4[2] = (byte)(4 + byArray2.length + byArray3.length);
                byArray4[3] = 2;
                byArray4[4] = (byte)byArray2.length;
                System.arraycopy(byArray2, 0, byArray4, 5, byArray2.length);
                byArray4[byArray2.length + 5] = 2;
                byArray4[byArray2.length + 6] = (byte)byArray3.length;
                System.arraycopy(byArray3, 0, byArray4, 7 + byArray2.length, byArray3.length);
            }
            byArray = byArray4;
        }
        return this.signature.verify(byArray);
    }

    private byte[] insert0(byte[] byArray) {
        if ((byArray[0] & 0x80) == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.bzero(byArray);
        return byArray2;
    }

    private byte[] chop0(byte[] byArray) {
        if (byArray[0] != 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - 1];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        this.bzero(byArray);
        return byArray2;
    }

    private void bzero(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
    }
}

