/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.JSchException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;

public class KeyPairGenECDSA
implements com.jcraft.jsch.KeyPairGenECDSA {
    byte[] d;
    byte[] r;
    byte[] s;
    ECPublicKey pubKey;
    ECPrivateKey prvKey;
    ECParameterSpec params;

    @Override
    public void init(int n) throws Exception {
        String string = null;
        if (n == 256) {
            string = "secp256r1";
        } else if (n == 384) {
            string = "secp384r1";
        } else if (n == 521) {
            string = "secp521r1";
        } else {
            throw new JSchException("unsupported key size: " + n);
        }
        int n2 = 0;
        while (n2 < 1000) {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
            ECGenParameterSpec eCGenParameterSpec = new ECGenParameterSpec(string);
            keyPairGenerator.initialize(eCGenParameterSpec);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            this.prvKey = (ECPrivateKey)keyPair.getPrivate();
            this.pubKey = (ECPublicKey)keyPair.getPublic();
            this.params = this.pubKey.getParams();
            this.d = this.prvKey.getS().toByteArray();
            ECPoint eCPoint = this.pubKey.getW();
            this.r = eCPoint.getAffineX().toByteArray();
            this.s = eCPoint.getAffineY().toByteArray();
            if (this.r.length == this.s.length && (n == 256 && this.r.length == 32 || n == 384 && this.r.length == 48 || n == 521 && this.r.length == 66)) break;
            ++n2;
        }
        if (this.d.length < this.r.length) {
            this.d = this.insert0(this.d);
        }
    }

    @Override
    public byte[] getD() {
        return this.d;
    }

    @Override
    public byte[] getR() {
        return this.r;
    }

    @Override
    public byte[] getS() {
        return this.s;
    }

    ECPublicKey getPublicKey() {
        return this.pubKey;
    }

    ECPrivateKey getPrivateKey() {
        return this.prvKey;
    }

    private byte[] insert0(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.bzero(byArray);
        return byArray2;
    }

    private byte[] chop0(byte[] byArray) {
        if (byArray[0] != 0 || (byArray[1] & 0x80) == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - 1];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        this.bzero(byArray);
        return byArray2;
    }

    private void bzero(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
    }
}

