/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.ServerSocketFactory;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

class PortWatcher
implements Runnable {
    private static Vector pool = new Vector();
    private static InetAddress anyLocalAddress = null;
    Session session;
    int lport;
    int rport;
    String host;
    InetAddress boundaddress;
    Runnable thread;
    ServerSocket ss;
    int connectTimeout = 0;

    static {
        try {
            anyLocalAddress = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException unknownHostException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = pool;
        synchronized (pool) {
            int n = 0;
            while (n < pool.size()) {
                PortWatcher portWatcher = (PortWatcher)pool.elementAt(n);
                if (portWatcher.session == session) {
                    vector.addElement(String.valueOf(portWatcher.lport) + ":" + portWatcher.host + ":" + portWatcher.rport);
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            stringArray = new String[vector.size()];
            n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PortWatcher getPort(Session session, String string, int n) throws JSchException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new JSchException("PortForwardingL: invalid address " + string + " specified.", unknownHostException);
        }
        Vector vector = pool;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < pool.size()) {
                PortWatcher portWatcher = (PortWatcher)pool.elementAt(n2);
                if (portWatcher.session == session && portWatcher.lport == n && (anyLocalAddress != null && portWatcher.boundaddress.equals(anyLocalAddress) || portWatcher.boundaddress.equals(inetAddress))) {
                    return portWatcher;
                }
                ++n2;
            }
            return null;
        }
    }

    private static String normalize(String string) {
        if (string != null) {
            if (string.length() == 0 || string.equals("*")) {
                string = "0.0.0.0";
            } else if (string.equals("localhost")) {
                string = "127.0.0.1";
            }
        }
        return string;
    }

    static PortWatcher addPort(Session session, String string, int n, String string2, int n2, ServerSocketFactory serverSocketFactory) throws JSchException {
        if (PortWatcher.getPort(session, string = PortWatcher.normalize(string), n) != null) {
            throw new JSchException("PortForwardingL: local port " + string + ":" + n + " is already registered.");
        }
        PortWatcher portWatcher = new PortWatcher(session, string, n, string2, n2, serverSocketFactory);
        pool.addElement(portWatcher);
        return portWatcher;
    }

    static void delPort(Session session, String string, int n) throws JSchException {
        PortWatcher portWatcher = PortWatcher.getPort(session, string = PortWatcher.normalize(string), n);
        if (portWatcher == null) {
            throw new JSchException("PortForwardingL: local port " + string + ":" + n + " is not registered.");
        }
        portWatcher.delete();
        pool.removeElement(portWatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        Vector vector = pool;
        synchronized (vector) {
            PortWatcher portWatcher;
            PortWatcher[] portWatcherArray = new PortWatcher[pool.size()];
            int n = 0;
            int n2 = 0;
            while (n2 < pool.size()) {
                portWatcher = (PortWatcher)pool.elementAt(n2);
                if (portWatcher.session == session) {
                    portWatcher.delete();
                    portWatcherArray[n++] = portWatcher;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                portWatcher = portWatcherArray[n2];
                pool.removeElement(portWatcher);
                ++n2;
            }
        }
    }

    PortWatcher(Session session, String string, int n, String string2, int n2, ServerSocketFactory serverSocketFactory) throws JSchException {
        int n3;
        this.session = session;
        this.lport = n;
        this.host = string2;
        this.rport = n2;
        try {
            this.boundaddress = InetAddress.getByName(string);
            this.ss = serverSocketFactory == null ? new ServerSocket(n, 0, this.boundaddress) : serverSocketFactory.createServerSocket(n, 0, this.boundaddress);
        }
        catch (Exception exception) {
            String string3 = "PortForwardingL: local port " + string + ":" + n + " cannot be bound.";
            if (exception instanceof Throwable) {
                throw new JSchException(string3, exception);
            }
            throw new JSchException(string3);
        }
        if (n == 0 && (n3 = this.ss.getLocalPort()) != -1) {
            this.lport = n3;
        }
    }

    @Override
    public void run() {
        this.thread = this;
        try {
            while (this.thread != null) {
                Socket socket = this.ss.accept();
                socket.setTcpNoDelay(true);
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                ChannelDirectTCPIP channelDirectTCPIP = new ChannelDirectTCPIP();
                channelDirectTCPIP.init();
                channelDirectTCPIP.setInputStream(inputStream);
                channelDirectTCPIP.setOutputStream(outputStream);
                this.session.addChannel(channelDirectTCPIP);
                channelDirectTCPIP.setHost(this.host);
                channelDirectTCPIP.setPort(this.rport);
                channelDirectTCPIP.setOrgIPAddress(socket.getInetAddress().getHostAddress());
                channelDirectTCPIP.setOrgPort(socket.getPort());
                channelDirectTCPIP.connect(this.connectTimeout);
                int cfr_ignored_0 = channelDirectTCPIP.exitstatus;
            }
        }
        catch (Exception exception) {}
        this.delete();
    }

    void delete() {
        this.thread = null;
        try {
            if (this.ss != null) {
                this.ss.close();
            }
            this.ss = null;
        }
        catch (Exception exception) {}
    }

    void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }
}

