/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.Util;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;

public class OpenSSHConfig
implements ConfigRepository {
    private final Hashtable config = new Hashtable();
    private final Vector hosts = new Vector();
    private static final Hashtable keymap = new Hashtable();

    static {
        keymap.put("kex", "KexAlgorithms");
        keymap.put("server_host_key", "HostKeyAlgorithms");
        keymap.put("cipher.c2s", "Ciphers");
        keymap.put("cipher.s2c", "Ciphers");
        keymap.put("mac.c2s", "Macs");
        keymap.put("mac.s2c", "Macs");
        keymap.put("compression.s2c", "Compression");
        keymap.put("compression.c2s", "Compression");
        keymap.put("compression_level", "CompressionLevel");
        keymap.put("MaxAuthTries", "NumberOfPasswordPrompts");
    }

    public static OpenSSHConfig parse(String string) throws IOException {
        try (StringReader stringReader = new StringReader(string);){
            OpenSSHConfig openSSHConfig = new OpenSSHConfig(stringReader);
            return openSSHConfig;
        }
    }

    public static OpenSSHConfig parseFile(String string) throws IOException {
        try (FileReader fileReader = new FileReader(Util.checkTilde(string));){
            OpenSSHConfig openSSHConfig = new OpenSSHConfig(fileReader);
            return openSSHConfig;
        }
    }

    OpenSSHConfig(Reader reader) throws IOException {
        this._parse(reader);
    }

    private void _parse(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = "";
        Vector<String[]> vector = new Vector<String[]>();
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#")) continue;
            String[] stringArray = string2.split("[= \t]", 2);
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringArray[n].trim();
                ++n;
            }
            if (stringArray.length <= 1) continue;
            if (stringArray[0].equals("Host")) {
                this.config.put(string, vector);
                this.hosts.addElement(string);
                string = stringArray[1];
                vector = new Vector();
                continue;
            }
            vector.addElement(stringArray);
        }
        this.config.put(string, vector);
        this.hosts.addElement(string);
    }

    @Override
    public ConfigRepository.Config getConfig(String string) {
        return new MyConfig(string);
    }

    class MyConfig
    implements ConfigRepository.Config {
        private String host;
        private Vector _configs = new Vector();

        MyConfig(String string) {
            this.host = string;
            this._configs.addElement(OpenSSHConfig.this.config.get(""));
            byte[] byArray = Util.str2byte(string);
            if (OpenSSHConfig.this.hosts.size() > 1) {
                int n = 1;
                while (n < OpenSSHConfig.this.hosts.size()) {
                    String[] stringArray = ((String)OpenSSHConfig.this.hosts.elementAt(n)).split("[ \t]");
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        boolean bl = false;
                        String string2 = stringArray[n2].trim();
                        if (string2.startsWith("!")) {
                            bl = true;
                            string2 = string2.substring(1).trim();
                        }
                        if (Util.glob(Util.str2byte(string2), byArray)) {
                            if (!bl) {
                                this._configs.addElement(OpenSSHConfig.this.config.get((String)OpenSSHConfig.this.hosts.elementAt(n)));
                            }
                        } else if (bl) {
                            this._configs.addElement(OpenSSHConfig.this.config.get((String)OpenSSHConfig.this.hosts.elementAt(n)));
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }

        private String find(String string) {
            if (keymap.get(string) != null) {
                string = (String)keymap.get(string);
            }
            string = string.toUpperCase();
            String string2 = null;
            int n = 0;
            while (n < this._configs.size()) {
                Vector vector = (Vector)this._configs.elementAt(n);
                int n2 = 0;
                while (n2 < vector.size()) {
                    String[] stringArray = (String[])vector.elementAt(n2);
                    if (stringArray[0].toUpperCase().equals(string)) {
                        string2 = stringArray[1];
                        break;
                    }
                    ++n2;
                }
                if (string2 != null) break;
                ++n;
            }
            return string2;
        }

        private String[] multiFind(String string) {
            string = string.toUpperCase();
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < this._configs.size()) {
                Vector vector2 = (Vector)this._configs.elementAt(n);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    String string2;
                    String[] stringArray = (String[])vector2.elementAt(n2);
                    if (stringArray[0].toUpperCase().equals(string) && (string2 = stringArray[1]) != null) {
                        vector.remove(string2);
                        vector.addElement(string2);
                    }
                    ++n2;
                }
                ++n;
            }
            String[] stringArray = new String[vector.size()];
            vector.toArray(stringArray);
            return stringArray;
        }

        @Override
        public String getHostname() {
            return this.find("Hostname");
        }

        @Override
        public String getUser() {
            return this.find("User");
        }

        @Override
        public int getPort() {
            String string = this.find("Port");
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
            return n;
        }

        @Override
        public String getValue(String string) {
            if (string.equals("compression.s2c") || string.equals("compression.c2s")) {
                String string2 = this.find(string);
                if (string2 == null || string2.equals("no")) {
                    return "none,zlib@openssh.com,zlib";
                }
                return "zlib@openssh.com,zlib,none";
            }
            return this.find(string);
        }

        @Override
        public String[] getValues(String string) {
            return this.multiFind(string);
        }
    }
}

