/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityFile;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Util;
import java.util.Vector;

class LocalIdentityRepository
implements IdentityRepository {
    private static final String name = "Local Identity Repository";
    private Vector identities = new Vector();
    private JSch jsch;

    LocalIdentityRepository(JSch jSch) {
        this.jsch = jSch;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getStatus() {
        return 2;
    }

    @Override
    public synchronized Vector getIdentities() {
        this.removeDupulicates();
        Vector vector = new Vector();
        int n = 0;
        while (n < this.identities.size()) {
            vector.addElement(this.identities.elementAt(n));
            ++n;
        }
        return vector;
    }

    public synchronized void add(Identity identity) {
        if (!this.identities.contains(identity)) {
            byte[] byArray = identity.getPublicKeyBlob();
            if (byArray == null) {
                this.identities.addElement(identity);
                return;
            }
            int n = 0;
            while (n < this.identities.size()) {
                byte[] byArray2 = ((Identity)this.identities.elementAt(n)).getPublicKeyBlob();
                if (byArray2 != null && Util.array_equals(byArray, byArray2)) {
                    if (!identity.isEncrypted() && ((Identity)this.identities.elementAt(n)).isEncrypted()) {
                        this.remove(byArray2);
                    } else {
                        return;
                    }
                }
                ++n;
            }
            this.identities.addElement(identity);
        }
    }

    @Override
    public synchronized boolean add(byte[] byArray) {
        try {
            IdentityFile identityFile = IdentityFile.newInstance("from remote:", byArray, null, this.jsch);
            this.add(identityFile);
            return true;
        }
        catch (JSchException jSchException) {
            return false;
        }
    }

    synchronized void remove(Identity identity) {
        if (this.identities.contains(identity)) {
            this.identities.removeElement(identity);
            identity.clear();
        } else {
            this.remove(identity.getPublicKeyBlob());
        }
    }

    @Override
    public synchronized boolean remove(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        int n = 0;
        while (n < this.identities.size()) {
            Identity identity = (Identity)this.identities.elementAt(n);
            byte[] byArray2 = identity.getPublicKeyBlob();
            if (byArray2 != null && Util.array_equals(byArray, byArray2)) {
                this.identities.removeElement(identity);
                identity.clear();
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public synchronized void removeAll() {
        int n = 0;
        while (n < this.identities.size()) {
            Identity identity = (Identity)this.identities.elementAt(n);
            identity.clear();
            ++n;
        }
        this.identities.removeAllElements();
    }

    private void removeDupulicates() {
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = this.identities.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Identity identity = (Identity)this.identities.elementAt(n2);
            byte[] byArray = identity.getPublicKeyBlob();
            if (byArray != null) {
                int n3 = n2 + 1;
                while (n3 < n) {
                    Identity identity2 = (Identity)this.identities.elementAt(n3);
                    byte[] byArray2 = identity2.getPublicKeyBlob();
                    if (byArray2 != null && Util.array_equals(byArray, byArray2) && identity.isEncrypted() == identity2.isEncrypted()) {
                        vector.addElement(byArray);
                        break;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector.size()) {
            this.remove((byte[])vector.elementAt(n2));
            ++n2;
        }
    }
}

