/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairGenRSA;
import com.jcraft.jsch.Signature;
import com.jcraft.jsch.SignatureRSA;
import com.jcraft.jsch.Util;
import java.math.BigInteger;

public class KeyPairRSA
extends KeyPair {
    private byte[] n_array;
    private byte[] pub_array;
    private byte[] prv_array;
    private byte[] p_array;
    private byte[] q_array;
    private byte[] ep_array;
    private byte[] eq_array;
    private byte[] c_array;
    private int key_size = 1024;
    private static final byte[] begin = Util.str2byte("-----BEGIN RSA PRIVATE KEY-----");
    private static final byte[] end = Util.str2byte("-----END RSA PRIVATE KEY-----");
    private static final byte[] sshrsa = Util.str2byte("ssh-rsa");

    public KeyPairRSA(JSch jSch) {
        this(jSch, null, null, null);
    }

    public KeyPairRSA(JSch jSch, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(jSch);
        this.n_array = byArray;
        this.pub_array = byArray2;
        this.prv_array = byArray3;
        if (byArray != null) {
            this.key_size = new BigInteger(byArray).bitLength();
        }
    }

    @Override
    void generate(int n) throws JSchException {
        this.key_size = n;
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("keypairgen.rsa"));
            KeyPairGenRSA keyPairGenRSA = (KeyPairGenRSA)clazz.newInstance();
            keyPairGenRSA.init(n);
            this.pub_array = keyPairGenRSA.getE();
            this.prv_array = keyPairGenRSA.getD();
            this.n_array = keyPairGenRSA.getN();
            this.p_array = keyPairGenRSA.getP();
            this.q_array = keyPairGenRSA.getQ();
            this.ep_array = keyPairGenRSA.getEP();
            this.eq_array = keyPairGenRSA.getEQ();
            this.c_array = keyPairGenRSA.getC();
            keyPairGenRSA = null;
        }
        catch (Exception exception) {
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    @Override
    byte[] getBegin() {
        return begin;
    }

    @Override
    byte[] getEnd() {
        return end;
    }

    @Override
    byte[] getPrivateKey() {
        int n = 1 + this.countLength(1) + 1 + 1 + this.countLength(this.n_array.length) + this.n_array.length + 1 + this.countLength(this.pub_array.length) + this.pub_array.length + 1 + this.countLength(this.prv_array.length) + this.prv_array.length + 1 + this.countLength(this.p_array.length) + this.p_array.length + 1 + this.countLength(this.q_array.length) + this.q_array.length + 1 + this.countLength(this.ep_array.length) + this.ep_array.length + 1 + this.countLength(this.eq_array.length) + this.eq_array.length + 1 + this.countLength(this.c_array.length) + this.c_array.length;
        int n2 = 1 + this.countLength(n) + n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        n3 = this.writeSEQUENCE(byArray, n3, n);
        n3 = this.writeINTEGER(byArray, n3, new byte[1]);
        n3 = this.writeINTEGER(byArray, n3, this.n_array);
        n3 = this.writeINTEGER(byArray, n3, this.pub_array);
        n3 = this.writeINTEGER(byArray, n3, this.prv_array);
        n3 = this.writeINTEGER(byArray, n3, this.p_array);
        n3 = this.writeINTEGER(byArray, n3, this.q_array);
        n3 = this.writeINTEGER(byArray, n3, this.ep_array);
        n3 = this.writeINTEGER(byArray, n3, this.eq_array);
        n3 = this.writeINTEGER(byArray, n3, this.c_array);
        return byArray;
    }

    @Override
    boolean parse(byte[] byArray) {
        int n;
        int n2;
        int n3;
        block33: {
            block32: {
                block31: {
                    n3 = 0;
                    n2 = 0;
                    if (this.vendor != 2) break block31;
                    Buffer buffer = new Buffer(byArray);
                    buffer.skip(byArray.length);
                    try {
                        byte[][] byArray2 = buffer.getBytes(4, "");
                        this.prv_array = byArray2[0];
                        this.p_array = byArray2[1];
                        this.q_array = byArray2[2];
                        this.c_array = byArray2[3];
                    }
                    catch (JSchException jSchException) {
                        return false;
                    }
                    this.getEPArray();
                    this.getEQArray();
                    return true;
                }
                if (this.vendor != 1) break block32;
                if (byArray[n3] != 48) {
                    Buffer buffer = new Buffer(byArray);
                    this.pub_array = buffer.getMPIntBits();
                    this.prv_array = buffer.getMPIntBits();
                    this.n_array = buffer.getMPIntBits();
                    buffer.getMPIntBits();
                    this.p_array = buffer.getMPIntBits();
                    this.q_array = buffer.getMPIntBits();
                    if (this.n_array != null) {
                        this.key_size = new BigInteger(this.n_array).bitLength();
                    }
                    this.getEPArray();
                    this.getEQArray();
                    this.getCArray();
                    return true;
                }
                return false;
            }
            int n4 = ++n3;
            ++n3;
            n2 = byArray[n4] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            if (byArray[n3] == 2) break block33;
            return false;
        }
        try {
            int n5 = ++n3;
            ++n3;
            n2 = byArray[n5] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            n3 += n2;
            int n6 = ++n3;
            ++n3;
            n2 = byArray[n6] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.n_array = new byte[n2];
            System.arraycopy(byArray, n3, this.n_array, 0, n2);
            n3 += n2;
            int n7 = ++n3;
            ++n3;
            n2 = byArray[n7] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.pub_array = new byte[n2];
            System.arraycopy(byArray, n3, this.pub_array, 0, n2);
            n3 += n2;
            int n8 = ++n3;
            ++n3;
            n2 = byArray[n8] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.prv_array = new byte[n2];
            System.arraycopy(byArray, n3, this.prv_array, 0, n2);
            n3 += n2;
            int n9 = ++n3;
            ++n3;
            n2 = byArray[n9] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.p_array = new byte[n2];
            System.arraycopy(byArray, n3, this.p_array, 0, n2);
            n3 += n2;
            int n10 = ++n3;
            ++n3;
            n2 = byArray[n10] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.q_array = new byte[n2];
            System.arraycopy(byArray, n3, this.q_array, 0, n2);
            n3 += n2;
            int n11 = ++n3;
            ++n3;
            n2 = byArray[n11] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.ep_array = new byte[n2];
            System.arraycopy(byArray, n3, this.ep_array, 0, n2);
            n3 += n2;
            int n12 = ++n3;
            ++n3;
            n2 = byArray[n12] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.eq_array = new byte[n2];
            System.arraycopy(byArray, n3, this.eq_array, 0, n2);
            n3 += n2;
            int n13 = ++n3;
            ++n3;
            n2 = byArray[n13] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.c_array = new byte[n2];
            System.arraycopy(byArray, n3, this.c_array, 0, n2);
            n3 += n2;
            if (this.n_array != null) {
                this.key_size = new BigInteger(this.n_array).bitLength();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public byte[] getPublicKeyBlob() {
        byte[] byArray = super.getPublicKeyBlob();
        if (byArray != null) {
            return byArray;
        }
        if (this.pub_array == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[][]{sshrsa, this.pub_array, this.n_array};
        return Buffer.fromBytes((byte[][])byArrayArray).buffer;
    }

    @Override
    byte[] getKeyTypeName() {
        return sshrsa;
    }

    @Override
    public int getKeyType() {
        return 2;
    }

    @Override
    public int getKeySize() {
        return this.key_size;
    }

    @Override
    public byte[] getSignature(byte[] byArray) {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("signature.rsa"));
            SignatureRSA signatureRSA = (SignatureRSA)clazz.newInstance();
            signatureRSA.init();
            signatureRSA.setPrvKey(this.prv_array, this.n_array);
            signatureRSA.update(byArray);
            byte[] byArray2 = signatureRSA.sign();
            byte[][] byArrayArray = new byte[][]{sshrsa, byArray2};
            return Buffer.fromBytes((byte[][])byArrayArray).buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Signature getVerifier() {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("signature.rsa"));
            SignatureRSA signatureRSA = (SignatureRSA)clazz.newInstance();
            signatureRSA.init();
            if (this.pub_array == null && this.n_array == null && this.getPublicKeyBlob() != null) {
                Buffer buffer = new Buffer(this.getPublicKeyBlob());
                buffer.getString();
                this.pub_array = buffer.getString();
                this.n_array = buffer.getString();
            }
            signatureRSA.setPubKey(this.pub_array, this.n_array);
            return signatureRSA;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static KeyPair fromSSHAgent(JSch jSch, Buffer buffer) throws JSchException {
        byte[][] byArray = buffer.getBytes(8, "invalid key format");
        byte[] byArray2 = byArray[1];
        byte[] byArray3 = byArray[2];
        byte[] byArray4 = byArray[3];
        KeyPairRSA keyPairRSA = new KeyPairRSA(jSch, byArray2, byArray3, byArray4);
        keyPairRSA.c_array = byArray[4];
        keyPairRSA.p_array = byArray[5];
        keyPairRSA.q_array = byArray[6];
        keyPairRSA.publicKeyComment = new String(byArray[7]);
        keyPairRSA.vendor = 0;
        return keyPairRSA;
    }

    @Override
    public byte[] forSSHAgent() throws JSchException {
        if (this.isEncrypted()) {
            throw new JSchException("key is encrypted.");
        }
        Buffer buffer = new Buffer();
        buffer.putString(sshrsa);
        buffer.putString(this.n_array);
        buffer.putString(this.pub_array);
        buffer.putString(this.prv_array);
        buffer.putString(this.getCArray());
        buffer.putString(this.p_array);
        buffer.putString(this.q_array);
        buffer.putString(Util.str2byte(this.publicKeyComment));
        byte[] byArray = new byte[buffer.getLength()];
        buffer.getByte(byArray, 0, byArray.length);
        return byArray;
    }

    private byte[] getEPArray() {
        if (this.ep_array == null) {
            this.ep_array = new BigInteger(this.prv_array).mod(new BigInteger(this.p_array).subtract(BigInteger.ONE)).toByteArray();
        }
        return this.ep_array;
    }

    private byte[] getEQArray() {
        if (this.eq_array == null) {
            this.eq_array = new BigInteger(this.prv_array).mod(new BigInteger(this.q_array).subtract(BigInteger.ONE)).toByteArray();
        }
        return this.eq_array;
    }

    private byte[] getCArray() {
        if (this.c_array == null) {
            this.c_array = new BigInteger(this.q_array).modInverse(new BigInteger(this.p_array)).toByteArray();
        }
        return this.c_array;
    }

    @Override
    public void dispose() {
        super.dispose();
        Util.bzero(this.prv_array);
    }
}

