/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairDSA;
import com.jcraft.jsch.KeyPairRSA;
import com.jcraft.jsch.PBKDF;
import com.jcraft.jsch.Signature;
import com.jcraft.jsch.Util;
import java.math.BigInteger;
import java.util.Vector;

public class KeyPairPKCS8
extends KeyPair {
    private static final byte[] rsaEncryption = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};
    private static final byte[] dsaEncryption = new byte[]{42, -122, 72, -50, 56, 4, 1};
    private static final byte[] pbes2 = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 13};
    private static final byte[] pbkdf2 = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 12};
    private static final byte[] aes128cbc = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 2};
    private static final byte[] aes192cbc = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 22};
    private static final byte[] aes256cbc = new byte[]{96, -122, 72, 1, 101, 3, 4, 1, 42};
    private static final byte[] pbeWithMD5AndDESCBC = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 3};
    private KeyPair kpair = null;
    private static final byte[] begin = Util.str2byte("-----BEGIN DSA PRIVATE KEY-----");
    private static final byte[] end = Util.str2byte("-----END DSA PRIVATE KEY-----");

    public KeyPairPKCS8(JSch jSch) {
        super(jSch);
    }

    @Override
    void generate(int n) throws JSchException {
    }

    @Override
    byte[] getBegin() {
        return begin;
    }

    @Override
    byte[] getEnd() {
        return end;
    }

    @Override
    byte[] getPrivateKey() {
        return null;
    }

    @Override
    boolean parse(byte[] byArray) {
        try {
            Vector<byte[]> vector = new Vector<byte[]>();
            KeyPair.ASN1[] aSN1Array = null;
            KeyPair.ASN1 aSN1 = new KeyPair.ASN1(byArray);
            aSN1Array = aSN1.getContents();
            KeyPair.ASN1 aSN12 = aSN1Array[1];
            KeyPair.ASN1 aSN13 = aSN1Array[2];
            aSN1Array = aSN12.getContents();
            byte[] byArray2 = aSN1Array[0].getContent();
            aSN1Array = aSN1Array[1].getContents();
            if (aSN1Array.length > 0) {
                int n = 0;
                while (n < aSN1Array.length) {
                    vector.addElement(aSN1Array[n].getContent());
                    ++n;
                }
            }
            byte[] byArray3 = aSN13.getContent();
            KeyPair keyPair = null;
            if (Util.array_equals(byArray2, rsaEncryption)) {
                keyPair = new KeyPairRSA(this.jsch);
                keyPair.copy(this);
                if (keyPair.parse(byArray3)) {
                    this.kpair = keyPair;
                }
            } else if (Util.array_equals(byArray2, dsaEncryption)) {
                byte[] byArray4;
                aSN1 = new KeyPair.ASN1(byArray3);
                if (vector.size() == 0) {
                    aSN1Array = aSN1.getContents();
                    byArray4 = aSN1Array[1].getContent();
                    aSN1Array = aSN1Array[0].getContents();
                    int n = 0;
                    while (n < aSN1Array.length) {
                        vector.addElement(aSN1Array[n].getContent());
                        ++n;
                    }
                    vector.addElement(byArray4);
                } else {
                    vector.addElement(aSN1.getContent());
                }
                byArray4 = (byte[])vector.elementAt(0);
                byte[] byArray5 = (byte[])vector.elementAt(1);
                byte[] byArray6 = (byte[])vector.elementAt(2);
                byte[] byArray7 = (byte[])vector.elementAt(3);
                byte[] byArray8 = new BigInteger(byArray6).modPow(new BigInteger(byArray7), new BigInteger(byArray4)).toByteArray();
                KeyPairDSA keyPairDSA = new KeyPairDSA(this.jsch, byArray4, byArray5, byArray6, byArray8, byArray7);
                byArray = keyPairDSA.getPrivateKey();
                keyPair = new KeyPairDSA(this.jsch);
                keyPair.copy(this);
                if (keyPair.parse(byArray)) {
                    this.kpair = keyPair;
                }
            }
        }
        catch (KeyPair.ASN1Exception aSN1Exception) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        return this.kpair != null;
    }

    @Override
    public byte[] getPublicKeyBlob() {
        return this.kpair.getPublicKeyBlob();
    }

    @Override
    byte[] getKeyTypeName() {
        return this.kpair.getKeyTypeName();
    }

    @Override
    public int getKeyType() {
        return this.kpair.getKeyType();
    }

    @Override
    public int getKeySize() {
        return this.kpair.getKeySize();
    }

    @Override
    public byte[] getSignature(byte[] byArray) {
        return this.kpair.getSignature(byArray);
    }

    @Override
    public Signature getVerifier() {
        return this.kpair.getVerifier();
    }

    @Override
    public byte[] forSSHAgent() throws JSchException {
        return this.kpair.forSSHAgent();
    }

    @Override
    public boolean decrypt(byte[] byArray) {
        Object object;
        Object object2;
        Object object3;
        byte[] byArray2;
        byte[] byArray3;
        block14: {
            int n;
            byte[] byArray4;
            block13: {
                if (!this.isEncrypted()) {
                    return true;
                }
                if (byArray == null) {
                    return !this.isEncrypted();
                }
                KeyPair.ASN1[] aSN1Array = null;
                KeyPair.ASN1 aSN1 = new KeyPair.ASN1(this.data);
                aSN1Array = aSN1.getContents();
                byArray3 = aSN1Array[1].getContent();
                KeyPair.ASN1 aSN12 = aSN1Array[0];
                aSN1Array = aSN12.getContents();
                byte[] byArray5 = aSN1Array[0].getContent();
                KeyPair.ASN1 aSN13 = aSN1Array[1];
                byArray4 = null;
                n = 0;
                byArray2 = null;
                byte[] byArray6 = null;
                if (!Util.array_equals(byArray5, pbes2)) {
                    if (Util.array_equals(byArray5, pbeWithMD5AndDESCBC)) {
                        return false;
                    }
                    return false;
                }
                aSN1Array = aSN13.getContents();
                object3 = aSN1Array[0];
                object2 = aSN1Array[1];
                aSN1Array = ((KeyPair.ASN1)object3).getContents();
                aSN1Array[0].getContent();
                object = aSN1Array[1];
                aSN1Array = ((KeyPair.ASN1)object).getContents();
                byArray4 = aSN1Array[0].getContent();
                n = Integer.parseInt(new BigInteger(aSN1Array[1].getContent()).toString());
                aSN1Array = ((KeyPair.ASN1)object2).getContents();
                byArray6 = aSN1Array[0].getContent();
                byArray2 = aSN1Array[1].getContent();
                object3 = this.getCipher(byArray6);
                if (object3 != null) break block13;
                return false;
            }
            object2 = null;
            try {
                object = Class.forName(JSch.getConfig("pbkdf"));
                PBKDF pBKDF = (PBKDF)((Class)object).newInstance();
                object2 = pBKDF.getKey(byArray, byArray4, n, object3.getBlockSize());
            }
            catch (Exception exception) {}
            if (object2 != null) break block14;
            return false;
        }
        try {
            object3.init(1, (byte[])object2, byArray2);
            Util.bzero((byte[])object2);
            object = new byte[byArray3.length];
            object3.update(byArray3, 0, byArray3.length, (byte[])object, 0);
            if (this.parse((byte[])object)) {
                this.encrypted = false;
                return true;
            }
        }
        catch (KeyPair.ASN1Exception aSN1Exception) {
        }
        catch (Exception exception) {}
        return false;
    }

    Cipher getCipher(byte[] byArray) {
        Cipher cipher;
        block7: {
            cipher = null;
            String string = null;
            try {
                if (Util.array_equals(byArray, aes128cbc)) {
                    string = "aes128-cbc";
                } else if (Util.array_equals(byArray, aes192cbc)) {
                    string = "aes192-cbc";
                } else if (Util.array_equals(byArray, aes256cbc)) {
                    string = "aes256-cbc";
                }
                Class<?> clazz = Class.forName(JSch.getConfig(string));
                cipher = (Cipher)clazz.newInstance();
            }
            catch (Exception exception) {
                if (!JSch.getLogger().isEnabled(4)) break block7;
                String string2 = "";
                string2 = string == null ? "unknown oid: " + Util.toHex(byArray) : "function " + string + " is not supported";
                JSch.getLogger().log(4, "PKCS8: " + string2);
            }
        }
        return cipher;
    }
}

