/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairGenECDSA;
import com.jcraft.jsch.Signature;
import com.jcraft.jsch.SignatureECDSA;
import com.jcraft.jsch.Util;

public class KeyPairECDSA
extends KeyPair {
    private static byte[][] oids;
    private static String[] names;
    private byte[] name = Util.str2byte(names[0]);
    private byte[] r_array;
    private byte[] s_array;
    private byte[] prv_array;
    private int key_size = 256;
    private static final byte[] begin;
    private static final byte[] end;

    static {
        byte[][] byArrayArray = new byte[3][];
        byArrayArray[0] = new byte[]{6, 8, 42, -122, 72, -50, 61, 3, 1, 7};
        byte[] byArray = new byte[7];
        byArray[0] = 6;
        byArray[1] = 5;
        byArray[2] = 43;
        byArray[3] = -127;
        byArray[4] = 4;
        byArray[6] = 34;
        byArrayArray[1] = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[0] = 6;
        byArray2[1] = 5;
        byArray2[2] = 43;
        byArray2[3] = -127;
        byArray2[4] = 4;
        byArray2[6] = 35;
        byArrayArray[2] = byArray2;
        oids = byArrayArray;
        names = new String[]{"nistp256", "nistp384", "nistp521"};
        begin = Util.str2byte("-----BEGIN EC PRIVATE KEY-----");
        end = Util.str2byte("-----END EC PRIVATE KEY-----");
    }

    public KeyPairECDSA(JSch jSch) {
        this(jSch, null, null, null, null);
    }

    public KeyPairECDSA(JSch jSch, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(jSch);
        if (byArray != null) {
            this.name = byArray;
        }
        this.r_array = byArray2;
        this.s_array = byArray3;
        this.prv_array = byArray4;
        if (byArray4 != null) {
            this.key_size = byArray4.length >= 64 ? 521 : (byArray4.length >= 48 ? 384 : 256);
        }
    }

    @Override
    void generate(int n) throws JSchException {
        this.key_size = n;
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("keypairgen.ecdsa"));
            KeyPairGenECDSA keyPairGenECDSA = (KeyPairGenECDSA)clazz.newInstance();
            keyPairGenECDSA.init(n);
            this.prv_array = keyPairGenECDSA.getD();
            this.r_array = keyPairGenECDSA.getR();
            this.s_array = keyPairGenECDSA.getS();
            this.name = Util.str2byte(names[this.prv_array.length >= 64 ? 2 : (this.prv_array.length >= 48 ? 1 : 0)]);
            keyPairGenECDSA = null;
        }
        catch (Exception exception) {
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    @Override
    byte[] getBegin() {
        return begin;
    }

    @Override
    byte[] getEnd() {
        return end;
    }

    @Override
    byte[] getPrivateKey() {
        byte[] byArray = new byte[]{1};
        byte[] byArray2 = oids[this.r_array.length >= 64 ? 2 : (this.r_array.length >= 48 ? 1 : 0)];
        byte[] byArray3 = KeyPairECDSA.toPoint(this.r_array, this.s_array);
        int n = (byArray3.length + 1 & 0x80) == 0 ? 3 : 4;
        byte[] byArray4 = new byte[byArray3.length + n];
        System.arraycopy(byArray3, 0, byArray4, n, byArray3.length);
        byArray4[0] = 3;
        if (n == 3) {
            byArray4[1] = (byte)(byArray3.length + 1);
        } else {
            byArray4[1] = -127;
            byArray4[2] = (byte)(byArray3.length + 1);
        }
        byArray3 = byArray4;
        int n2 = 1 + this.countLength(byArray.length) + byArray.length + 1 + this.countLength(this.prv_array.length) + this.prv_array.length + 1 + this.countLength(byArray2.length) + byArray2.length + 1 + this.countLength(byArray3.length) + byArray3.length;
        int n3 = 1 + this.countLength(n2) + n2;
        byte[] byArray5 = new byte[n3];
        int n4 = 0;
        n4 = this.writeSEQUENCE(byArray5, n4, n2);
        n4 = this.writeINTEGER(byArray5, n4, byArray);
        n4 = this.writeOCTETSTRING(byArray5, n4, this.prv_array);
        n4 = this.writeDATA(byArray5, (byte)-96, n4, byArray2);
        n4 = this.writeDATA(byArray5, (byte)-95, n4, byArray3);
        return byArray5;
    }

    @Override
    boolean parse(byte[] byArray) {
        int n;
        int n2;
        int n3;
        block22: {
            block21: {
                block20: {
                    block19: {
                        if (this.vendor != 1) break block19;
                        return false;
                    }
                    if (this.vendor != 2) break block20;
                    return false;
                }
                n3 = 0;
                n2 = 0;
                if (byArray[n3] == 48) break block21;
                return false;
            }
            int n4 = ++n3;
            ++n3;
            n2 = byArray[n4] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            if (byArray[n3] == 2) break block22;
            return false;
        }
        try {
            int n5 = ++n3;
            ++n3;
            n2 = byArray[n5] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            n3 += n2;
            int n6 = ++n3;
            ++n3;
            n2 = byArray[n6] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.prv_array = new byte[n2];
            System.arraycopy(byArray, n3, this.prv_array, 0, n2);
            n3 += n2;
            int n7 = ++n3;
            ++n3;
            n2 = byArray[n7] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n3, byArray2, 0, n2);
            n3 += n2;
            int n8 = 0;
            while (n8 < oids.length) {
                if (Util.array_equals(oids[n8], byArray2)) {
                    this.name = Util.str2byte(names[n8]);
                    break;
                }
                ++n8;
            }
            int n9 = ++n3;
            ++n3;
            n2 = byArray[n9] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n8 = n2 & 0x7F;
                n2 = 0;
                while (n8-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n3, byArray3, 0, n2);
            n3 += n2;
            byte[][] byArray4 = KeyPairECDSA.fromPoint(byArray3);
            this.r_array = byArray4[0];
            this.s_array = byArray4[1];
            if (this.prv_array != null) {
                this.key_size = this.prv_array.length >= 64 ? 521 : (this.prv_array.length >= 48 ? 384 : 256);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public byte[] getPublicKeyBlob() {
        byte[] byArray = super.getPublicKeyBlob();
        if (byArray != null) {
            return byArray;
        }
        if (this.r_array == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[][]{Util.str2byte("ecdsa-sha2-" + new String(this.name)), this.name, new byte[1 + this.r_array.length + this.s_array.length]};
        byArrayArray[2][0] = 4;
        System.arraycopy(this.r_array, 0, byArrayArray[2], 1, this.r_array.length);
        System.arraycopy(this.s_array, 0, byArrayArray[2], 1 + this.r_array.length, this.s_array.length);
        return Buffer.fromBytes((byte[][])byArrayArray).buffer;
    }

    @Override
    byte[] getKeyTypeName() {
        return Util.str2byte("ecdsa-sha2-" + new String(this.name));
    }

    @Override
    public int getKeyType() {
        return 3;
    }

    @Override
    public int getKeySize() {
        return this.key_size;
    }

    @Override
    public byte[] getSignature(byte[] byArray) {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("signature.ecdsa"));
            SignatureECDSA signatureECDSA = (SignatureECDSA)clazz.newInstance();
            signatureECDSA.init();
            signatureECDSA.setPrvKey(this.prv_array);
            signatureECDSA.update(byArray);
            byte[] byArray2 = signatureECDSA.sign();
            byte[][] byArrayArray = new byte[][]{Util.str2byte("ecdsa-sha2-" + new String(this.name)), byArray2};
            return Buffer.fromBytes((byte[][])byArrayArray).buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Signature getVerifier() {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("signature.ecdsa"));
            SignatureECDSA signatureECDSA = (SignatureECDSA)clazz.newInstance();
            signatureECDSA.init();
            if (this.r_array == null && this.s_array == null && this.getPublicKeyBlob() != null) {
                Buffer buffer = new Buffer(this.getPublicKeyBlob());
                buffer.getString();
                buffer.getString();
                byte[][] byArray = KeyPairECDSA.fromPoint(buffer.getString());
                this.r_array = byArray[0];
                this.s_array = byArray[1];
            }
            signatureECDSA.setPubKey(this.r_array, this.s_array);
            return signatureECDSA;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static KeyPair fromSSHAgent(JSch jSch, Buffer buffer) throws JSchException {
        byte[][] byArray = buffer.getBytes(5, "invalid key format");
        byte[] byArray2 = byArray[1];
        byte[][] byArray3 = KeyPairECDSA.fromPoint(byArray[2]);
        byte[] byArray4 = byArray3[0];
        byte[] byArray5 = byArray3[1];
        byte[] byArray6 = byArray[3];
        KeyPairECDSA keyPairECDSA = new KeyPairECDSA(jSch, byArray2, byArray4, byArray5, byArray6);
        keyPairECDSA.publicKeyComment = new String(byArray[4]);
        keyPairECDSA.vendor = 0;
        return keyPairECDSA;
    }

    @Override
    public byte[] forSSHAgent() throws JSchException {
        if (this.isEncrypted()) {
            throw new JSchException("key is encrypted.");
        }
        Buffer buffer = new Buffer();
        buffer.putString(Util.str2byte("ecdsa-sha2-" + new String(this.name)));
        buffer.putString(this.name);
        buffer.putString(KeyPairECDSA.toPoint(this.r_array, this.s_array));
        buffer.putString(this.prv_array);
        buffer.putString(Util.str2byte(this.publicKeyComment));
        byte[] byArray = new byte[buffer.getLength()];
        buffer.getByte(byArray, 0, byArray.length);
        return byArray;
    }

    static byte[] toPoint(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[1 + byArray.length + byArray2.length];
        byArray3[0] = 4;
        System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 1 + byArray.length, byArray2.length);
        return byArray3;
    }

    static byte[][] fromPoint(byte[] byArray) {
        int n = 0;
        while (byArray[n] != 4) {
            ++n;
        }
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray2 = new byte[(byArray.length - ++n) / 2];
        byte[] byArray3 = new byte[(byArray.length - n) / 2];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        System.arraycopy(byArray, n + byArray2.length, byArray3, 0, byArray3.length);
        byArrayArray[0] = byArray2;
        byArrayArray[1] = byArray3;
        return byArrayArray;
    }

    @Override
    public void dispose() {
        super.dispose();
        Util.bzero(this.prv_array);
    }
}

