/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairGenDSA;
import com.jcraft.jsch.Signature;
import com.jcraft.jsch.SignatureDSA;
import com.jcraft.jsch.Util;
import java.math.BigInteger;

public class KeyPairDSA
extends KeyPair {
    private byte[] P_array;
    private byte[] Q_array;
    private byte[] G_array;
    private byte[] pub_array;
    private byte[] prv_array;
    private int key_size = 1024;
    private static final byte[] begin = Util.str2byte("-----BEGIN DSA PRIVATE KEY-----");
    private static final byte[] end = Util.str2byte("-----END DSA PRIVATE KEY-----");
    private static final byte[] sshdss = Util.str2byte("ssh-dss");

    public KeyPairDSA(JSch jSch) {
        this(jSch, null, null, null, null, null);
    }

    public KeyPairDSA(JSch jSch, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        super(jSch);
        this.P_array = byArray;
        this.Q_array = byArray2;
        this.G_array = byArray3;
        this.pub_array = byArray4;
        this.prv_array = byArray5;
        if (byArray != null) {
            this.key_size = new BigInteger(byArray).bitLength();
        }
    }

    @Override
    void generate(int n) throws JSchException {
        this.key_size = n;
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("keypairgen.dsa"));
            KeyPairGenDSA keyPairGenDSA = (KeyPairGenDSA)clazz.newInstance();
            keyPairGenDSA.init(n);
            this.P_array = keyPairGenDSA.getP();
            this.Q_array = keyPairGenDSA.getQ();
            this.G_array = keyPairGenDSA.getG();
            this.pub_array = keyPairGenDSA.getY();
            this.prv_array = keyPairGenDSA.getX();
            keyPairGenDSA = null;
        }
        catch (Exception exception) {
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    @Override
    byte[] getBegin() {
        return begin;
    }

    @Override
    byte[] getEnd() {
        return end;
    }

    @Override
    byte[] getPrivateKey() {
        int n = 1 + this.countLength(1) + 1 + 1 + this.countLength(this.P_array.length) + this.P_array.length + 1 + this.countLength(this.Q_array.length) + this.Q_array.length + 1 + this.countLength(this.G_array.length) + this.G_array.length + 1 + this.countLength(this.pub_array.length) + this.pub_array.length + 1 + this.countLength(this.prv_array.length) + this.prv_array.length;
        int n2 = 1 + this.countLength(n) + n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        n3 = this.writeSEQUENCE(byArray, n3, n);
        n3 = this.writeINTEGER(byArray, n3, new byte[1]);
        n3 = this.writeINTEGER(byArray, n3, this.P_array);
        n3 = this.writeINTEGER(byArray, n3, this.Q_array);
        n3 = this.writeINTEGER(byArray, n3, this.G_array);
        n3 = this.writeINTEGER(byArray, n3, this.pub_array);
        n3 = this.writeINTEGER(byArray, n3, this.prv_array);
        return byArray;
    }

    @Override
    boolean parse(byte[] byArray) {
        int n;
        int n2;
        int n3;
        block28: {
            block27: {
                block26: {
                    block25: {
                        if (this.vendor != 1) break block25;
                        if (byArray[0] != 48) {
                            Buffer buffer = new Buffer(byArray);
                            buffer.getInt();
                            this.P_array = buffer.getMPIntBits();
                            this.G_array = buffer.getMPIntBits();
                            this.Q_array = buffer.getMPIntBits();
                            this.pub_array = buffer.getMPIntBits();
                            this.prv_array = buffer.getMPIntBits();
                            if (this.P_array != null) {
                                this.key_size = new BigInteger(this.P_array).bitLength();
                            }
                            return true;
                        }
                        return false;
                    }
                    if (this.vendor != 2) break block26;
                    Buffer buffer = new Buffer(byArray);
                    buffer.skip(byArray.length);
                    try {
                        byte[][] byArray2 = buffer.getBytes(1, "");
                        this.prv_array = byArray2[0];
                    }
                    catch (JSchException jSchException) {
                        return false;
                    }
                    return true;
                }
                n3 = 0;
                n2 = 0;
                if (byArray[n3] == 48) break block27;
                return false;
            }
            int n4 = ++n3;
            ++n3;
            n2 = byArray[n4] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            if (byArray[n3] == 2) break block28;
            return false;
        }
        try {
            int n5 = ++n3;
            ++n3;
            n2 = byArray[n5] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            n3 += n2;
            int n6 = ++n3;
            ++n3;
            n2 = byArray[n6] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.P_array = new byte[n2];
            System.arraycopy(byArray, n3, this.P_array, 0, n2);
            n3 += n2;
            int n7 = ++n3;
            ++n3;
            n2 = byArray[n7] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.Q_array = new byte[n2];
            System.arraycopy(byArray, n3, this.Q_array, 0, n2);
            n3 += n2;
            int n8 = ++n3;
            ++n3;
            n2 = byArray[n8] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.G_array = new byte[n2];
            System.arraycopy(byArray, n3, this.G_array, 0, n2);
            n3 += n2;
            int n9 = ++n3;
            ++n3;
            n2 = byArray[n9] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.pub_array = new byte[n2];
            System.arraycopy(byArray, n3, this.pub_array, 0, n2);
            n3 += n2;
            int n10 = ++n3;
            ++n3;
            n2 = byArray[n10] & 0xFF;
            if ((n2 & 0x80) != 0) {
                n = n2 & 0x7F;
                n2 = 0;
                while (n-- > 0) {
                    n2 = (n2 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.prv_array = new byte[n2];
            System.arraycopy(byArray, n3, this.prv_array, 0, n2);
            n3 += n2;
            if (this.P_array != null) {
                this.key_size = new BigInteger(this.P_array).bitLength();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public byte[] getPublicKeyBlob() {
        byte[] byArray = super.getPublicKeyBlob();
        if (byArray != null) {
            return byArray;
        }
        if (this.P_array == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[][]{sshdss, this.P_array, this.Q_array, this.G_array, this.pub_array};
        return Buffer.fromBytes((byte[][])byArrayArray).buffer;
    }

    @Override
    byte[] getKeyTypeName() {
        return sshdss;
    }

    @Override
    public int getKeyType() {
        return 1;
    }

    @Override
    public int getKeySize() {
        return this.key_size;
    }

    @Override
    public byte[] getSignature(byte[] byArray) {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("signature.dss"));
            SignatureDSA signatureDSA = (SignatureDSA)clazz.newInstance();
            signatureDSA.init();
            signatureDSA.setPrvKey(this.prv_array, this.P_array, this.Q_array, this.G_array);
            signatureDSA.update(byArray);
            byte[] byArray2 = signatureDSA.sign();
            byte[][] byArrayArray = new byte[][]{sshdss, byArray2};
            return Buffer.fromBytes((byte[][])byArrayArray).buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Signature getVerifier() {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("signature.dss"));
            SignatureDSA signatureDSA = (SignatureDSA)clazz.newInstance();
            signatureDSA.init();
            if (this.pub_array == null && this.P_array == null && this.getPublicKeyBlob() != null) {
                Buffer buffer = new Buffer(this.getPublicKeyBlob());
                buffer.getString();
                this.P_array = buffer.getString();
                this.Q_array = buffer.getString();
                this.G_array = buffer.getString();
                this.pub_array = buffer.getString();
            }
            signatureDSA.setPubKey(this.pub_array, this.P_array, this.Q_array, this.G_array);
            return signatureDSA;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static KeyPair fromSSHAgent(JSch jSch, Buffer buffer) throws JSchException {
        byte[][] byArray = buffer.getBytes(7, "invalid key format");
        byte[] byArray2 = byArray[1];
        byte[] byArray3 = byArray[2];
        byte[] byArray4 = byArray[3];
        byte[] byArray5 = byArray[4];
        byte[] byArray6 = byArray[5];
        KeyPairDSA keyPairDSA = new KeyPairDSA(jSch, byArray2, byArray3, byArray4, byArray5, byArray6);
        keyPairDSA.publicKeyComment = new String(byArray[6]);
        keyPairDSA.vendor = 0;
        return keyPairDSA;
    }

    @Override
    public byte[] forSSHAgent() throws JSchException {
        if (this.isEncrypted()) {
            throw new JSchException("key is encrypted.");
        }
        Buffer buffer = new Buffer();
        buffer.putString(sshdss);
        buffer.putString(this.P_array);
        buffer.putString(this.Q_array);
        buffer.putString(this.G_array);
        buffer.putString(this.pub_array);
        buffer.putString(this.prv_array);
        buffer.putString(Util.str2byte(this.publicKeyComment));
        byte[] byArray = new byte[buffer.getLength()];
        buffer.getByte(byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    public void dispose() {
        super.dispose();
        Util.bzero(this.prv_array);
    }
}

