/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SignatureDSA;
import com.jcraft.jsch.SignatureECDSA;
import com.jcraft.jsch.SignatureRSA;
import com.jcraft.jsch.Util;

public abstract class KeyExchange {
    static final int PROPOSAL_KEX_ALGS = 0;
    static final int PROPOSAL_SERVER_HOST_KEY_ALGS = 1;
    static final int PROPOSAL_ENC_ALGS_CTOS = 2;
    static final int PROPOSAL_ENC_ALGS_STOC = 3;
    static final int PROPOSAL_MAC_ALGS_CTOS = 4;
    static final int PROPOSAL_MAC_ALGS_STOC = 5;
    static final int PROPOSAL_COMP_ALGS_CTOS = 6;
    static final int PROPOSAL_COMP_ALGS_STOC = 7;
    static final int PROPOSAL_LANG_CTOS = 8;
    static final int PROPOSAL_LANG_STOC = 9;
    static final int PROPOSAL_MAX = 10;
    static String kex = "diffie-hellman-group1-sha1";
    static String server_host_key = "ssh-rsa,ssh-dss";
    static String enc_c2s = "blowfish-cbc";
    static String enc_s2c = "blowfish-cbc";
    static String mac_c2s = "hmac-md5";
    static String mac_s2c = "hmac-md5";
    static String lang_c2s = "";
    static String lang_s2c = "";
    public static final int STATE_END = 0;
    protected Session session = null;
    protected HASH sha = null;
    protected byte[] K = null;
    protected byte[] H = null;
    protected byte[] K_S = null;
    protected final int RSA = 0;
    protected final int DSS = 1;
    protected final int ECDSA = 2;
    private int type = 0;
    private String key_alg_name = "";

    public abstract void init(Session var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5) throws Exception;

    public abstract boolean next(Buffer var1) throws Exception;

    public abstract int getState();

    public String getKeyType() {
        if (this.type == 1) {
            return "DSA";
        }
        if (this.type == 0) {
            return "RSA";
        }
        return "ECDSA";
    }

    public String getKeyAlgorithName() {
        return this.key_alg_name;
    }

    /*
     * Unable to fully structure code
     */
    protected static String[] guess(byte[] var0, byte[] var1_1) {
        var2_2 = new String[10];
        var3_3 = new Buffer(var0);
        var3_3.setOffSet(17);
        var4_4 = new Buffer(var1_1);
        var4_4.setOffSet(17);
        if (JSch.getLogger().isEnabled(1)) {
            var5_5 = 0;
            while (var5_5 < 10) {
                JSch.getLogger().log(1, "kex: server: " + Util.byte2str(var3_3.getString()));
                ++var5_5;
            }
            var5_5 = 0;
            while (var5_5 < 10) {
                JSch.getLogger().log(1, "kex: client: " + Util.byte2str(var4_4.getString()));
                ++var5_5;
            }
            var3_3.setOffSet(17);
            var4_4.setOffSet(17);
        }
        var5_5 = 0;
        while (var5_5 < 10) {
            var6_6 = var3_3.getString();
            var7_7 = var4_4.getString();
            var8_8 = 0;
            var9_9 = 0;
            ** GOTO lbl46
            {
                ++var8_8;
                do {
                    if (var8_8 < var7_7.length && var7_7[var8_8] != 44) continue block3;
                    if (var9_9 == var8_8) {
                        return null;
                    }
                    var10_10 = Util.byte2str(var7_7, var9_9, var8_8 - var9_9);
                    var11_11 = 0;
                    var12_12 = 0;
                    ** GOTO lbl44
                    {
                        ++var11_11;
                        do {
                            if (var11_11 < var6_6.length && var6_6[var11_11] != 44) continue block5;
                            if (var12_12 == var11_11) {
                                return null;
                            }
                            if (var10_10.equals(Util.byte2str(var6_6, var12_12, var11_11 - var12_12))) {
                                var2_2[var5_5] = var10_10;
                                break block3;
                            }
                            var12_12 = ++var11_11;
lbl44:
                            // 2 sources

                        } while (var11_11 < var6_6.length);
                    }
                    var9_9 = ++var8_8;
lbl46:
                    // 2 sources

                } while (var8_8 < var7_7.length);
            }
            if (var8_8 == 0) {
                var2_2[var5_5] = "";
            } else if (var2_2[var5_5] == null) {
                return null;
            }
            ++var5_5;
        }
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "kex: server->client " + var2_2[3] + " " + var2_2[5] + " " + var2_2[7]);
            JSch.getLogger().log(1, "kex: client->server " + var2_2[2] + " " + var2_2[4] + " " + var2_2[6]);
        }
        return var2_2;
    }

    public String getFingerPrint() {
        HASH hASH = null;
        try {
            Class<?> clazz = Class.forName(this.session.getConfig("md5"));
            hASH = (HASH)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("getFingerPrint: " + exception);
        }
        return Util.getFingerPrint(hASH, this.getHostKey());
    }

    byte[] getK() {
        return this.K;
    }

    byte[] getH() {
        return this.H;
    }

    HASH getHash() {
        return this.sha;
    }

    byte[] getHostKey() {
        return this.K_S;
    }

    protected byte[] normalize(byte[] byArray) {
        if (byArray.length > 1 && byArray[0] == 0 && (byArray[1] & 0x80) == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return this.normalize(byArray2);
        }
        return byArray;
    }

    protected boolean verify(String string, byte[] byArray, int n, byte[] byArray2) throws Exception {
        int n2 = n;
        boolean bl = false;
        if (string.equals("ssh-rsa")) {
            this.type = 0;
            this.key_alg_name = string;
            int n3 = byArray[n2++] << 24 & 0xFF000000 | byArray[n2++] << 16 & 0xFF0000 | byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n2, byArray3, 0, n3);
            n2 += n3;
            byte[] byArray4 = byArray3;
            n3 = byArray[n2++] << 24 & 0xFF000000 | byArray[n2++] << 16 & 0xFF0000 | byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
            byArray3 = new byte[n3];
            System.arraycopy(byArray, n2, byArray3, 0, n3);
            n2 += n3;
            byte[] byArray5 = byArray3;
            SignatureRSA signatureRSA = null;
            try {
                Class<?> clazz = Class.forName(this.session.getConfig("signature.rsa"));
                signatureRSA = (SignatureRSA)clazz.newInstance();
                signatureRSA.init();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            signatureRSA.setPubKey(byArray4, byArray5);
            signatureRSA.update(this.H);
            bl = signatureRSA.verify(byArray2);
            if (JSch.getLogger().isEnabled(1)) {
                JSch.getLogger().log(1, "ssh_rsa_verify: signature " + bl);
            }
        } else if (string.equals("ssh-dss")) {
            byte[] byArray6 = null;
            this.type = 1;
            this.key_alg_name = string;
            int n4 = byArray[n2++] << 24 & 0xFF000000 | byArray[n2++] << 16 & 0xFF0000 | byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
            byte[] byArray7 = new byte[n4];
            System.arraycopy(byArray, n2, byArray7, 0, n4);
            n2 += n4;
            byte[] byArray8 = byArray7;
            n4 = byArray[n2++] << 24 & 0xFF000000 | byArray[n2++] << 16 & 0xFF0000 | byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
            byArray7 = new byte[n4];
            System.arraycopy(byArray, n2, byArray7, 0, n4);
            n2 += n4;
            byArray6 = byArray7;
            n4 = byArray[n2++] << 24 & 0xFF000000 | byArray[n2++] << 16 & 0xFF0000 | byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
            byArray7 = new byte[n4];
            System.arraycopy(byArray, n2, byArray7, 0, n4);
            n2 += n4;
            byte[] byArray9 = byArray7;
            n4 = byArray[n2++] << 24 & 0xFF000000 | byArray[n2++] << 16 & 0xFF0000 | byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
            byArray7 = new byte[n4];
            System.arraycopy(byArray, n2, byArray7, 0, n4);
            n2 += n4;
            byte[] byArray10 = byArray7;
            SignatureDSA signatureDSA = null;
            try {
                Class<?> clazz = Class.forName(this.session.getConfig("signature.dss"));
                signatureDSA = (SignatureDSA)clazz.newInstance();
                signatureDSA.init();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            signatureDSA.setPubKey(byArray10, byArray8, byArray6, byArray9);
            signatureDSA.update(this.H);
            bl = signatureDSA.verify(byArray2);
            if (JSch.getLogger().isEnabled(1)) {
                JSch.getLogger().log(1, "ssh_dss_verify: signature " + bl);
            }
        } else if (string.equals("ecdsa-sha2-nistp256") || string.equals("ecdsa-sha2-nistp384") || string.equals("ecdsa-sha2-nistp521")) {
            this.type = 2;
            this.key_alg_name = string;
            int n5 = byArray[n2++] << 24 & 0xFF000000 | byArray[n2++] << 16 & 0xFF0000 | byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
            byte[] byArray11 = new byte[n5];
            System.arraycopy(byArray, n2, byArray11, 0, n5);
            n2 += n5;
            n5 = byArray[n2++] << 24 & 0xFF000000 | byArray[n2++] << 16 & 0xFF0000 | byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
            byArray11 = new byte[(n5 - 1) / 2];
            System.arraycopy(byArray, ++n2, byArray11, 0, byArray11.length);
            byte[] byArray12 = byArray11;
            byArray11 = new byte[(n5 - 1) / 2];
            System.arraycopy(byArray, n2 += (n5 - 1) / 2, byArray11, 0, byArray11.length);
            n2 += (n5 - 1) / 2;
            byte[] byArray13 = byArray11;
            SignatureECDSA signatureECDSA = null;
            try {
                Class<?> clazz = Class.forName(this.session.getConfig("signature.ecdsa"));
                signatureECDSA = (SignatureECDSA)clazz.newInstance();
                signatureECDSA.init();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            signatureECDSA.setPubKey(byArray12, byArray13);
            signatureECDSA.update(this.H);
            bl = signatureECDSA.verify(byArray2);
        } else {
            System.err.println("unknown alg");
        }
        return bl;
    }
}

