/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.DH;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;

public class DHGEX
extends KeyExchange {
    private static final int SSH_MSG_KEX_DH_GEX_GROUP = 31;
    private static final int SSH_MSG_KEX_DH_GEX_INIT = 32;
    private static final int SSH_MSG_KEX_DH_GEX_REPLY = 33;
    private static final int SSH_MSG_KEX_DH_GEX_REQUEST = 34;
    static int min = 1024;
    static int preferred = 1024;
    int max = 1024;
    private int state;
    DH dh;
    byte[] V_S;
    byte[] V_C;
    byte[] I_S;
    byte[] I_C;
    private Buffer buf;
    private Packet packet;
    private byte[] p;
    private byte[] g;
    private byte[] e;
    protected String hash = "sha-1";

    @Override
    public void init(Session session, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws Exception {
        Class<?> clazz;
        this.session = session;
        this.V_S = byArray;
        this.V_C = byArray2;
        this.I_S = byArray3;
        this.I_C = byArray4;
        try {
            clazz = Class.forName(session.getConfig(this.hash));
            this.sha = (HASH)clazz.newInstance();
            this.sha.init();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        clazz = Class.forName(session.getConfig("dh"));
        preferred = this.max = this.check2048(clazz, this.max);
        this.dh = (DH)clazz.newInstance();
        this.dh.init();
        this.packet.reset();
        this.buf.putByte((byte)34);
        this.buf.putInt(min);
        this.buf.putInt(preferred);
        this.buf.putInt(this.max);
        session.write(this.packet);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "SSH_MSG_KEX_DH_GEX_REQUEST(" + min + "<" + preferred + "<" + this.max + ") sent");
            JSch.getLogger().log(1, "expecting SSH_MSG_KEX_DH_GEX_GROUP");
        }
        this.state = 31;
    }

    @Override
    public boolean next(Buffer buffer) throws Exception {
        switch (this.state) {
            case 31: {
                buffer.getInt();
                buffer.getByte();
                int n = buffer.getByte();
                if (n != 31) {
                    System.err.println("type: must be SSH_MSG_KEX_DH_GEX_GROUP " + n);
                    return false;
                }
                this.p = buffer.getMPInt();
                this.g = buffer.getMPInt();
                this.dh.setP(this.p);
                this.dh.setG(this.g);
                this.e = this.dh.getE();
                this.packet.reset();
                this.buf.putByte((byte)32);
                this.buf.putMPInt(this.e);
                this.session.write(this.packet);
                if (JSch.getLogger().isEnabled(1)) {
                    JSch.getLogger().log(1, "SSH_MSG_KEX_DH_GEX_INIT sent");
                    JSch.getLogger().log(1, "expecting SSH_MSG_KEX_DH_GEX_REPLY");
                }
                this.state = 33;
                return true;
            }
            case 33: {
                int n = buffer.getInt();
                n = buffer.getByte();
                n = buffer.getByte();
                if (n != 33) {
                    System.err.println("type: must be SSH_MSG_KEX_DH_GEX_REPLY " + n);
                    return false;
                }
                this.K_S = buffer.getString();
                byte[] byArray = buffer.getMPInt();
                byte[] byArray2 = buffer.getString();
                this.dh.setF(byArray);
                this.dh.checkRange();
                this.K = this.normalize(this.dh.getK());
                this.buf.reset();
                this.buf.putString(this.V_C);
                this.buf.putString(this.V_S);
                this.buf.putString(this.I_C);
                this.buf.putString(this.I_S);
                this.buf.putString(this.K_S);
                this.buf.putInt(min);
                this.buf.putInt(preferred);
                this.buf.putInt(this.max);
                this.buf.putMPInt(this.p);
                this.buf.putMPInt(this.g);
                this.buf.putMPInt(this.e);
                this.buf.putMPInt(byArray);
                this.buf.putMPInt(this.K);
                byte[] byArray3 = new byte[this.buf.getLength()];
                this.buf.getByte(byArray3);
                this.sha.update(byArray3, 0, byArray3.length);
                this.H = this.sha.digest();
                int n2 = 0;
                n = 0;
                n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                String string = Util.byte2str(this.K_S, n2, n);
                boolean bl = this.verify(string, this.K_S, n2 += n, byArray2);
                this.state = 0;
                return bl;
            }
        }
        return false;
    }

    @Override
    public int getState() {
        return this.state;
    }

    protected int check2048(Class clazz, int n) throws Exception {
        DH dH = (DH)clazz.newInstance();
        dH.init();
        byte[] byArray = new byte[257];
        byArray[1] = -35;
        byArray[256] = 115;
        dH.setP(byArray);
        byte[] byArray2 = new byte[]{2};
        dH.setG(byArray2);
        try {
            dH.getE();
            n = 2048;
        }
        catch (Exception exception) {}
        return n;
    }
}

