/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;

class ChannelX11
extends Channel {
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    private static final int TIMEOUT = 10000;
    private static String host = "127.0.0.1";
    private static int port = 6000;
    private boolean init = true;
    static byte[] cookie = null;
    private static byte[] cookie_hex = null;
    private static Hashtable faked_cookie_pool = new Hashtable();
    private static Hashtable faked_cookie_hex_pool = new Hashtable();
    private static byte[] table = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private Socket socket = null;
    private byte[] cache = new byte[0];

    static int revtable(byte by) {
        int n = 0;
        while (n < table.length) {
            if (table[n] == by) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    static void setCookie(String string) {
        cookie_hex = Util.str2byte(string);
        cookie = new byte[16];
        int n = 0;
        while (n < 16) {
            ChannelX11.cookie[n] = (byte)(ChannelX11.revtable(cookie_hex[n * 2]) << 4 & 0xF0 | ChannelX11.revtable(cookie_hex[n * 2 + 1]) & 0xF);
            ++n;
        }
    }

    static void setHost(String string) {
        host = string;
    }

    static void setPort(int n) {
        port = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getFakedCookie(Session session) {
        Hashtable hashtable = faked_cookie_hex_pool;
        synchronized (hashtable) {
            Object object = (byte[])faked_cookie_hex_pool.get(session);
            if (object == null) {
                Random random = Session.random;
                object = new byte[16];
                Object object2 = random;
                synchronized (object2) {
                    random.fill((byte[])object, 0, 16);
                }
                faked_cookie_pool.put(session, object);
                object2 = new byte[32];
                int n = 0;
                while (n < 16) {
                    object2[2 * n] = table[object[n] >>> 4 & 0xF];
                    object2[2 * n + 1] = table[object[n] & 0xF];
                    ++n;
                }
                faked_cookie_hex_pool.put(session, object2);
                object = object2;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFakedCookie(Session session) {
        Hashtable hashtable = faked_cookie_hex_pool;
        synchronized (hashtable) {
            faked_cookie_hex_pool.remove(session);
            faked_cookie_pool.remove(session);
        }
    }

    ChannelX11() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
        this.type = Util.str2byte("x11");
        this.connected = true;
    }

    @Override
    public void run() {
        try {
            this.socket = Util.createSocket(host, port, 10000);
            this.socket.setTcpNoDelay(true);
            this.io = new IO();
            this.io.setInputStream(this.socket.getInputStream());
            this.io.setOutputStream(this.socket.getOutputStream());
            this.sendOpenConfirmation();
        }
        catch (Exception exception) {
            this.sendOpenFailure(1);
            this.close = true;
            this.disconnect();
            return;
        }
        this.thread = Thread.currentThread();
        Buffer buffer = new Buffer(this.rmpsize);
        Packet packet = new Packet(buffer);
        int n = 0;
        try {
            while (this.thread != null && this.io != null && this.io.in != null) {
                n = this.io.in.read(buffer.buffer, 14, buffer.buffer.length - 14 - 84);
                if (n <= 0) {
                    this.eof();
                } else if (!this.close) {
                    packet.reset();
                    buffer.putByte((byte)94);
                    buffer.putInt(this.recipient);
                    buffer.putInt(n);
                    buffer.skip(n);
                    this.getSession().write(packet, this, n);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {}
        this.disconnect();
    }

    private byte[] addCache(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[this.cache.length + n2];
        System.arraycopy(byArray, n, byArray2, this.cache.length, n2);
        if (this.cache.length > 0) {
            System.arraycopy(this.cache, 0, byArray2, 0, this.cache.length);
        }
        this.cache = byArray2;
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.init) {
            Session session = null;
            try {
                session = this.getSession();
            }
            catch (JSchException jSchException) {
                throw new IOException(jSchException.toString());
            }
            byArray = this.addCache(byArray, n, n2);
            n = 0;
            n2 = byArray.length;
            if (n2 < 9) {
                return;
            }
            int n3 = (byArray[n + 6] & 0xFF) * 256 + (byArray[n + 7] & 0xFF);
            int n4 = (byArray[n + 8] & 0xFF) * 256 + (byArray[n + 9] & 0xFF);
            if ((byArray[n] & 0xFF) != 66 && (byArray[n] & 0xFF) == 108) {
                n3 = n3 >>> 8 & 0xFF | n3 << 8 & 0xFF00;
                n4 = n4 >>> 8 & 0xFF | n4 << 8 & 0xFF00;
            }
            if (n2 < 12 + n3 + (-n3 & 3) + n4) {
                return;
            }
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n + 12 + n3 + (-n3 & 3), byArray2, 0, n4);
            byte[] byArray3 = null;
            Hashtable hashtable = faked_cookie_pool;
            synchronized (hashtable) {
                byArray3 = (byte[])faked_cookie_pool.get(session);
            }
            if (ChannelX11.equals(byArray2, byArray3)) {
                if (cookie != null) {
                    System.arraycopy(cookie, 0, byArray, n + 12 + n3 + (-n3 & 3), n4);
                }
            } else {
                this.thread = null;
                this.eof();
                this.io.close();
                this.disconnect();
            }
            this.init = false;
            this.io.put(byArray, n, n2);
            this.cache = null;
            return;
        }
        this.io.put(byArray, n, n2);
    }

    private static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

