/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.deltopia.io.PipedOutputStream;
import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Request;
import com.jcraft.jsch.RequestSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.SftpStatVFS;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class ChannelSftp
extends ChannelSession {
    private static final Logger LOG = JSch.getLogger();
    private static final boolean TRACE;
    private static final boolean TRACE_STREAM;
    private static final boolean TRACE_QUEUE;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 32768;
    private static final int LOCAL_WINDOW_SIZE_MAX = 0x200000;
    private static final byte SSH_FXP_INIT = 1;
    private static final byte SSH_FXP_VERSION = 2;
    private static final byte SSH_FXP_OPEN = 3;
    private static final byte SSH_FXP_CLOSE = 4;
    private static final byte SSH_FXP_READ = 5;
    private static final byte SSH_FXP_WRITE = 6;
    private static final byte SSH_FXP_LSTAT = 7;
    private static final byte SSH_FXP_FSTAT = 8;
    private static final byte SSH_FXP_SETSTAT = 9;
    private static final byte SSH_FXP_FSETSTAT = 10;
    private static final byte SSH_FXP_OPENDIR = 11;
    private static final byte SSH_FXP_READDIR = 12;
    private static final byte SSH_FXP_REMOVE = 13;
    private static final byte SSH_FXP_MKDIR = 14;
    private static final byte SSH_FXP_RMDIR = 15;
    private static final byte SSH_FXP_REALPATH = 16;
    private static final byte SSH_FXP_STAT = 17;
    private static final byte SSH_FXP_RENAME = 18;
    private static final byte SSH_FXP_READLINK = 19;
    private static final byte SSH_FXP_SYMLINK = 20;
    private static final byte SSH_FXP_STATUS = 101;
    private static final byte SSH_FXP_HANDLE = 102;
    private static final byte SSH_FXP_DATA = 103;
    private static final byte SSH_FXP_NAME = 104;
    private static final byte SSH_FXP_ATTRS = 105;
    private static final byte SSH_FXP_EXTENDED = -56;
    private static final byte SSH_FXP_EXTENDED_REPLY = -55;
    private static final int SSH_FXF_READ = 1;
    private static final int SSH_FXF_WRITE = 2;
    private static final int SSH_FXF_APPEND = 4;
    private static final int SSH_FXF_CREAT = 8;
    private static final int SSH_FXF_TRUNC = 16;
    private static final int SSH_FXF_EXCL = 32;
    private static final int SSH_FILEXFER_ATTR_SIZE = 1;
    private static final int SSH_FILEXFER_ATTR_UIDGID = 2;
    private static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    private static final int SSH_FILEXFER_ATTR_ACMODTIME = 8;
    private static final int SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    public static final int SSH_FX_OK = 0;
    public static final int SSH_FX_EOF = 1;
    public static final int SSH_FX_NO_SUCH_FILE = 2;
    public static final int SSH_FX_PERMISSION_DENIED = 3;
    public static final int SSH_FX_FAILURE = 4;
    public static final int SSH_FX_BAD_MESSAGE = 5;
    public static final int SSH_FX_NO_CONNECTION = 6;
    public static final int SSH_FX_CONNECTION_LOST = 7;
    public static final int SSH_FX_OP_UNSUPPORTED = 8;
    private static final int MAX_MSG_LENGTH = 262144;
    public static final int OVERWRITE = 0;
    public static final int RESUME = 1;
    public static final int APPEND = 2;
    private boolean interactive = false;
    private int seq = 1;
    private int[] ackid = new int[1];
    private Buffer buf;
    private Packet packet;
    private Buffer obuf;
    private Packet opacket;
    private int client_version = 3;
    private int server_version = 3;
    private String version = String.valueOf(this.client_version);
    private Hashtable extensions = null;
    private InputStream io_in = null;
    private boolean extension_posix_rename = false;
    private boolean extension_statvfs = false;
    private boolean extension_hardlink = false;
    private static final String file_separator;
    private static final char file_separatorc;
    private static boolean fs_is_bs;
    private String cwd;
    private String home;
    private String lcwd;
    private static final String UTF8 = "UTF-8";
    private String fEncoding = "UTF-8";
    private boolean fEncoding_is_utf8 = true;
    private RequestQueue rq = new RequestQueue(16);

    static {
        TRACE_STREAM = TRACE = LOG.isEnabled(0);
        TRACE_QUEUE = TRACE;
        file_separator = File.separator;
        file_separatorc = File.separatorChar;
        fs_is_bs = (byte)File.separatorChar == 92;
    }

    public void setBulkRequests(int n) throws JSchException {
        if (n <= 0) {
            throw new JSchException("setBulkRequests: " + n + " must be greater than 0.");
        }
        this.rq = new RequestQueue(n);
    }

    public int getBulkRequests() {
        return this.rq.size();
    }

    public ChannelSftp() {
        this.setLocalWindowSizeMax(0x200000);
        this.setLocalWindowSize(0x200000);
        this.setLocalPacketSize(32768);
        if (TRACE) {
            LOG.log(1, "Create channel " + this);
        }
    }

    @Override
    void init() {
    }

    @Override
    public void start() throws JSchException {
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            this.io.setOutputStream((OutputStream)pipedOutputStream);
            Channel.MyPipedInputStream myPipedInputStream = (Channel)this.new Channel.MyPipedInputStream(pipedOutputStream, this.rmpsize);
            this.io.setInputStream((InputStream)((Object)myPipedInputStream));
            this.io_in = this.io.in;
            if (this.io_in == null) {
                throw new JSchException("channel is down");
            }
            RequestSftp requestSftp = new RequestSftp();
            ((Request)requestSftp).request(this.getSession(), this);
            this.buf = new Buffer(this.lmpsize);
            this.packet = new Packet(this.buf);
            this.obuf = new Buffer(this.rmpsize);
            this.opacket = new Packet(this.obuf);
            this.sendINIT();
            Header header = new Header();
            header = this.header(this.buf, header);
            int n = header.length;
            if (n > 262144) {
                throw new SftpException(4, "Received message is too long: " + n);
            }
            int cfr_ignored_0 = header.type;
            this.server_version = header.rid;
            this.extensions = new Hashtable();
            if (n > 0) {
                this.fill(this.buf, n);
                byte[] byArray = null;
                byte[] byArray2 = null;
                while (n > 0) {
                    byArray = this.buf.getString();
                    n -= 4 + byArray.length;
                    byArray2 = this.buf.getString();
                    n -= 4 + byArray2.length;
                    this.extensions.put(Util.byte2str(byArray), Util.byte2str(byArray2));
                }
            }
            if (this.extensions.get("posix-rename@openssh.com") != null && this.extensions.get("posix-rename@openssh.com").equals("1")) {
                this.extension_posix_rename = true;
            }
            if (this.extensions.get("statvfs@openssh.com") != null && this.extensions.get("statvfs@openssh.com").equals("2")) {
                this.extension_statvfs = true;
            }
            if (this.extensions.get("hardlink@openssh.com") != null && this.extensions.get("hardlink@openssh.com").equals("1")) {
                this.extension_hardlink = true;
            }
            this.lcwd = new File(".").getCanonicalPath();
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    public void quit() {
        this.disconnect();
    }

    public void exit() {
        this.disconnect();
    }

    public void lcd(String string) throws SftpException {
        if (new File(string = this.localAbsolutePath(string)).isDirectory()) {
            try {
                string = new File(string).getCanonicalPath();
            }
            catch (Exception exception) {}
            this.lcwd = string;
            return;
        }
        throw new SftpException(2, "No such directory");
    }

    public void cd(String string) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            string = this.isUnique(string);
            byte[] byArray = this._realpath(string);
            SftpATTRS sftpATTRS = this._stat(byArray);
            if ((sftpATTRS.getFlags() & 4) == 0) {
                throw new SftpException(4, "Can't change directory: " + string);
            }
            if (!sftpATTRS.isDir()) {
                throw new SftpException(4, "Can't change directory: " + string);
            }
            this.setCwd(Util.byte2str(byArray, this.fEncoding));
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void put(String string, String string2) throws SftpException {
        this.put(string, string2, null, 0);
    }

    public void put(String string, String string2, int n) throws SftpException {
        this.put(string, string2, null, n);
    }

    public void put(String string, String string2, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        this.put(string, string2, sftpProgressMonitor, 0);
    }

    public void put(String string, String string2, SftpProgressMonitor sftpProgressMonitor, int n) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.localAbsolutePath(string);
            string2 = this.remoteAbsolutePath(string2);
            Vector vector = this.glob_remote(string2);
            int n2 = vector.size();
            if (n2 != 1) {
                if (n2 == 0) {
                    if (this.isPattern(string2)) {
                        throw new SftpException(4, string2);
                    }
                    string2 = Util.unquote(string2);
                }
                throw new SftpException(4, vector.toString());
            }
            string2 = (String)vector.elementAt(0);
            boolean bl = this.isRemoteDir(string2);
            vector = this.glob_local(string);
            n2 = vector.size();
            StringBuffer stringBuffer = null;
            if (bl) {
                if (!string2.endsWith("/")) {
                    string2 = String.valueOf(string2) + "/";
                }
                stringBuffer = new StringBuffer(string2);
            } else if (n2 > 1) {
                throw new SftpException(4, "Copying multiple files, but the destination is missing or a file.");
            }
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                String string3 = (String)vector.elementAt(n3);
                String string4 = null;
                if (bl) {
                    int n4;
                    int n5 = string3.lastIndexOf(file_separatorc);
                    if (fs_is_bs && (n4 = string3.lastIndexOf(47)) != -1 && n4 > n5) {
                        n5 = n4;
                    }
                    if (n5 == -1) {
                        stringBuffer.append(string3);
                    } else {
                        stringBuffer.append(string3.substring(n5 + 1));
                    }
                    string4 = stringBuffer.toString();
                    stringBuffer.delete(string2.length(), string4.length());
                } else {
                    string4 = string2;
                }
                long l = 0L;
                if (n == 1) {
                    try {
                        object = this._stat(string4);
                        l = ((SftpATTRS)object).getSize();
                    }
                    catch (Exception exception) {}
                    long l2 = new File(string3).length();
                    if (l2 < l) {
                        throw new SftpException(4, "failed to resume for " + string4);
                    }
                    if (l2 == l) {
                        return;
                    }
                }
                if (sftpProgressMonitor != null) {
                    sftpProgressMonitor.init(0, string3, string4, new File(string3).length());
                    if (n == 1) {
                        sftpProgressMonitor.count(l);
                    }
                }
                object = null;
                try {
                    object = new FileInputStream(string3);
                    this._put((InputStream)object, string4, sftpProgressMonitor, n);
                }
                finally {
                    if (object != null) {
                        ((FileInputStream)object).close();
                    }
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, exception.toString(), exception);
            }
            throw new SftpException(4, exception.toString());
        }
    }

    public void put(InputStream inputStream, String string) throws SftpException {
        this.put(inputStream, string, null, 0);
    }

    public void put(InputStream inputStream, String string, int n) throws SftpException {
        this.put(inputStream, string, null, n);
    }

    public void put(InputStream inputStream, String string, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        this.put(inputStream, string, sftpProgressMonitor, 0);
    }

    public void put(InputStream inputStream, String string, SftpProgressMonitor sftpProgressMonitor, int n) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n2 = vector.size();
            if (n2 != 1) {
                if (n2 == 0) {
                    if (this.isPattern(string)) {
                        throw new SftpException(4, string);
                    }
                    string = Util.unquote(string);
                }
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            if (sftpProgressMonitor != null) {
                sftpProgressMonitor.init(0, "-", string, -1L);
            }
            this._put(inputStream, string, sftpProgressMonitor, n);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                if (((SftpException)exception).id == 4 && this.isRemoteDir(string)) {
                    throw new SftpException(4, String.valueOf(string) + " is a directory");
                }
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, exception.toString(), exception);
            }
            throw new SftpException(4, exception.toString());
        }
    }

    public void _put(InputStream inputStream, String string, SftpProgressMonitor sftpProgressMonitor, int n) throws SftpException {
        try {
            int n2;
            int n3;
            long l;
            Object object;
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            byte[] byArray = Util.str2byte(string, this.fEncoding);
            long l2 = 0L;
            if (n == 1 || n == 2) {
                try {
                    object = this._stat(byArray);
                    l2 = ((SftpATTRS)object).getSize();
                }
                catch (Exception exception) {}
            }
            if (n == 1 && l2 > 0L && (l = inputStream.skip(l2)) < l2) {
                throw new SftpException(4, "failed to resume for " + string);
            }
            if (n == 0) {
                this.sendOPENW(byArray);
            } else {
                this.sendOPENA(byArray);
            }
            object = new Header();
            object = this.header(this.buf, (Header)object);
            int n4 = ((Header)object).length;
            int n5 = ((Header)object).type;
            this.fill(this.buf, n4);
            if (n5 != 101 && n5 != 102) {
                throw new SftpException(4, "invalid type=" + n5);
            }
            if (n5 == 101) {
                int n6 = this.buf.getInt();
                this.throwStatusError(this.buf, n6);
            }
            byte[] byArray2 = this.buf.getString();
            byte[] byArray3 = null;
            boolean bl = true;
            if (!bl) {
                byArray3 = new byte[this.obuf.buffer.length - (39 + byArray2.length + 84)];
            }
            long l3 = 0L;
            if (n == 1 || n == 2) {
                l3 += l2;
            }
            int n7 = this.seq;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            if (!bl) {
                n10 = byArray3.length;
            } else {
                byArray3 = this.obuf.buffer;
                n9 = 39 + byArray2.length;
                n10 = this.obuf.buffer.length - n9 - 84;
            }
            int n11 = this.rq.size();
            do {
                n2 = 0;
                n3 = 0;
                int n12 = n9;
                int n13 = n10;
                do {
                    if ((n2 = inputStream.read(byArray3, n12, n13)) <= 0) continue;
                    n12 += n2;
                    n13 -= n2;
                    n3 += n2;
                } while (n13 > 0 && n2 > 0);
                if (n3 <= 0) break;
                int n14 = n3;
                while (n14 > 0) {
                    if (this.seq - 1 == n7 || this.seq - n7 - n8 >= n11) {
                        while (this.seq - n7 - n8 >= n11) {
                            if (!this.checkStatus(this.ackid, (Header)object)) break;
                            int n15 = this.ackid[0];
                            if (n7 > n15 || n15 > this.seq - 1) {
                                if (n15 == this.seq) {
                                    System.err.println("ack error: startid=" + n7 + " seq=" + this.seq + " _ackid=" + n15);
                                } else {
                                    throw new SftpException(4, "ack error: startid=" + n7 + " seq=" + this.seq + " _ackid=" + n15);
                                }
                            }
                            ++n8;
                        }
                    }
                    n14 -= this.sendWRITE(byArray2, l3, byArray3, 0, n14);
                }
                l3 += (long)n3;
            } while (sftpProgressMonitor == null || sftpProgressMonitor.count(n3));
            n2 = this.seq - n7;
            while (n2 > n8) {
                if (!this.checkStatus(null, (Header)object)) break;
                ++n8;
            }
            if (sftpProgressMonitor != null) {
                sftpProgressMonitor.end();
            }
            this._sendCLOSE(byArray2, (Header)object);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, exception.toString(), exception);
            }
            throw new SftpException(4, exception.toString());
        }
    }

    public OutputStream put(String string) throws SftpException {
        return this.put(string, (SftpProgressMonitor)null, 0);
    }

    public OutputStream put(String string, int n) throws SftpException {
        return this.put(string, (SftpProgressMonitor)null, n);
    }

    public OutputStream put(String string, SftpProgressMonitor sftpProgressMonitor, int n) throws SftpException {
        return this.put(string, sftpProgressMonitor, n, 0L);
    }

    public OutputStream put(String string, final SftpProgressMonitor sftpProgressMonitor, int n, long l) throws SftpException {
        try {
            Object object;
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            string = this.isUnique(string);
            if (this.isRemoteDir(string)) {
                throw new SftpException(4, String.valueOf(string) + " is a directory");
            }
            byte[] byArray = Util.str2byte(string, this.fEncoding);
            long l2 = 0L;
            if (n == 1 || n == 2) {
                try {
                    object = this._stat(byArray);
                    l2 = ((SftpATTRS)object).getSize();
                }
                catch (Exception exception) {}
            }
            if (n == 0) {
                this.sendOPENW(byArray);
            } else {
                this.sendOPENA(byArray);
            }
            object = new Header();
            object = this.header(this.buf, (Header)object);
            int n2 = ((Header)object).length;
            int n3 = ((Header)object).type;
            this.fill(this.buf, n2);
            if (n3 != 101 && n3 != 102) {
                throw new SftpException(4, "");
            }
            if (n3 == 101) {
                int n4 = this.buf.getInt();
                this.throwStatusError(this.buf, n4);
            }
            final byte[] byArray2 = this.buf.getString();
            if (n == 1 || n == 2) {
                l += l2;
            }
            final long[] lArray = new long[]{l};
            OutputStream outputStream = new OutputStream(){
                private boolean init = true;
                private boolean isClosed = false;
                private int[] ackid = new int[1];
                private int startid = 0;
                private int _ackid = 0;
                private int ackcount = 0;
                private int writecount = 0;
                private Header header;
                byte[] _data;
                {
                    this.header = new Header();
                    this._data = new byte[1];
                }

                @Override
                public void write(byte[] byArray) throws IOException {
                    this.write(byArray, 0, byArray.length);
                }

                @Override
                public void write(byte[] byArray, int n, int n2) throws IOException {
                    if (this.init) {
                        this.startid = ChannelSftp.this.seq;
                        this._ackid = ChannelSftp.this.seq;
                        this.init = false;
                    }
                    if (this.isClosed) {
                        throw new IOException("stream already closed");
                    }
                    try {
                        int n3 = n2;
                        block3: while (n3 > 0) {
                            int n4 = ChannelSftp.this.sendWRITE(byArray2, lArray[0], byArray, n, n3);
                            ++this.writecount;
                            lArray[0] = lArray[0] + (long)n4;
                            n += n4;
                            n3 -= n4;
                            if (ChannelSftp.this.seq - 1 != this.startid && ChannelSftp.this.io_in.available() < 1024) continue;
                            while (ChannelSftp.this.io_in.available() > 0) {
                                if (!ChannelSftp.this.checkStatus(this.ackid, this.header)) continue block3;
                                this._ackid = this.ackid[0];
                                if (this.startid > this._ackid || this._ackid > ChannelSftp.this.seq - 1) {
                                    throw new SftpException(4, "");
                                }
                                ++this.ackcount;
                            }
                        }
                        if (sftpProgressMonitor != null && !sftpProgressMonitor.count(n2)) {
                            this.close();
                            throw new IOException("canceled");
                        }
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Exception exception) {
                        ChannelSftp.wrapToIOException("Write failed", exception);
                    }
                }

                @Override
                public void write(int n) throws IOException {
                    this._data[0] = (byte)n;
                    this.write(this._data, 0, 1);
                }

                @Override
                public void flush() throws IOException {
                    if (this.isClosed) {
                        throw new IOException("stream already closed");
                    }
                    if (!this.init) {
                        try {
                            while (this.writecount > this.ackcount) {
                                if (ChannelSftp.this.checkStatus(null, this.header)) {
                                    ++this.ackcount;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (SftpException sftpException) {
                            ChannelSftp.wrapToIOException(null, sftpException);
                        }
                    }
                }

                @Override
                public void close() throws IOException {
                    if (this.isClosed) {
                        return;
                    }
                    this.flush();
                    if (sftpProgressMonitor != null) {
                        sftpProgressMonitor.end();
                    }
                    try {
                        ChannelSftp.this._sendCLOSE(byArray2, this.header);
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Exception exception) {
                        ChannelSftp.wrapToIOException("Close failed", exception);
                    }
                    this.isClosed = true;
                }
            };
            return outputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void get(String string, String string2) throws SftpException {
        this.get(string, string2, null, 0);
    }

    public void get(String string, String string2, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        this.get(string, string2, sftpProgressMonitor, 0);
    }

    public void get(String string, String string2, SftpProgressMonitor sftpProgressMonitor, int n) throws SftpException {
        boolean bl = false;
        String string3 = null;
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            string2 = this.localAbsolutePath(string2);
            Vector vector = this.glob_remote(string);
            int n2 = vector.size();
            if (n2 == 0) {
                throw new SftpException(2, "No such file");
            }
            File file = new File(string2);
            boolean bl2 = file.isDirectory();
            StringBuffer stringBuffer = null;
            if (bl2) {
                if (!string2.endsWith(file_separator)) {
                    string2 = String.valueOf(string2) + file_separator;
                }
                stringBuffer = new StringBuffer(string2);
            } else if (n2 > 1) {
                throw new SftpException(4, "Copying multiple files, but destination is missing or a file.");
            }
            int n3 = 0;
            while (n3 < n2) {
                String string4 = (String)vector.elementAt(n3);
                SftpATTRS sftpATTRS = this._stat(string4);
                if (sftpATTRS.isDir()) {
                    throw new SftpException(4, "not supported to get directory " + string4);
                }
                string3 = null;
                if (bl2) {
                    int n4 = string4.lastIndexOf(47);
                    if (n4 == -1) {
                        stringBuffer.append(string4);
                    } else {
                        stringBuffer.append(string4.substring(n4 + 1));
                    }
                    string3 = stringBuffer.toString();
                    stringBuffer.delete(string2.length(), string3.length());
                } else {
                    string3 = string2;
                }
                File file2 = new File(string3);
                if (n == 1) {
                    long l = sftpATTRS.getSize();
                    long l2 = file2.length();
                    if (l2 > l) {
                        throw new SftpException(4, "failed to resume for " + string3);
                    }
                    if (l2 == l) {
                        return;
                    }
                }
                if (sftpProgressMonitor != null) {
                    sftpProgressMonitor.init(1, string4, string3, sftpATTRS.getSize());
                    if (n == 1) {
                        sftpProgressMonitor.count(file2.length());
                    }
                }
                bl = file2.exists();
                try (FileOutputStream fileOutputStream = null;){
                    fileOutputStream = n == 0 ? new FileOutputStream(string3) : new FileOutputStream(string3, true);
                    this._get(string4, fileOutputStream, sftpProgressMonitor, n, new File(string3).length());
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            File file;
            if (!bl && string3 != null && (file = new File(string3)).exists() && file.length() == 0L) {
                file.delete();
            }
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void get(String string, OutputStream outputStream) throws SftpException {
        this.get(string, outputStream, null, 0, 0L);
    }

    public void get(String string, OutputStream outputStream, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        this.get(string, outputStream, sftpProgressMonitor, 0, 0L);
    }

    public void get(String string, OutputStream outputStream, SftpProgressMonitor sftpProgressMonitor, int n, long l) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            string = this.isUnique(string);
            if (sftpProgressMonitor != null) {
                SftpATTRS sftpATTRS = this._stat(string);
                sftpProgressMonitor.init(1, string, "??", sftpATTRS.getSize());
                if (n == 1) {
                    sftpProgressMonitor.count(l);
                }
            }
            this._get(string, outputStream, sftpProgressMonitor, n, l);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private void _get(String string, OutputStream outputStream, SftpProgressMonitor sftpProgressMonitor, int n, long l) throws SftpException {
        byte[] byArray = Util.str2byte(string, this.fEncoding);
        try {
            this.sendOPENR(byArray);
            Header header = new Header();
            header = this.header(this.buf, header);
            int n2 = header.length;
            int n3 = header.type;
            this.fill(this.buf, n2);
            if (n3 != 101 && n3 != 102) {
                throw new SftpException(4, "");
            }
            if (n3 == 101) {
                int n4 = this.buf.getInt();
                this.throwStatusError(this.buf, n4);
            }
            byte[] byArray2 = this.buf.getString();
            long l2 = 0L;
            if (n == 1) {
                l2 += l;
            }
            int n5 = 1;
            this.rq.init();
            long l3 = l2;
            int n6 = this.buf.buffer.length - 13;
            if (this.server_version == 0) {
                n6 = 1024;
            }
            block4: while (true) {
                int n7;
                int n8 = 0;
                while (this.rq.count() < n5) {
                    this.sendREAD(byArray2, l3, n6, this.rq);
                    l3 += (long)n6;
                    if (!TRACE_QUEUE || ++n8 <= 1) continue;
                    LOG.log(1, "Sent more than 1:  " + n8);
                }
                header = this.header(this.buf, header);
                n2 = header.length;
                n3 = header.type;
                RequestQueue.Request request = null;
                try {
                    request = this.rq.get(header.rid);
                }
                catch (RequestQueue.OutOfOrderException outOfOrderException) {
                    l3 = outOfOrderException.offset;
                    this.skip(header.length);
                    this.rq.cancel(header, this.buf);
                    continue;
                }
                if (n3 == 101) {
                    this.fill(this.buf, n2);
                    int n9 = this.buf.getInt();
                    if (n9 == 1) break;
                    this.throwStatusError(this.buf, n9);
                }
                if (n3 != 103) break;
                this.buf.rewind();
                this.fill(this.buf.buffer, 0, 4);
                int n10 = this.buf.getInt();
                int n11 = (n2 -= 4) - n10;
                for (int i = n10; i > 0; i -= n7) {
                    int n12 = i;
                    if (n12 > this.buf.buffer.length) {
                        n12 = this.buf.buffer.length;
                    }
                    if ((n7 = this.io_in.read(this.buf.buffer, 0, n12)) < 0) break block4;
                    outputStream.write(this.buf.buffer, 0, n7);
                    l2 += (long)n7;
                    if (sftpProgressMonitor == null || sftpProgressMonitor.count(n7)) continue;
                    this.skip(i);
                    if (n11 <= 0) break block4;
                    this.skip(n11);
                    break block4;
                }
                if (n11 > 0) {
                    this.skip(n11);
                }
                if ((long)n10 < request.length) {
                    this.rq.cancel(header, this.buf);
                    this.sendREAD(byArray2, request.offset + (long)n10, (int)(request.length - (long)n10), this.rq);
                    l3 = request.offset + request.length;
                }
                if (n5 >= this.rq.size()) continue;
                if (TRACE_QUEUE) {
                    LOG.log(1, this + " Increase Max Req " + this.rq.size() + " max=" + n5);
                }
                ++n5;
            }
            outputStream.flush();
            if (sftpProgressMonitor != null) {
                sftpProgressMonitor.end();
            }
            this.rq.cancel(header, this.buf);
            this._sendCLOSE(byArray2, header);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public InputStream get(String string) throws SftpException {
        return this.get(string, null, 0L);
    }

    public InputStream get(String string, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        return this.get(string, sftpProgressMonitor, 0L);
    }

    public InputStream get(String string, int n) throws SftpException {
        return this.get(string, null, 0L);
    }

    public InputStream get(String string, SftpProgressMonitor sftpProgressMonitor, int n) throws SftpException {
        return this.get(string, sftpProgressMonitor, 0L);
    }

    public InputStream get(String string, final SftpProgressMonitor sftpProgressMonitor, long l) throws SftpException {
        try {
            Object object;
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            string = this.isUnique(string);
            byte[] byArray = Util.str2byte(string, this.fEncoding);
            if (sftpProgressMonitor != null) {
                object = this._stat(byArray);
                sftpProgressMonitor.init(1, string, "??", ((SftpATTRS)object).getSize());
            }
            this.sendOPENR(byArray);
            object = new Header();
            object = this.header(this.buf, (Header)object);
            int n = ((Header)object).length;
            int n2 = ((Header)object).type;
            this.fill(this.buf, n);
            if (n2 != 101 && n2 != 102) {
                throw new SftpException(4, "");
            }
            if (n2 == 101) {
                int n3 = this.buf.getInt();
                this.throwStatusError(this.buf, n3);
            }
            final byte[] byArray2 = this.buf.getString();
            this.rq.init();
            InputStream inputStream = new InputStream(l){
                long offset;
                boolean closed;
                int rest_length;
                byte[] _data;
                byte[] rest_byte;
                Header header;
                int request_max;
                long request_offset;
                {
                    this.offset = l;
                    this.closed = false;
                    this.rest_length = 0;
                    this._data = new byte[1];
                    this.rest_byte = new byte[1024];
                    this.header = new Header();
                    this.request_max = 1;
                    this.request_offset = this.offset;
                }

                @Override
                public int read() throws IOException {
                    if (this.closed) {
                        return -1;
                    }
                    int n = this.read(this._data, 0, 1);
                    if (n == -1) {
                        return -1;
                    }
                    return this._data[0] & 0xFF;
                }

                @Override
                public int read(byte[] byArray) throws IOException {
                    if (this.closed) {
                        return -1;
                    }
                    return this.read(byArray, 0, byArray.length);
                }

                @Override
                public int read(byte[] byArray, int n, int n2) throws IOException {
                    int n3;
                    if (this.closed) {
                        return -1;
                    }
                    if (byArray == null) {
                        throw new NullPointerException();
                    }
                    if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (n2 == 0) {
                        return 0;
                    }
                    if (this.rest_length > 0) {
                        int n4 = this.rest_length;
                        if (n4 > n2) {
                            n4 = n2;
                        }
                        System.arraycopy(this.rest_byte, 0, byArray, n, n4);
                        if (n4 != this.rest_length) {
                            System.arraycopy(this.rest_byte, n4, this.rest_byte, 0, this.rest_length - n4);
                        }
                        if (sftpProgressMonitor != null && !sftpProgressMonitor.count(n4)) {
                            this.close();
                            return -1;
                        }
                        this.rest_length -= n4;
                        if (TRACE_STREAM) {
                            LOG.log(1, "Copy " + n4 + " from " + this);
                        }
                        return n4;
                    }
                    if (((ChannelSftp)ChannelSftp.this).buf.buffer.length - 13 < n2) {
                        n2 = ((ChannelSftp)ChannelSftp.this).buf.buffer.length - 13;
                    }
                    if (ChannelSftp.this.server_version == 0 && n2 > 1024) {
                        n2 = 1024;
                    }
                    if (ChannelSftp.this.rq.count() == 0) {
                        n3 = ((ChannelSftp)ChannelSftp.this).buf.buffer.length - 13;
                        if (ChannelSftp.this.server_version == 0) {
                            n3 = 1024;
                        }
                        int n5 = 0;
                        while (ChannelSftp.this.rq.count() < this.request_max) {
                            try {
                                ChannelSftp.this.sendREAD(byArray2, this.request_offset, n3, ChannelSftp.this.rq);
                                if (TRACE_QUEUE && ++n5 > 1) {
                                    LOG.log(1, "Sent more than 1:  " + n5);
                                }
                            }
                            catch (Exception exception) {
                                ChannelSftp.wrapToIOException("Error send read", exception);
                            }
                            this.request_offset += (long)n3;
                        }
                    }
                    this.header = ChannelSftp.this.header(ChannelSftp.this.buf, this.header);
                    this.rest_length = this.header.length;
                    n3 = this.header.type;
                    int cfr_ignored_0 = this.header.rid;
                    RequestQueue.Request request = null;
                    try {
                        request = ChannelSftp.this.rq.get(this.header.rid);
                    }
                    catch (RequestQueue.OutOfOrderException outOfOrderException) {
                        this.request_offset = outOfOrderException.offset;
                        this.skip(this.header.length);
                        ChannelSftp.this.rq.cancel(this.header, ChannelSftp.this.buf);
                        return 0;
                    }
                    catch (SftpException sftpException) {
                        throw new IOException("error: " + sftpException.toString(), sftpException);
                    }
                    if (n3 != 101 && n3 != 103) {
                        throw new IOException("Invalid header type " + n3);
                    }
                    if (n3 == 101) {
                        ChannelSftp.this.fill(ChannelSftp.this.buf, this.rest_length);
                        int n6 = ChannelSftp.this.buf.getInt();
                        this.rest_length = 0;
                        if (n6 == 1) {
                            this.close();
                            return -1;
                        }
                        throw new IOException("error");
                    }
                    ChannelSftp.this.buf.rewind();
                    ChannelSftp.this.fill(((ChannelSftp)ChannelSftp.this).buf.buffer, 0, 4);
                    int n7 = ChannelSftp.this.buf.getInt();
                    this.rest_length -= 4;
                    int n8 = this.rest_length - n7;
                    this.offset += (long)n7;
                    int n9 = n7;
                    if (n9 > 0) {
                        int n10;
                        int n11 = n9;
                        if (n11 > n2) {
                            n11 = n2;
                        }
                        if ((n10 = ChannelSftp.this.io_in.read(byArray, n, n11)) < 0) {
                            return -1;
                        }
                        this.rest_length = n9 -= n10;
                        if (n9 > 0) {
                            if (this.rest_byte.length < n9) {
                                this.rest_byte = new byte[n9];
                            }
                            int n12 = 0;
                            int n13 = n9;
                            while (n13 > 0) {
                                int n14 = ChannelSftp.this.io_in.read(this.rest_byte, n12, n13);
                                if (n14 <= 0) break;
                                n12 += n14;
                                n13 -= n14;
                            }
                        }
                        if (n8 > 0) {
                            ChannelSftp.this.io_in.skip(n8);
                        }
                        if ((long)n7 < request.length) {
                            ChannelSftp.this.rq.cancel(this.header, ChannelSftp.this.buf);
                            try {
                                ChannelSftp.this.sendREAD(byArray2, request.offset + (long)n7, (int)(request.length - (long)n7), ChannelSftp.this.rq);
                            }
                            catch (Exception exception) {
                                ChannelSftp.wrapToIOException("Error send read", exception);
                            }
                            this.request_offset = request.offset + request.length;
                        }
                        if (this.request_max < ChannelSftp.this.rq.size()) {
                            if (TRACE_QUEUE) {
                                LOG.log(1, this + " Increase Max Req " + ChannelSftp.this.rq.size() + " max=" + this.request_max);
                            }
                            ++this.request_max;
                        }
                        if (sftpProgressMonitor != null && !sftpProgressMonitor.count(n10)) {
                            this.close();
                            return -1;
                        }
                        if (TRACE_STREAM) {
                            LOG.log(1, "Read " + n10 + " from " + this);
                        }
                        return n10;
                    }
                    return 0;
                }

                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    if (TRACE_STREAM) {
                        LOG.log(1, "Close stream " + this);
                    }
                    if (sftpProgressMonitor != null) {
                        sftpProgressMonitor.end();
                    }
                    ChannelSftp.this.rq.cancel(this.header, ChannelSftp.this.buf);
                    try {
                        ChannelSftp.this._sendCLOSE(byArray2, this.header);
                    }
                    catch (Exception exception) {
                        ChannelSftp.wrapToIOException("Close failed", exception);
                    }
                }

                public String toString() {
                    return ChannelSftp.this + " IS @" + System.identityHashCode(this);
                }
            };
            if (TRACE_STREAM) {
                LOG.log(1, "Create stream " + inputStream);
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public Vector ls(String string) throws SftpException {
        final Vector vector = new Vector();
        LsEntrySelector lsEntrySelector = new LsEntrySelector(){

            @Override
            public int select(LsEntry lsEntry) {
                vector.addElement(lsEntry);
                return 0;
            }
        };
        this.ls(string, lsEntrySelector);
        return vector;
    }

    private static final void wrapToIOException(String string, Throwable throwable) throws IOException {
        throw new IOException(string, throwable);
    }

    public void ls(String string, LsEntrySelector lsEntrySelector) throws SftpException {
        try {
            int n;
            Object object;
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            byte[] byArray = null;
            new Vector();
            int n2 = string.lastIndexOf(47);
            String string2 = string.substring(0, n2 == 0 ? 1 : n2);
            String string3 = string.substring(n2 + 1);
            string2 = Util.unquote(string2);
            byte[][] byArrayArray = new byte[1][];
            boolean bl = this.isPattern(string3, byArrayArray);
            if (bl) {
                byArray = byArrayArray[0];
            } else {
                object = Util.unquote(string);
                SftpATTRS sftpATTRS = this._stat((String)object);
                if (sftpATTRS.isDir()) {
                    byArray = null;
                    string2 = object;
                } else if (this.fEncoding_is_utf8) {
                    byArray = byArrayArray[0];
                    byArray = Util.unquote(byArray);
                } else {
                    string3 = Util.unquote(string3);
                    byArray = Util.str2byte(string3, this.fEncoding);
                }
            }
            this.sendOPENDIR(Util.str2byte(string2, this.fEncoding));
            object = new Header();
            object = this.header(this.buf, (Header)object);
            int n3 = ((Header)object).length;
            int n4 = ((Header)object).type;
            this.fill(this.buf, n3);
            if (n4 != 101 && n4 != 102) {
                throw new SftpException(4, "");
            }
            if (n4 == 101) {
                n = this.buf.getInt();
                this.throwStatusError(this.buf, n);
            }
            n = 0;
            byte[] byArray2 = this.buf.getString();
            while (n == 0) {
                int n5;
                this.sendREADDIR(byArray2);
                object = this.header(this.buf, (Header)object);
                n3 = ((Header)object).length;
                n4 = ((Header)object).type;
                if (n4 != 101 && n4 != 104) {
                    throw new SftpException(4, "");
                }
                if (n4 == 101) {
                    this.fill(this.buf, n3);
                    n5 = this.buf.getInt();
                    if (n5 == 1) break;
                    this.throwStatusError(this.buf, n5);
                }
                this.buf.rewind();
                this.fill(this.buf.buffer, 0, 4);
                n3 -= 4;
                n5 = this.buf.getInt();
                this.buf.reset();
                while (n5 > 0) {
                    Object object2;
                    if (n3 > 0) {
                        this.buf.shift();
                        int n6 = this.buf.buffer.length > this.buf.index + n3 ? n3 : this.buf.buffer.length - this.buf.index;
                        int n7 = this.fill(this.buf.buffer, this.buf.index, n6);
                        this.buf.index += n7;
                        n3 -= n7;
                    }
                    byte[] byArray3 = this.buf.getString();
                    byte[] byArray4 = null;
                    if (this.server_version <= 3) {
                        byArray4 = this.buf.getString();
                    }
                    SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
                    if (n == 1) {
                        --n5;
                        continue;
                    }
                    boolean bl2 = false;
                    String string4 = null;
                    if (byArray == null) {
                        bl2 = true;
                    } else if (!bl) {
                        bl2 = Util.array_equals(byArray, byArray3);
                    } else {
                        object2 = byArray3;
                        if (!this.fEncoding_is_utf8) {
                            string4 = Util.byte2str((byte[])object2, this.fEncoding);
                            object2 = Util.str2byte(string4, UTF8);
                        }
                        bl2 = Util.glob(byArray, (byte[])object2);
                    }
                    if (bl2) {
                        if (string4 == null) {
                            string4 = Util.byte2str(byArray3, this.fEncoding);
                        }
                        object2 = null;
                        object2 = byArray4 == null ? (Object)(String.valueOf(sftpATTRS.toString()) + " " + string4) : (Object)Util.byte2str(byArray4, this.fEncoding);
                        n = lsEntrySelector.select(new LsEntry(string4, (String)object2, sftpATTRS));
                    }
                    --n5;
                }
            }
            this._sendCLOSE(byArray2, (Header)object);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public String readlink(String string) throws SftpException {
        try {
            if (this.server_version < 3) {
                throw new SftpException(8, "The remote sshd is too old to support symlink operation.");
            }
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            string = this.isUnique(string);
            this.sendREADLINK(Util.str2byte(string, this.fEncoding));
            Header header = new Header();
            header = this.header(this.buf, header);
            int n = header.length;
            int n2 = header.type;
            this.fill(this.buf, n);
            if (n2 != 101 && n2 != 104) {
                throw new SftpException(4, "");
            }
            if (n2 == 104) {
                int n3 = this.buf.getInt();
                byte[] byArray = null;
                int n4 = 0;
                while (n4 < n3) {
                    byArray = this.buf.getString();
                    if (this.server_version <= 3) {
                        this.buf.getString();
                    }
                    SftpATTRS.getATTR(this.buf);
                    ++n4;
                }
                return Util.byte2str(byArray, this.fEncoding);
            }
            int n5 = this.buf.getInt();
            this.throwStatusError(this.buf, n5);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
        return null;
    }

    public void symlink(String string, String string2) throws SftpException {
        if (this.server_version < 3) {
            throw new SftpException(8, "The remote sshd is too old to support symlink operation.");
        }
        try {
            Object object;
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            String string3 = this.remoteAbsolutePath(string);
            string2 = this.remoteAbsolutePath(string2);
            string3 = this.isUnique(string3);
            if (string.charAt(0) != '/') {
                object = this.getCwd();
                string = string3.substring(((String)object).length() + (((String)object).endsWith("/") ? 0 : 1));
            } else {
                string = string3;
            }
            if (this.isPattern(string2)) {
                throw new SftpException(4, string2);
            }
            string2 = Util.unquote(string2);
            this.sendSYMLINK(Util.str2byte(string, this.fEncoding), Util.str2byte(string2, this.fEncoding));
            object = new Header();
            object = this.header(this.buf, (Header)object);
            int n = ((Header)object).length;
            int n2 = ((Header)object).type;
            this.fill(this.buf, n);
            if (n2 != 101) {
                throw new SftpException(4, "");
            }
            int n3 = this.buf.getInt();
            if (n3 == 0) {
                return;
            }
            this.throwStatusError(this.buf, n3);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void hardlink(String string, String string2) throws SftpException {
        if (!this.extension_hardlink) {
            throw new SftpException(8, "hardlink@openssh.com is not supported");
        }
        try {
            Object object;
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            String string3 = this.remoteAbsolutePath(string);
            string2 = this.remoteAbsolutePath(string2);
            string3 = this.isUnique(string3);
            if (string.charAt(0) != '/') {
                object = this.getCwd();
                string = string3.substring(((String)object).length() + (((String)object).endsWith("/") ? 0 : 1));
            } else {
                string = string3;
            }
            if (this.isPattern(string2)) {
                throw new SftpException(4, string2);
            }
            string2 = Util.unquote(string2);
            this.sendHARDLINK(Util.str2byte(string, this.fEncoding), Util.str2byte(string2, this.fEncoding));
            object = new Header();
            object = this.header(this.buf, (Header)object);
            int n = ((Header)object).length;
            int n2 = ((Header)object).type;
            this.fill(this.buf, n);
            if (n2 != 101) {
                throw new SftpException(4, "");
            }
            int n3 = this.buf.getInt();
            if (n3 == 0) {
                return;
            }
            this.throwStatusError(this.buf, n3);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void rename(String string, String string2) throws SftpException {
        if (this.server_version < 2) {
            throw new SftpException(8, "The remote sshd is too old to support rename operation.");
        }
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            string2 = this.remoteAbsolutePath(string2);
            string = this.isUnique(string);
            Vector vector = this.glob_remote(string2);
            int n = vector.size();
            if (n >= 2) {
                throw new SftpException(4, vector.toString());
            }
            if (n == 1) {
                string2 = (String)vector.elementAt(0);
            } else {
                if (this.isPattern(string2)) {
                    throw new SftpException(4, string2);
                }
                string2 = Util.unquote(string2);
            }
            this.sendRENAME(Util.str2byte(string, this.fEncoding), Util.str2byte(string2, this.fEncoding));
            Header header = new Header();
            header = this.header(this.buf, header);
            int n2 = header.length;
            int n3 = header.type;
            this.fill(this.buf, n2);
            if (n3 != 101) {
                throw new SftpException(4, "");
            }
            int n4 = this.buf.getInt();
            if (n4 == 0) {
                return;
            }
            this.throwStatusError(this.buf, n4);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void rm(String string) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n = vector.size();
            Header header = new Header();
            int n2 = 0;
            while (n2 < n) {
                string = (String)vector.elementAt(n2);
                this.sendREMOVE(Util.str2byte(string, this.fEncoding));
                header = this.header(this.buf, header);
                int n3 = header.length;
                int n4 = header.type;
                this.fill(this.buf, n3);
                if (n4 != 101) {
                    throw new SftpException(4, "");
                }
                int n5 = this.buf.getInt();
                if (n5 != 0) {
                    this.throwStatusError(this.buf, n5);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private boolean isRemoteDir(String string) {
        block3: {
            try {
                this.sendSTAT(Util.str2byte(string, this.fEncoding));
                Header header = new Header();
                header = this.header(this.buf, header);
                int n = header.length;
                int n2 = header.type;
                this.fill(this.buf, n);
                if (n2 == 105) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
        return sftpATTRS.isDir();
    }

    public void chgrp(int n, String string) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                string = (String)vector.elementAt(n3);
                SftpATTRS sftpATTRS = this._stat(string);
                sftpATTRS.setFLAGS(0);
                sftpATTRS.setUIDGID(sftpATTRS.uid, n);
                this._setStat(string, sftpATTRS);
                ++n3;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void chown(int n, String string) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                string = (String)vector.elementAt(n3);
                SftpATTRS sftpATTRS = this._stat(string);
                sftpATTRS.setFLAGS(0);
                sftpATTRS.setUIDGID(n, sftpATTRS.gid);
                this._setStat(string, sftpATTRS);
                ++n3;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void chmod(int n, String string) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                string = (String)vector.elementAt(n3);
                SftpATTRS sftpATTRS = this._stat(string);
                sftpATTRS.setFLAGS(0);
                sftpATTRS.setPERMISSIONS(n);
                this._setStat(string, sftpATTRS);
                ++n3;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void setMtime(String string, int n) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                string = (String)vector.elementAt(n3);
                SftpATTRS sftpATTRS = this._stat(string);
                sftpATTRS.setFLAGS(0);
                sftpATTRS.setACMODTIME(sftpATTRS.getATime(), n);
                this._setStat(string, sftpATTRS);
                ++n3;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void rmdir(String string) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n = vector.size();
            Header header = new Header();
            int n2 = 0;
            while (n2 < n) {
                string = (String)vector.elementAt(n2);
                this.sendRMDIR(Util.str2byte(string, this.fEncoding));
                header = this.header(this.buf, header);
                int n3 = header.length;
                int n4 = header.type;
                this.fill(this.buf, n3);
                if (n4 != 101) {
                    throw new SftpException(4, "");
                }
                int n5 = this.buf.getInt();
                if (n5 != 0) {
                    this.throwStatusError(this.buf, n5);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void mkdir(String string) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            this.sendMKDIR(Util.str2byte(string, this.fEncoding), null);
            Header header = new Header();
            header = this.header(this.buf, header);
            int n = header.length;
            int n2 = header.type;
            this.fill(this.buf, n);
            if (n2 != 101) {
                throw new SftpException(4, "");
            }
            int n3 = this.buf.getInt();
            if (n3 == 0) {
                return;
            }
            this.throwStatusError(this.buf, n3);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public SftpATTRS stat(String string) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            string = this.isUnique(string);
            return this._stat(string);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private SftpATTRS _stat(byte[] byArray) throws SftpException {
        try {
            this.sendSTAT(byArray);
            Header header = new Header();
            header = this.header(this.buf, header);
            int n = header.length;
            int n2 = header.type;
            this.fill(this.buf, n);
            if (n2 != 105) {
                if (n2 == 101) {
                    int n3 = this.buf.getInt();
                    this.throwStatusError(this.buf, n3);
                }
                throw new SftpException(4, "");
            }
            SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
            return sftpATTRS;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private SftpATTRS _stat(String string) throws SftpException {
        return this._stat(Util.str2byte(string, this.fEncoding));
    }

    public SftpStatVFS statVFS(String string) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            string = this.isUnique(string);
            return this._statVFS(string);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private SftpStatVFS _statVFS(byte[] byArray) throws SftpException {
        if (!this.extension_statvfs) {
            throw new SftpException(8, "statvfs@openssh.com is not supported");
        }
        try {
            this.sendSTATVFS(byArray);
            Header header = new Header();
            header = this.header(this.buf, header);
            int n = header.length;
            int n2 = header.type;
            this.fill(this.buf, n);
            if (n2 != 201) {
                if (n2 == 101) {
                    int n3 = this.buf.getInt();
                    this.throwStatusError(this.buf, n3);
                }
                throw new SftpException(4, "");
            }
            SftpStatVFS sftpStatVFS = SftpStatVFS.getStatVFS(this.buf);
            return sftpStatVFS;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private SftpStatVFS _statVFS(String string) throws SftpException {
        return this._statVFS(Util.str2byte(string, this.fEncoding));
    }

    public SftpATTRS lstat(String string) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            string = this.isUnique(string);
            return this._lstat(string);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private SftpATTRS _lstat(String string) throws SftpException {
        try {
            this.sendLSTAT(Util.str2byte(string, this.fEncoding));
            Header header = new Header();
            header = this.header(this.buf, header);
            int n = header.length;
            int n2 = header.type;
            this.fill(this.buf, n);
            if (n2 != 105) {
                if (n2 == 101) {
                    int n3 = this.buf.getInt();
                    this.throwStatusError(this.buf, n3);
                }
                throw new SftpException(4, "");
            }
            SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
            return sftpATTRS;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private byte[] _realpath(String string) throws SftpException, IOException, Exception {
        int n;
        this.sendREALPATH(Util.str2byte(string, this.fEncoding));
        Header header = new Header();
        header = this.header(this.buf, header);
        int n2 = header.length;
        int n3 = header.type;
        this.fill(this.buf, n2);
        if (n3 != 101 && n3 != 104) {
            throw new SftpException(4, "");
        }
        if (n3 == 101) {
            n = this.buf.getInt();
            this.throwStatusError(this.buf, n);
        }
        n = this.buf.getInt();
        byte[] byArray = null;
        while (n-- > 0) {
            byArray = this.buf.getString();
            if (this.server_version <= 3) {
                this.buf.getString();
            }
            SftpATTRS.getATTR(this.buf);
        }
        return byArray;
    }

    public void setStat(String string, SftpATTRS sftpATTRS) throws SftpException {
        try {
            ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                string = (String)vector.elementAt(n2);
                this._setStat(string, sftpATTRS);
                ++n2;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private void _setStat(String string, SftpATTRS sftpATTRS) throws SftpException {
        try {
            this.sendSETSTAT(Util.str2byte(string, this.fEncoding), sftpATTRS);
            Header header = new Header();
            header = this.header(this.buf, header);
            int n = header.length;
            int n2 = header.type;
            this.fill(this.buf, n);
            if (n2 != 101) {
                throw new SftpException(4, "");
            }
            int n3 = this.buf.getInt();
            if (n3 != 0) {
                this.throwStatusError(this.buf, n3);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public String pwd() throws SftpException {
        return this.getCwd();
    }

    public String lpwd() {
        return this.lcwd;
    }

    public String version() {
        return this.version;
    }

    public String getHome() throws SftpException {
        if (this.home == null) {
            try {
                ((Channel.MyPipedInputStream)((Object)this.io_in)).updateReadSide();
                byte[] byArray = this._realpath("");
                this.home = Util.byte2str(byArray, this.fEncoding);
            }
            catch (Exception exception) {
                if (exception instanceof SftpException) {
                    throw (SftpException)exception;
                }
                if (exception instanceof Throwable) {
                    throw new SftpException(4, "", exception);
                }
                throw new SftpException(4, "");
            }
        }
        return this.home;
    }

    private String getCwd() throws SftpException {
        if (this.cwd == null) {
            this.cwd = this.getHome();
        }
        return this.cwd;
    }

    private void setCwd(String string) {
        this.cwd = string;
    }

    private void read(byte[] byArray, int n, int n2) throws IOException, SftpException {
        int n3 = 0;
        while (n2 > 0) {
            n3 = this.io_in.read(byArray, n, n2);
            if (n3 <= 0) {
                throw new SftpException(4, "");
            }
            n += n3;
            n2 -= n3;
        }
    }

    private boolean checkStatus(int[] nArray, Header header) throws IOException, SftpException {
        header = this.header(this.buf, header);
        int n = header.length;
        int n2 = header.type;
        if (nArray != null) {
            nArray[0] = header.rid;
        }
        this.fill(this.buf, n);
        if (n2 != 101) {
            throw new SftpException(4, "");
        }
        int n3 = this.buf.getInt();
        if (n3 != 0) {
            this.throwStatusError(this.buf, n3);
        }
        return true;
    }

    private boolean _sendCLOSE(byte[] byArray, Header header) throws Exception {
        this.sendCLOSE(byArray);
        return this.checkStatus(null, header);
    }

    private void sendINIT() throws Exception {
        this.packet.reset();
        this.putHEAD((byte)1, 5);
        this.buf.putInt(3);
        this.getSession().write(this.packet, this, 9);
    }

    private void sendREALPATH(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)16, byArray);
    }

    private void sendSTAT(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)17, byArray);
    }

    private void sendSTATVFS(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)0, byArray, "statvfs@openssh.com");
    }

    private void sendLSTAT(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)7, byArray);
    }

    private void sendFSTAT(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)8, byArray);
    }

    private void sendSETSTAT(byte[] byArray, SftpATTRS sftpATTRS) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)9, 9 + byArray.length + sftpATTRS.length());
        this.buf.putInt(this.seq++);
        this.buf.putString(byArray);
        sftpATTRS.dump(this.buf);
        this.getSession().write(this.packet, this, 9 + byArray.length + sftpATTRS.length() + 4);
    }

    private void sendREMOVE(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)13, byArray);
    }

    private void sendMKDIR(byte[] byArray, SftpATTRS sftpATTRS) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)14, 9 + byArray.length + (sftpATTRS != null ? sftpATTRS.length() : 4));
        this.buf.putInt(this.seq++);
        this.buf.putString(byArray);
        if (sftpATTRS != null) {
            sftpATTRS.dump(this.buf);
        } else {
            this.buf.putInt(0);
        }
        this.getSession().write(this.packet, this, 9 + byArray.length + (sftpATTRS != null ? sftpATTRS.length() : 4) + 4);
    }

    private void sendRMDIR(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)15, byArray);
    }

    private void sendSYMLINK(byte[] byArray, byte[] byArray2) throws Exception {
        this.sendPacketPath((byte)20, byArray, byArray2);
    }

    private void sendHARDLINK(byte[] byArray, byte[] byArray2) throws Exception {
        this.sendPacketPath((byte)0, byArray, byArray2, "hardlink@openssh.com");
    }

    private void sendREADLINK(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)19, byArray);
    }

    private void sendOPENDIR(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)11, byArray);
    }

    private void sendREADDIR(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)12, byArray);
    }

    private void sendRENAME(byte[] byArray, byte[] byArray2) throws Exception {
        this.sendPacketPath((byte)18, byArray, byArray2, this.extension_posix_rename ? "posix-rename@openssh.com" : null);
    }

    private void sendCLOSE(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)4, byArray);
    }

    private void sendOPENR(byte[] byArray) throws Exception {
        this.sendOPEN(byArray, 1);
    }

    private void sendOPENW(byte[] byArray) throws Exception {
        this.sendOPEN(byArray, 26);
    }

    private void sendOPENA(byte[] byArray) throws Exception {
        this.sendOPEN(byArray, 10);
    }

    private void sendOPEN(byte[] byArray, int n) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)3, 17 + byArray.length);
        this.buf.putInt(this.seq++);
        this.buf.putString(byArray);
        this.buf.putInt(n);
        this.buf.putInt(0);
        this.getSession().write(this.packet, this, 17 + byArray.length + 4);
    }

    private void sendPacketPath(byte by, byte[] byArray) throws Exception {
        this.sendPacketPath(by, byArray, (String)null);
    }

    private void sendPacketPath(byte by, byte[] byArray, String string) throws Exception {
        this.packet.reset();
        int n = 9 + byArray.length;
        if (string == null) {
            this.putHEAD(by, n);
            this.buf.putInt(this.seq++);
        } else {
            this.putHEAD((byte)-56, n += 4 + string.length());
            this.buf.putInt(this.seq++);
            this.buf.putString(Util.str2byte(string));
        }
        this.buf.putString(byArray);
        this.getSession().write(this.packet, this, n + 4);
    }

    private void sendPacketPath(byte by, byte[] byArray, byte[] byArray2) throws Exception {
        this.sendPacketPath(by, byArray, byArray2, null);
    }

    private void sendPacketPath(byte by, byte[] byArray, byte[] byArray2, String string) throws Exception {
        this.packet.reset();
        int n = 13 + byArray.length + byArray2.length;
        if (string == null) {
            this.putHEAD(by, n);
            this.buf.putInt(this.seq++);
        } else {
            this.putHEAD((byte)-56, n += 4 + string.length());
            this.buf.putInt(this.seq++);
            this.buf.putString(Util.str2byte(string));
        }
        this.buf.putString(byArray);
        this.buf.putString(byArray2);
        this.getSession().write(this.packet, this, n + 4);
    }

    private int sendWRITE(byte[] byArray, long l, byte[] byArray2, int n, int n2) throws Exception {
        int n3 = n2;
        this.opacket.reset();
        if (this.obuf.buffer.length < this.obuf.index + 13 + 21 + byArray.length + n2 + 84) {
            n3 = this.obuf.buffer.length - (this.obuf.index + 13 + 21 + byArray.length + 84);
        }
        this.putHEAD(this.obuf, (byte)6, 21 + byArray.length + n3);
        this.obuf.putInt(this.seq++);
        this.obuf.putString(byArray);
        this.obuf.putLong(l);
        if (this.obuf.buffer != byArray2) {
            this.obuf.putString(byArray2, n, n3);
        } else {
            this.obuf.putInt(n3);
            this.obuf.skip(n3);
        }
        this.getSession().write(this.opacket, this, 21 + byArray.length + n3 + 4);
        return n3;
    }

    private void sendREAD(byte[] byArray, long l, int n) throws Exception {
        this.sendREAD(byArray, l, n, null);
    }

    private void sendREAD(byte[] byArray, long l, int n, RequestQueue requestQueue) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)5, 21 + byArray.length);
        this.buf.putInt(this.seq++);
        this.buf.putString(byArray);
        this.buf.putLong(l);
        this.buf.putInt(n);
        this.getSession().write(this.packet, this, 21 + byArray.length + 4);
        if (requestQueue != null) {
            requestQueue.add(this.seq - 1, l, n);
        }
    }

    private void putHEAD(Buffer buffer, byte by, int n) throws Exception {
        buffer.putByte((byte)94);
        buffer.putInt(this.recipient);
        buffer.putInt(n + 4);
        buffer.putInt(n);
        buffer.putByte(by);
    }

    private void putHEAD(byte by, int n) throws Exception {
        this.putHEAD(this.buf, by, n);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private Vector glob_remote(String string) throws Exception {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.lastIndexOf(47);
        if (n2 < 0) {
            vector.addElement(Util.unquote(string));
            return vector;
        }
        String string2 = string.substring(0, n2 == 0 ? 1 : n2);
        String string3 = string.substring(n2 + 1);
        string2 = Util.unquote(string2);
        byte[] byArray = null;
        byte[][] byArrayArray = new byte[1][];
        boolean bl = this.isPattern(string3, byArrayArray);
        if (!bl) {
            if (!string2.equals("/")) {
                string2 = String.valueOf(string2) + "/";
            }
            vector.addElement(String.valueOf(string2) + Util.unquote(string3));
            return vector;
        }
        byArray = byArrayArray[0];
        this.sendOPENDIR(Util.str2byte(string2, this.fEncoding));
        Header header = new Header();
        header = this.header(this.buf, header);
        int n3 = header.length;
        int n4 = header.type;
        this.fill(this.buf, n3);
        if (n4 != 101 && n4 != 102) {
            throw new SftpException(4, "");
        }
        if (n4 == 101) {
            n = this.buf.getInt();
            this.throwStatusError(this.buf, n);
        }
        byte[] byArray2 = this.buf.getString();
        String string4 = null;
        block0: while (true) {
            this.sendREADDIR(byArray2);
            header = this.header(this.buf, header);
            n3 = header.length;
            n4 = header.type;
            if (n4 != 101 && n4 != 104) {
                throw new SftpException(4, "");
            }
            if (n4 == 101) {
                this.fill(this.buf, n3);
                if (this._sendCLOSE(byArray2, header)) return vector;
                return null;
            }
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, 4);
            n3 -= 4;
            int n5 = this.buf.getInt();
            this.buf.reset();
            boolean bl2 = true;
            do {
                if (bl2 && !(bl2 = false)) {
                    if (true) continue;
                }
                if (n3 > 0) {
                    this.buf.shift();
                    int n6 = this.buf.buffer.length > this.buf.index + n3 ? n3 : this.buf.buffer.length - this.buf.index;
                    n = this.io_in.read(this.buf.buffer, this.buf.index, n6);
                    if (n <= 0) continue block0;
                    this.buf.index += n;
                    n3 -= n;
                }
                byte[] byArray3 = this.buf.getString();
                if (this.server_version <= 3) {
                    this.buf.getString();
                }
                SftpATTRS.getATTR(this.buf);
                byte[] byArray4 = byArray3;
                String string5 = null;
                boolean bl3 = false;
                if (!this.fEncoding_is_utf8) {
                    string5 = Util.byte2str(byArray3, this.fEncoding);
                    byArray4 = Util.str2byte(string5, UTF8);
                }
                if (bl3 = Util.glob(byArray, byArray4)) {
                    if (string5 == null) {
                        string5 = Util.byte2str(byArray3, this.fEncoding);
                    }
                    if (string4 == null && !(string4 = string2).endsWith("/")) {
                        string4 = String.valueOf(string4) + "/";
                    }
                    vector.addElement(String.valueOf(string4) + string5);
                }
                --n5;
            } while (n5 > 0);
        }
    }

    private boolean isPattern(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == 42 || byArray[n2] == 63) {
                return true;
            }
            if (byArray[n2] == 92 && n2 + 1 < n) {
                ++n2;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private Vector glob_local(String var1_1) throws Exception {
        var2_2 = new Vector<String>();
        var3_3 = Util.str2byte(var1_1, "UTF-8");
        var4_4 = var3_3.length - 1;
        while (var4_4 >= 0) {
            if (var3_3[var4_4] != 42 && var3_3[var4_4] != 63) {
                --var4_4;
                continue;
            }
            if (ChannelSftp.fs_is_bs || var4_4 <= 0 || var3_3[var4_4 - 1] != 92 || --var4_4 <= 0 || var3_3[var4_4 - 1] != 92) break;
            --var4_4;
            --var4_4;
        }
        if (var4_4 >= 0) ** GOTO lbl17
        var2_2.addElement(ChannelSftp.fs_is_bs != false ? var1_1 : Util.unquote(var1_1));
        return var2_2;
        while (!(var3_3[var4_4] == ChannelSftp.file_separatorc || ChannelSftp.fs_is_bs && var3_3[var4_4] == 47)) {
            --var4_4;
lbl17:
            // 2 sources

            if (var4_4 >= 0) continue;
        }
        if (var4_4 < 0) {
            var2_2.addElement(ChannelSftp.fs_is_bs != false ? var1_1 : Util.unquote(var1_1));
            return var2_2;
        }
        if (var4_4 == 0) {
            var5_5 = new byte[]{(byte)ChannelSftp.file_separatorc};
        } else {
            var5_5 = new byte[var4_4];
            System.arraycopy(var3_3, 0, var5_5, 0, var4_4);
        }
        var6_6 = new byte[var3_3.length - var4_4 - 1];
        System.arraycopy(var3_3, var4_4 + 1, var6_6, 0, var6_6.length);
        try {
            var7_7 = new File(Util.byte2str(var5_5, "UTF-8")).list();
            var8_8 = String.valueOf(Util.byte2str(var5_5)) + ChannelSftp.file_separator;
            var9_9 = 0;
            while (var9_9 < var7_7.length) {
                if (Util.glob(var6_6, Util.str2byte(var7_7[var9_9], "UTF-8"))) {
                    var2_2.addElement(String.valueOf(var8_8) + var7_7[var9_9]);
                }
                ++var9_9;
            }
        }
        catch (Exception v0) {}
        return var2_2;
    }

    private void throwStatusError(Buffer buffer, int n) throws SftpException {
        if (this.server_version >= 3 && buffer.getLength() >= 4) {
            byte[] byArray = buffer.getString();
            throw new SftpException(n, Util.byte2str(byArray, UTF8));
        }
        throw new SftpException(n, "Failure");
    }

    private static boolean isLocalAbsolutePath(String string) {
        return new File(string).isAbsolute();
    }

    @Override
    public void disconnect() {
        if (TRACE) {
            LOG.log(1, "Disconnect channel " + this);
        }
        super.disconnect();
    }

    private boolean isPattern(String string, byte[][] byArray) {
        byte[] byArray2 = Util.str2byte(string, UTF8);
        if (byArray != null) {
            byArray[0] = byArray2;
        }
        return this.isPattern(byArray2);
    }

    private boolean isPattern(String string) {
        return this.isPattern(string, null);
    }

    private void fill(Buffer buffer, int n) throws IOException {
        buffer.reset();
        this.fill(buffer.buffer, 0, n);
        buffer.skip(n);
    }

    private int fill(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = n;
        while (n2 > 0) {
            n3 = this.io_in.read(byArray, n, n2);
            if (n3 <= 0) {
                throw new IOException("inputstream is closed");
            }
            n += n3;
            n2 -= n3;
        }
        return n - n4;
    }

    private void skip(long l) throws IOException {
        while (l > 0L) {
            long l2 = this.io_in.skip(l);
            if (l2 <= 0L) break;
            l -= l2;
        }
    }

    private Header header(Buffer buffer, Header header) throws IOException {
        buffer.rewind();
        this.fill(buffer.buffer, 0, 9);
        header.length = buffer.getInt() - 5;
        header.type = buffer.getByte() & 0xFF;
        header.rid = buffer.getInt();
        return header;
    }

    private String remoteAbsolutePath(String string) throws SftpException {
        if (string.charAt(0) == '/') {
            return string;
        }
        String string2 = this.getCwd();
        if (string2.endsWith("/")) {
            return String.valueOf(string2) + string;
        }
        return String.valueOf(string2) + "/" + string;
    }

    private String localAbsolutePath(String string) {
        if (ChannelSftp.isLocalAbsolutePath(string)) {
            return string;
        }
        if (this.lcwd.endsWith(file_separator)) {
            return String.valueOf(this.lcwd) + string;
        }
        return String.valueOf(this.lcwd) + file_separator + string;
    }

    private String isUnique(String string) throws SftpException, Exception {
        Vector vector = this.glob_remote(string);
        if (vector.size() != 1) {
            throw new SftpException(4, String.valueOf(string) + " is not unique: " + vector.toString());
        }
        return (String)vector.elementAt(0);
    }

    public int getServerVersion() throws SftpException {
        if (!this.isConnected()) {
            throw new SftpException(4, "The channel is not connected.");
        }
        return this.server_version;
    }

    public void setFilenameEncoding(String string) throws SftpException {
        int n = this.getServerVersion();
        if (3 <= n && n <= 5 && !string.equals(UTF8)) {
            throw new SftpException(4, "The encoding can not be changed for this sftp server.");
        }
        if (string.equals(UTF8)) {
            string = UTF8;
        }
        this.fEncoding = string;
        this.fEncoding_is_utf8 = this.fEncoding.equals(UTF8);
    }

    public String getExtension(String string) {
        if (this.extensions == null) {
            return null;
        }
        return (String)this.extensions.get(string);
    }

    public String realpath(String string) throws SftpException {
        try {
            byte[] byArray = this._realpath(this.remoteAbsolutePath(string));
            return Util.byte2str(byArray, this.fEncoding);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public String toString() {
        return "SFTP @" + System.identityHashCode(this);
    }

    class Header {
        int length;
        int type;
        int rid;

        Header() {
        }
    }

    public class LsEntry
    implements Comparable {
        private String filename;
        private String longname;
        private SftpATTRS attrs;

        LsEntry(String string, String string2, SftpATTRS sftpATTRS) {
            this.setFilename(string);
            this.setLongname(string2);
            this.setAttrs(sftpATTRS);
        }

        public String getFilename() {
            return this.filename;
        }

        void setFilename(String string) {
            this.filename = string;
        }

        public String getLongname() {
            return this.longname;
        }

        void setLongname(String string) {
            this.longname = string;
        }

        public SftpATTRS getAttrs() {
            return this.attrs;
        }

        void setAttrs(SftpATTRS sftpATTRS) {
            this.attrs = sftpATTRS;
        }

        public String toString() {
            return this.longname;
        }

        public int compareTo(Object object) throws ClassCastException {
            if (object instanceof LsEntry) {
                return this.filename.compareTo(((LsEntry)object).getFilename());
            }
            throw new ClassCastException("a decendent of LsEntry must be given.");
        }
    }

    public static interface LsEntrySelector {
        public static final int CONTINUE = 0;
        public static final int BREAK = 1;

        public int select(LsEntry var1);
    }

    private class RequestQueue {
        Request[] rrq = null;
        int head;
        int count;

        RequestQueue(int n) {
            this.rrq = new Request[n];
            int n2 = 0;
            while (n2 < this.rrq.length) {
                this.rrq[n2] = new Request();
                ++n2;
            }
            this.init();
        }

        void init() {
            this.count = 0;
            this.head = 0;
        }

        void add(int n, long l, int n2) {
            int n3;
            if (this.count == 0) {
                this.head = 0;
            }
            if ((n3 = this.head + this.count) >= this.rrq.length) {
                n3 -= this.rrq.length;
            }
            this.rrq[n3].id = n;
            this.rrq[n3].offset = l;
            this.rrq[n3].length = n2;
            ++this.count;
            if (TRACE_QUEUE) {
                LOG.log(1, this + " Add " + n3 + ": " + this.rrq[n3]);
            }
        }

        Request get(int n) throws OutOfOrderException, SftpException {
            --this.count;
            int n2 = this.head++;
            if (this.head == this.rrq.length) {
                this.head = 0;
            }
            if (this.rrq[n2].id != n) {
                long l = this.getOffset();
                boolean bl = false;
                int n3 = 0;
                while (n3 < this.rrq.length) {
                    if (this.rrq[n3].id == n) {
                        bl = true;
                        this.rrq[n3].id = 0;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    throw new OutOfOrderException(l);
                }
                throw new SftpException(4, "RequestQueue: unknown request id " + n);
            }
            if (TRACE_QUEUE) {
                LOG.log(1, this + " Remove " + n2 + ": " + this.rrq[n2]);
            }
            this.rrq[n2].id = 0;
            return this.rrq[n2];
        }

        int count() {
            return this.count;
        }

        int size() {
            return this.rrq.length;
        }

        void cancel(Header header, Buffer buffer) throws IOException {
            int n = this.count;
            int n2 = 0;
            while (n2 < n) {
                header = ChannelSftp.this.header(buffer, header);
                int n3 = header.length;
                int n4 = 0;
                while (n4 < this.rrq.length) {
                    if (this.rrq[n4].id == header.rid) {
                        this.rrq[n4].id = 0;
                        break;
                    }
                    ++n4;
                }
                ChannelSftp.this.skip(n3);
                ++n2;
            }
            this.init();
        }

        long getOffset() {
            long l = Long.MAX_VALUE;
            int n = 0;
            while (n < this.rrq.length) {
                if (this.rrq[n].id != 0 && l > this.rrq[n].offset) {
                    l = this.rrq[n].offset;
                }
                ++n;
            }
            return l;
        }

        public String toString() {
            return ChannelSftp.this + " Queue";
        }

        class OutOfOrderException
        extends Exception {
            long offset;

            OutOfOrderException(long l) {
                this.offset = l;
            }
        }

        class Request {
            int id;
            long offset;
            long length;

            Request() {
            }

            public String toString() {
                return "id=" + this.id + ", off=" + this.offset + ", len=" + this.length;
            }
        }
    }
}

