/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.deltopia.io.PipedOutputStream;
import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ForwardedTCPIPDaemon;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.Util;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;

public class ChannelForwardedTCPIP
extends Channel {
    private static Vector pool = new Vector();
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    private static final int TIMEOUT = 10000;
    private Socket socket = null;
    private ForwardedTCPIPDaemon daemon = null;
    private Config config = null;

    ChannelForwardedTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
        this.io = new IO();
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Object object2;
        try {
            if (this.config instanceof ConfigDaemon) {
                object2 = (ConfigDaemon)this.config;
                object = Class.forName(((ConfigDaemon)object2).target);
                this.daemon = (ForwardedTCPIPDaemon)((Class)object).newInstance();
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                this.io.setInputStream((InputStream)((Object)(Channel)this.new Channel.PassiveInputStream(pipedOutputStream, 32768)), false);
                this.daemon.setChannel(this, this.getInputStream(), (OutputStream)pipedOutputStream);
                this.daemon.setArg(((ConfigDaemon)object2).arg);
                new Thread(this.daemon).start();
            } else {
                object2 = (ConfigLHost)this.config;
                this.socket = ((ConfigLHost)object2).factory == null ? Util.createSocket(((ConfigLHost)object2).target, ((ConfigLHost)object2).lport, 10000) : ((ConfigLHost)object2).factory.createSocket(((ConfigLHost)object2).target, ((ConfigLHost)object2).lport);
                this.socket.setTcpNoDelay(true);
                this.io.setInputStream(this.socket.getInputStream());
                this.io.setOutputStream(this.socket.getOutputStream());
            }
            this.sendOpenConfirmation();
        }
        catch (Exception exception) {
            this.sendOpenFailure(1);
            this.close = true;
            this.disconnect();
            return;
        }
        this.thread = Thread.currentThread();
        object2 = new Buffer(this.rmpsize);
        object = new Packet((Buffer)object2);
        int n = 0;
        try {
            Session session = this.getSession();
            while (this.thread != null && this.io != null && this.io.in != null) {
                n = this.io.in.read(((Buffer)object2).buffer, 14, ((Buffer)object2).buffer.length - 14 - 84);
                if (n <= 0) {
                    this.eof();
                    break;
                }
                ((Packet)object).reset();
                ((Buffer)object2).putByte((byte)94);
                ((Buffer)object2).putInt(this.recipient);
                ((Buffer)object2).putInt(n);
                ((Buffer)object2).skip(n);
                ChannelForwardedTCPIP channelForwardedTCPIP = this;
                synchronized (channelForwardedTCPIP) {
                    if (this.close) {
                        break;
                    }
                    session.write((Packet)object, this, n);
                }
            }
        }
        catch (Exception exception) {}
        this.disconnect();
    }

    @Override
    void getData(Buffer buffer) {
        this.setRecipient(buffer.getInt());
        this.setRemoteWindowSize(buffer.getUInt());
        this.setRemotePacketSize(buffer.getInt());
        byte[] byArray = buffer.getString();
        int n = buffer.getInt();
        buffer.getString();
        buffer.getInt();
        Session session = null;
        try {
            session = this.getSession();
        }
        catch (JSchException jSchException) {}
        this.config = ChannelForwardedTCPIP.getPort(session, Util.byte2str(byArray), n);
        if (this.config == null) {
            this.config = ChannelForwardedTCPIP.getPort(session, null, n);
        }
        if (this.config == null && JSch.getLogger().isEnabled(3)) {
            JSch.getLogger().log(3, "ChannelForwardedTCPIP: " + Util.byte2str(byArray) + ":" + n + " is not registered.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Config getPort(Session session, String string, int n) {
        Vector vector = pool;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < pool.size()) {
                Config config = (Config)pool.elementAt(n2);
                if (config.session == session && (config.rport == n || config.rport == 0 && config.allocated_rport == n) && (string == null || config.address_to_bind.equals(string))) {
                    return config;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = pool;
        synchronized (pool) {
            int n = 0;
            while (n < pool.size()) {
                Config config = (Config)pool.elementAt(n);
                if (config instanceof ConfigDaemon) {
                    vector.addElement(String.valueOf(config.allocated_rport) + ":" + config.target + ":");
                } else {
                    vector.addElement(String.valueOf(config.allocated_rport) + ":" + config.target + ":" + ((ConfigLHost)config).lport);
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            stringArray = new String[vector.size()];
            n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
            return stringArray;
        }
    }

    static String normalize(String string) {
        if (string == null) {
            return "localhost";
        }
        if (string.length() == 0 || string.equals("*")) {
            return "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, String string, int n, int n2, String string2, int n3, SocketFactory socketFactory) throws JSchException {
        String string3 = ChannelForwardedTCPIP.normalize(string);
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, string3, n) != null) {
                throw new JSchException("PortForwardingR: remote port " + n + " is already registered.");
            }
            ConfigLHost configLHost = new ConfigLHost();
            configLHost.session = session;
            configLHost.rport = n;
            configLHost.allocated_rport = n2;
            configLHost.target = string2;
            configLHost.lport = n3;
            configLHost.address_to_bind = string3;
            configLHost.factory = socketFactory;
            pool.addElement(configLHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, String string, int n, int n2, String string2, Object[] objectArray) throws JSchException {
        String string3 = ChannelForwardedTCPIP.normalize(string);
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, string3, n) != null) {
                throw new JSchException("PortForwardingR: remote port " + n + " is already registered.");
            }
            ConfigDaemon configDaemon = new ConfigDaemon();
            configDaemon.session = session;
            configDaemon.rport = n;
            configDaemon.allocated_rport = n;
            configDaemon.target = string2;
            configDaemon.arg = objectArray;
            configDaemon.address_to_bind = string3;
            pool.addElement(configDaemon);
        }
    }

    static void delPort(ChannelForwardedTCPIP channelForwardedTCPIP) {
        Session session = null;
        try {
            session = channelForwardedTCPIP.getSession();
        }
        catch (JSchException jSchException) {}
        if (session != null && channelForwardedTCPIP.config != null) {
            ChannelForwardedTCPIP.delPort(session, channelForwardedTCPIP.config.rport);
        }
    }

    static void delPort(Session session, int n) {
        ChannelForwardedTCPIP.delPort(session, null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session, String string, int n) {
        Object object;
        Object object2 = pool;
        synchronized (object2) {
            object = ChannelForwardedTCPIP.getPort(session, ChannelForwardedTCPIP.normalize(string), n);
            if (object == null) {
                object = ChannelForwardedTCPIP.getPort(session, null, n);
            }
            if (object == null) {
                return;
            }
            pool.removeElement(object);
            if (string == null) {
                string = ((Config)object).address_to_bind;
            }
            if (string == null) {
                string = "0.0.0.0";
            }
        }
        object2 = new Buffer(100);
        object = new Packet((Buffer)object2);
        try {
            ((Packet)object).reset();
            ((Buffer)object2).putByte((byte)80);
            ((Buffer)object2).putString(Util.str2byte("cancel-tcpip-forward"));
            ((Buffer)object2).putByte((byte)0);
            ((Buffer)object2).putString(Util.str2byte(string));
            ((Buffer)object2).putInt(n);
            session.write((Packet)object);
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        int[] nArray = null;
        int n = 0;
        Vector vector = pool;
        synchronized (vector) {
            nArray = new int[pool.size()];
            int n2 = 0;
            while (n2 < pool.size()) {
                Config config = (Config)pool.elementAt(n2);
                if (config.session == session) {
                    nArray[n++] = config.rport;
                }
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            ChannelForwardedTCPIP.delPort(session, nArray[n3]);
            ++n3;
        }
    }

    public int getRemotePort() {
        return this.config != null ? this.config.rport : 0;
    }

    private void setSocketFactory(SocketFactory socketFactory) {
        if (this.config != null && this.config instanceof ConfigLHost) {
            ((ConfigLHost)this.config).factory = socketFactory;
        }
    }

    static abstract class Config {
        Session session;
        int rport;
        int allocated_rport;
        String address_to_bind;
        String target;

        Config() {
        }
    }

    static class ConfigDaemon
    extends Config {
        Object[] arg;

        ConfigDaemon() {
        }
    }

    static class ConfigLHost
    extends Config {
        int lport;
        SocketFactory factory;

        ConfigLHost() {
        }
    }
}

