/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.webauth;

import com.deltawalker.webauth.IWebAuthListener;
import com.deltopia.io.URLEncodedUtils;
import com.deltopia.io.VfsUtil;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthServer {
    private static final String ADDRESS = "localhost";
    private static WebAuthServer INSTANCE = null;
    private static final Logger LOG = LoggerFactory.getLogger(WebAuthServer.class);
    private static final int PORT = 8000;
    private final HashMap<String, URL> schemeToUrl = new HashMap(VfsUtil.CLOUD_SCHEMES.size());
    private HttpServer server = null;

    public static final synchronized WebAuthServer getInstance() throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new WebAuthServer();
        }
        return INSTANCE;
    }

    private WebAuthServer() {
        for (String string : VfsUtil.CLOUD_SCHEMES) {
            URL uRL;
            String string2 = "http://localhost:8000/auth-finish-" + string;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalStateException(malformedURLException);
            }
            this.schemeToUrl.put(string, uRL);
        }
    }

    public String getRedirectUrl(String string) {
        if (!VfsUtil.isCloudScheme((String)string)) {
            throw new IllegalArgumentException("Not-cloud scheme: " + string);
        }
        return this.schemeToUrl.get(string).toExternalForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWebServer(IWebAuthListener iWebAuthListener) throws IOException {
        if (iWebAuthListener == null) {
            throw new NullPointerException("listener");
        }
        this.stopWebServer();
        if (LOG.isInfoEnabled()) {
            LOG.info("-> Start web server");
        }
        HttpServer httpServer = HttpServer.create(new InetSocketAddress(ADDRESS, 8000), 0);
        httpServer.setExecutor(null);
        httpServer.start();
        for (URL object2 : this.schemeToUrl.values()) {
            String string = object2.getPath();
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            httpServer.createContext(string, new AcceptHandler(iWebAuthListener));
        }
        WebAuthServer webAuthServer = this;
        synchronized (webAuthServer) {
            this.server = httpServer;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("<- Start web server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWebServer() throws IOException {
        HttpServer httpServer;
        WebAuthServer webAuthServer = this;
        synchronized (webAuthServer) {
            httpServer = this.server;
            this.server = null;
        }
        if (httpServer != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("-> Stop web server");
            }
            httpServer.stop(1);
            this.server = null;
            if (LOG.isInfoEnabled()) {
                LOG.info("<- Stop web server");
            }
        }
    }

    private static final class AcceptHandler
    implements HttpHandler {
        private final IWebAuthListener listener;

        private AcceptHandler(IWebAuthListener iWebAuthListener) {
            this.listener = iWebAuthListener;
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            URI uRI = httpExchange.getRequestURI();
            Map map = URLEncodedUtils.parseToMap((URI)uRI, null);
            if (LOG.isInfoEnabled()) {
                LOG.info("Get URL params: " + map);
            }
            try {
                String string = URLEncodedUtils.getValue((Map)map, (String)"code");
                if (string == null) {
                    throw new Exception("Missing parameter 'code'");
                }
                String string2 = this.listener.finishAuth(map);
                this.sendResponse(httpExchange, false, string2);
            }
            catch (Throwable throwable) {
                LOG.error("Failed to validate token", throwable);
                this.sendResponse(httpExchange, true, throwable.getMessage());
            }
        }

        private void sendResponse(HttpExchange httpExchange, boolean bl, String string) {
            try {
                httpExchange.sendResponseHeaders(bl ? 400 : 200, string.length());
                OutputStream outputStream = httpExchange.getResponseBody();
                outputStream.write(string.getBytes());
                outputStream.close();
            }
            catch (Exception exception) {
                LOG.error("Failed to send response", (Throwable)exception);
            }
        }
    }
}

