/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal.ui.dialogs;

import com.deltawalker.Addon;
import com.deltawalker.AddonInfoUtil;
import com.deltawalker.UriInfo;
import com.deltawalker.vfs.internal.ui.dialogs.RemoteResourceSheet;
import com.deltawalker.vfs.internal.ui.dialogs.WebAuthComposite;
import com.deltopia.io.VfsService;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WebAuthPrefPage
extends PreferencePage
implements RemoteResourceSheet.IRemoteResourcePrefPage {
    private final Set<Addon.Edition> availableIn = EnumSet.noneOf(Addon.Edition.class);
    private WebAuthComposite cmpWebAuth;
    private final RemoteResourceSheet.IResourceDialogInfo dlgInfo;
    private WebAuthComposite.IAuthListener onAuth;
    private final VfsService service;

    public WebAuthPrefPage(VfsService vfsService, WebAuthComposite.IAuthListener iAuthListener, RemoteResourceSheet.IResourceDialogInfo iResourceDialogInfo, Set<Addon.Edition> set) {
        super(String.valueOf(vfsService.displayName()) + AddonInfoUtil.constructSuffix(set));
        this.onAuth = iAuthListener;
        this.service = vfsService;
        this.dlgInfo = iResourceDialogInfo;
        this.availableIn.addAll(set);
    }

    protected Control createContents(Composite composite) {
        this.cmpWebAuth = new WebAuthComposite(composite, 0, this.onAuth, this.service, this.dlgInfo);
        Addon.Edition edition = AddonInfoUtil.addonInfo().edition();
        boolean bl = this.availableIn.contains(edition);
        if (!this.availableIn.isEmpty() && !bl) {
            this.cmpWebAuth.setEnabled(false);
        }
        return this.cmpWebAuth;
    }

    @Override
    public boolean isDoneAuthorizing() {
        return this.cmpWebAuth != null ? this.cmpWebAuth.isDoneAuthorizing() : false;
    }

    @Override
    public final VfsService service() {
        return this.service;
    }

    @Override
    public UriInfo uriInfo() {
        return this.cmpWebAuth.constructUriInfo();
    }
}

