/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal.ui.dialogs;

import com.deltawalker.UriInfo;
import com.deltawalker.vfs.internal.Msg;
import com.deltawalker.vfs.internal.SecurePrefsUtil;
import com.deltawalker.vfs.internal.ui.dialogs.AuthComposite;
import com.deltawalker.vfs.internal.ui.dialogs.AuthToken;
import com.deltawalker.vfs.internal.ui.dialogs.CloudAccount;
import com.deltawalker.vfs.internal.ui.dialogs.CloudAuthFlow;
import com.deltawalker.vfs.internal.ui.dialogs.CloudDeauthFlow;
import com.deltawalker.vfs.internal.ui.dialogs.RemoteResourceSheet;
import com.deltawalker.webauth.IWebAuthListener;
import com.deltawalker.webauth.WebAuthServer;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import com.deltopia.io.UriInfoKey;
import com.deltopia.io.VfsService;
import com.deltopia.jface.util.DialogUtil;
import com.deltopia.ui.concurrency.GuiExecutor;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthComposite
extends AuthComposite {
    private static final Logger LOG = LoggerFactory.getLogger(WebAuthComposite.class);
    private CloudAuthFlow authFlow = null;
    private AuthToken authToken = null;
    private Button btnAuth;
    private Button btnDeauth;
    private final IAuthListener onAuth;
    private DisposeListener onDispose = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            WebAuthComposite.this.stopWebServer();
        }
    };
    private SelectionListener onSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == WebAuthComposite.this.btnAuth) {
                WebAuthComposite.this.startAuthorization();
            } else if (selectionEvent.widget == WebAuthComposite.this.btnDeauth) {
                WebAuthComposite.this.removeAuthToken();
            }
        }
    };
    private IWebAuthListener onWebAuth = new IWebAuthListener(){

        @Override
        public String finishAuth(Map<String, String[]> map) throws Exception {
            return WebAuthComposite.this.finishAuthorization(map);
        }
    };
    private WebAuthServer server = null;

    public WebAuthComposite(Composite composite, int n, IAuthListener iAuthListener, VfsService vfsService, RemoteResourceSheet.IResourceDialogInfo iResourceDialogInfo) {
        super(composite, n, vfsService, iResourceDialogInfo);
        if (iAuthListener == null) {
            throw new NullPointerException("onAuth");
        }
        this.onAuth = iAuthListener;
        this.createControls();
    }

    private Button addButton(Composite composite, String string) {
        Button button = new Button(composite, 0);
        button.setText(string);
        button.addSelectionListener(this.onSelection);
        return button;
    }

    @Override
    protected String constructUri(UriInfo uriInfo, boolean bl) {
        if (uriInfo == null) {
            uriInfo = this.uriInfo;
        }
        if (uriInfo == null) {
            return "";
        }
        String string = uriInfo.uri();
        String string2 = uriInfo.email();
        if (string2.isEmpty()) {
            return string;
        }
        String string3 = this.service().fullScheme();
        String string4 = String.valueOf(string3) + string2 + string.substring(string3.length(), string.length());
        return string4;
    }

    public UriInfo constructUriInfo() {
        AuthToken authToken = this.getAuthToken();
        if (authToken != null) {
            this.writeAuthToken(authToken);
        }
        FileType fileType = this.dialogInfo().isFileDialog() ? FileType.FILE : FileType.FOLDER;
        ContentType contentType = fileType.isFolder() ? ContentType.FOLDER : ContentType.UNKNOWN;
        this.uriInfo = new UriInfo(this.service().fullScheme(), fileType, contentType, null, this.props());
        return this.uriInfo;
    }

    @Override
    protected void createControls() {
        super.createControls();
        Composite composite = DialogUtil.createComposite((Composite)this, (int)2, (int)1, (boolean)false);
        this.btnAuth = this.addButton(composite, Msg.WebAuthComposite_auth);
        this.btnDeauth = this.addButton(composite, Msg.WebAuthComposite_deauth);
        this.setAuthToken(null);
        this.addDisposeListener(this.onDispose);
        this.installListeners();
        UriInfo uriInfo = this.dialogInfo().mruUriInfo();
        this.setMruUriInfo(uriInfo);
        if (uriInfo != null && !uriInfo.isEmpty()) {
            this.readAuthToken(uriInfo);
        }
        this.fillRecentCombo();
        this.showUri();
    }

    private String finishAuthorization(Map<String, String[]> map) throws IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info(">>> Finish authorization");
        }
        try {
            AuthToken authToken = this.authFlow.finishFlow(map);
            if (LOG.isInfoEnabled()) {
                LOG.info("<<< Finish authorization. Token: " + authToken);
            }
            this.setAuthToken(authToken);
            this.onAuth.successfulAuth(authToken);
            String string = NLS.bind((String)Msg.WebAuthComposite_authSucceeded, (Object)this.service().displayName());
            this.reportStatus(string, null);
            String string2 = NLS.bind((String)Msg.WebAuthComposite_authConfirm, (Object)this.service().displayName());
            return string2;
        }
        catch (Exception exception) {
            String string = NLS.bind((String)Msg.WebAuthComposite_authFailed, (Object)this.service().displayName(), (Object)exception.getMessage());
            this.reportStatus(string, exception);
            throw new IOException(string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthToken getAuthToken() {
        WebAuthComposite webAuthComposite = this;
        synchronized (webAuthComposite) {
            return this.authToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDoneAuthorizing() {
        WebAuthComposite webAuthComposite = this;
        synchronized (webAuthComposite) {
            return this.authToken != null;
        }
    }

    private void openUrl(String string) throws IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Open URL: " + string);
        }
        URI uRI = URI.create(string);
        Desktop.getDesktop().browse(uRI);
    }

    public void readAuthToken(UriInfo uriInfo) {
        String string = uriInfo.email();
        String string2 = String.valueOf(this.service().fullScheme()) + uriInfo.email();
        String string3 = SecurePrefsUtil.get(string2, "");
        if (string3.isEmpty()) {
            string3 = uriInfo.authToken();
        }
        if (!string3.isEmpty()) {
            String string4;
            CloudAccount cloudAccount = null;
            if (!string.isEmpty() && !(string4 = uriInfo.accountId()).isEmpty()) {
                cloudAccount = new CloudAccount(string4, "", string);
            }
            this.setAuthToken(new AuthToken(string3, cloudAccount));
        }
        this.dialogInfo().updateButtons();
    }

    private void removeAuthToken() {
        AuthToken authToken = this.getAuthToken();
        CloudDeauthFlow cloudDeauthFlow = CloudDeauthFlow.createFlow(this.service().scheme(), authToken);
        if (cloudDeauthFlow != null) {
            try {
                cloudDeauthFlow.deauth();
                this.onAuth.successfulDeAuth(authToken);
                String string = NLS.bind((String)Msg.WebAuthComposite_deauthSucceeded, (Object)this.service().displayName());
                this.reportStatus(string, null);
                GuiExecutor.instance().asyncExec(this.getDisplay(), new Runnable(){

                    @Override
                    public void run() {
                        WebAuthComposite.this.btnDeauth.setEnabled(false);
                    }
                });
            }
            catch (Exception exception) {
                String string = NLS.bind((String)Msg.WebAuthComposite_deauthFailed, (Object)this.service().displayName(), (Object)exception.getMessage());
                this.reportStatus(string, exception);
            }
        }
    }

    private void reportStatus(final String string, final Exception exception) {
        if (exception != null) {
            LOG.warn(string, (Throwable)exception);
        }
        GuiExecutor.instance().asyncExec(this.getDisplay(), new Runnable(){

            @Override
            public void run() {
                if (!WebAuthComposite.this.isDisposed()) {
                    if (exception == null) {
                        WebAuthComposite.this.showAlert(true, string, 0);
                    } else {
                        WebAuthComposite.this.showAlert(true, string, 1);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAuthToken(AuthToken authToken) {
        boolean bl;
        WebAuthComposite webAuthComposite = this;
        synchronized (webAuthComposite) {
            this.authToken = authToken;
            bl = authToken != null;
        }
        GuiExecutor.instance().asyncExec(this.getDisplay(), new Runnable(){

            @Override
            public void run() {
                if (!WebAuthComposite.this.isDisposed()) {
                    WebAuthComposite.this.btnDeauth.setEnabled(bl);
                }
            }
        });
    }

    private void startAuthorization() {
        if (LOG.isInfoEnabled()) {
            LOG.info(">>> Start authorization");
        }
        try {
            this.startWebServer();
            String string = this.server.getRedirectUrl(this.service().scheme());
            this.authFlow = CloudAuthFlow.createFlow(this.service().scheme(), string, true);
            String string2 = this.authFlow.initFlow();
            this.openUrl(string2);
            if (LOG.isInfoEnabled()) {
                LOG.info("<<< Start authorization");
            }
        }
        catch (Exception exception) {
            String string = NLS.bind((String)Msg.WebAuthComposite_authFailed, (Object)this.service().displayName(), (Object)exception.getMessage());
            this.reportStatus(string, exception);
        }
    }

    private void startWebServer() throws IOException {
        if (this.server == null) {
            WebAuthServer webAuthServer;
            this.server = webAuthServer = WebAuthServer.getInstance();
            webAuthServer.startWebServer(this.onWebAuth);
        }
    }

    private void stopWebServer() {
        if (this.server != null) {
            try {
                this.server.stopWebServer();
                this.server = null;
            }
            catch (Exception exception) {
                LOG.warn("Failed to stop web server", (Throwable)exception);
            }
        }
    }

    @Override
    protected void updateButtons(UriInfo uriInfo) {
        this.readAuthToken(uriInfo);
    }

    public void writeAuthToken(AuthToken authToken) {
        this.props().put(UriInfoKey.AUTH_TOKEN, authToken.getToken());
        CloudAccount cloudAccount = authToken.getAccount();
        String string = cloudAccount.getEmail();
        this.props().put(UriInfoKey.EMAIL, string);
        String string2 = cloudAccount.getId();
        if (!string2.isEmpty()) {
            this.props().put(UriInfoKey.ACCOUNT_ID, string2);
        }
        this.props().put(UriInfoKey.EMAIL, string);
        String string3 = String.valueOf(this.service().fullScheme()) + string;
        SecurePrefsUtil.put(string3, authToken.getToken());
    }

    public static interface IAuthListener {
        public void successfulAuth(AuthToken var1);

        public void successfulDeAuth(AuthToken var1);
    }
}

