/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal.ui.dialogs;

import com.deltawalker.PrefKey;
import com.deltawalker.UriInfo;
import com.deltawalker.ui.Alerts;
import com.deltawalker.ui.ControlUtil;
import com.deltawalker.ui.EncodingChooser;
import com.deltawalker.ui.IAlert;
import com.deltawalker.ui.LineEndingChooser;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.vfs.internal.Msg;
import com.deltawalker.vfs.internal.SecurePrefsUtil;
import com.deltawalker.vfs.internal.VfsResourceFactory;
import com.deltawalker.vfs.internal.ui.dialogs.AuthComposite;
import com.deltawalker.vfs.internal.ui.dialogs.PassphraseDialog;
import com.deltawalker.vfs.internal.ui.dialogs.RemoteResourceSheet;
import com.deltopia.ObjectUtil;
import com.deltopia.StringUtil;
import com.deltopia.io.FileType;
import com.deltopia.io.FileUtil;
import com.deltopia.io.TextEncoding;
import com.deltopia.io.UriInfoKey;
import com.deltopia.io.VfsService;
import com.deltopia.io.VfsUtil;
import com.deltopia.jface.util.DialogUtil;
import com.deltopia.ui.OSFileDialog;
import com.deltopia.ui.concurrency.GuiExecutor;
import com.deltopia.util.Const;
import com.deltopia.vfs.util.UriUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPwdAuthComposite
extends AuthComposite {
    private static final int CMP_HOST_COL_COUNT = 5;
    private static final int HOST_WIDTH_HINT = 120;
    private static final Logger LOG = LoggerFactory.getLogger(UserPwdAuthComposite.class);
    private Button btnAnonym;
    private Composite cmpHost;
    private Composite cmpPwd;
    private EncodingChooser csChooser;
    private TextEncoding encoding;
    private Map<Control, Label> indicators;
    private LineEndingChooser leChooser;
    private String lineEnding;
    private Locale locale;
    private final FocusListener onFocus = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            Text text = (Text)focusEvent.widget;
            if (text.getEditable()) {
                text.selectAll();
                Boolean bl = text.getSelectionText().trim().length() != 0;
                UserPwdAuthComposite.this.selections.put(text, bl);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            ((Text)focusEvent.widget).setSelection(0, 0);
        }
    };
    private KeyListener onKey = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            keyEvent.widget.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UserPwdAuthComposite.this.showUri();
                }
            });
        }
    };
    private final MouseAdapter onMouse = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            ((Text)mouseEvent.widget).selectAll();
        }

        public void mouseDown(MouseEvent mouseEvent) {
            Text text = (Text)mouseEvent.widget;
            Boolean bl = (Boolean)UserPwdAuthComposite.this.selections.get(text);
            if (bl != null && bl.booleanValue()) {
                text.selectAll();
                UserPwdAuthComposite.this.selections.put(text, false);
            }
        }
    };
    private Map<Control, Boolean> selections = new HashMap<Control, Boolean>();
    private ToolBar tbOptions;
    private ToolBar tbSsh;
    private Thread thread;
    private Text txtHost;
    private Text txtPassword;
    private Text txtPath;
    private Text txtPort;
    private Text txtUsername;
    private URI uri;

    protected UserPwdAuthComposite(Composite composite, int n, VfsService vfsService, RemoteResourceSheet.IResourceDialogInfo iResourceDialogInfo) {
        super(composite, n, vfsService, iResourceDialogInfo);
        this.createControls();
    }

    private void clearIndicators() {
        if (this.indicators == null || this.indicators.isEmpty()) {
            return;
        }
        for (Control control : this.indicators.values()) {
            Composite composite = control.getParent();
            --((GridLayout)composite.getLayout()).numColumns;
            control.dispose();
            composite.layout();
        }
        this.indicators.clear();
    }

    private String constructPath(String string) {
        if (string.isEmpty()) {
            return string;
        }
        string = string.replace('\\', '/').trim();
        String string2 = string = (string = string.replaceAll("//", "/")).startsWith("/") ? string : "/" + string;
        if (this.dialogInfo().isFileDialog()) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            string = string.endsWith("/") ? string : String.valueOf(string) + "/";
        }
        return UriUtil.escapeUriComponent((String)string, (String)"/");
    }

    @Override
    protected String constructUri(UriInfo uriInfo, boolean bl) {
        String string;
        String string2 = this.service().fullScheme();
        if (!this.isAnonymous()) {
            String string3;
            string = this.txtUsername.getText().trim();
            if (!string.isEmpty()) {
                this.setProperty(UriInfoKey.USERNAME, string);
            }
            if (!(string3 = this.txtPassword.getText().trim()).isEmpty()) {
                this.setProperty(UriInfoKey.PASSWORD, string3);
            }
        }
        string = this.txtPort.getText();
        boolean bl2 = this.isExplicit();
        int n = this.verifyPort(string) ? Integer.parseInt(string) : VfsUtil.getDefaultPort((String)string2, (boolean)bl2);
        string = n == VfsUtil.getDefaultPort((String)string2, (boolean)bl2) ? "" : String.valueOf(':') + new Integer(n).toString();
        String string4 = String.valueOf(this.getHost()) + string;
        String string5 = this.constructPath(this.txtPath.getText());
        string4 = string4.length() == 0 && string5.equals("/") ? string2 : String.valueOf(string2) + string4 + string5;
        return string4;
    }

    public UriInfo constructUriInfo() {
        String string;
        String string2;
        Object object;
        Object object2;
        String string3 = this.constructUri(null, false);
        FileType fileType = FileType.FOLDER;
        if (this.dialogInfo().isFileDialog()) {
            object2 = null;
            object = null;
            if (this.csChooser.isCharsetSelected()) {
                object = this.csChooser.getSelectedEncoding(false);
                if (object != null) {
                    this.props().put(UriInfoKey.ENCODING, object.charset());
                    this.props().put(UriInfoKey.BOM, object.bom());
                }
            } else {
                object2 = this.csChooser.getSelectedLocale();
                if (object2 != null) {
                    this.props().put(UriInfoKey.LOCALE, object2);
                }
            }
            if (!StringUtil.isEmpty((String)(string2 = this.leChooser.getSelectedLineEnding()))) {
                this.props().put(UriInfoKey.LINE_ENDING, string2);
            }
            fileType = FileType.FILE;
        }
        this.isUserDirRoot();
        this.uriInfo = new UriInfo(string3, fileType, null, null, this.props());
        object2 = this.uriInfo.username();
        object = this.uriInfo.password();
        string2 = this.uriInfo.sshPassphrase();
        if (!string2.isEmpty()) {
            string = UriUtil.constructSshPassphrasePrefKey((String)string3, (String)object2);
            SecurePrefsUtil.put(string, string2);
        }
        if (!((String)object).isEmpty()) {
            string = UriUtil.constructUriPasswordPrefKey((String)string3, (String)object2);
            SecurePrefsUtil.put(string, (String)object);
        }
        return this.uriInfo;
    }

    private void createAuthControls() {
        Composite composite = DialogUtil.createComposite((Composite)this, (int)3, (int)1, (boolean)false);
        this.btnAnonym = new Button(composite, 32);
        this.btnAnonym.setText(Msg.RemoteResourceDialog_anonymous);
        this.btnAnonym.setSelection(false);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 3;
        this.btnAnonym.setLayoutData((Object)gridData);
        Composite composite2 = DialogUtil.createComposite((Composite)this, (int)3, (int)769, (boolean)false);
        Label label = new Label(composite2, 0);
        label.setText(Msg.RemoteResourceDialog_username);
        this.setLabelWidthHint((Control)label);
        this.txtUsername = new Text(composite2, 2048);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        this.txtUsername.setLayoutData((Object)gridData);
        this.cmpPwd = DialogUtil.createComposite((Composite)this, (int)3, (int)769, (boolean)false);
        label = new Label(this.cmpPwd, 0);
        label.setText(Msg.RemoteResourceDialog_password);
        this.setLabelWidthHint((Control)label);
        this.txtPassword = new Text(this.cmpPwd, 0x400800);
        gridData = new GridData(4, 0x1000000, true, false);
        this.txtPassword.setLayoutData((Object)gridData);
        this.createSshToolbar(this.cmpPwd);
        this.cmpPwd.layout();
    }

    private void createCharsetChooser(IPreferenceStore iPreferenceStore) {
        Composite composite = DialogUtil.createComposite((Composite)this, (int)2, (int)1, (boolean)false);
        this.createEncodingControls(composite, iPreferenceStore);
        this.createDelimiterControls(composite, iPreferenceStore);
    }

    @Override
    protected void createControls() {
        super.createControls();
        String string = this.dialogInfo().isFileDialog() ? Msg.RemoteResourceDialog_file : Msg.RemoteResourceDialog_folder;
        String string2 = this.dialogInfo().isOpen() ? Msg.RemoteResourceDialog_selectTitle : Msg.RemoteResourceDialog_saveTitle;
        this.getShell().setText(NLS.bind((String)string2, (Object)this.dialogInfo().roleName(), (Object)string));
        DialogUtil.insertSpace((Composite)this, (boolean)true);
        this.createHostControls();
        DialogUtil.insertSpace((Composite)this, (boolean)true);
        this.createAuthControls();
        if (this.dialogInfo().isFileDialog()) {
            DialogUtil.insertSpace((Composite)this, (boolean)true);
            this.createCharsetChooser(this.dialogInfo().prefs());
            if (this.locale != null) {
                this.csChooser.setSelectedLocale(this.locale);
            } else if (this.encoding != null) {
                this.csChooser.setSelectedEncoding(this.encoding);
            }
            if (!StringUtil.isEmpty((String)this.lineEnding)) {
                this.leChooser.setSelectedDelimiter(this.lineEnding);
            }
        }
        this.createTestControl();
        this.installListeners();
        this.setMruUriInfo(this.dialogInfo().mruUriInfo());
        this.fillRecentCombo();
        this.toggleAnonymousUser();
        this.initializePort();
        this.updateToolbarVisibility();
        DialogUtil.removeControlFromTabOrder((Control)this.txtUri, (Composite)this);
        this.txtHost.setFocus();
        UIUtil.enforceMinDialogSize((Shell)this.getShell());
        this.showUri();
    }

    private void createDelimiterControls(Composite composite, IPreferenceStore iPreferenceStore) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)gridData);
        label.setText(UIMsg.FileDlg_lineEnding);
        this.leChooser = new LineEndingChooser(composite, 12, false, true, iPreferenceStore);
        this.leChooser.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void createEncodingControls(Composite composite, IPreferenceStore iPreferenceStore) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)gridData);
        label.setText(UIMsg.FileDlg_encoding);
        this.csChooser = new EncodingChooser(composite, 12, false, this.dialogInfo().isOpen(), iPreferenceStore);
        this.csChooser.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void createHostControls() {
        this.cmpHost = DialogUtil.createComposite((Composite)this, (int)5, (int)1, (boolean)false);
        Label label = new Label(this.cmpHost, 0);
        label.setText(Msg.RemoteResourceDialog_server);
        this.setLabelWidthHint((Control)label);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = DialogUtil.convertDLUsToPixels((int)120, (boolean)true);
        this.txtHost = new Text(this.cmpHost, 2048);
        this.txtHost.setLayoutData((Object)gridData);
        label = new Label(this.cmpHost, 0);
        label.setText(Msg.RemoteResourceDialog_port);
        this.txtPort = new Text(this.cmpHost, 2048);
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = UIUtil.stringExtent((String)"99999", (Control)this.txtPort);
        this.txtPort.setLayoutData((Object)gridData);
        this.createOptionsToolbar(this.cmpHost);
        this.cmpHost.layout();
        Composite composite = DialogUtil.createComposite((Composite)this, (int)4, (int)769, (boolean)false);
        label = new Label(composite, 0);
        String string = this.dialogInfo().isFileDialog() ? Msg.RemoteResourceDialog_file : Msg.RemoteResourceDialog_folder;
        label.setText(NLS.bind((String)Msg.RemoteResourceDialog_initialPath, (Object)string));
        this.setLabelWidthHint((Control)label);
        this.txtPath = new Text(composite, 2048);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 3;
        this.txtPath.setLayoutData((Object)gridData);
        this.txtPath.setToolTipText(NLS.bind((String)Msg.RemoteResourceDialog_pathTooltip, (Object)string.toLowerCase()));
    }

    private Menu createOptionsMenu(Composite composite) {
        boolean bl;
        MenuItem menuItem;
        assert (composite != null);
        Menu menu = new Menu((Control)composite);
        String string = this.service().scheme();
        if ("ftps".equals(string)) {
            menuItem = new MenuItem(menu, 32);
            menuItem.setText(Msg.RemoteResourceDialog_explicit);
            bl = this.isExplicit();
            menuItem.setSelection(bl);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    UserPwdAuthComposite.this.setProperty(UriInfoKey.EXPLICIT_MODE, menuItem.getSelection());
                    UserPwdAuthComposite.this.schemeChanged(null);
                }
            });
        }
        if ("ftp".equals(string) || "ftps".equals(string)) {
            menuItem = new MenuItem(menu, 32);
            menuItem.setText(Msg.RemoteResourceDialog_passive);
            bl = this.isPassive();
            menuItem.setSelection(bl);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    UserPwdAuthComposite.this.setProperty(UriInfoKey.PASSIVE_MODE, menuItem.getSelection());
                }
            });
        }
        assert ("ftp".equals(string) || "sftp".equals(string) || "ftps".equals(string));
        menuItem = new MenuItem(menu, 32);
        menuItem.setText(Msg.RemoteResourceDialog_userDir);
        bl = this.isUserDirRoot();
        menuItem.setSelection(bl);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UserPwdAuthComposite.this.setProperty(UriInfoKey.USER_DIR_IS_ROOT, menuItem.getSelection());
            }
        });
        return menu;
    }

    private void createOptionsToolbar(final Composite composite) {
        assert (composite != null);
        this.tbOptions = new ToolBar(composite, 0);
        this.tbOptions.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final ToolItem toolItem = new ToolItem(this.tbOptions, 4);
        toolItem.setText(Msg.RemoteResourceDialog_options);
        toolItem.setToolTipText(Msg.RemoteResourceDialog_optionsTooltip);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Rectangle rectangle = toolItem.getBounds();
                Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                point = UserPwdAuthComposite.this.tbOptions.toDisplay(point);
                Menu menu = UserPwdAuthComposite.this.createOptionsMenu(composite);
                menu.setLocation(point.x, point.y);
                menu.setVisible(true);
            }
        });
        this.tbOptions.pack();
    }

    private void createSshToolbar(Composite composite) {
        this.tbSsh = new ToolBar(composite, 0);
        this.tbSsh.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final Menu menu = new Menu((Control)composite);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(Msg.RemoteResourceDialog_selectKey);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = String.valueOf(Const.USER_HOME) + "/.ssh";
                if (!FileUtil.absolutelyExists((String)string)) {
                    string = Const.USER_HOME;
                }
                OSFileDialog oSFileDialog = new OSFileDialog(UserPwdAuthComposite.this.getShell(), 4096);
                if (FileUtil.absolutelyExists((String)string)) {
                    oSFileDialog.setFilterPath(string);
                    oSFileDialog.setFileName("id_rsa");
                }
                if (FileUtil.absolutelyExists((String)(string = oSFileDialog.open())) && new File(string).isFile()) {
                    UserPwdAuthComposite.this.setProperty(UriInfoKey.SSH_KEY, string);
                } else {
                    UserPwdAuthComposite.this.removeProperty(UriInfoKey.SSH_KEY);
                }
            }
        });
        MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.setText(Msg.RemoteResourceDialog_specifyPassphrase);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PassphraseDialog passphraseDialog = new PassphraseDialog(UserPwdAuthComposite.this.getShell());
                String string = "";
                UriInfo uriInfo = UserPwdAuthComposite.this.getMruUriInfo();
                if (uriInfo != null && !(string = uriInfo.sshPassphrase()).isEmpty()) {
                    passphraseDialog.setPassphrase(string);
                }
                if (passphraseDialog.open() == 0) {
                    string = passphraseDialog.getPassphrase();
                    UserPwdAuthComposite.this.setProperty(UriInfoKey.SSH_PASSPHRASE, string);
                }
            }
        });
        final ToolItem toolItem = new ToolItem(this.tbSsh, 4);
        MenuItem menuItem3 = new MenuItem(menu, 8);
        menuItem3.setText(Msg.RemoteResourceDialog_clearSettings);
        menuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UserPwdAuthComposite.this.removeProperty(UriInfoKey.SSH_KEY);
                UserPwdAuthComposite.this.removeProperty(UriInfoKey.SSH_PASSPHRASE);
                toolItem.setToolTipText(Msg.RemoteResourceDialog_sshTooltip);
            }
        });
        toolItem.setText(Msg.RemoteResourceDialog_ssh);
        toolItem.setToolTipText(Msg.RemoteResourceDialog_sshTooltip);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Rectangle rectangle = toolItem.getBounds();
                Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                point = UserPwdAuthComposite.this.tbSsh.toDisplay(point);
                menu.setLocation(point.x, point.y);
                menu.setVisible(true);
            }
        });
        this.tbSsh.pack();
    }

    private void createTestControl() {
        Composite composite = DialogUtil.createComposite((Composite)this, (int)1, (int)769, (boolean)false);
        Button button = new Button(composite, 0);
        button.setText(Msg.RemoteResourceDialog_testConnection);
        button.setLayoutData((Object)new GridData(0x1000008, 0, true, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UserPwdAuthComposite.this.testConnection();
            }
        });
    }

    private String getHost() {
        String string = String.valueOf(this.service().scheme()) + "://";
        String string2 = this.txtHost.getText().trim();
        if (string2.startsWith(string)) {
            string2 = string2.substring(string.length(), string2.length());
        }
        if (string.equalsIgnoreCase("webdav://") && string2.startsWith("http://")) {
            string2 = string2.substring("http://".length(), string2.length());
        }
        if (string.equalsIgnoreCase("webdavs://") && string2.startsWith("https://")) {
            string2 = string2.substring("https://".length(), string2.length());
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private int getPort(URI uRI) {
        int n;
        int n2 = n = uRI != null ? uRI.getPort() : -1;
        if (n != -1) {
            return n;
        }
        String string = uRI != null ? uRI.getScheme() : this.service().scheme();
        return VfsUtil.getDefaultPort((String)string, (boolean)this.isExplicit());
    }

    public Object getProperty(UriInfoKey uriInfoKey) {
        return this.props().get(uriInfoKey);
    }

    private void initializePort() {
        this.txtPort.setText(Integer.toString(this.getPort(this.uri)));
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.btnAnonym.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UserPwdAuthComposite.this.toggleAnonymousUser();
            }
        });
        this.txtHost.addKeyListener(this.onKey);
        this.txtPath.addKeyListener(this.onKey);
        this.txtPort.addKeyListener(this.onKey);
        this.txtUsername.addKeyListener(this.onKey);
        this.txtHost.addFocusListener(this.onFocus);
        this.txtHost.addMouseListener((MouseListener)this.onMouse);
        this.txtPort.addFocusListener(this.onFocus);
        this.txtPort.addMouseListener((MouseListener)this.onMouse);
        this.txtPath.addFocusListener(this.onFocus);
        this.txtPath.addMouseListener((MouseListener)this.onMouse);
        this.txtUsername.addFocusListener(this.onFocus);
        this.txtUsername.addMouseListener((MouseListener)this.onMouse);
        this.txtPassword.addFocusListener(this.onFocus);
        this.txtPassword.addMouseListener((MouseListener)this.onMouse);
    }

    private boolean isAnonymous() {
        return this.btnAnonym.getSelection();
    }

    private boolean isExplicit() {
        Boolean bl = (Boolean)this.getProperty(UriInfoKey.EXPLICIT_MODE);
        boolean bl2 = bl != null ? bl.booleanValue() : this.dialogInfo().prefs().getBoolean(PrefKey.R_EXPLICIT_MODE.toString());
        return bl2;
    }

    private boolean isPassive() {
        Boolean bl = (Boolean)this.getProperty(UriInfoKey.PASSIVE_MODE);
        boolean bl2 = bl != null ? bl.booleanValue() : this.dialogInfo().prefs().getBoolean(PrefKey.R_PASSIVE_MODE.toString());
        return bl2;
    }

    private boolean isUserDirRoot() {
        boolean bl = true;
        Boolean bl2 = (Boolean)this.getProperty(UriInfoKey.USER_DIR_IS_ROOT);
        if (bl2 != null) {
            bl = bl2;
        } else {
            bl = this.dialogInfo().prefs().getBoolean(PrefKey.R_USER_DIR_IS_ROOT.toString());
            this.setProperty(UriInfoKey.USER_DIR_IS_ROOT, bl);
        }
        return bl;
    }

    public void removeProperty(UriInfoKey uriInfoKey) {
        this.props().remove(uriInfoKey);
    }

    private void schemeChanged(URI uRI) {
        this.txtPort.setText(Integer.toString(this.getPort(uRI)));
        this.showUri();
        this.updateToolbarVisibility();
    }

    private void setAnonymous(boolean bl) {
        this.btnAnonym.setSelection(bl);
        this.toggleAnonymousUser();
    }

    public void setProperty(UriInfoKey uriInfoKey, Object object) {
        this.props().put(uriInfoKey, object);
    }

    private void showIndicator(Control control) {
    }

    private void showTestResult(final boolean bl, final String string, final int n, final Control control) {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                if (UserPwdAuthComposite.this.isDisposed()) {
                    return;
                }
                UserPwdAuthComposite.this.showAlert(bl, string, n);
                if (control != null && !control.isDisposed()) {
                    UserPwdAuthComposite.this.showIndicator(control);
                }
            }
        });
    }

    private void showUnknownHostError() {
        String string = NLS.bind((String)Msg.RemoteResourceDialog_unknownHost, (Object)this.txtHost.getText());
        this.showTestResult(true, string, 1, (Control)this.txtHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection() {
        if (StringUtil.isEmpty((String)this.txtHost.getText())) {
            return;
        }
        this.showAlert(true, NLS.bind((String)Msg.RemoteResourceDialog_connecting, (Object)this.service().displayName()), 2);
        this.clearIndicators();
        final String string = this.service().scheme();
        UserPwdAuthComposite userPwdAuthComposite = this;
        synchronized (userPwdAuthComposite) {
            this.constructUriInfo();
            try {
                URI uRI = new URI(this.uriInfo.uri(), true);
                String string2 = uRI.getHost();
                InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                this.showUnknownHostError();
                return;
            }
            catch (URIException uRIException) {
                this.showUnknownHostError();
                return;
            }
            this.thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    try {
                        var1_1 = VfsResourceFactory.staticResolveFile(UserPwdAuthComposite.this.uriInfo);
                        if (var1_1.getType() != org.apache.commons.vfs2.FileType.IMAGINARY) ** GOTO lbl35
                        var2_4 = Msg.RemoteResourceDialog_invalidUri;
                        UserPwdAuthComposite.access$11(UserPwdAuthComposite.this, true, var2_4, 1, (Control)UserPwdAuthComposite.access$10(UserPwdAuthComposite.this));
                        var4_6 = this;
                    }
                    catch (IOException var1_2) {
                        var2_5 = Alerts.fetchErrorMessage((Throwable)var1_2);
                        if (var2_5.indexOf(" as user ") != -1) {
                            UserPwdAuthComposite.access$11(UserPwdAuthComposite.this, true, var2_5, 1, (Control)UserPwdAuthComposite.access$12(UserPwdAuthComposite.this));
                            UserPwdAuthComposite.access$11(UserPwdAuthComposite.this, true, var2_5, 1, (Control)UserPwdAuthComposite.access$13(UserPwdAuthComposite.this));
                        } else {
                            UserPwdAuthComposite.access$11(UserPwdAuthComposite.this, true, var2_5, 1, null);
                        }
                        var4_7 = this;
                        synchronized (var4_7) {
                            if (UserPwdAuthComposite.access$8(UserPwdAuthComposite.this) == Thread.currentThread()) {
                                UserPwdAuthComposite.access$9(UserPwdAuthComposite.this, null);
                            }
                        }
                        return;
                    }
                    catch (Throwable var1_3) {
                        UserPwdAuthComposite.access$14().warn("Failed to connect to remote resource: " + UserPwdAuthComposite.this.uriInfo, var1_3);
lbl35:
                        // 2 sources

                        var1_1 = NLS.bind((String)Msg.RemoteResourceDialog_connectSucceeded, (Object)string);
                        UserPwdAuthComposite.access$11(UserPwdAuthComposite.this, true, (String)var1_1, 2, null);
                        {
                            catch (Throwable var3_10) {
                                var4_8 = this;
                                synchronized (var4_8) {
                                    if (UserPwdAuthComposite.access$8(UserPwdAuthComposite.this) == Thread.currentThread()) {
                                        UserPwdAuthComposite.access$9(UserPwdAuthComposite.this, null);
                                    }
                                }
                                throw var3_10;
                            }
                        }
                    }
                    synchronized (var4_6) {
                        if (UserPwdAuthComposite.access$8(UserPwdAuthComposite.this) == Thread.currentThread()) {
                            UserPwdAuthComposite.access$9(UserPwdAuthComposite.this, null);
                        }
                    }
                    return;
                    var4_9 = this;
                    synchronized (var4_9) {
                        if (UserPwdAuthComposite.access$8(UserPwdAuthComposite.this) == Thread.currentThread()) {
                            UserPwdAuthComposite.access$9(UserPwdAuthComposite.this, null);
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    private void toggleAnonymousUser() {
        ControlUtil.enableControls((Control[])new Control[]{this.txtUsername, this.txtPassword}, (!this.btnAnonym.getSelection() ? 1 : 0) != 0);
        this.showUri();
    }

    private void updateToolbarVisibility() {
        String string = this.service().scheme();
        this.txtHost.setToolTipText(NLS.bind((String)Msg.RemoteResourceDialog_hostTooltip, (Object)(String.valueOf(string) + "://")));
        boolean bl = "sftp".equals(string) || "ftp".equals(string) || "ftps".equals(string);
        ((GridData)this.tbOptions.getLayoutData()).exclude = !bl;
        ((GridLayout)this.cmpHost.getLayout()).numColumns = bl ? 5 : 4;
        boolean bl2 = "sftp".equals(string);
        ((GridData)this.tbSsh.getLayoutData()).exclude = !bl2;
        ((GridLayout)this.cmpPwd.getLayout()).numColumns = bl2 ? 3 : 2;
        this.getShell().layout(true, true);
    }

    public UriInfo uriInfo() {
        return this.uriInfo;
    }

    @Override
    protected void uriInfoChanged(UriInfo uriInfo) {
        String string;
        if (uriInfo == null) {
            LOG.warn("uriInfo = null");
            return;
        }
        this.uriInfo = uriInfo;
        Map map = uriInfo.properties();
        if (!map.isEmpty()) {
            this.props = this.props();
            this.props.putAll(map);
        }
        if (StringUtil.isEmpty((String)(string = uriInfo.uri()))) {
            return;
        }
        try {
            this.uri = new URI(string, UriUtil.isEscaped((String)string));
            String string2 = uriInfo.username();
            String string3 = "";
            if (!string2.isEmpty()) {
                String string4 = UriUtil.constructUriPasswordPrefKey((String)string, (String)string2);
                string3 = SecurePrefsUtil.get(string4, "");
            }
            boolean bl = StringUtil.isEmpty((String)string2) || string2.equalsIgnoreCase("anonymous");
            String string5 = StringUtil.makeSafe((String)this.uri.getPath());
            if (bl) {
                this.setAnonymous(true);
            } else {
                this.txtUsername.setText(string2);
                this.txtPassword.setText(string3);
            }
            this.txtPath.setText(string5);
            this.txtHost.setText(StringUtil.makeSafe((String)this.uri.getHost()));
            this.schemeChanged(this.uri);
            ToolItem toolItem = this.tbSsh.getItem(0);
            String string6 = (String)uriInfo.property(UriInfoKey.SSH_KEY, (Object)"");
            if (!string6.isEmpty()) {
                toolItem.setToolTipText(string6);
            }
            this.txtHost.setToolTipText(NLS.bind((String)Msg.RemoteResourceDialog_hostTooltip, (Object)(String.valueOf(this.uri.getScheme()) + "://")));
        }
        catch (URIException uRIException) {
            LOG.error("Couldn't create URI for " + this.uri, (Throwable)uRIException);
        }
    }

    private boolean verifyPort(String string) {
        if (StringUtil.isEmpty((String)string)) {
            return false;
        }
        try {
            int n = Integer.parseInt(this.txtPort.getText());
            if (n < 0 || n > 65536) {
                throw new NumberFormatException();
            }
            IAlert iAlert = this.alert();
            if (ObjectUtil.areEqual((Object)(iAlert != null ? iAlert.getText() : null), (Object)Msg.RemoteResourceDialog_portNumberOutOfRange)) {
                this.showAlert(false, "", 0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.showAlert(true, Msg.RemoteResourceDialog_portNumberOutOfRange, 1);
            LOG.error(null, (Throwable)numberFormatException);
            return false;
        }
        return true;
    }

    static /* synthetic */ Thread access$8(UserPwdAuthComposite userPwdAuthComposite) {
        return userPwdAuthComposite.thread;
    }

    static /* synthetic */ void access$9(UserPwdAuthComposite userPwdAuthComposite, Thread thread) {
        userPwdAuthComposite.thread = thread;
    }

    static /* synthetic */ Text access$10(UserPwdAuthComposite userPwdAuthComposite) {
        return userPwdAuthComposite.txtPath;
    }

    static /* synthetic */ void access$11(UserPwdAuthComposite userPwdAuthComposite, boolean bl, String string, int n, Control control) {
        userPwdAuthComposite.showTestResult(bl, string, n, control);
    }

    static /* synthetic */ Text access$12(UserPwdAuthComposite userPwdAuthComposite) {
        return userPwdAuthComposite.txtUsername;
    }

    static /* synthetic */ Text access$13(UserPwdAuthComposite userPwdAuthComposite) {
        return userPwdAuthComposite.txtPassword;
    }

    static /* synthetic */ Logger access$14() {
        return LOG;
    }
}

