/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal.ui.dialogs;

import com.deltawalker.Addon;
import com.deltawalker.UriInfo;
import com.deltawalker.script.Role;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.IResourceDialog;
import com.deltawalker.ui.dialogs.PreferenceSheet;
import com.deltawalker.vfs.internal.ui.dialogs.AuthToken;
import com.deltawalker.vfs.internal.ui.dialogs.UserPwdAuthPage;
import com.deltawalker.vfs.internal.ui.dialogs.WebAuthComposite;
import com.deltawalker.vfs.internal.ui.dialogs.WebAuthPrefPage;
import com.deltopia.io.VfsService;
import com.deltopia.io.VfsUtil;
import com.deltopia.ui.concurrency.GuiExecutor;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.vfs2.provider.UriParser;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Button;

public class RemoteResourceSheet
extends PreferenceSheet
implements IResourceDialog {
    private static Set<Addon.Edition> availableIn = EnumSet.of(Addon.Edition.TRIAL, Addon.Edition.PRO, Addon.Edition.ORO);
    private IResourceDialogInfo dialogInfo = new IResourceDialogInfo(){

        @Override
        public boolean isFileDialog() {
            return RemoteResourceSheet.this.fileDialog;
        }

        @Override
        public boolean isOpen() {
            return RemoteResourceSheet.this.open;
        }

        @Override
        public UriInfo mruUriInfo() {
            return RemoteResourceSheet.this.mruUriInfo;
        }

        @Override
        public IPreferenceStore prefs() {
            return RemoteResourceSheet.this.getPreferenceStore();
        }

        @Override
        public Role role() {
            return RemoteResourceSheet.this.role;
        }

        @Override
        public String roleName() {
            return RemoteResourceSheet.this.roleName;
        }

        @Override
        public void updateButtons() {
            RemoteResourceSheet.this.updateButtons();
        }
    };
    private final boolean fileDialog;
    private UriInfo mruUriInfo;
    private WebAuthComposite.IAuthListener onAuth = new WebAuthComposite.IAuthListener(){

        @Override
        public void successfulAuth(AuthToken authToken) {
            RemoteResourceSheet.this.updateButtons();
        }

        @Override
        public void successfulDeAuth(AuthToken authToken) {
            RemoteResourceSheet.this.updateButtons();
        }
    };
    private final boolean open;
    private final Role role;
    private final String roleName;
    private UriInfo uriInfo;

    public RemoteResourceSheet(Role role, boolean bl, boolean bl2, String string, IPreferenceStore iPreferenceStore, UriInfo uriInfo) {
        super(UIUtil.getActiveWindowShell(), new PreferenceManager());
        this.role = role;
        this.fileDialog = bl;
        this.open = bl2;
        this.setPreferenceStore(iPreferenceStore);
        this.roleName = string;
        this.mruUriInfo = uriInfo;
        this.createPages();
    }

    private void createPages() {
        PreferenceManager preferenceManager = this.getPreferenceManager();
        VfsService vfsService = VfsService.FTP;
        preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(vfsService.scheme(), (IPreferencePage)new UserPwdAuthPage(vfsService, this.dialogInfo)));
        vfsService = VfsService.SFTP;
        preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(vfsService.scheme(), (IPreferencePage)new UserPwdAuthPage(vfsService, this.dialogInfo)));
        vfsService = VfsService.FTPS;
        preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(vfsService.scheme(), (IPreferencePage)new UserPwdAuthPage(vfsService, this.dialogInfo)));
        if (this.open && this.fileDialog) {
            vfsService = VfsService.HTTP;
            preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(vfsService.scheme(), (IPreferencePage)new UserPwdAuthPage(VfsService.HTTP, this.dialogInfo)));
            vfsService = VfsService.HTTPS;
            preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(vfsService.scheme(), (IPreferencePage)new UserPwdAuthPage(vfsService, this.dialogInfo)));
        }
        vfsService = VfsService.WEBDAV;
        preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(vfsService.scheme(), (IPreferencePage)new UserPwdAuthPage(vfsService, this.dialogInfo)));
        vfsService = VfsService.WEBDAVS;
        preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(vfsService.scheme(), (IPreferencePage)new UserPwdAuthPage(vfsService, this.dialogInfo)));
        vfsService = VfsService.DROPBOX;
        preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(vfsService.scheme(), (IPreferencePage)new WebAuthPrefPage(VfsService.DROPBOX, this.onAuth, this.dialogInfo, availableIn)));
        vfsService = VfsService.GOOGLE;
        preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(vfsService.scheme(), (IPreferencePage)new WebAuthPrefPage(vfsService, this.onAuth, this.dialogInfo, availableIn)));
    }

    protected void helpPressed() {
        UIUtil.showHelp((String)"open-remote-file", (UIUtil.HelpContext)UIUtil.HelpContext.DIALOG);
    }

    protected void okPressed() {
        this.uriInfo = this.selectedPage().uriInfo();
        super.okPressed();
    }

    public IRemoteResourcePrefPage selectedPage() {
        return (IRemoteResourcePrefPage)this.getSelectedPage();
    }

    public UriInfo show() {
        String string;
        if (this.mruUriInfo != null && !(string = this.mruUriInfo.uri()).isEmpty()) {
            PreferenceManager preferenceManager = this.getPreferenceManager();
            IPreferenceNode[] iPreferenceNodeArray = preferenceManager.getRootSubNodes();
            String string2 = UriParser.extractScheme(string);
            IPreferenceNode[] iPreferenceNodeArray2 = iPreferenceNodeArray;
            int n = iPreferenceNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPreferenceNode iPreferenceNode = iPreferenceNodeArray2[n2];
                IRemoteResourcePrefPage iRemoteResourcePrefPage = (IRemoteResourcePrefPage)iPreferenceNode.getPage();
                if (iRemoteResourcePrefPage.service().scheme().equals(string2)) {
                    this.setSelectedNode(iPreferenceNode.getId());
                    break;
                }
                ++n2;
            }
        }
        return super.open() == 0 ? this.uriInfo : null;
    }

    public void updateButtons() {
        GuiExecutor.instance().asyncExec(this.getParentShell().getDisplay(), new Runnable(){

            @Override
            public void run() {
                Button button = RemoteResourceSheet.this.getButton(0);
                if (button != null) {
                    IRemoteResourcePrefPage iRemoteResourcePrefPage = RemoteResourceSheet.this.selectedPage();
                    String string = iRemoteResourcePrefPage.service().scheme();
                    boolean bl = true;
                    if (VfsUtil.isCloudScheme((String)string)) {
                        bl = iRemoteResourcePrefPage.isDoneAuthorizing();
                    }
                    button.setEnabled(bl);
                }
            }
        });
    }

    static interface IRemoteResourcePrefPage {
        public boolean isDoneAuthorizing();

        public VfsService service();

        public UriInfo uriInfo();
    }

    static interface IResourceDialogInfo {
        public boolean isFileDialog();

        public boolean isOpen();

        public UriInfo mruUriInfo();

        public IPreferenceStore prefs();

        public Role role();

        public String roleName();

        public void updateButtons();
    }
}

