/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal.ui.dialogs;

import com.deltawalker.App;
import com.deltawalker.PrefKey;
import com.deltawalker.UriInfo;
import com.deltawalker.script.Role;
import com.deltawalker.ui.Alerts;
import com.deltawalker.ui.ControlUtil;
import com.deltawalker.ui.EncodingChooser;
import com.deltawalker.ui.IAlert;
import com.deltawalker.ui.LineEndingChooser;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.AlertTrayDialog;
import com.deltawalker.ui.dialogs.ILocalResourceDialog;
import com.deltawalker.vfs.internal.Msg;
import com.deltawalker.vfs.internal.SecurePrefsUtil;
import com.deltawalker.vfs.internal.VfsContextId;
import com.deltawalker.vfs.internal.VfsResourceFactory;
import com.deltawalker.vfs.internal.ui.dialogs.AuthToken;
import com.deltawalker.vfs.internal.ui.dialogs.PassphraseDialog;
import com.deltawalker.vfs.internal.ui.dialogs.WebAuthComposite;
import com.deltopia.ObjectUtil;
import com.deltopia.StringUtil;
import com.deltopia.io.FileType;
import com.deltopia.io.FileUtil;
import com.deltopia.io.TextEncoding;
import com.deltopia.io.UriInfoKey;
import com.deltopia.io.VfsService;
import com.deltopia.io.VfsUtil;
import com.deltopia.jface.util.DialogUtil;
import com.deltopia.ui.OSFileDialog;
import com.deltopia.ui.concurrency.GuiExecutor;
import com.deltopia.util.Checker;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import com.deltopia.vfs.util.UriUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.vfs2.provider.UriParser;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteResourceDialog
extends AlertTrayDialog
implements ILocalResourceDialog {
    private static final int HOST_WIDTH_HINT = 160;
    private static final Logger LOG = LoggerFactory.getLogger(RemoteResourceDialog.class);
    private Button btnAnonym;
    private Combo cbRecent;
    private Combo cbScheme;
    private WebAuthComposite cloudComposite;
    private Composite cmpHost;
    private Composite cmpPwd;
    private EncodingChooser csChooser;
    private TextEncoding encoding;
    private final boolean fileDialog;
    private Map<Control, Label> indicators;
    private int labelWidthHint;
    private LineEndingChooser leChooser;
    private String lineEnding;
    private Locale locale;
    private UriInfo mruUriInfo;
    private final FocusListener onFocus = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            Text text = (Text)focusEvent.widget;
            if (text.getEditable()) {
                text.selectAll();
                Boolean bl = text.getSelectionText().trim().length() != 0;
                RemoteResourceDialog.this.selections.put(text, bl);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            ((Text)focusEvent.widget).setSelection(0, 0);
        }
    };
    private KeyListener onKey = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            keyEvent.widget.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RemoteResourceDialog.this.showUri();
                }
            });
        }
    };
    private final MouseAdapter onMouse = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            ((Text)mouseEvent.widget).selectAll();
        }

        public void mouseDown(MouseEvent mouseEvent) {
            Text text = (Text)mouseEvent.widget;
            Boolean bl = (Boolean)RemoteResourceDialog.this.selections.get(text);
            if (bl != null && bl.booleanValue()) {
                text.selectAll();
                RemoteResourceDialog.this.selections.put(text, false);
            }
        }
    };
    private final boolean open;
    private final IPreferenceStore prefs;
    private Map<UriInfoKey, Object> props;
    private final List<UriInfo> recentUris = new ArrayList<UriInfo>();
    private final Role role;
    private final String roleName;
    Map<String, String> schemes = new LinkedHashMap<String, String>();
    private Map<Control, Boolean> selections = new HashMap<Control, Boolean>();
    private ToolBar tbOptions;
    private ToolBar tbSsh;
    private Thread thread;
    private Text txtHost;
    private Text txtPassword;
    private Text txtPath;
    private Text txtPort;
    private StyledText txtUri;
    private Text txtUsername;
    private URI uri;
    private UriInfo uriInfo;

    public RemoteResourceDialog(Role role, boolean bl, boolean bl2, String string, IPreferenceStore iPreferenceStore) {
        super(UIUtil.getActiveWindowShell());
        this.role = role;
        this.fileDialog = bl;
        this.open = bl2;
        this.prefs = iPreferenceStore;
        this.roleName = string;
        this.fillSchemeList();
    }

    private void addRecentUri(UriInfo uriInfo) {
        String string = uriInfo.uri();
        if (VfsUtil.hasRemoteScheme((String)string) && this.getSchemeIndex(UriParser.extractScheme(string)) != -1) {
            this.cbRecent.add(string);
            this.recentUris.add(uriInfo);
        }
    }

    private void calculateLabelWidthHint(Control control) {
        String string = NLS.bind((String)Msg.RemoteResourceDialog_initialPath, (Object)(this.fileDialog ? Msg.RemoteResourceDialog_file : Msg.RemoteResourceDialog_folder));
        this.labelWidthHint = UIUtil.stringExtent((String)string, (Control)control);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private void clearIndicators() {
        if (this.indicators == null || this.indicators.isEmpty()) {
            return;
        }
        for (Control control : this.indicators.values()) {
            Composite composite = control.getParent();
            --((GridLayout)composite.getLayout()).numColumns;
            control.dispose();
            composite.layout();
        }
        this.indicators.clear();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        UIUtil.setHelpContextId((Control)shell, (String)VfsContextId.REMOTE_RESOURCE_DIALOG);
    }

    private String constructPath(String string) {
        string = string.replace('\\', '/').trim();
        String string2 = string = (string = string.replaceAll("//", "/")).startsWith("/") ? string : "/" + string;
        if (this.fileDialog) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            string = string.endsWith("/") ? string : String.valueOf(string) + "/";
        }
        return UriUtil.escapeUriComponent((String)string, (String)"/");
    }

    private String constructUri(boolean bl) {
        String string;
        String string2 = this.getSelectedScheme();
        boolean bl2 = VfsUtil.isCloudScheme((String)string2);
        string2 = String.valueOf(string2) + "://";
        if (bl2) {
            string = string2;
            AuthToken authToken = this.cloudComposite.getAuthToken();
            if (authToken != null) {
                this.setProperty(UriInfoKey.AUTH_TOKEN, authToken.getToken());
            }
        } else {
            String string3;
            if (!this.isAnonymous()) {
                String string4;
                string3 = this.txtUsername.getText().trim();
                if (!string3.isEmpty()) {
                    this.setProperty(UriInfoKey.USERNAME, string3);
                }
                if (!(string4 = this.txtPassword.getText().trim()).isEmpty()) {
                    this.setProperty(UriInfoKey.PASSWORD, string4);
                }
            }
            string3 = this.txtPort.getText();
            boolean bl3 = this.isExplicit();
            int n = this.verifyPort(string3) ? Integer.parseInt(string3) : VfsUtil.getDefaultPort((String)string2, (boolean)bl3);
            string3 = n == VfsUtil.getDefaultPort((String)string2, (boolean)bl3) ? "" : String.valueOf(':') + new Integer(n).toString();
            string = String.valueOf(this.getHost()) + string3;
            String string5 = this.constructPath(this.txtPath.getText());
            string = string.length() == 0 && string5.equals("/") ? string2 : String.valueOf(string2) + string + string5;
        }
        return string;
    }

    private UriInfo constructUriInfo() {
        String string;
        String string2;
        Object object;
        Object object2;
        String string3 = this.constructUri(false);
        FileType fileType = FileType.FOLDER;
        if (this.fileDialog) {
            object2 = null;
            object = null;
            if (this.csChooser.isCharsetSelected()) {
                object = this.csChooser.getSelectedEncoding(false);
                if (object != null) {
                    this.props().put(UriInfoKey.ENCODING, object.charset());
                    this.props().put(UriInfoKey.BOM, object.bom());
                }
            } else {
                object2 = this.csChooser.getSelectedLocale();
                if (object2 != null) {
                    this.props().put(UriInfoKey.LOCALE, object2);
                }
            }
            if (!StringUtil.isEmpty((String)(string2 = this.leChooser.getSelectedLineEnding()))) {
                this.props().put(UriInfoKey.LINE_ENDING, string2);
            }
            fileType = FileType.FILE;
        }
        this.isUserDirRoot();
        this.uriInfo = new UriInfo(string3, fileType, null, null, this.props());
        object2 = this.uriInfo.username();
        object = this.uriInfo.password();
        string2 = this.uriInfo.sshPassphrase();
        if (!string2.isEmpty()) {
            string = UriUtil.constructSshPassphrasePrefKey((String)string3, (String)object2);
            SecurePrefsUtil.put(string, string2);
        }
        if (!((String)object).isEmpty()) {
            string = UriUtil.constructUriPasswordPrefKey((String)string3, (String)object2);
            SecurePrefsUtil.put(string, (String)object);
        }
        return this.uriInfo;
    }

    private void createAuthenticationControls(Composite composite) {
        Composite composite2 = DialogUtil.createComposite((Composite)composite, (int)3, (int)769, (boolean)false);
        this.btnAnonym = new Button(composite2, 32);
        this.btnAnonym.setText(Msg.RemoteResourceDialog_anonymous);
        this.btnAnonym.setSelection(false);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 3;
        this.btnAnonym.setLayoutData((Object)gridData);
        Composite composite3 = DialogUtil.createComposite((Composite)composite, (int)3, (int)769, (boolean)false);
        Label label = new Label(composite3, 0);
        label.setText(Msg.RemoteResourceDialog_username);
        this.setLabelWidthHint((Control)label);
        this.txtUsername = new Text(composite3, 2048);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        this.txtUsername.setLayoutData((Object)gridData);
        this.cmpPwd = DialogUtil.createComposite((Composite)composite, (int)3, (int)769, (boolean)false);
        label = new Label(this.cmpPwd, 0);
        label.setText(Msg.RemoteResourceDialog_password);
        this.setLabelWidthHint((Control)label);
        this.txtPassword = new Text(this.cmpPwd, 0x400800);
        gridData = new GridData(4, 0x1000000, true, false);
        this.txtPassword.setLayoutData((Object)gridData);
        this.createSshToolbar(this.cmpPwd);
        this.cmpPwd.layout();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        if (OS.OSX) {
            this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
            this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        } else {
            this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    private void createCharsetChooser(Composite composite, IPreferenceStore iPreferenceStore) {
        Composite composite2 = DialogUtil.createComposite((Composite)composite, (int)2, (int)769, (boolean)false);
        this.createEncodingControls(composite2, iPreferenceStore);
        this.createDelimiterControls(composite2, iPreferenceStore);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        UIUtil.enforceMinDialogSize((Shell)this.getShell());
        return control;
    }

    private void createDelimiterControls(Composite composite, IPreferenceStore iPreferenceStore) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)gridData);
        label.setText(UIMsg.FileDlg_lineEnding);
        this.leChooser = new LineEndingChooser(composite, 12, false, true, iPreferenceStore);
        this.leChooser.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        String string = this.fileDialog ? Msg.RemoteResourceDialog_file : Msg.RemoteResourceDialog_folder;
        String string2 = this.open ? Msg.RemoteResourceDialog_selectTitle : Msg.RemoteResourceDialog_saveTitle;
        this.getShell().setText(NLS.bind((String)string2, (Object)this.roleName, (Object)string));
        this.createUriControl(composite2);
        this.createRecentControl(composite2);
        DialogUtil.insertSpace((Composite)composite2, (boolean)true);
        this.createHostControls(composite2);
        this.fillSchemeCombo();
        this.fillRecentCombo();
        DialogUtil.insertSpace((Composite)composite2, (boolean)true);
        this.createAuthenticationControls(composite2);
        if (this.fileDialog) {
            DialogUtil.insertSpace((Composite)composite2, (boolean)true);
            this.createCharsetChooser(composite2, this.prefs);
            if (this.locale != null) {
                this.csChooser.setSelectedLocale(this.locale);
            } else if (this.encoding != null) {
                this.csChooser.setSelectedEncoding(this.encoding);
            }
            if (!StringUtil.isEmpty((String)this.lineEnding)) {
                this.leChooser.setSelectedDelimiter(this.lineEnding);
            }
        }
        this.cloudComposite = new WebAuthComposite(composite, 0, new WebAuthComposite.IAuthListener(){

            @Override
            public void successfulAuth(AuthToken authToken) {
                GuiExecutor.instance().asyncExec(RemoteResourceDialog.this.getParentShell().getDisplay(), new Runnable(){

                    @Override
                    public void run() {
                        RemoteResourceDialog.this.updateButtons();
                    }
                });
            }

            @Override
            public void successfulDeAuth(AuthToken authToken) {
                RemoteResourceDialog.this.getParentShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RemoteResourceDialog.this.updateButtons();
                    }
                });
            }
        }, null, null);
        this.createTestControl(composite2);
        this.installListeners();
        if (this.mruUriInfo != null) {
            this.uriInfoChanged(this.mruUriInfo);
        }
        this.toggleAnonymousUser();
        this.initializePort();
        this.updateToolbarVisibility();
        DialogUtil.removeControlFromTabOrder((Control)this.txtUri, (Composite)composite2);
        RemoteResourceDialog.applyDialogFont((Control)composite2);
        this.txtHost.setFocus();
        return composite2;
    }

    private void createEncodingControls(Composite composite, IPreferenceStore iPreferenceStore) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)gridData);
        label.setText(UIMsg.FileDlg_encoding);
        this.csChooser = new EncodingChooser(composite, 12, false, this.open, iPreferenceStore);
        this.csChooser.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void createHostControls(Composite composite) {
        Composite composite2 = DialogUtil.createComposite((Composite)composite, (int)4, (int)769, (boolean)false);
        Label label = new Label(composite2, 0);
        label.setText("Protocol:");
        this.setLabelWidthHint((Control)label);
        this.cbScheme = new Combo(composite2, 2060);
        this.cbScheme.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(composite2, 0);
        label.setText(Msg.RemoteResourceDialog_port);
        this.txtPort = new Text(composite2, 2048);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = UIUtil.stringExtent((String)"99999", (Control)this.txtPort);
        this.txtPort.setLayoutData((Object)gridData);
        this.cmpHost = DialogUtil.createComposite((Composite)composite, (int)3, (int)769, (boolean)false);
        label = new Label(this.cmpHost, 0);
        label.setText(Msg.RemoteResourceDialog_server);
        this.setLabelWidthHint((Control)label);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(160);
        this.txtHost = new Text(this.cmpHost, 2048);
        this.txtHost.setLayoutData((Object)gridData);
        this.createOptionsToolbar(this.cmpHost);
        this.cmpHost.layout();
        Composite composite3 = DialogUtil.createComposite((Composite)composite, (int)4, (int)769, (boolean)false);
        label = new Label(composite3, 0);
        String string = this.fileDialog ? Msg.RemoteResourceDialog_file : Msg.RemoteResourceDialog_folder;
        label.setText(NLS.bind((String)Msg.RemoteResourceDialog_initialPath, (Object)string));
        this.setLabelWidthHint((Control)label);
        this.txtPath = new Text(composite3, 2048);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 3;
        this.txtPath.setLayoutData((Object)gridData);
        this.txtPath.setToolTipText(NLS.bind((String)Msg.RemoteResourceDialog_pathTooltip, (Object)string.toLowerCase()));
    }

    private Menu createOptionsMenu(Composite composite) {
        boolean bl;
        MenuItem menuItem;
        assert (composite != null);
        Menu menu = new Menu((Control)composite);
        String string = this.getSelectedScheme();
        if ("ftps".equals(string)) {
            menuItem = new MenuItem(menu, 32);
            menuItem.setText(Msg.RemoteResourceDialog_explicit);
            bl = this.isExplicit();
            menuItem.setSelection(bl);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RemoteResourceDialog.this.setProperty(UriInfoKey.EXPLICIT_MODE, menuItem.getSelection());
                    RemoteResourceDialog.this.schemeChanged(null);
                }
            });
        }
        if ("ftp".equals(string) || "ftps".equals(string)) {
            menuItem = new MenuItem(menu, 32);
            menuItem.setText(Msg.RemoteResourceDialog_passive);
            bl = this.isPassive();
            menuItem.setSelection(bl);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RemoteResourceDialog.this.setProperty(UriInfoKey.PASSIVE_MODE, menuItem.getSelection());
                }
            });
        }
        assert ("ftp".equals(string) || "sftp".equals(string) || "ftps".equals(string));
        menuItem = new MenuItem(menu, 32);
        menuItem.setText(Msg.RemoteResourceDialog_userDir);
        bl = this.isUserDirRoot();
        menuItem.setSelection(bl);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RemoteResourceDialog.this.setProperty(UriInfoKey.USER_DIR_IS_ROOT, menuItem.getSelection());
            }
        });
        return menu;
    }

    private void createOptionsToolbar(final Composite composite) {
        assert (composite != null);
        this.tbOptions = new ToolBar(composite, 0);
        this.tbOptions.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final ToolItem toolItem = new ToolItem(this.tbOptions, 4);
        toolItem.setText(Msg.RemoteResourceDialog_options);
        toolItem.setToolTipText(Msg.RemoteResourceDialog_optionsTooltip);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Rectangle rectangle = toolItem.getBounds();
                Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                point = RemoteResourceDialog.this.tbOptions.toDisplay(point);
                Menu menu = RemoteResourceDialog.this.createOptionsMenu(composite);
                menu.setLocation(point.x, point.y);
                menu.setVisible(true);
            }
        });
        this.tbOptions.pack();
    }

    private void createRecentControl(Composite composite) {
        Composite composite2 = DialogUtil.createComposite((Composite)composite, (int)2, (int)769, (boolean)false);
        Label label = new Label(composite2, 0);
        label.setText(Msg.RemoteResourceDialog_recent);
        this.cbRecent = new Combo(composite2, 2060);
        this.cbRecent.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void createSshToolbar(Composite composite) {
        this.tbSsh = new ToolBar(composite, 0);
        this.tbSsh.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final Menu menu = new Menu((Control)composite);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(Msg.RemoteResourceDialog_selectKey);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = String.valueOf(Const.USER_HOME) + "/.ssh";
                if (!FileUtil.absolutelyExists((String)string)) {
                    string = Const.USER_HOME;
                }
                OSFileDialog oSFileDialog = new OSFileDialog(RemoteResourceDialog.this.getShell(), 4096);
                if (FileUtil.absolutelyExists((String)string)) {
                    oSFileDialog.setFilterPath(string);
                    oSFileDialog.setFileName("id_rsa");
                }
                if (FileUtil.absolutelyExists((String)(string = oSFileDialog.open())) && new File(string).isFile()) {
                    RemoteResourceDialog.this.setProperty(UriInfoKey.SSH_KEY, string);
                } else {
                    RemoteResourceDialog.this.removeProperty(UriInfoKey.SSH_KEY);
                }
            }
        });
        MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.setText(Msg.RemoteResourceDialog_specifyPassphrase);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PassphraseDialog passphraseDialog = new PassphraseDialog(RemoteResourceDialog.this.getShell());
                String string = "";
                if (RemoteResourceDialog.this.mruUriInfo != null && !(string = RemoteResourceDialog.this.mruUriInfo.sshPassphrase()).isEmpty()) {
                    passphraseDialog.setPassphrase(string);
                }
                if (passphraseDialog.open() == 0) {
                    string = passphraseDialog.getPassphrase();
                    RemoteResourceDialog.this.setProperty(UriInfoKey.SSH_PASSPHRASE, string);
                }
            }
        });
        final ToolItem toolItem = new ToolItem(this.tbSsh, 4);
        MenuItem menuItem3 = new MenuItem(menu, 8);
        menuItem3.setText(Msg.RemoteResourceDialog_clearSettings);
        menuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RemoteResourceDialog.this.removeProperty(UriInfoKey.SSH_KEY);
                RemoteResourceDialog.this.removeProperty(UriInfoKey.SSH_PASSPHRASE);
                toolItem.setToolTipText(Msg.RemoteResourceDialog_sshTooltip);
            }
        });
        toolItem.setText(Msg.RemoteResourceDialog_ssh);
        toolItem.setToolTipText(Msg.RemoteResourceDialog_sshTooltip);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Rectangle rectangle = toolItem.getBounds();
                Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                point = RemoteResourceDialog.this.tbSsh.toDisplay(point);
                menu.setLocation(point.x, point.y);
                menu.setVisible(true);
            }
        });
        this.tbSsh.pack();
    }

    private void createTestControl(Composite composite) {
        Composite composite2 = DialogUtil.createComposite((Composite)composite, (int)1, (int)769, (boolean)false);
        Button button = new Button(composite2, 0);
        button.setText(Msg.RemoteResourceDialog_testConnection);
        button.setLayoutData((Object)new GridData(0x1000008, 0, true, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RemoteResourceDialog.this.testConnection();
            }
        });
    }

    private void createUriControl(Composite composite) {
        this.txtUri = new StyledText(composite, 74);
        this.txtUri.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtUri.setBackground(composite.getBackground());
    }

    private void fillRecentCombo() {
        List list = App.instance().docBoss().recentUriInfos(this.fileDialog ? FileType.FILE : FileType.FOLDER, this.role);
        for (UriInfo uriInfo : list) {
            this.addRecentUri(uriInfo);
        }
        int n = this.cbRecent.getItemCount();
        if (n > 0) {
            this.selectMruUriInRecentCombo();
        }
    }

    private void fillSchemeCombo() {
        this.cbScheme.setItems(this.schemes.keySet().toArray(new String[this.schemes.size()]));
        this.cbScheme.select(0);
        this.cbScheme.setVisibleItemCount(this.cbScheme.getItemCount());
    }

    private void fillSchemeList() {
        this.schemes.put(Msg.RemoteResourceDialog_scheme_ftp, VfsService.FTP.scheme());
        this.schemes.put(Msg.RemoteResourceDialog_scheme_sftp, VfsService.SFTP.scheme());
        this.schemes.put(Msg.RemoteResourceDialog_scheme_ftps, VfsService.FTPS.scheme());
        if (this.open && this.fileDialog) {
            this.schemes.put(Msg.RemoteResourceDialog_scheme_http, VfsService.HTTP.scheme());
            this.schemes.put(Msg.RemoteResourceDialog_scheme_https, VfsService.HTTPS.scheme());
        }
        this.schemes.put(Msg.RemoteResourceDialog_scheme_webdav, VfsService.WEBDAV.scheme());
        this.schemes.put(Msg.RemoteResourceDialog_scheme_webdavs, VfsService.WEBDAVS.scheme());
        this.schemes.put(Msg.RemoteResourceDialog_scheme_dropbox, VfsService.DROPBOX.scheme());
        this.schemes.put(Msg.RemoteResourceDialog_scheme_googleDrive, VfsService.GOOGLE.scheme());
    }

    public String[] getFilterExtensions() {
        return null;
    }

    public String[] getFilterNames() {
        return null;
    }

    public String getFilterPath() {
        return null;
    }

    private String getHost() {
        String string = String.valueOf(this.getSelectedScheme()) + "://";
        String string2 = this.txtHost.getText().trim();
        if (string2.startsWith(string)) {
            string2 = string2.substring(string.length(), string2.length());
        }
        if (string.equalsIgnoreCase("webdav://") && string2.startsWith("http://")) {
            string2 = string2.substring("http://".length(), string2.length());
        }
        if (string.equalsIgnoreCase("webdavs://") && string2.startsWith("https://")) {
            string2 = string2.substring("https://".length(), string2.length());
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private String getMruUriInfo() {
        return this.mruUriInfo != null ? this.mruUriInfo.uri() : "";
    }

    private int getPort(URI uRI) {
        int n;
        int n2 = n = uRI != null ? uRI.getPort() : -1;
        if (n != -1) {
            return n;
        }
        String string = uRI != null ? uRI.getScheme() : this.getSelectedScheme();
        return VfsUtil.getDefaultPort((String)string, (boolean)this.isExplicit());
    }

    public Object getProperty(UriInfoKey uriInfoKey) {
        return this.props().get(uriInfoKey);
    }

    private int getSchemeIndex(String string) {
        String string2 = StringUtil.makeSafe((String)string).toLowerCase();
        int n = 0;
        for (Map.Entry<String, String> entry : this.schemes.entrySet()) {
            if (entry.getValue().equals(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private String getSelectedScheme() {
        return this.schemes.get(this.cbScheme.getText());
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x10000000;
    }

    protected void helpPressed() {
        UIUtil.showHelp((String)"open-remote-file", (UIUtil.HelpContext)UIUtil.HelpContext.DIALOG);
    }

    protected void initializeBounds() {
        this.showUri();
        this.getShell().layout(true, true);
        super.initializeBounds();
    }

    private void initializePort() {
        this.txtPort.setText(Integer.toString(this.getPort(this.uri)));
    }

    private void installListeners() {
        this.cbRecent.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = RemoteResourceDialog.this.cbRecent.getSelectionIndex();
                RemoteResourceDialog.this.uriInfoChanged(n == -1 ? null : (UriInfo)RemoteResourceDialog.this.recentUris.get(n));
            }
        });
        this.cbScheme.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RemoteResourceDialog.this.schemeChanged(null);
            }
        });
        this.btnAnonym.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RemoteResourceDialog.this.toggleAnonymousUser();
            }
        });
        this.txtHost.addKeyListener(this.onKey);
        this.txtPath.addKeyListener(this.onKey);
        this.txtPort.addKeyListener(this.onKey);
        this.txtUsername.addKeyListener(this.onKey);
        this.txtHost.addFocusListener(this.onFocus);
        this.txtHost.addMouseListener((MouseListener)this.onMouse);
        this.txtPort.addFocusListener(this.onFocus);
        this.txtPort.addMouseListener((MouseListener)this.onMouse);
        this.txtPath.addFocusListener(this.onFocus);
        this.txtPath.addMouseListener((MouseListener)this.onMouse);
        this.txtUsername.addFocusListener(this.onFocus);
        this.txtUsername.addMouseListener((MouseListener)this.onMouse);
        this.txtPassword.addFocusListener(this.onFocus);
        this.txtPassword.addMouseListener((MouseListener)this.onMouse);
    }

    private boolean isAnonymous() {
        return this.btnAnonym.getSelection();
    }

    private boolean isExplicit() {
        Boolean bl = (Boolean)this.getProperty(UriInfoKey.EXPLICIT_MODE);
        boolean bl2 = bl != null ? bl.booleanValue() : this.prefs.getBoolean(PrefKey.R_EXPLICIT_MODE.toString());
        return bl2;
    }

    private boolean isPassive() {
        Boolean bl = (Boolean)this.getProperty(UriInfoKey.PASSIVE_MODE);
        boolean bl2 = bl != null ? bl.booleanValue() : this.prefs.getBoolean(PrefKey.R_PASSIVE_MODE.toString());
        return bl2;
    }

    private boolean isUserDirRoot() {
        boolean bl = true;
        Boolean bl2 = (Boolean)this.getProperty(UriInfoKey.USER_DIR_IS_ROOT);
        if (bl2 != null) {
            bl = bl2;
        } else {
            bl = this.prefs.getBoolean(PrefKey.R_USER_DIR_IS_ROOT.toString());
            this.setProperty(UriInfoKey.USER_DIR_IS_ROOT, bl);
        }
        return bl;
    }

    protected void okPressed() {
        this.constructUriInfo();
        super.okPressed();
    }

    private Map<UriInfoKey, Object> props() {
        if (this.props == null) {
            this.props = new HashMap<UriInfoKey, Object>(2);
        }
        return this.props;
    }

    public void removeProperty(UriInfoKey uriInfoKey) {
        this.props().remove(uriInfoKey);
    }

    private void schemeChanged(URI uRI) {
        this.txtPort.setText(Integer.toString(this.getPort(uRI)));
        this.showUri();
        this.updateToolbarVisibility();
        if (uRI != null) {
            uRI.getScheme();
        } else {
            this.getSelectedScheme();
        }
        this.updateButtons();
    }

    private void selectMruUriInRecentCombo() {
        if (this.mruUriInfo == null) {
            return;
        }
        String string = this.getMruUriInfo();
        assert (!string.isEmpty());
        int n = this.recentUris.indexOf(this.mruUriInfo);
        if (n == 0) {
            this.cbRecent.select(0);
        } else {
            this.cbRecent.add(string, 0);
            this.cbRecent.select(0);
            this.cbRecent.setVisibleItemCount(this.cbRecent.getItemCount());
        }
    }

    private void setAnonymous(boolean bl) {
        this.btnAnonym.setSelection(bl);
        this.toggleAnonymousUser();
    }

    public void setFilterExtensions(String[] stringArray) {
    }

    public void setFilterNames(String[] stringArray) {
    }

    public void setFilterPath(String string) {
    }

    private void setLabelWidthHint(Control control) {
        if (this.labelWidthHint == 0) {
            this.calculateLabelWidthHint(control);
        }
        GridData gridData = new GridData();
        gridData.widthHint = this.labelWidthHint;
        control.setLayoutData((Object)gridData);
    }

    public void setProperty(UriInfoKey uriInfoKey, Object object) {
        this.props().put(uriInfoKey, object);
    }

    public void setSelectedEncoding(TextEncoding textEncoding) {
        this.encoding = (TextEncoding)Checker.notNull((Object)textEncoding, (String)"encoding");
    }

    public void setSelectedLineEnding(String string) {
        this.lineEnding = string;
    }

    public void setSelectedLocale(Locale locale) {
        this.locale = locale;
    }

    public void setShowLineEnding(boolean bl) {
    }

    public UriInfo show() {
        return this.open() == 0 ? this.uriInfo : null;
    }

    private void showIndicator(Control control) {
    }

    private void showTestResult(final Shell shell, final boolean bl, final String string, final int n, final Control control) {
        if (shell.isDisposed()) {
            return;
        }
        if (Thread.currentThread().equals(shell.getDisplay().getThread())) {
            this.showAlert(bl, string, n);
            if (control != null) {
                this.showIndicator(control);
            }
        } else {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!shell.isDisposed()) {
                        RemoteResourceDialog.this.showAlert(bl, string, n);
                        if (control != null) {
                            RemoteResourceDialog.this.showIndicator(control);
                        }
                    }
                }
            });
        }
    }

    private void showUnknownHostError() {
        String string = NLS.bind((String)Msg.RemoteResourceDialog_unknownHost, (Object)this.txtHost.getText());
        this.showTestResult(this.getShell(), true, string, 1, (Control)this.txtHost);
    }

    private void showUri() {
        String string = this.constructUri(true);
        this.txtUri.setText(string);
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = string.length();
        styleRange.fontStyle = 1;
        this.txtUri.setStyleRange(styleRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection() {
        if (StringUtil.isEmpty((String)this.txtHost.getText())) {
            return;
        }
        final Shell shell = this.getShell();
        this.showAlert(true, NLS.bind((String)Msg.RemoteResourceDialog_connecting, (Object)this.cbScheme.getText()), 2);
        this.clearIndicators();
        final String string = this.getSelectedScheme();
        RemoteResourceDialog remoteResourceDialog = this;
        synchronized (remoteResourceDialog) {
            this.constructUriInfo();
            try {
                URI uRI = new URI(this.uriInfo.uri(), true);
                String string2 = uRI.getHost();
                InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                this.showUnknownHostError();
                return;
            }
            catch (URIException uRIException) {
                this.showUnknownHostError();
                return;
            }
            this.thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    try {
                        var1_1 = VfsResourceFactory.staticResolveFile(RemoteResourceDialog.access$17(RemoteResourceDialog.this));
                        if (var1_1.getType() != org.apache.commons.vfs2.FileType.IMAGINARY) ** GOTO lbl35
                        var2_4 = Msg.RemoteResourceDialog_invalidUri;
                        RemoteResourceDialog.access$19(RemoteResourceDialog.this, shell, true, var2_4, 1, (Control)RemoteResourceDialog.access$18(RemoteResourceDialog.this));
                        var4_6 = this;
                    }
                    catch (IOException var1_2) {
                        var2_5 = Alerts.fetchErrorMessage((Throwable)var1_2);
                        if (var2_5.indexOf(" as user ") != -1) {
                            RemoteResourceDialog.access$19(RemoteResourceDialog.this, shell, true, var2_5, 1, (Control)RemoteResourceDialog.access$20(RemoteResourceDialog.this));
                            RemoteResourceDialog.access$19(RemoteResourceDialog.this, shell, true, var2_5, 1, (Control)RemoteResourceDialog.access$21(RemoteResourceDialog.this));
                        } else {
                            RemoteResourceDialog.access$19(RemoteResourceDialog.this, shell, true, var2_5, 1, null);
                        }
                        var4_7 = this;
                        synchronized (var4_7) {
                            if (RemoteResourceDialog.access$15(RemoteResourceDialog.this) == Thread.currentThread()) {
                                RemoteResourceDialog.access$16(RemoteResourceDialog.this, null);
                            }
                        }
                        return;
                    }
                    catch (Throwable var1_3) {
                        RemoteResourceDialog.access$22().warn("Failed to connect to remote resource: " + RemoteResourceDialog.access$17(RemoteResourceDialog.this), var1_3);
lbl35:
                        // 2 sources

                        var1_1 = NLS.bind((String)Msg.RemoteResourceDialog_connectSucceeded, (Object)string);
                        RemoteResourceDialog.access$19(RemoteResourceDialog.this, shell, true, (String)var1_1, 2, null);
                        {
                            catch (Throwable var3_10) {
                                var4_8 = this;
                                synchronized (var4_8) {
                                    if (RemoteResourceDialog.access$15(RemoteResourceDialog.this) == Thread.currentThread()) {
                                        RemoteResourceDialog.access$16(RemoteResourceDialog.this, null);
                                    }
                                }
                                throw var3_10;
                            }
                        }
                    }
                    synchronized (var4_6) {
                        if (RemoteResourceDialog.access$15(RemoteResourceDialog.this) == Thread.currentThread()) {
                            RemoteResourceDialog.access$16(RemoteResourceDialog.this, null);
                        }
                    }
                    return;
                    var4_9 = this;
                    synchronized (var4_9) {
                        if (RemoteResourceDialog.access$15(RemoteResourceDialog.this) == Thread.currentThread()) {
                            RemoteResourceDialog.access$16(RemoteResourceDialog.this, null);
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    private void toggleAnonymousUser() {
        ControlUtil.enableControls((Control[])new Control[]{this.txtUsername, this.txtPassword}, (!this.btnAnonym.getSelection() ? 1 : 0) != 0);
        this.showUri();
    }

    private void updateButtons() {
        Button button;
        String string = this.getSelectedScheme();
        boolean bl = true;
        if (VfsUtil.isCloudScheme((String)string)) {
            bl = this.cloudComposite.isDoneAuthorizing();
        }
        if ((button = this.getButton(0)) != null) {
            button.setEnabled(bl);
        }
    }

    private void updateToolbarVisibility() {
        String string = this.getSelectedScheme();
        this.txtHost.setToolTipText(NLS.bind((String)Msg.RemoteResourceDialog_hostTooltip, (Object)(String.valueOf(string) + "://")));
        boolean bl = "sftp".equals(string) || "ftp".equals(string) || "ftps".equals(string);
        ((GridData)this.tbOptions.getLayoutData()).exclude = !bl;
        ((GridLayout)this.cmpHost.getLayout()).numColumns = bl ? 3 : 2;
        boolean bl2 = "sftp".equals(string);
        ((GridData)this.tbSsh.getLayoutData()).exclude = !bl2;
        ((GridLayout)this.cmpPwd.getLayout()).numColumns = bl2 ? 3 : 2;
        this.getShell().layout(true, true);
    }

    private void uriInfoChanged(UriInfo uriInfo) {
        String string;
        assert (uriInfo != null);
        this.uriInfo = uriInfo;
        Map map = uriInfo.properties();
        if (!map.isEmpty()) {
            this.props = this.props();
            this.props.putAll(map);
        }
        if (StringUtil.isEmpty((String)(string = uriInfo.uri()))) {
            return;
        }
        try {
            this.uri = new URI(string, UriUtil.isEscaped((String)string));
            String string2 = uriInfo.username();
            String string3 = "";
            if (!string2.isEmpty()) {
                String string4 = UriUtil.constructUriPasswordPrefKey((String)string, (String)string2);
                string3 = SecurePrefsUtil.get(string4, "");
            }
            boolean bl = StringUtil.isEmpty((String)string2) || string2.equalsIgnoreCase("anonymous");
            String string5 = StringUtil.makeSafe((String)this.uri.getPath());
            if (bl) {
                this.setAnonymous(true);
            } else {
                this.txtUsername.setText(string2);
                this.txtPassword.setText(string3);
            }
            this.txtPath.setText(string5);
            this.txtHost.setText(StringUtil.makeSafe((String)this.uri.getHost()));
            int n = this.getSchemeIndex(this.uri.getScheme());
            if (n != -1) {
                this.cbScheme.select(n);
            }
            this.schemeChanged(this.uri);
            ToolItem toolItem = this.tbSsh.getItem(0);
            String string6 = (String)uriInfo.property(UriInfoKey.SSH_KEY, (Object)"");
            if (!string6.isEmpty()) {
                toolItem.setToolTipText(string6);
            }
            this.txtHost.setToolTipText(NLS.bind((String)Msg.RemoteResourceDialog_hostTooltip, (Object)(String.valueOf(this.uri.getScheme()) + "://")));
        }
        catch (URIException uRIException) {
            LOG.error("Couldn't create URI for " + this.uri, (Throwable)uRIException);
        }
    }

    private boolean verifyPort(String string) {
        if (StringUtil.isEmpty((String)string)) {
            return false;
        }
        try {
            int n = Integer.parseInt(this.txtPort.getText());
            if (n < 0 || n > 65536) {
                throw new NumberFormatException();
            }
            IAlert iAlert = this.alert();
            if (ObjectUtil.areEqual((Object)(iAlert != null ? iAlert.getText() : null), (Object)Msg.RemoteResourceDialog_portNumberOutOfRange)) {
                this.showAlert(false, "", 0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.showAlert(true, Msg.RemoteResourceDialog_portNumberOutOfRange, 1);
            LOG.error(null, (Throwable)numberFormatException);
            return false;
        }
        return true;
    }

    static /* synthetic */ Thread access$15(RemoteResourceDialog remoteResourceDialog) {
        return remoteResourceDialog.thread;
    }

    static /* synthetic */ void access$16(RemoteResourceDialog remoteResourceDialog, Thread thread) {
        remoteResourceDialog.thread = thread;
    }

    static /* synthetic */ UriInfo access$17(RemoteResourceDialog remoteResourceDialog) {
        return remoteResourceDialog.uriInfo;
    }

    static /* synthetic */ Text access$18(RemoteResourceDialog remoteResourceDialog) {
        return remoteResourceDialog.txtPath;
    }

    static /* synthetic */ void access$19(RemoteResourceDialog remoteResourceDialog, Shell shell, boolean bl, String string, int n, Control control) {
        remoteResourceDialog.showTestResult(shell, bl, string, n, control);
    }

    static /* synthetic */ Text access$20(RemoteResourceDialog remoteResourceDialog) {
        return remoteResourceDialog.txtUsername;
    }

    static /* synthetic */ Text access$21(RemoteResourceDialog remoteResourceDialog) {
        return remoteResourceDialog.txtPassword;
    }

    static /* synthetic */ Logger access$22() {
        return LOG;
    }
}

