/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal.ui.dialogs;

import com.deltawalker.vfs.internal.ui.dialogs.AuthToken;
import com.deltawalker.vfs.internal.ui.dialogs.CloudDeauthFlow;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import java.io.IOException;
import java.security.GeneralSecurityException;

final class GoogleDeAuthFlow
extends CloudDeauthFlow {
    private NetHttpTransport httpTransport;

    protected GoogleDeAuthFlow(AuthToken authToken) {
        super(authToken);
    }

    @Override
    protected void deauthImpl() throws IOException {
        if (this.httpTransport == null) {
            try {
                this.httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException("Failed to create HTTPS transport", generalSecurityException);
            }
        }
        HttpRequestFactory httpRequestFactory = this.httpTransport.createRequestFactory();
        GenericUrl genericUrl = new GenericUrl("https://accounts.google.com/o/oauth2/revoke?token=" + this.token.getToken());
        HttpRequest httpRequest = httpRequestFactory.buildGetRequest(genericUrl);
        httpRequest.setThrowExceptionOnExecuteError(true);
        HttpResponse httpResponse = httpRequest.execute();
        if (LOG.isInfoEnabled()) {
            LOG.info("Revoke Google token response: " + httpResponse);
        }
    }
}

