/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal.ui.dialogs;

import com.deltawalker.vfs.internal.ui.dialogs.AuthToken;
import com.deltawalker.vfs.internal.ui.dialogs.CloudAccount;
import com.deltawalker.vfs.internal.ui.dialogs.CloudAuthFlow;
import com.deltopia.StringUtil;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.About;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class GoogleAuthFlow
extends CloudAuthFlow {
    public static final String APP_NAME = "DeltaWalker";
    public static final String CLIENT_ID = "1011684278665-oco29t38frgn23j1h7t8v4ftgp22lcjf.apps.googleusercontent.com";
    public static final String CLIENT_SECRET = "pPHeBwNq_9YfknPL0Dm2BZzn";
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/drive");
    private GoogleAuthorizationCodeFlow flow;
    private NetHttpTransport httpTransport;

    GoogleAuthFlow(String string, boolean bl) {
        super(string, bl);
    }

    @Override
    protected AuthToken finishFlowImpl(Map<String, String[]> map) throws IOException {
        try {
            String string = map.get("code")[0];
            GoogleTokenResponse googleTokenResponse = this.flow.newTokenRequest(string).setRedirectUri(this.redirectUrl).execute();
            String string2 = googleTokenResponse.getRefreshToken();
            CloudAccount cloudAccount = null;
            if (this.retrieveAccount) {
                cloudAccount = this.getAccount(googleTokenResponse.getAccessToken(), string2);
            }
            AuthToken authToken = new AuthToken(string2, cloudAccount);
            return authToken;
        }
        finally {
            this.flow = null;
        }
    }

    private CloudAccount getAccount(String string, String string2) {
        Object object;
        GoogleCredential googleCredential = new GoogleCredential.Builder().setClientSecrets(CLIENT_ID, CLIENT_SECRET).setJsonFactory((JsonFactory)JacksonFactory.getDefaultInstance()).setTransport((HttpTransport)this.httpTransport).build();
        googleCredential.setAccessToken(string);
        googleCredential.setRefreshToken(string2);
        Drive.Builder builder = new Drive.Builder(googleCredential.getTransport(), googleCredential.getJsonFactory(), (HttpRequestInitializer)googleCredential);
        builder.setApplicationName(APP_NAME);
        Drive drive = builder.build();
        About about = null;
        try {
            about = (About)drive.about().get().execute();
        }
        catch (Exception exception) {
            this.LOG.warn("Cannot get account info", (Throwable)exception);
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (about != null) {
            object = about.getUser();
            string4 = object.getDisplayName();
            string3 = string5 = object.getEmailAddress();
        }
        if (StringUtil.isEmpty(string3)) {
            string3 = String.valueOf(System.currentTimeMillis());
            this.LOG.warn("Cannot get account info: " + about + ". Will use current date: " + string3);
        }
        object = new CloudAccount("GD_" + string3, string4, string5);
        return object;
    }

    @Override
    public String initFlowImpl() throws IOException {
        if (this.httpTransport == null) {
            try {
                this.httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException("Failed to create HTTPS transport", generalSecurityException);
            }
        }
        JacksonFactory jacksonFactory = JacksonFactory.getDefaultInstance();
        this.flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)this.httpTransport, (JsonFactory)jacksonFactory, CLIENT_ID, CLIENT_SECRET, SCOPES).setAccessType("offline").setApprovalPrompt("force").build();
        String string = this.flow.newAuthorizationUrl().setRedirectUri(this.redirectUrl).build();
        return string;
    }
}

