/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal.ui.dialogs;

import com.deltawalker.vfs.internal.ui.dialogs.AuthToken;
import com.deltawalker.vfs.internal.ui.dialogs.CloudAccount;
import com.deltawalker.vfs.internal.ui.dialogs.CloudAuthFlow;
import com.deltopia.StringUtil;
import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxSessionStore;
import com.dropbox.core.DbxWebAuth;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.users.FullAccount;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;

public final class DropboxAuthFlow
extends CloudAuthFlow {
    private static final String CLIENT_ID = "20kvzg9hunff6eo";
    static final String CLIENT_NAME = "DW-DB/2.0";
    private static final String CLIENT_SECRET = "90lv45wes2skqcr";
    static final Locale LOCALE = Locale.ENGLISH;
    private static final DbxSessionStore SESSION_STORE = new InMemorySessionStore();
    private final DbxAppInfo appInfo = new DbxAppInfo("20kvzg9hunff6eo", "90lv45wes2skqcr");
    private final DbxRequestConfig config = DropboxAuthFlow.createConfig();
    private DbxWebAuth webAuth;

    DropboxAuthFlow(String string, boolean bl) {
        super(string, bl);
    }

    @Override
    protected AuthToken finishFlowImpl(Map<String, String[]> map) throws IOException {
        try {
            DbxAuthFinish dbxAuthFinish = this.webAuth.finishFromRedirect(this.redirectUrl, SESSION_STORE, map);
            CloudAccount cloudAccount = null;
            if (this.retrieveAccount) {
                cloudAccount = this.getAccount(dbxAuthFinish.getAccessToken());
            }
            AuthToken authToken = new AuthToken(dbxAuthFinish.getAccessToken(), cloudAccount);
            return authToken;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        finally {
            this.webAuth = null;
        }
    }

    private CloudAccount getAccount(String string) {
        DbxRequestConfig dbxRequestConfig = DropboxAuthFlow.createConfig();
        DbxClientV2 dbxClientV2 = new DbxClientV2(dbxRequestConfig, string);
        FullAccount fullAccount = null;
        try {
            fullAccount = dbxClientV2.users().getCurrentAccount();
        }
        catch (Exception exception) {
            this.LOG.warn("Cannot get account info", (Throwable)exception);
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (fullAccount != null) {
            string3 = fullAccount.getName().getDisplayName();
            string4 = fullAccount.getEmail();
            if (StringUtil.isEmpty((String)string4)) {
                string2 = String.valueOf(fullAccount.getAccountId());
                this.LOG.warn("Cannot get account info: " + fullAccount + ". Will use user ID: " + string2);
            }
        }
        if (StringUtil.isEmpty(string2)) {
            string2 = String.valueOf(System.currentTimeMillis());
            this.LOG.warn("Cannot get account info: " + fullAccount + ". Will use current date: " + string2);
        }
        CloudAccount cloudAccount = new CloudAccount("DB_" + string2, string3, string4);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Create cloud account: " + cloudAccount);
        }
        return cloudAccount;
    }

    @Override
    protected String initFlowImpl() throws IOException {
        this.webAuth = new DbxWebAuth(this.config, this.appInfo);
        DbxWebAuth.Request request = DbxWebAuth.newRequestBuilder().withRedirectUri(this.redirectUrl, SESSION_STORE).build();
        String string = this.webAuth.authorize(request);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Start authorization flow. URL: " + string);
        }
        return string;
    }

    public static final DbxRequestConfig createConfig() {
        return DbxRequestConfig.newBuilder((String)CLIENT_NAME).withUserLocaleFrom(LOCALE).build();
    }

    private static class InMemorySessionStore
    implements DbxSessionStore {
        private String value;

        private InMemorySessionStore() {
        }

        public void clear() {
            this.value = null;
        }

        public String get() {
            return this.value;
        }

        public void set(String string) {
            this.value = string;
        }
    }
}

