/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal.ui.dialogs;

import com.deltawalker.vfs.internal.ui.dialogs.AuthToken;
import com.deltawalker.vfs.internal.ui.dialogs.DropboxDeAuthFlow;
import com.deltawalker.vfs.internal.ui.dialogs.GoogleDeAuthFlow;
import com.deltopia.io.VfsService;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloudDeauthFlow {
    protected static final Logger LOG = LoggerFactory.getLogger(CloudDeauthFlow.class);
    protected final AuthToken token;

    public static final CloudDeauthFlow createFlow(String string, AuthToken authToken) {
        if (string.equals(VfsService.GOOGLE.scheme())) {
            return new GoogleDeAuthFlow(authToken);
        }
        if (string.equals(VfsService.DROPBOX.scheme())) {
            return new DropboxDeAuthFlow(authToken);
        }
        throw new IllegalArgumentException("Unknown scheme: " + string);
    }

    protected CloudDeauthFlow(AuthToken authToken) {
        if (authToken == null) {
            throw new IllegalArgumentException("Token is null");
        }
        this.token = authToken;
    }

    public final void deauth() throws IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info("-> DeAuthorize token: " + this);
        }
        this.deauthImpl();
        if (LOG.isInfoEnabled()) {
            LOG.info("<- DeAuthorize token: " + this);
        }
    }

    protected abstract void deauthImpl() throws IOException;

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ", token=" + this.token;
    }
}

