/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal.ui.dialogs;

import com.deltawalker.vfs.internal.ui.dialogs.AuthToken;
import com.deltawalker.vfs.internal.ui.dialogs.DropboxAuthFlow;
import com.deltawalker.vfs.internal.ui.dialogs.GoogleAuthFlow;
import com.deltopia.StringUtil;
import com.deltopia.io.VfsService;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloudAuthFlow {
    protected final Logger LOG;
    protected final String redirectUrl;
    protected final boolean retrieveAccount;

    public static final CloudAuthFlow createFlow(String string, String string2, boolean bl) {
        if (string.equals(VfsService.GOOGLE.scheme())) {
            return new GoogleAuthFlow(string2, bl);
        }
        if (string.equals(VfsService.DROPBOX.scheme())) {
            return new DropboxAuthFlow(string2, bl);
        }
        throw new IllegalArgumentException("Unknown scheme: " + string);
    }

    protected CloudAuthFlow(String string, boolean bl) {
        if (StringUtil.isEmpty((String)string)) {
            throw new IllegalArgumentException("Invalid redirectUrl: " + string);
        }
        this.redirectUrl = string;
        this.retrieveAccount = bl;
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }

    public final AuthToken finishFlow(Map<String, String[]> map) throws IOException {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Invalid params: " + map);
        }
        AuthToken authToken = this.finishFlowImpl(map);
        if (authToken == null) {
            throw new IllegalStateException("Null generated token");
        }
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("Got token: " + authToken);
        }
        return authToken;
    }

    protected abstract AuthToken finishFlowImpl(Map<String, String[]> var1) throws IOException;

    public final String initFlow() throws IOException {
        String string = this.initFlowImpl();
        if (StringUtil.isEmpty((String)string)) {
            throw new IllegalArgumentException("Invalid generated authUrl: " + string);
        }
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("Generate authorization URL: " + string);
        }
        return string;
    }

    protected abstract String initFlowImpl() throws IOException;
}

