/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal.ui.dialogs;

import com.deltawalker.App;
import com.deltawalker.UriInfo;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.AlertComposite;
import com.deltawalker.vfs.internal.Msg;
import com.deltawalker.vfs.internal.ui.dialogs.RemoteResourceSheet;
import com.deltopia.io.FileType;
import com.deltopia.io.UriInfoKey;
import com.deltopia.io.VfsService;
import com.deltopia.io.VfsUtil;
import com.deltopia.jface.util.DialogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.provider.UriParser;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthComposite
extends AlertComposite {
    private static final Logger LOG = LoggerFactory.getLogger(AuthComposite.class);
    private Combo cbRecent;
    private RemoteResourceSheet.IResourceDialogInfo dialogInfo = null;
    private int labelWidthHint;
    protected UriInfo mruUriInfo;
    protected Map<UriInfoKey, Object> props;
    private final List<UriInfo> recentUris = new ArrayList<UriInfo>();
    private VfsService service = null;
    protected StyledText txtUri;
    protected UriInfo uriInfo;

    public AuthComposite(Composite composite, int n, VfsService vfsService, RemoteResourceSheet.IResourceDialogInfo iResourceDialogInfo) {
        super(composite, n);
        if (vfsService == null) {
            throw new NullPointerException("service");
        }
        this.service = vfsService;
        if (iResourceDialogInfo == null) {
            throw new NullPointerException("dlgInfo");
        }
        this.dialogInfo = iResourceDialogInfo;
    }

    private void addRecentUri(UriInfo uriInfo) {
        String string = uriInfo.displayUri();
        String string2 = UriParser.extractScheme(string);
        if (this.service().scheme().equals(string2)) {
            String string3 = VfsUtil.isCloudScheme((String)string2) ? this.constructUri(uriInfo, true) : string;
            this.cbRecent.add(string3);
            this.recentUris.add(uriInfo);
        }
    }

    private void computeLabelWidthHint(Control control) {
        String string = NLS.bind((String)Msg.RemoteResourceDialog_initialPath, (Object)(this.dialogInfo().isFileDialog() ? Msg.RemoteResourceDialog_file : Msg.RemoteResourceDialog_folder));
        this.labelWidthHint = UIUtil.stringExtent((String)string, (Control)control);
    }

    protected String constructUri(UriInfo uriInfo, boolean bl) {
        return "";
    }

    protected void createControls() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.createUriControl();
        this.createRecentControl();
    }

    protected void createRecentControl() {
        Composite composite = DialogUtil.createComposite((Composite)this, (int)2, (int)769, (boolean)false);
        Label label = new Label(composite, 0);
        label.setText(Msg.RemoteResourceDialog_recent);
        this.setLabelWidthHint((Control)label);
        this.cbRecent = new Combo(composite, 2060);
        this.cbRecent.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void createUriControl() {
        this.txtUri = new StyledText((Composite)this, 74);
        this.txtUri.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.txtUri.setBackground(this.getBackground());
    }

    protected RemoteResourceSheet.IResourceDialogInfo dialogInfo() {
        return this.dialogInfo;
    }

    protected void fillRecentCombo() {
        FileType fileType = this.dialogInfo.isFileDialog() ? FileType.FILE : FileType.FOLDER;
        List list = App.instance().docBoss().recentUriInfos(fileType, this.dialogInfo.role());
        String string = this.service.scheme();
        for (UriInfo uriInfo : list) {
            if (!string.equals(UriParser.extractScheme(uriInfo.uri()))) continue;
            this.addRecentUri(uriInfo);
        }
        int n = this.cbRecent.getItemCount();
        if (n > 0) {
            this.selectMruUriInRecentCombo();
        }
    }

    protected UriInfo getMruUriInfo() {
        return this.mruUriInfo;
    }

    protected void installListeners() {
        this.cbRecent.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = AuthComposite.this.cbRecent.getSelectionIndex();
                AuthComposite.this.uriInfoChanged(n == -1 ? null : (UriInfo)AuthComposite.this.recentUris.get(n));
            }
        });
    }

    private String mruUri() {
        return this.mruUriInfo != null ? this.mruUriInfo.uri() : "";
    }

    protected final Map<UriInfoKey, Object> props() {
        if (this.props == null) {
            this.props = new HashMap<UriInfoKey, Object>(2);
        }
        return this.props;
    }

    private void selectMruUriInRecentCombo() {
        if (this.mruUriInfo == null) {
            return;
        }
        String string = this.mruUri();
        assert (!string.isEmpty());
        int n = this.recentUris.indexOf(this.mruUriInfo);
        if (n == 0) {
            this.cbRecent.select(0);
        } else {
            this.cbRecent.add(string, 0);
            this.cbRecent.select(0);
            this.cbRecent.setVisibleItemCount(this.cbRecent.getItemCount());
        }
    }

    protected VfsService service() {
        return this.service;
    }

    protected void setLabelWidthHint(Control control) {
        if (this.labelWidthHint == 0) {
            this.computeLabelWidthHint(control);
        }
        GridData gridData = new GridData();
        gridData.widthHint = this.labelWidthHint;
        control.setLayoutData((Object)gridData);
    }

    public void setMruUriInfo(UriInfo uriInfo) {
        String string = uriInfo.displayUri();
        String string2 = UriParser.extractScheme(string);
        if (VfsUtil.hasRemoteScheme((String)string) && this.service().scheme().equals(string2)) {
            this.mruUriInfo = uriInfo;
            Map map = this.mruUriInfo.properties();
            if (!map.isEmpty()) {
                this.props = new HashMap<UriInfoKey, Object>(map);
            }
        }
        if (this.mruUriInfo != null) {
            this.uriInfoChanged(this.mruUriInfo);
        }
    }

    protected void showUri() {
        String string = this.constructUri(null, true);
        this.txtUri.setText(string);
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = string.length();
        styleRange.fontStyle = 1;
        this.txtUri.setStyleRange(styleRange);
    }

    protected void uriInfoChanged(UriInfo uriInfo) {
        if (uriInfo == null) {
            LOG.warn("uriInfo = null");
            return;
        }
        this.uriInfo = uriInfo;
        Map map = uriInfo.properties();
        if (!map.isEmpty()) {
            this.props = this.props();
            this.props.putAll(map);
        }
        this.showUri();
        this.updateButtons(uriInfo);
    }

    protected void updateButtons(UriInfo uriInfo) {
    }
}

