/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal;

import com.deltawalker.UriInfo;
import com.deltawalker.resources.IResource;
import com.deltawalker.resources.ResourceFactory;
import com.deltawalker.script.Role;
import com.deltawalker.ui.dialogs.IResourceDialog;
import com.deltawalker.vfs.internal.Msg;
import com.deltawalker.vfs.internal.SecurePrefsUtil;
import com.deltawalker.vfs.internal.VfsFile;
import com.deltawalker.vfs.internal.VfsFileResource;
import com.deltawalker.vfs.internal.VfsFolderResource;
import com.deltawalker.vfs.internal.ui.dialogs.RemoteResourceSheet;
import com.deltopia.StringUtil;
import com.deltopia.io.FileType;
import com.deltopia.io.FileUtil;
import com.deltopia.io.IFile;
import com.deltopia.io.VfsService;
import com.deltopia.io.VfsUtil;
import com.deltopia.vfs.util.UriUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.dropbox.DropboxFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;

public class VfsResourceFactory
extends ResourceFactory {
    private static final String ARCHIVE_SUFFIX = "!/";
    private static VfsResourceFactory factory;

    private static String[] extractArchiveShemes(String string) {
        int n = string.indexOf("://");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n != -1) {
            String string2 = string.substring(0, n);
            int n2 = string2.length();
            int n3 = 0;
            while (n3 < n2) {
                String string3;
                int n4 = string2.indexOf(58, n3);
                if (n4 == -1) {
                    string3 = string2.substring(n3);
                    n3 = n2;
                } else {
                    string3 = string2.substring(n3, n4);
                    n3 = n4 + 1;
                }
                if (!VfsUtil.isArchiveExtension((String)string3)) continue;
                arrayList.add(string3);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static VfsResourceFactory getInstance() {
        return factory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String prepareArchiveUri(UriInfo uriInfo, URI uRI) {
        String string = uRI.getEscapedPath();
        String string2 = FileUtil.getExtension((String)string);
        String string3 = uRI.getEscapedURI();
        if (string == null) return string3;
        if (!uriInfo.hasArchiveUri()) return string3;
        String[] stringArray = VfsResourceFactory.extractArchiveShemes(string3);
        int n = stringArray.length;
        boolean bl = true;
        if (n != 0) {
            int n2 = 0;
            int n3 = ARCHIVE_SUFFIX.length();
            int n4 = n - 1;
            while (n4 >= 0) {
                String string4 = stringArray[n4];
                int n5 = string3.indexOf(String.valueOf(string4) + ARCHIVE_SUFFIX, n2);
                if (n5 == -1) {
                    if (n4 != 0) return string3;
                    bl = !string4.equalsIgnoreCase(string2);
                } else {
                    n2 = n5 + string4.length() + n3;
                }
                --n4;
            }
        }
        if (bl) {
            String string5;
            if (!VfsUtil.isArchiveExtension((String)string2)) {
                string2 = "zip";
            }
            String string6 = StringUtil.isEmpty((String)(string5 = UriParser.extractScheme(string3))) ? "://" : ":";
            string3 = String.valueOf(string2) + string6 + string3;
            ++n;
        }
        if (n <= 1) return string3;
        if (string.endsWith(ARCHIVE_SUFFIX)) return string3;
        return String.valueOf(string3) + ARCHIVE_SUFFIX;
    }

    public static FileObject staticResolveFile(UriInfo uriInfo) throws FileSystemException, URIException {
        return VfsResourceFactory.staticResolveFile(uriInfo, false);
    }

    public static FileObject staticResolveFile(UriInfo uriInfo, boolean bl) throws FileSystemException, URIException {
        Object object;
        Object object2;
        String string = uriInfo.uri();
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = null;
        while (UriParser.extractScheme(stringBuilder.toString(), stringBuilder) != null) {
            string2 = VfsUtil.getRootName((StringBuilder)stringBuilder);
        }
        string = string.replace("\\", "/");
        URI uRI = new URI(string, UriUtil.isEscaped((String)string));
        if (!bl) {
            string = VfsResourceFactory.prepareArchiveUri(uriInfo, uRI);
        }
        String string3 = uRI.getScheme();
        String string4 = uriInfo.username();
        String string5 = uriInfo.email();
        if (string4.isEmpty() && ("sftp".equals(string3) || "ftps".equals(string3))) {
            throw new URIException(NLS.bind((String)Msg.VfsResourceFactory_errNoUsername, (Object)string3.toUpperCase()));
        }
        String string6 = uriInfo.password();
        if (!string4.isEmpty() && StringUtil.isEmpty((String)string6)) {
            object2 = UriUtil.constructUriPasswordPrefKey((String)string2, (String)string4);
            string6 = SecurePrefsUtil.get((String)object2, "");
        }
        object2 = VFS.getManager();
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        boolean bl2 = uriInfo.isUserDirRoot();
        boolean bl3 = uriInfo.isPassiveMode();
        if ("ftp".equals(string3)) {
            object = FtpFileSystemConfigBuilder.getInstance();
            ((FtpFileSystemConfigBuilder)object).setPassiveMode(fileSystemOptions, bl3);
            ((FtpFileSystemConfigBuilder)object).setUserDirIsRoot(fileSystemOptions, bl2);
        } else if ("sftp".equals(string3)) {
            object = SftpFileSystemConfigBuilder.getInstance();
            ((SftpFileSystemConfigBuilder)object).setStrictHostKeyChecking(fileSystemOptions, "no");
            ((SftpFileSystemConfigBuilder)object).setUserDirIsRoot(fileSystemOptions, bl2);
            String string7 = null;
            String string8 = uriInfo.sshKey();
            if (!string8.isEmpty()) {
                String string9 = UriUtil.constructSshPassphrasePrefKey((String)string2, (String)string4);
                string7 = SecurePrefsUtil.get(string9, "");
                byte[] byArray = !string7.isEmpty() ? string7.getBytes() : null;
                IdentityInfo identityInfo = new IdentityInfo(string8.toString(), byArray);
                Set<IdentityInfo> set = Collections.singleton(identityInfo);
                ((SftpFileSystemConfigBuilder)object).setIdentities(fileSystemOptions, set);
            }
        } else if ("ftps".equals(string3)) {
            object = FtpsFileSystemConfigBuilder.getInstance();
            ((FtpsFileSystemConfigBuilder)object).setPassiveMode(fileSystemOptions, bl3);
            boolean bl4 = uriInfo.isExplicitMode();
            ((FtpsFileSystemConfigBuilder)object).setFtpsType(fileSystemOptions, bl4 ? "explicit" : "implicit");
            ((FtpsFileSystemConfigBuilder)object).setUserDirIsRoot(fileSystemOptions, bl2);
        } else if (VfsService.DROPBOX.scheme().equals(string3) || !string5.isEmpty() && string.contains(VfsService.DROPBOX.fullScheme())) {
            object = DropboxFileSystemConfigBuilder.getInstance();
            String string10 = String.valueOf(VfsService.DROPBOX.fullScheme()) + string5;
            String string11 = SecurePrefsUtil.get(string10, "");
            ((DropboxFileSystemConfigBuilder)object).setAccessToken(fileSystemOptions, string11);
        } else if (VfsService.GOOGLE.scheme().equals(string3) || !string5.isEmpty() && string.contains(VfsService.GOOGLE.fullScheme())) {
            object = GoogleFileSystemConfigBuilder.getInstance();
            ((GoogleFileSystemConfigBuilder)object).setClientId(fileSystemOptions, "1011684278665-oco29t38frgn23j1h7t8v4ftgp22lcjf.apps.googleusercontent.com");
            ((GoogleFileSystemConfigBuilder)object).setClientSecret(fileSystemOptions, "pPHeBwNq_9YfknPL0Dm2BZzn");
            ((GoogleFileSystemConfigBuilder)object).setAppName(fileSystemOptions, "DeltaWalker");
            String string12 = String.valueOf(VfsService.GOOGLE.fullScheme()) + string5;
            String string13 = SecurePrefsUtil.get(string12, "");
            ((GoogleFileSystemConfigBuilder)object).setRefreshToken(fileSystemOptions, string13);
        }
        if (!StringUtil.isEmpty((String)string4)) {
            object = new StaticUserAuthenticator(uRI.getHost(), string4, StringUtil.makeSafe((String)string6));
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(fileSystemOptions, (UserAuthenticator)object);
        }
        return object2.resolveFile(string, fileSystemOptions);
    }

    public VfsResourceFactory() {
        factory = this;
    }

    public IResource createResource(UriInfo uriInfo, boolean bl, boolean bl2) throws IOException {
        org.apache.commons.vfs2.FileType fileType;
        FileObject fileObject = VfsResourceFactory.staticResolveFile(uriInfo);
        if (bl && !fileObject.exists()) {
            if (uriInfo.fileType().isFile()) {
                fileObject.createFile();
            } else {
                fileObject.createFolder();
            }
        }
        if ((fileType = fileObject.getType()) == org.apache.commons.vfs2.FileType.FILE || fileType == org.apache.commons.vfs2.FileType.FILE_OR_FOLDER) {
            return new VfsFileResource(fileObject, uriInfo.contentType(), bl2);
        }
        if (fileType == org.apache.commons.vfs2.FileType.FOLDER) {
            return new VfsFolderResource(fileObject, bl2, false);
        }
        throw new IOException(Msg.VfsResourceFactory_errNoResource);
    }

    public IResourceDialog createResourceWindow(Role role, boolean bl, boolean bl2, String string, IPreferenceStore iPreferenceStore, UriInfo uriInfo) {
        return new RemoteResourceSheet(role, bl, bl2, string, iPreferenceStore, uriInfo);
    }

    public FileType getResourceType(UriInfo uriInfo) throws IOException {
        String string = uriInfo.uri();
        URI uRI = new URI(string, UriUtil.isEscaped((String)string));
        FileType fileType = FileType.UNKNOWN;
        if (VfsUtil.hasArchiveExtension((String)uRI.getPath())) {
            fileType = FileType.FOLDER;
        } else {
            FileObject fileObject = VfsResourceFactory.staticResolveFile(uriInfo);
            org.apache.commons.vfs2.FileType fileType2 = fileObject.getType();
            if (fileType2 == org.apache.commons.vfs2.FileType.FILE) {
                fileType = fileType2.hasChildren() ? FileType.FOLDER : FileType.FILE;
            } else if (fileType2 == org.apache.commons.vfs2.FileType.FOLDER) {
                fileType = FileType.FOLDER;
            }
        }
        return fileType;
    }

    public boolean isLocal() {
        return false;
    }

    public IFile resolveFile(UriInfo uriInfo) {
        try {
            FileObject fileObject = VfsResourceFactory.staticResolveFile(uriInfo);
            return new VfsFile(fileObject, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public boolean resourceExists(UriInfo uriInfo) {
        try {
            return this.getResourceType(uriInfo) != FileType.UNKNOWN;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

