/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal;

import com.deltawalker.UriInfo;
import com.deltawalker.vfs.internal.VfsResourceFactory;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.ICopyFrom;
import com.deltopia.interfaces.IPrincipal;
import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.FileInfo;
import com.deltopia.io.FileType;
import com.deltopia.io.IFile;
import com.deltopia.io.Principal;
import com.deltopia.io.StreamUtil;
import com.deltopia.io.UriInfoKey;
import com.deltopia.io.VfsService;
import com.deltopia.io.VfsUtil;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.IFileObjectWithId;
import org.apache.commons.vfs2.provider.ftp.FtpFileObject;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileObject;
import org.apache.commons.vfs2.provider.gzip.GzipFileObject;
import org.apache.commons.vfs2.provider.http.HttpFileObject;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.apache.commons.vfs2.provider.webdav.WebdavFileObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfsFile
implements IFile,
ICopyFrom {
    private static final Map<Object, Principal> groupCache = new ConcurrentHashMap<Object, Principal>(2);
    private static final Logger LOG = LoggerFactory.getLogger(VfsFile.class);
    private static final Map<Object, Principal> ownerCache = new ConcurrentHashMap<Object, Principal>(2);
    private FileObject file;
    private FileInfo fileInfo;
    private IFile parent;
    private Boolean readable = null;

    private static final int fromFtpAttributes(FtpFileObject ftpFileObject) {
        FTPFile fTPFile = ftpFileObject.getFileInfo();
        int n = 0;
        if (fTPFile.hasPermission(0, 0)) {
            n |= 0x10000;
        }
        if (fTPFile.hasPermission(0, 1)) {
            n |= 0x20000;
        }
        if (fTPFile.hasPermission(0, 2)) {
            n |= 0x40000;
        }
        if (fTPFile.hasPermission(1, 0)) {
            n |= 0x80000;
        }
        if (fTPFile.hasPermission(1, 1)) {
            n |= 0x100000;
        }
        if (fTPFile.hasPermission(1, 2)) {
            n |= 0x200000;
        }
        if (fTPFile.hasPermission(2, 0)) {
            n |= 0x400000;
        }
        if (fTPFile.hasPermission(2, 1)) {
            n |= 0x800000;
        }
        if (fTPFile.hasPermission(2, 2)) {
            n |= 0x1000000;
        }
        if (fTPFile.isDirectory()) {
            n |= 1;
        }
        if (fTPFile.isSymbolicLink()) {
            n |= 0x40;
        }
        return n;
    }

    private static final int fromSftpAttributes(SftpFileObject sftpFileObject) {
        SftpATTRS sftpATTRS = sftpFileObject.getAttributes();
        int n = 0;
        if ((sftpATTRS.getFlags() & 4) != 0) {
            int n2 = sftpATTRS.getPermissions();
            if ((n2 & 0x100) != 0) {
                n |= 0x10000;
            }
            if ((n2 & 0x80) != 0) {
                n |= 0x20000;
            }
            if ((n2 & 0x40) != 0) {
                n |= 0x40000;
            }
            if ((n2 & 0x20) != 0) {
                n |= 0x80000;
            }
            if ((n2 & 0x10) != 0) {
                n |= 0x100000;
            }
            if ((n2 & 8) != 0) {
                n |= 0x200000;
            }
            if ((n2 & 4) != 0) {
                n |= 0x400000;
            }
            if ((n2 & 2) != 0) {
                n |= 0x800000;
            }
            if ((n2 & 1) != 0) {
                n |= 0x1000000;
            }
            if ((n2 & 0x800) != 0) {
                n |= 0x2000000;
            }
            if ((n2 & 0x400) != 0) {
                n |= 0x4000000;
            }
            if ((n2 & 0x200) != 0) {
                n |= 0x8000000;
            }
        }
        if (sftpATTRS.isDir()) {
            n |= 1;
        }
        if (sftpATTRS.isLink()) {
            n |= 0x40;
        }
        return n;
    }

    private static final int toSftpPermissions(FileInfo fileInfo) {
        int n = 0;
        if (fileInfo.hasPermission(65536)) {
            n |= 0x100;
        }
        if (fileInfo.hasPermission(131072)) {
            n |= 0x80;
        }
        if (fileInfo.hasPermission(262144)) {
            n |= 0x40;
        }
        if (fileInfo.hasPermission(524288)) {
            n |= 0x20;
        }
        if (fileInfo.hasPermission(0x100000)) {
            n |= 0x10;
        }
        if (fileInfo.hasPermission(0x200000)) {
            n |= 8;
        }
        if (fileInfo.hasPermission(0x400000)) {
            n |= 4;
        }
        if (fileInfo.hasPermission(0x800000)) {
            n |= 2;
        }
        if (fileInfo.hasPermission(0x1000000)) {
            n |= 1;
        }
        if (fileInfo.hasPermission(0x2000000)) {
            n |= 0x800;
        }
        if (fileInfo.hasPermission(0x4000000)) {
            n |= 0x400;
        }
        if (fileInfo.hasPermission(0x8000000)) {
            n |= 0x200;
        }
        return n;
    }

    public VfsFile(FileObject fileObject, IFile iFile) {
        this(fileObject, iFile, false);
    }

    public VfsFile(FileObject fileObject, IFile iFile, boolean bl) {
        if (fileObject == null) {
            throw new NullPointerException("file");
        }
        this.file = fileObject;
        if (iFile != null) {
            this.parent = iFile;
        } else {
            try {
                FileObject fileObject2 = fileObject.getParent();
                if (fileObject2 != null) {
                    this.parent = new VfsFile(fileObject.getParent(), null, bl);
                }
            }
            catch (FileSystemException fileSystemException) {
                LOG.warn("getParent() failed for " + fileObject, (Throwable)fileSystemException);
            }
        }
        if (!bl) {
            this.updateFileInfo();
        }
    }

    private String constructPath(boolean bl) {
        String string = this.parentPath(bl);
        String string2 = this.getName();
        if (!StringUtil.isEmpty((String)string)) {
            if (!string.endsWith("/")) {
                return String.valueOf(string) + "/" + string2;
            }
            return String.valueOf(string) + string2;
        }
        return bl && this.parent == null ? "" : string2;
    }

    public long copyFrom(InputStream inputStream, String string, String string2, long l, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        if (this.file instanceof ICopyFrom) {
            return ((ICopyFrom)this.file).copyFrom(inputStream, string, string2, l, iSyncProgressMonitor);
        }
        OutputStream outputStream = this.file.getContent().getOutputStream(false);
        try {
            long l2 = StreamUtil.copyStream((InputStream)inputStream, (OutputStream)outputStream, (int)0, (ISyncProgressMonitor)iSyncProgressMonitor);
            return l2;
        }
        finally {
            StreamUtil.closeSilently((Closeable)outputStream);
        }
    }

    public long createdTime() {
        return this.getLastModifiedTime();
    }

    public InputStream createInputStream(boolean bl) throws IOException {
        return this.file.getContent().getInputStream();
    }

    public void createNewFile() throws IOException {
        this.file.createFile();
    }

    public OutputStream createOutputStream(boolean bl) throws IOException {
        return this.file.getContent().getOutputStream();
    }

    public void createSymbolicLink(IFile iFile) throws IOException {
        if (this.file instanceof SftpFileObject) {
            String string = this.getPath();
            String string2 = iFile.readSymbolicLink();
            ((SftpFileObject)this.file).createSymbolicLink(string, string2);
        } else {
            LOG.warn("The API for accessing the destination file system does not support creation of symbolic links. Creating a new VFS file instead.");
            this.createNewFile();
        }
    }

    public boolean delete() {
        try {
            return this.file.delete(new AllFileSelector(), null) > 0;
        }
        catch (FileSystemException fileSystemException) {
            LOG.error("delete() failed for " + this.file, (Throwable)fileSystemException);
            return false;
        }
    }

    public boolean exists() {
        try {
            return this.file.exists();
        }
        catch (FileSystemException fileSystemException) {
            LOG.error("exists() failed for " + this.file, (Throwable)fileSystemException);
            return false;
        }
    }

    private String friendlyUri() {
        return this.file.getName().getFriendlyURI();
    }

    public int getAttributes() {
        return this.fileInfo != null ? this.fileInfo.attributes() : 0;
    }

    public String getDisplayUri() {
        if (this.file instanceof IFileObjectWithId) {
            String string = VfsService.GOOGLE.fullScheme();
            if (this.isRoot()) {
                return String.valueOf(string) + "/";
            }
            String string2 = String.valueOf(this.parent.isRoot() ? "" : this.parent.getDisplayUri()) + "/" + this.getName();
            return string2.startsWith(string) ? string2 : String.valueOf(string) + string2;
        }
        return this.getUri();
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public IPrincipal getGroup() {
        if (this.file instanceof SftpFileObject) {
            SftpATTRS sftpATTRS = ((SftpFileObject)this.file).getAttributes();
            int n = sftpATTRS.getUId();
            Principal principal = groupCache.get(n);
            if (principal == null) {
                Principal principal2 = new Principal((Object)n);
                principal = groupCache.put(n, principal2);
                if (principal == null) {
                    principal = principal2;
                }
            }
            return principal;
        }
        return null;
    }

    public long getLastModifiedTime() {
        return this.fileInfo != null ? this.fileInfo.lastModifiedTime() : 0L;
    }

    public String getName() {
        String string;
        if (this.file instanceof IFileObjectWithId) {
            IFileObjectWithId iFileObjectWithId = (IFileObjectWithId)((Object)this.file);
            string = iFileObjectWithId.getDisplayName();
        } else {
            String string2 = string = this.fileInfo != null ? this.fileInfo.name() : this.file.getName().getBaseName();
        }
        if (!this.isRoot() && StringUtil.isEmpty((String)string)) {
            throw new IllegalStateException("Returns invalid name " + string + " of " + this);
        }
        return string;
    }

    public IPrincipal getOwner() {
        if (this.file instanceof SftpFileObject) {
            SftpATTRS sftpATTRS = ((SftpFileObject)this.file).getAttributes();
            int n = sftpATTRS.getUId();
            Principal principal = ownerCache.get(n);
            if (principal == null) {
                Principal principal2 = new Principal((Object)n);
                principal = ownerCache.put(n, principal2);
                if (principal == null) {
                    principal = principal2;
                }
            }
            return principal;
        }
        return null;
    }

    public String getParentUri() {
        FileName fileName = this.file.getName().getParent();
        return fileName == null ? null : fileName.getURI();
    }

    public String getPath() {
        return this.file.getName().getPath();
    }

    public String getUri() {
        return this.file.getName().getURI();
    }

    public boolean isDirectory(boolean bl) {
        try {
            return this.file.getType() == org.apache.commons.vfs2.FileType.FOLDER;
        }
        catch (FileSystemException fileSystemException) {
            LOG.error("Couldn't get the file type");
            return false;
        }
    }

    public boolean isHidden() {
        boolean bl = true;
        try {
            bl = this.file.isHidden();
        }
        catch (FileSystemException fileSystemException) {
            fileSystemException.printStackTrace();
        }
        return bl;
    }

    public boolean isLocal() {
        return !VfsUtil.hasVfsScheme((String)this.getUri());
    }

    public boolean isMoveToTrashSupported() {
        return false;
    }

    public boolean isReadable() {
        int n;
        if (this.readable != null) {
            return this.readable;
        }
        if (VfsUtil.isArchiveExtension((String)this.file.getName().getScheme())) {
            this.readable = true;
            return true;
        }
        if (this.isRoot()) {
            this.readable = true;
            return true;
        }
        if (this.fileInfo == null) {
            LOG.warn("fileInfo is 'null' for " + this.friendlyUri());
            this.updateFileInfoImpl();
            if (this.fileInfo == null) {
                this.readable = true;
                return true;
            }
        }
        this.readable = (n = this.fileInfo.attributes() & 0xFFFFFFFE & 0xFFFFFFBF) != 0 ? this.fileInfo.isReadable() : true;
        return this.readable;
    }

    public boolean isRoot() {
        return this.file.getName().getDepth() == 0;
    }

    private boolean isSupported(Field field) throws FileSystemException {
        FileSystem fileSystem = this.file.getFileSystem();
        switch (field) {
            case SET_LAST_MODIFIED: {
                org.apache.commons.vfs2.FileType fileType = this.file.getType();
                if (fileType == org.apache.commons.vfs2.FileType.FOLDER) {
                    return fileSystem.hasCapability(Capability.SET_LAST_MODIFIED_FOLDER);
                }
                if (fileType == org.apache.commons.vfs2.FileType.FILE) {
                    return fileSystem.hasCapability(Capability.SET_LAST_MODIFIED_FILE);
                }
                return false;
            }
            case SET_HIDDEN: 
            case SET_READ_ONLY: {
                return fileSystem.hasCapability(Capability.ATTRIBUTES);
            }
        }
        return false;
    }

    public boolean isSymbolicLink() {
        return this.fileInfo != null ? this.fileInfo.isSymbolicLink() : false;
    }

    public boolean isWritable() {
        try {
            return this.file.isWriteable();
        }
        catch (FileSystemException fileSystemException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("canWrite() failed for " + this.file, (Throwable)fileSystemException);
            }
            return false;
        }
    }

    public long lastOpenedTime() {
        return this.getLastModifiedTime();
    }

    public IFile[] listFiles(int n, IProgressMonitor iProgressMonitor) throws IOException {
        IFile[] iFileArray = NO_FILES;
        try {
            if (this.file.getType() == org.apache.commons.vfs2.FileType.FOLDER) {
                FileObject[] fileObjectArray = this.file.getChildren(iProgressMonitor);
                int n2 = fileObjectArray.length;
                if (n2 == 0 || iProgressMonitor.isCanceled()) {
                    return NO_FILES;
                }
                iFileArray = new IFile[n2];
                int n3 = 0;
                while (n3 < n2) {
                    iFileArray[n3] = new VfsFile(fileObjectArray[n3], this);
                    ++n3;
                }
            }
        }
        catch (Throwable throwable) {
            this.readable = false;
            throw new IOException(throwable.getLocalizedMessage(), throwable);
        }
        return iFileArray;
    }

    public void mkdir() throws IOException {
        this.file.createFolder();
    }

    public boolean moveToTrash() {
        return this.delete();
    }

    public IFile parent() {
        return this.parent;
    }

    private String parentPath(boolean bl) {
        if (this.parent != null) {
            return bl ? this.parent.rootlessPath() : this.parent.getPath();
        }
        return bl ? "" : this.file.getName().getPath();
    }

    public String readSymbolicLink() throws IOException {
        String string = "";
        if (this.file instanceof SftpFileObject) {
            string = ((SftpFileObject)this.file).readSymbolicLink();
        } else if (this.file instanceof FtpFileObject) {
            string = ((FtpFileObject)this.file).readSymbolicLink();
        }
        return string;
    }

    public void renameTo(String string, Map<UriInfoKey, Object> map, boolean bl) throws IOException {
        FileType fileType = this.isDirectory(false) ? FileType.FOLDER : FileType.FILE;
        String string2 = String.valueOf(this.getParentUri()) + '/' + string;
        UriInfo uriInfo = new UriInfo(string2, fileType, map);
        FileObject fileObject = VfsResourceFactory.staticResolveFile(uriInfo, true);
        if (this.file.canRenameTo(fileObject)) {
            this.file.moveTo(fileObject, null);
            this.file = fileObject;
            if (this.file instanceof IFileObjectWithId) {
                IFileObjectWithId iFileObjectWithId = (IFileObjectWithId)((Object)this.file);
                this.fileInfo = this.fileInfo.cloneUsingNewName(iFileObjectWithId.getDisplayName());
            } else {
                this.fileInfo = this.fileInfo.cloneUsingNewName(fileObject.getName().getBaseName());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Rename to: " + this.file + ", name=" + this.getName());
            }
        }
    }

    public IFile resolveFile(String string, IFile iFile, boolean bl) throws IOException {
        return new VfsFile(this.file.resolveFile(string), iFile, bl);
    }

    public long resourceForkSize() {
        return 0L;
    }

    public String rootlessPath() {
        String string = this.constructPath(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("VFS rootless path: " + string);
        }
        return string;
    }

    public String scheme() {
        return this.file.getName().getScheme();
    }

    public void setAttributes(int n) throws IOException {
        this.setFileInfo(this.fileInfo.cloneUsingNewAttributes(n));
    }

    public void setFileInfo(FileInfo fileInfo) throws IOException {
        if (fileInfo == null) {
            throw new NullPointerException("fileInfo");
        }
        if (this.file instanceof SftpFileObject) {
            try {
                ((SftpFileObject)this.file).setAttributes(fileInfo.lastModifiedTime(), VfsFile.toSftpPermissions(fileInfo));
                this.fileInfo = fileInfo;
            }
            catch (IOException iOException) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("setFileInfo() failed for " + this.friendlyUri(), (Throwable)iOException);
                }
                throw iOException;
            }
            catch (SftpException sftpException) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("setFileInfo() failed for " + this.friendlyUri(), (Throwable)sftpException);
                }
                throw new IOException(sftpException);
            }
        } else if (!(this.file instanceof GoogleFileObject)) {
            boolean bl = false;
            switch (this.file.getType()) {
                case FILE: {
                    if (!this.file.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE)) break;
                    bl = true;
                    break;
                }
                case FOLDER: {
                    if (!this.file.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FOLDER)) break;
                    bl = true;
                    break;
                }
                case FILE_OR_FOLDER: {
                    if (!this.file.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FOLDER) && !this.file.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE)) break;
                    bl = true;
                }
            }
            if (bl) {
                this.file.getContent().setLastModifiedTime(fileInfo.lastModifiedTime());
            } else {
                LOG.warn("Calling setFileInfo() for an object whose attributes cannot be modified: " + this);
            }
        }
    }

    public void setHidden(boolean bl) throws IOException {
        if (this.isSupported(Field.SET_HIDDEN)) {
            this.file.getContent().setAttribute(Field.SET_HIDDEN.toString(), new Boolean(bl));
        } else {
            LOG.warn("setHidden() not supported for " + this.friendlyUri());
        }
    }

    public void setLastModifiedTime(long l) throws IOException {
        if (this.isSupported(Field.SET_LAST_MODIFIED)) {
            this.file.getContent().setLastModifiedTime(l);
        } else {
            LOG.warn("setLastModified() not supported for " + this.friendlyUri());
        }
    }

    public void setWritable(boolean bl) throws IOException {
        if (this.isSupported(Field.SET_READ_ONLY)) {
            this.file.getContent().setAttribute(Field.SET_READ_ONLY.toString(), new Boolean(!bl));
        } else {
            LOG.warn("setWritable() not supported for " + this.friendlyUri());
        }
    }

    public long size() {
        return this.fileInfo != null ? this.fileInfo.size() : 0L;
    }

    public String toString() {
        return this.friendlyUri();
    }

    public void updateFileInfo() {
        try {
            org.apache.commons.vfs2.FileType fileType = this.file.getType();
            if (fileType == org.apache.commons.vfs2.FileType.IMAGINARY || this.isRoot()) {
                return;
            }
            this.updateFileInfoImpl();
        }
        catch (FileSystemException fileSystemException) {
            LOG.error("updateFileInfo()  failed for " + this.file, (Throwable)fileSystemException);
        }
    }

    private void updateFileInfoImpl() {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        try {
            if (this.file instanceof HttpFileObject && !(this.file instanceof WebdavFileObject)) {
                return;
            }
            if (this.file instanceof FtpFileObject) {
                FtpFileObject ftpFileObject = (FtpFileObject)this.file;
                n = VfsFile.fromFtpAttributes((FtpFileObject)this.file);
                FTPFile fTPFile = ftpFileObject.getFileInfo();
                l = fTPFile.getSize();
                Calendar calendar = fTPFile.getTimestamp();
                if (calendar == null) {
                    if (this.file.getFileSystem().hasCapability(Capability.GET_LAST_MODIFIED)) {
                        LOG.warn("No timestamp of FTP file " + ftpFileObject);
                    } else if (LOG.isInfoEnabled()) {
                        LOG.info("No timestamp of FTP file " + ftpFileObject);
                    }
                    l2 = -1L;
                } else {
                    l2 = calendar.getTimeInMillis();
                }
            } else if (this.file != null) {
                org.apache.commons.vfs2.FileType fileType = this.file.getType();
                FileContent fileContent = this.file.getContent();
                if (fileContent != null) {
                    l2 = fileContent.getLastModifiedTime();
                    if (fileType == org.apache.commons.vfs2.FileType.FILE && (l = fileContent.getSize()) == -1L && fileContent.getFile() instanceof GzipFileObject) {
                        l = 0L;
                    }
                } else {
                    LOG.warn("content == null");
                }
                if (this.file instanceof SftpFileObject) {
                    SftpFileObject sftpFileObject = (SftpFileObject)this.file;
                    n = VfsFile.fromSftpAttributes(sftpFileObject);
                }
            }
        }
        catch (FileSystemException fileSystemException) {
            LOG.error("updateFileInfo()  failed for " + this.file, (Throwable)fileSystemException);
        }
        if (this.file != null) {
            this.fileInfo = new FileInfo(this.file.getName().getBaseName(), n, l, l2);
        } else {
            LOG.warn("Cannot update 'fileInfo' as 'file' is 'null'");
        }
    }

    private static enum Field {
        SET_HIDDEN("hidden"),
        SET_LAST_MODIFIED("lastModified"),
        SET_READ_ONLY("readOnly");

        private final String name;

        private Field(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

