/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.vfs.internal;

import java.io.File;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesContainer;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesWrapper;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurePrefsUtil {
    private static final Logger LOG;
    private static ISecurePreferences PREF_NODE;
    private static ConcurrentMap<String, String> secrets;

    static {
        secrets = new ConcurrentHashMap<String, String>();
        LOG = LoggerFactory.getLogger(SecurePrefsUtil.class);
        try {
            URL uRL = Platform.getInstanceLocation().getURL();
            File file = new File(uRL.getFile(), "secure_storage");
            URL uRL2 = file.toURL();
            if (LOG.isInfoEnabled()) {
                LOG.info("secure file location path: " + file);
                LOG.info("secure file location: URL" + uRL2);
            }
            ISecurePreferences iSecurePreferences = SecurePreferencesFactory.open((URL)uRL2, null);
            SecurePreferencesContainer securePreferencesContainer = ((SecurePreferencesWrapper)iSecurePreferences).getContainer();
            securePreferencesContainer.setOption((Object)"org.eclipse.equinox.security.storage.defaultPassword", (Object)new PBEKeySpec("MasterPassword".toCharArray()));
            securePreferencesContainer.setOption((Object)"org.eclipse.equinox.security.storage.promptUser", (Object)false);
            PREF_NODE = iSecurePreferences.node("com.deltopia");
        }
        catch (Throwable throwable) {
            LOG.error("Couldn't obtain 'com.deltopia' secure preference node", throwable);
        }
    }

    public static String get(String string, String string2) {
        try {
            String string3;
            if (secrets.containsKey(string)) {
                string3 = (String)secrets.get(string);
            } else {
                string3 = PREF_NODE.get(string, string2);
                secrets.putIfAbsent(string, string3);
            }
            return string3;
        }
        catch (Throwable throwable) {
            LOG.error("Couldn't get secure preference using key=\"" + string, throwable);
            return string2;
        }
    }

    public static void put(String string, String string2) {
        try {
            PREF_NODE.put(string, string2, true);
            secrets.put(string, string2);
        }
        catch (Throwable throwable) {
            LOG.error("Couldn't put secure preference using key=\"" + string, throwable);
        }
    }
}

