/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.docreader.internal;

import com.deltawalker.interfaces.ICompoundDocReader;
import com.deltopia.io.ContentType;
import com.deltopia.io.StreamUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.poi.extractor.POITextExtractor;
import org.apache.poi.ooxml.extractor.ExtractorFactory;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundDocReader
implements ICompoundDocReader {
    private static final Logger LOG = LoggerFactory.getLogger(CompoundDocReader.class);

    public String extractText(InputStream inputStream, ContentType contentType) throws Throwable {
        switch (contentType) {
            case OFFICE: 
            case OFFICE2007: {
                POITextExtractor pOITextExtractor = ExtractorFactory.createExtractor((InputStream)inputStream);
                return pOITextExtractor.getText();
            }
            case PDF: {
                PDDocument pDDocument = null;
                try {
                    pDDocument = PDDocument.load((InputStream)inputStream);
                    PDFTextStripper pDFTextStripper = new PDFTextStripper();
                    String string = pDFTextStripper.getText(pDDocument);
                    return string;
                }
                finally {
                    StreamUtil.closeSilently((Closeable)pDDocument);
                }
            }
            case TEXT_RTF: {
                DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
                RTFEditorKit rTFEditorKit = new RTFEditorKit();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                rTFEditorKit.read(bufferedReader, (Document)defaultStyledDocument, 0);
                return defaultStyledDocument.getText(0, defaultStyledDocument.getLength());
            }
        }
        LOG.warn(NLS.bind((String)"Text extraction is not supported for {0}.", (Object)contentType.toString()));
        return null;
    }
}

