/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTBHOTITEM;
import org.eclipse.swt.internal.win32.NMTOOLBAR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTON;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    int lastFocusId;
    int lastArrowId;
    int lastHotId;
    ToolItem[] items;
    ToolItem[] tabItemList;
    boolean ignoreResize;
    boolean ignoreMouse;
    ImageList imageList;
    ImageList disabledImageList;
    ImageList hotImageList;
    static final long ToolBarProc;
    static final TCHAR ToolBarClass;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;

    static {
        ToolBarClass = new TCHAR(0, "ToolbarWindow32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0L, ToolBarClass, wNDCLASS);
        ToolBarProc = wNDCLASS.lpfnWndProc;
    }

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        if ((n & 0x200) != 0) {
            this.style |= 0x200;
            int n2 = OS.GetWindowLong(this.handle, -16);
            if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (n & 0x20000) != 0) {
                n2 |= 0x1000;
            }
            OS.SetWindowLong(this.handle, -16, n2 | 0x80);
        } else {
            this.style |= 0x100;
        }
    }

    @Override
    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        if (n == 262) {
            return OS.DefWindowProc(l, n, l2, l3);
        }
        return OS.CallWindowProc(ToolBarProc, l, n, l2, l3);
    }

    static int checkStyle(int n) {
        if ((n & 0x800000) == 0) {
            n |= 0x80000;
        }
        if ((n & 0x200) != 0) {
            n &= 0xFFFFFFBF;
        }
        return n & 0xFFFFFCFF;
    }

    @Override
    void checkBuffered() {
        super.checkBuffered();
        if (OS.COMCTL32_MAJOR >= 6) {
            this.style |= 0x20000000;
        }
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        Object object;
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x200) != 0) {
            object = new RECT();
            TBBUTTON tBBUTTON = new TBBUTTON();
            int n5 = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
            int n6 = 0;
            while (n6 < n5) {
                OS.SendMessage(this.handle, 1053, (long)n6, (RECT)object);
                n4 = Math.max(n4, ((RECT)object).bottom);
                OS.SendMessage(this.handle, 1047, (long)n6, tBBUTTON);
                if ((tBBUTTON.fsStyle & 1) != 0) {
                    TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                    tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                    tBBUTTONINFO.dwMask = 64;
                    OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, (long)tBBUTTON.idCommand, tBBUTTONINFO);
                    n3 = Math.max(n3, tBBUTTONINFO.cx);
                } else {
                    n3 = Math.max(n3, ((RECT)object).right);
                }
                ++n6;
            }
        } else {
            object = new RECT();
            OS.GetWindowRect(this.handle, (RECT)object);
            int n7 = ((RECT)object).right - ((RECT)object).left;
            int n8 = ((RECT)object).bottom - ((RECT)object).top;
            int n9 = this.getBorderWidthInPixels();
            int n10 = n == -1 ? 16383 : n + n9 * 2;
            int n11 = n2 == -1 ? 16383 : n2 + n9 * 2;
            boolean bl2 = this.getDrawing() && OS.IsWindowVisible(this.handle);
            this.ignoreResize = true;
            if (bl2) {
                OS.UpdateWindow(this.handle);
            }
            int n12 = 30;
            this.SetWindowPos(this.handle, 0L, 0, 0, n10, n11, n12);
            int n13 = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
            if (n13 != 0) {
                RECT rECT = new RECT();
                OS.SendMessage(this.handle, 1053, (long)(n13 - 1), rECT);
                n3 = Math.max(n3, rECT.right);
                n4 = Math.max(n4, rECT.bottom);
            }
            this.SetWindowPos(this.handle, 0L, 0, 0, n7, n8, n12);
            if (bl2) {
                OS.ValidateRect(this.handle, null);
            }
            this.ignoreResize = false;
        }
        if (n3 == 0) {
            n3 = 24;
        }
        if (n4 == 0) {
            n4 = 22;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        object = this.computeTrimInPixels(0, 0, n3, n4);
        n3 = ((Rectangle)object).width;
        n4 = ((Rectangle)object).height;
        return new Point(n3, n4);
    }

    @Override
    Rectangle computeTrimInPixels(int n, int n2, int n3, int n4) {
        Rectangle rectangle = super.computeTrimInPixels(n, n2, n3, n4);
        int n5 = OS.GetWindowLong(this.handle, -16);
        if ((n5 & 0x40) == 0) {
            rectangle.height += 2;
        }
        return rectangle;
    }

    @Override
    Widget computeTabGroup() {
        int n;
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            n = 0;
            while (n < toolItemArray.length && toolItemArray[n].control == null) {
                ++n;
            }
            if (n == toolItemArray.length) {
                return super.computeTabGroup();
            }
        }
        if ((n = (int)OS.SendMessage(this.handle, 1095, 0L, 0L)) == -1) {
            n = this.lastHotId;
        }
        while (n >= 0) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.isTabGroup()) {
                return toolItem;
            }
            --n;
        }
        return super.computeTabGroup();
    }

    @Override
    Widget[] computeTabList() {
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            int n = 0;
            while (n < toolItemArray.length && toolItemArray[n].control == null) {
                ++n;
            }
            if (n == toolItemArray.length) {
                return super.computeTabList();
            }
        }
        Widget[] widgetArray = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return widgetArray;
        }
        ToolItem[] toolItemArray2 = this.tabList != null ? this._getTabItemList() : toolItemArray;
        int n = 0;
        while (n < toolItemArray2.length) {
            ToolItem toolItem = toolItemArray2[n];
            Widget[] widgetArray2 = toolItem.computeTabList();
            if (widgetArray2.length != 0) {
                Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
                System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
                System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
                widgetArray = widgetArray3;
            }
            ++n;
        }
        if (widgetArray.length == 0) {
            widgetArray = new Widget[]{this};
        }
        return widgetArray;
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        if (!((this.style & 0x800000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            int n = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n &= 0xFFFF7FFF);
        }
        long l = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, l, 0L);
        OS.SendMessage(this.handle, 1054, (long)TBBUTTON.sizeof, 0L);
        OS.SendMessage(this.handle, 1056, 0L, 0L);
        OS.SendMessage(this.handle, 1055, 0L, 0L);
        int n = 25;
        if (OS.COMCTL32_MAJOR >= 6) {
            n |= 0x80;
        }
        OS.SendMessage(this.handle, 1108, 0L, (long)n);
    }

    void createItem(ToolItem toolItem, int n) {
        int n2 = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
        if (n < 0 || n > n2) {
            this.error(6);
        }
        int n3 = 0;
        while (n3 < this.items.length && this.items[n3] != null) {
            ++n3;
        }
        if (n3 == this.items.length) {
            ToolItem[] toolItemArray = new ToolItem[this.items.length + 4];
            System.arraycopy(this.items, 0, toolItemArray, 0, this.items.length);
            this.items = toolItemArray;
        }
        int n4 = toolItem.widgetStyle();
        TBBUTTON tBBUTTON = new TBBUTTON();
        tBBUTTON.idCommand = n3;
        tBBUTTON.fsStyle = (byte)n4;
        tBBUTTON.fsState = (byte)4;
        if ((n4 & 1) == 0) {
            tBBUTTON.iBitmap = -2;
        }
        if (OS.SendMessage(this.handle, OS.TB_INSERTBUTTON, (long)n, tBBUTTON) == 0L) {
            this.error(14);
        }
        toolItem.id = n3;
        this.items[toolItem.id] = toolItem;
        if ((this.style & 0x200) != 0) {
            this.setRowCount(n2 + 1);
        }
        this.layoutItems();
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.lastHotId = -1;
        this.lastArrowId = -1;
        this.lastFocusId = -1;
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    @Override
    int defaultBackground() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_BTNFACE);
        }
        return super.defaultBackground();
    }

    void destroyItem(ToolItem toolItem) {
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
        tBBUTTONINFO.dwMask = 9;
        int n = (int)OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, (long)toolItem.id, tBBUTTONINFO);
        if ((tBBUTTONINFO.fsStyle & 1) == 0 && tBBUTTONINFO.iImage != -2) {
            if (this.imageList != null) {
                this.imageList.put(tBBUTTONINFO.iImage, null);
            }
            if (this.hotImageList != null) {
                this.hotImageList.put(tBBUTTONINFO.iImage, null);
            }
            if (this.disabledImageList != null) {
                this.disabledImageList.put(tBBUTTONINFO.iImage, null);
            }
        }
        OS.SendMessage(this.handle, 1046, (long)n, 0L);
        if (toolItem.id == this.lastFocusId) {
            this.lastFocusId = -1;
        }
        if (toolItem.id == this.lastArrowId) {
            this.lastArrowId = -1;
        }
        if (toolItem.id == this.lastHotId) {
            this.lastHotId = -1;
        }
        this.items[toolItem.id] = null;
        toolItem.id = -1;
        int n2 = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
        if (n2 == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 1072, 0L, 0L);
                this.display.releaseToolImageList(this.imageList);
            }
            if (this.hotImageList != null) {
                OS.SendMessage(this.handle, 1076, 0L, 0L);
                this.display.releaseToolHotImageList(this.hotImageList);
            }
            if (this.disabledImageList != null) {
                OS.SendMessage(this.handle, 1078, 0L, 0L);
                this.display.releaseToolDisabledImageList(this.disabledImageList);
            }
            this.disabledImageList = null;
            this.hotImageList = null;
            this.imageList = null;
            this.items = new ToolItem[4];
        }
        if ((this.style & 0x200) != 0) {
            this.setRowCount(n2 - 1);
        }
        this.layoutItems();
    }

    @Override
    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        int n = 0;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && (toolItem.style & 2) == 0) {
                toolItem.updateImages(bl && toolItem.getEnabled());
            }
            ++n;
        }
    }

    ImageList getDisabledImageList() {
        return this.disabledImageList;
    }

    ImageList getHotImageList() {
        return this.hotImageList;
    }

    ImageList getImageList() {
        return this.imageList;
    }

    public ToolItem getItem(int n) {
        TBBUTTON tBBUTTON;
        long l;
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        if ((l = OS.SendMessage(this.handle, 1047, (long)n, tBBUTTON = new TBBUTTON())) == 0L) {
            this.error(8);
        }
        return this.items[tBBUTTON.idCommand];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.getItemInPixels(DPIUtil.autoScaleUp(point));
    }

    ToolItem getItemInPixels(Point point) {
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            Rectangle rectangle = toolItemArray[n].getBoundsInPixels();
            if (rectangle.contains(point)) {
                return toolItemArray[n];
            }
            ++n;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        int n = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
        TBBUTTON tBBUTTON = new TBBUTTON();
        ToolItem[] toolItemArray = new ToolItem[n];
        int n2 = 0;
        while (n2 < n) {
            OS.SendMessage(this.handle, 1047, (long)n2, tBBUTTON);
            toolItemArray[n2] = this.items[tBBUTTON.idCommand];
            ++n2;
        }
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        if ((this.style & 0x200) != 0) {
            return (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
        }
        return (int)OS.SendMessage(this.handle, 1064, 0L, 0L);
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabItemList.length) {
            if (!this.tabItemList[n2].isDisposed()) {
                ++n;
            }
            ++n2;
        }
        if (n == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] toolItemArray = new ToolItem[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.tabItemList.length) {
            if (!this.tabItemList[n4].isDisposed()) {
                toolItemArray[n3++] = this.tabItemList[n4];
            }
            ++n4;
        }
        this.tabItemList = toolItemArray;
        return this.tabItemList;
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        if (toolItem.isDisposed()) {
            this.error(5);
        }
        return (int)OS.SendMessage(this.handle, 1049, (long)toolItem.id, 0L);
    }

    void layoutItems() {
        int n;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (this.style & 0x20000) != 0 && (this.style & 0x200) == 0) {
            n = 0;
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.items.length) {
                ToolItem toolItem = this.items[n2];
                if (toolItem != null) {
                    if (n == 0) {
                        int n3 = n = toolItem.text.length() != 0 ? 1 : 0;
                    }
                    if (!bl) {
                        boolean bl2 = bl = toolItem.image != null;
                    }
                    if (n != 0 && bl) break;
                }
                ++n2;
            }
            int n4 = n2 = OS.GetWindowLong(this.handle, -16);
            n4 = n != 0 && bl ? (n4 |= 0x1000) : (n4 &= 0xFFFFEFFF);
            if (n4 != n2) {
                this.setDropDownItems(false);
                OS.SetWindowLong(this.handle, -16, n4);
                long l = OS.SendMessage(this.handle, 49, 0L, 0L);
                OS.SendMessage(this.handle, 48, l, 0L);
                this.setDropDownItems(true);
            }
        }
        if ((this.style & 0x40) != 0) {
            OS.SendMessage(this.handle, 1057, 0L, 0L);
        }
        if ((this.style & 0x200) != 0 && (n = (int)OS.SendMessage(this.handle, 1048, 0L, 0L)) > 1) {
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 64;
            long l = OS.SendMessage(this.handle, 1082, 0L, 0L);
            tBBUTTONINFO.cx = (short)OS.LOWORD(l);
            int n5 = 0;
            int n6 = 0;
            while (n5 < this.items.length) {
                ToolItem toolItem = this.items[n5];
                if (toolItem != null && (toolItem.style & 4) != 0) {
                    n6 = 1;
                    break;
                }
                ++n5;
            }
            if (n5 < this.items.length) {
                long l2 = OS.SendMessage(this.handle, 1110, 0L, 0L);
                tBBUTTONINFO.cx = (short)(tBBUTTONINFO.cx + OS.LOWORD(l2 + (long)n6) * 2);
            }
            int n7 = 0;
            while (n7 < this.items.length) {
                ToolItem toolItem = this.items[n7];
                if (toolItem != null && (toolItem.style & 2) == 0) {
                    OS.SendMessage(this.handle, OS.TB_SETBUTTONINFO, (long)toolItem.id, tBBUTTONINFO);
                }
                ++n7;
            }
        }
        if ((this.style & 0x240) != 0 && ((n = OS.GetWindowLong(this.handle, -16)) & 0x1000) != 0) {
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 64;
            int n8 = 0;
            while (n8 < this.items.length) {
                ToolItem toolItem = this.items[n8];
                if (toolItem != null && toolItem.cx > 0) {
                    tBBUTTONINFO.cx = toolItem.cx;
                    OS.SendMessage(this.handle, OS.TB_SETBUTTONINFO, (long)toolItem.id, tBBUTTONINFO);
                }
                ++n8;
            }
        }
        n = 0;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null) {
                toolItem.resizeControl();
            }
            ++n;
        }
    }

    @Override
    boolean mnemonicHit(char c) {
        int[] nArray;
        int n = Display.wcsToMbcs(c);
        if (OS.SendMessage(this.handle, OS.TB_MAPACCELERATOR, (long)n, nArray = new int[1]) == 0L) {
            return false;
        }
        if ((this.style & 0x800000) != 0 && !this.setTabGroupFocus()) {
            return false;
        }
        int n2 = (int)OS.SendMessage(this.handle, 1049, (long)nArray[0], 0L);
        if (n2 == -1) {
            return false;
        }
        OS.SendMessage(this.handle, 1096, (long)n2, 0L);
        this.items[nArray[0]].click(false);
        return true;
    }

    @Override
    boolean mnemonicMatch(char c) {
        int[] nArray;
        int n = Display.wcsToMbcs(c);
        if (OS.SendMessage(this.handle, OS.TB_MAPACCELERATOR, (long)n, nArray = new int[1]) == 0L) {
            return false;
        }
        int n2 = (int)OS.SendMessage(this.handle, 1049, (long)nArray[0], 0L);
        if (n2 == -1) {
            return false;
        }
        return this.findMnemonic(this.items[nArray[0]].text) != '\u0000';
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                ToolItem toolItem = this.items[n];
                if (toolItem != null && !toolItem.isDisposed()) {
                    toolItem.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 1072, 0L, 0L);
            this.display.releaseToolImageList(this.imageList);
        }
        if (this.hotImageList != null) {
            OS.SendMessage(this.handle, 1076, 0L, 0L);
            this.display.releaseToolHotImageList(this.hotImageList);
        }
        if (this.disabledImageList != null) {
            OS.SendMessage(this.handle, 1078, 0L, 0L);
            this.display.releaseToolDisabledImageList(this.disabledImageList);
        }
        this.disabledImageList = null;
        this.hotImageList = null;
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        int n = 0;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && toolItem.control == control) {
                toolItem.setControl(null);
            }
            ++n;
        }
    }

    @Override
    void reskinChildren(int n) {
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.items.length) {
                ToolItem toolItem = this.items[n2];
                if (toolItem != null) {
                    toolItem.reskin(n);
                }
                ++n2;
            }
        }
        super.reskinChildren(n);
    }

    @Override
    void setBackgroundImage(long l) {
        super.setBackgroundImage(l);
        this.setBackgroundTransparent(l != 0L);
    }

    @Override
    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
        this.setBackgroundTransparent(n != -1);
    }

    void setBackgroundTransparent(boolean bl) {
        if (!((this.style & 0x800000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            int n = OS.GetWindowLong(this.handle, -16);
            n = !bl && this.findBackgroundControl() == null ? (n &= 0xFFFF7FFF) : (n |= 0x8000);
            OS.SetWindowLong(this.handle, -16, n);
        }
    }

    @Override
    void setBoundsInPixels(int n, int n2, int n3, int n4, int n5) {
        if (this.parent.lpwp != null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
            this.parent.setResizeChildren(false);
            this.parent.setResizeChildren(true);
        }
        super.setBoundsInPixels(n, n2, n3, n4, n5);
    }

    @Override
    void setDefaultFont() {
        super.setDefaultFont();
        OS.SendMessage(this.handle, 1056, 0L, 0L);
        OS.SendMessage(this.handle, 1055, 0L, 0L);
    }

    void setDropDownItems(boolean bl) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            ToolItem toolItem;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (n < this.items.length) {
                toolItem = this.items[n];
                if (toolItem != null) {
                    if (!bl2) {
                        boolean bl4 = bl2 = toolItem.text.length() != 0;
                    }
                    if (!bl3) {
                        boolean bl5 = bl3 = toolItem.image != null;
                    }
                    if (bl2 && bl3) break;
                }
                ++n;
            }
            if (bl3 && !bl2) {
                n = 0;
                while (n < this.items.length) {
                    toolItem = this.items[n];
                    if (toolItem != null && (toolItem.style & 4) != 0) {
                        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                        tBBUTTONINFO.dwMask = 8;
                        OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, (long)toolItem.id, tBBUTTONINFO);
                        tBBUTTONINFO.fsStyle = bl ? (byte)(tBBUTTONINFO.fsStyle | 8) : (byte)(tBBUTTONINFO.fsStyle & 0xFFFFFFF7);
                        OS.SendMessage(this.handle, OS.TB_SETBUTTONINFO, (long)toolItem.id, tBBUTTONINFO);
                    }
                    ++n;
                }
            }
        }
    }

    void setDisabledImageList(ImageList imageList) {
        if (this.disabledImageList == imageList) {
            return;
        }
        long l = 0L;
        this.disabledImageList = imageList;
        if (this.disabledImageList != null) {
            l = this.disabledImageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1078, 0L, l);
        this.setDropDownItems(true);
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        this.setDropDownItems(false);
        super.setFont(font);
        this.setDropDownItems(true);
        int n = 0;
        int n2 = 60;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && (toolItem.style & n2) != 0) break;
            ++n;
        }
        if (n == this.items.length) {
            OS.SendMessage(this.handle, 1056, 0L, 0L);
            OS.SendMessage(this.handle, 1055, 0L, 0L);
        }
        this.layoutItems();
    }

    void setHotImageList(ImageList imageList) {
        if (this.hotImageList == imageList) {
            return;
        }
        long l = 0L;
        this.hotImageList = imageList;
        if (this.hotImageList != null) {
            l = this.hotImageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1076, 0L, l);
        this.setDropDownItems(true);
    }

    void setImageList(ImageList imageList) {
        if (this.imageList == imageList) {
            return;
        }
        long l = 0L;
        this.imageList = imageList;
        if (this.imageList != null) {
            l = imageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1072, 0L, l);
        this.setDropDownItems(true);
    }

    @Override
    public boolean setParent(Composite composite) {
        this.checkWidget();
        if (!super.setParent(composite)) {
            return false;
        }
        long l = composite.handle;
        OS.SendMessage(this.handle, 1061, l, 0L);
        long l2 = composite.getShell().handle;
        long l3 = OS.SendMessage(this.handle, 1059, 0L, 0L);
        OS.SetWindowLongPtr(l3, -8, l2);
        return true;
    }

    @Override
    public void setRedraw(boolean bl) {
        this.checkWidget();
        this.setDropDownItems(false);
        super.setRedraw(bl);
        this.setDropDownItems(true);
    }

    void setRowCount(int n) {
        if ((this.style & 0x200) != 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            OS.MapWindowPoints(0L, this.parent.handle, rECT, 2);
            this.ignoreResize = true;
            OS.SendMessage(this.handle, 1063, OS.MAKEWPARAM(n += 2, 1), 0L);
            int n2 = 22;
            this.SetWindowPos(this.handle, 0L, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top, n2);
            this.ignoreResize = false;
        }
    }

    void setTabItemList(ToolItem[] toolItemArray) {
        this.checkWidget();
        if (toolItemArray != null) {
            int n = 0;
            while (n < toolItemArray.length) {
                ToolItem toolItem = toolItemArray[n];
                if (toolItem == null) {
                    this.error(5);
                }
                if (toolItem.isDisposed()) {
                    this.error(5);
                }
                if (toolItem.parent != this) {
                    this.error(32);
                }
                ++n;
            }
            ToolItem[] toolItemArray2 = new ToolItem[toolItemArray.length];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, toolItemArray.length);
            toolItemArray = toolItemArray2;
        }
        this.tabItemList = toolItemArray;
    }

    @Override
    boolean setTabItemFocus() {
        int n = 0;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && (toolItem.style & 2) == 0 && toolItem.getEnabled()) break;
            ++n;
        }
        if (n == this.items.length) {
            return false;
        }
        return super.setTabItemFocus();
    }

    @Override
    boolean updateTextDirection(int n) {
        if (super.updateTextDirection(n)) {
            ToolItem[] toolItemArray = this._getItems();
            int n2 = toolItemArray.length;
            while (n2-- > 0) {
                toolItemArray[n2].updateTextDirection(this.style & Integer.MIN_VALUE);
            }
            return true;
        }
        return false;
    }

    @Override
    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        if ((nMTTDISPINFO.uFlags & 1) != 0) {
            return null;
        }
        if (!this.hasCursor()) {
            return "";
        }
        int n = (int)nMTTDISPINFO.idFrom;
        long l = OS.SendMessage(this.handle, 1059, 0L, 0L);
        if (l == nMTTDISPINFO.hwndFrom) {
            ToolItem toolItem;
            int n2 = -2080374784;
            nMTTDISPINFO.uFlags = (this.style & n2) != 0 && (this.style & n2) != n2 ? (nMTTDISPINFO.uFlags |= 4) : (nMTTDISPINFO.uFlags &= 0xFFFFFFFB);
            if (this.toolTipText != null) {
                return "";
            }
            if (n >= 0 && n < this.items.length && (toolItem = this.items[n]) != null) {
                if (this.lastArrowId != -1) {
                    return "";
                }
                return toolItem.toolTipText;
            }
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    @Override
    void updateOrientation() {
        super.updateOrientation();
        if (this.imageList != null) {
            Point point = this.imageList.getImageSize();
            ImageList imageList = this.display.getImageListToolBar(this.style & 0x4000000, point.x, point.y);
            ImageList imageList2 = this.display.getImageListToolBarHot(this.style & 0x4000000, point.x, point.y);
            ImageList imageList3 = this.display.getImageListToolBarDisabled(this.style & 0x4000000, point.x, point.y);
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 1;
            int n = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
            int n2 = 0;
            while (n2 < n) {
                ToolItem toolItem = this.items[n2];
                if ((toolItem.style & 2) == 0 && toolItem.image != null) {
                    OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, (long)toolItem.id, tBBUTTONINFO);
                    if (tBBUTTONINFO.iImage != -2) {
                        Image image = this.imageList.get(tBBUTTONINFO.iImage);
                        Image image2 = this.hotImageList.get(tBBUTTONINFO.iImage);
                        Image image3 = this.disabledImageList.get(tBBUTTONINFO.iImage);
                        this.imageList.put(tBBUTTONINFO.iImage, null);
                        this.hotImageList.put(tBBUTTONINFO.iImage, null);
                        this.disabledImageList.put(tBBUTTONINFO.iImage, null);
                        tBBUTTONINFO.iImage = imageList.add(image);
                        imageList2.add(image2);
                        imageList3.add(image3);
                        OS.SendMessage(this.handle, OS.TB_SETBUTTONINFO, (long)toolItem.id, tBBUTTONINFO);
                    }
                }
                ++n2;
            }
            this.display.releaseToolImageList(this.imageList);
            this.display.releaseToolHotImageList(this.hotImageList);
            this.display.releaseToolDisabledImageList(this.disabledImageList);
            OS.SendMessage(this.handle, 1072, 0L, imageList.getHandle());
            OS.SendMessage(this.handle, 1076, 0L, imageList2.getHandle());
            OS.SendMessage(this.handle, 1078, 0L, imageList3.getHandle());
            this.imageList = imageList;
            this.hotImageList = imageList2;
            this.disabledImageList = imageList3;
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    @Override
    int widgetStyle() {
        int n = super.widgetStyle() | 4 | 0x100 | 0x2000;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n |= 0x8000;
        }
        if ((this.style & 8) == 0) {
            n |= 0x40;
        }
        if ((this.style & 0x40) != 0) {
            n |= 0x200;
        }
        if ((this.style & 0x800000) != 0) {
            n |= 0x800;
        }
        if (!(OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() || (this.style & 0x20000) == 0)) {
            n |= 0x1000;
        }
        return n;
    }

    @Override
    TCHAR windowClass() {
        return ToolBarClass;
    }

    @Override
    long windowProc() {
        return ToolBarProc;
    }

    @Override
    LRESULT WM_CAPTURECHANGED(long l, long l2) {
        LRESULT lRESULT = super.WM_CAPTURECHANGED(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n = 0;
        while (n < this.items.length) {
            int n2;
            ToolItem toolItem = this.items[n];
            if (toolItem != null && ((n2 = (int)OS.SendMessage(this.handle, 1042, (long)toolItem.id, 0L)) & 2) != 0) {
                OS.SendMessage(this.handle, 1041, (long)toolItem.id, (long)(n2 &= 0xFFFFFFFD));
            }
            ++n;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_CHAR(long l, long l2) {
        LRESULT lRESULT = super.WM_CHAR(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch ((int)l) {
            case 32: {
                TBBUTTON tBBUTTON;
                long l3;
                int n = (int)OS.SendMessage(this.handle, 1095, 0L, 0L);
                if (n == -1 || (l3 = OS.SendMessage(this.handle, 1047, (long)n, tBBUTTON = new TBBUTTON())) == 0L) break;
                this.items[tBBUTTON.idCommand].click(false);
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_COMMAND(long l, long l2) {
        LRESULT lRESULT = super.WM_COMMAND(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_ERASEBKGND(long l, long l2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(l, l2);
        if (this.findBackgroundControl() != null && OS.COMCTL32_MAJOR < 6) {
            this.drawBackground(l);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETDLGCODE(long l, long l2) {
        LRESULT lRESULT = super.WM_GETDLGCODE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(8193L);
    }

    @Override
    LRESULT WM_KEYDOWN(long l, long l2) {
        LRESULT lRESULT = super.WM_KEYDOWN(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch ((int)l) {
            case 32: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_KILLFOCUS(long l, long l2) {
        TBBUTTON tBBUTTON;
        int n = (int)OS.SendMessage(this.handle, 1095, 0L, 0L);
        long l3 = OS.SendMessage(this.handle, 1047, (long)n, tBBUTTON = new TBBUTTON());
        if (l3 != 0L) {
            this.lastFocusId = tBBUTTON.idCommand;
        }
        return super.WM_KILLFOCUS(l, l2);
    }

    @Override
    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONDOWN(l, l2);
    }

    @Override
    LRESULT WM_LBUTTONUP(long l, long l2) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONUP(l, l2);
    }

    @Override
    LRESULT WM_MOUSELEAVE(long l, long l2) {
        LRESULT lRESULT = super.WM_MOUSELEAVE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            long l3 = OS.SendMessage(this.handle, 1059, 0L, 0L);
            if (OS.SendMessage(l3, OS.TTM_GETCURRENTTOOL, 0L, tOOLINFO) != 0L && (tOOLINFO.uFlags & 1) == 0) {
                OS.SendMessage(l3, OS.TTM_DELTOOL, 0L, tOOLINFO);
                OS.SendMessage(l3, OS.TTM_ADDTOOL, 0L, tOOLINFO);
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_MOUSEMOVE(long l, long l2) {
        if (OS.GetMessagePos() != this.display.lastMouse) {
            this.lastArrowId = -1;
        }
        return super.WM_MOUSEMOVE(l, l2);
    }

    @Override
    LRESULT WM_NOTIFY(long l, long l2) {
        LRESULT lRESULT = super.WM_NOTIFY(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_SETFOCUS(long l, long l2) {
        LRESULT lRESULT = super.WM_SETFOCUS(l, l2);
        if (this.lastFocusId != -1 && this.handle == OS.GetFocus()) {
            int n = (int)OS.SendMessage(this.handle, 1049, (long)this.lastFocusId, 0L);
            OS.SendMessage(this.handle, 1096, (long)n, 0L);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SIZE(long l, long l2) {
        if (this.ignoreResize) {
            long l3 = this.callWindowProc(this.handle, 5, l, l2);
            if (l3 == 0L) {
                return LRESULT.ZERO;
            }
            return new LRESULT(l3);
        }
        LRESULT lRESULT = super.WM_SIZE(l, l2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if ((this.style & 0x800) != 0 && (this.style & 0x40) != 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            int n = 0;
            int n2 = this.getBorderWidthInPixels() * 2;
            RECT rECT2 = new RECT();
            int n3 = (int)OS.SendMessage(this.handle, 1048, 0L, 0L);
            while (n < n3) {
                OS.SendMessage(this.handle, 1053, (long)n, rECT2);
                OS.MapWindowPoints(this.handle, 0L, rECT2, 2);
                if (rECT2.right > rECT.right - n2 * 2) break;
                ++n;
            }
            int n4 = (int)OS.SendMessage(this.handle, 1109, 0L, 0L);
            n4 = n == n3 ? (n4 |= 0x10) : (n4 &= 0xFFFFFFEF);
            OS.SendMessage(this.handle, 1108, 0L, (long)n4);
        }
        this.layoutItems();
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(long l, long l2) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.ignoreResize) {
            return lRESULT;
        }
        if (!this.getDrawing()) {
            return lRESULT;
        }
        if ((this.style & 0x40) == 0) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        if (OS.SendMessage(this.handle, 1064, 0L, 0L) == 1L) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, l2, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 9) != 0) {
            return lRESULT;
        }
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        RECT rECT2 = new RECT();
        OS.SetRect(rECT2, 0, 0, wINDOWPOS.cx, wINDOWPOS.cy);
        OS.SendMessage(this.handle, 131, 0L, rECT2);
        int n = rECT.right - rECT.left;
        int n2 = rECT2.right - rECT2.left;
        if (n2 > n) {
            RECT rECT3 = new RECT();
            int n3 = rECT2.bottom - rECT2.top;
            OS.SetRect(rECT3, n - 2, 0, n, n3);
            OS.InvalidateRect(this.handle, rECT3, false);
        }
        return lRESULT;
    }

    @Override
    LRESULT wmCommandChild(long l, long l2) {
        ToolItem toolItem = this.items[OS.LOWORD(l)];
        if (toolItem == null) {
            return null;
        }
        return toolItem.wmCommandChild(l, l2);
    }

    @Override
    LRESULT wmNotifyChild(NMHDR nMHDR, long l, long l2) {
        switch (nMHDR.code) {
            case -710: {
                NMTOOLBAR nMTOOLBAR = new NMTOOLBAR();
                OS.MoveMemory(nMTOOLBAR, l2, NMTOOLBAR.sizeof);
                ToolItem toolItem = this.items[nMTOOLBAR.iItem];
                if (toolItem == null) break;
                Event event = new Event();
                event.detail = 4;
                int n = (int)OS.SendMessage(this.handle, 1049, (long)nMTOOLBAR.iItem, 0L);
                RECT rECT = new RECT();
                OS.SendMessage(this.handle, 1053, (long)n, rECT);
                event.setLocationInPixels(rECT.left, rECT.bottom);
                toolItem.sendSelectionEvent(13, event, false);
                break;
            }
            case -12: {
                if (OS.COMCTL32_MAJOR < 6) break;
                NMCUSTOMDRAW nMCUSTOMDRAW = new NMCUSTOMDRAW();
                OS.MoveMemory(nMCUSTOMDRAW, l2, NMCUSTOMDRAW.sizeof);
                switch (nMCUSTOMDRAW.dwDrawStage) {
                    case 3: {
                        int n = OS.GetWindowLong(this.handle, -16);
                        if ((n & 0x800) == 0) {
                            this.drawBackground(nMCUSTOMDRAW.hdc);
                        } else {
                            RECT rECT = new RECT();
                            OS.SetRect(rECT, nMCUSTOMDRAW.left, nMCUSTOMDRAW.top, nMCUSTOMDRAW.right, nMCUSTOMDRAW.bottom);
                            this.drawBackground(nMCUSTOMDRAW.hdc, rECT);
                        }
                        return new LRESULT(4L);
                    }
                }
                break;
            }
            case -713: {
                if (OS.IsWinCE) break;
                NMTBHOTITEM nMTBHOTITEM = new NMTBHOTITEM();
                OS.MoveMemory(nMTBHOTITEM, l2, NMTBHOTITEM.sizeof);
                switch (nMTBHOTITEM.dwFlags) {
                    case 1: {
                        if (this.lastArrowId == -1) break;
                        return LRESULT.ONE;
                    }
                    case 2: {
                        RECT rECT = new RECT();
                        OS.GetClientRect(this.handle, rECT);
                        int n = (int)OS.SendMessage(this.handle, 1049, (long)nMTBHOTITEM.idNew, 0L);
                        RECT rECT2 = new RECT();
                        OS.SendMessage(this.handle, 1053, (long)n, rECT2);
                        if (rECT2.right > rECT.right || rECT2.bottom > rECT.bottom) {
                            return LRESULT.ONE;
                        }
                        this.lastArrowId = nMTBHOTITEM.idNew;
                        break;
                    }
                    default: {
                        this.lastArrowId = -1;
                    }
                }
                if ((nMTBHOTITEM.dwFlags & 0x20) != 0) break;
                this.lastHotId = nMTBHOTITEM.idNew;
            }
        }
        return super.wmNotifyChild(nMHDR, l, l2);
    }
}

